/*************************************************************************************************************************************************/
/*!     hal.h
 *      Device and board specific pins need to be configured here
 *
 */

/**************************************************************************************************************************************************
 *       Copyright  2014 Texas Instruments Incorporated - http://www.ti.com/                                                                      *
 ***************************************************************************************************************************************************
 *  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
 *                                                                                                                                                 *
 *    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
 *                                                                                                                                                 *
 *    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
 *    documentation and/or other materials provided with the distribution.                                                                         *
 *                                                                                                                                                 *
 *    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
 *    from this software without specific prior written permission.                                                                                *
 *                                                                                                                                                 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
 **************************************************************************************************************************************************/
//
//
//   Thomas Schneider
//   Texas Instruments Inc.
//   July 2014
//   Built with Code Composer Studio V6.0
//***************************************************************************************************************************************************

#ifndef HAL_H_
#define HAL_H_

//Ports
#define DAC8760_LATCH_PORTOUT    P2OUT
#define DAC8760_LATCH_PORTDIR    P2DIR
#define DAC8760_SPI_PORTOUT      P1OUT
#define DAC8760_SPI_PORTDIR      P1DIR
#define DAC8760_SPI_PORTSEL      P1SEL


//Port Pins
#define DAC8760_LATCH_PIN        BIT0   //P2.0
#define DAC8760_SIMO_PIN         BIT1   //P1.1
#define DAC8760_SOMI_PIN         BIT2   //P1.2
#define DAC8760_CLK_PIN          BIT0   //P1.0

/**********************************************************************************************************************************/
/*                              PROTOTYPES                                                                                        */
/**********************************************************************************************************************************/

void initPorts(void);
void initClocks(uint32_t mclkFreq);
void DAC8760_SPISetupMaster(void);
uint8_t DAC8760_SPIWriteByte (uint8_t data);
void DAC8760_SPIWrite (uint8_t *outData, uint8_t *inData);

#endif /* HAL_H_ */
