/**************************************************************************************************************************************************
 *       Copyright  2014 Texas Instruments Incorporated - http://www.ti.com/                                                                      *
 ***************************************************************************************************************************************************
 *  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
 *                                                                                                                                                 *
 *    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
 *                                                                                                                                                 *
 *    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
 *    documentation and/or other materials provided with the distribution.                                                                         *
 *                                                                                                                                                 *
 *    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
 *    from this software without specific prior written permission.                                                                                *
 *                                                                                                                                                 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
 **************************************************************************************************************************************************/
//
//  Demo Application for MSP430/DAC8760 Interface Code Library
//  This application configures the DAC8760 for 0-10V and sets the DAC8760 output to 0V
//
//
//   Thomas Schneider
//   Texas Instruments Inc.
//   July 2014
//   Built with Code Composer Studio V6.0
//***************************************************************************************************************************************************


#include <stdint.h>
#include <msp430.h> 
#include "DAC8760.h"
#include "driverlib.h"
//NOTE: Modify hal.h to select a specific board and customize for your own board.
#include "hal.h"


int main(void)
{
    uint8_t status;
    WDTCTL = WDTPW | WDTHOLD;	                                          // Stop watchdog timer
    initPorts();                                                          // Config GPIOS for low-power (output low)
    initClocks(4000000);                                                  // Config clocks. MCLK=SMCLK=FLL=4MHz; ACLK=REFO=32kHz
    DAC8760_Setup((DAC8760_RANGE_0V_10V + DAC8760_OUTEN),0,0,0);          // Config DAC8760
    status = DAC8760_ReadStatus();                                        // Read Status DAC8760
    DAC8760_SetOutValue(0);                                               // Set DAC8760 output value to 0V
    __bis_SR_register(LPM0_bits);                                         // LPM0
    __no_operation();                                                     // For debugger
}
