%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script invokes the top level DDC matlab models of ADC32RF80.
% 
% This code base is a property of Texas Instruments Inc. and has been
% shared for the purpose of evaluation [TI Confidential - NDA
% Restrictions]
%
% Date Created: Mar 30, 2016.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% start fresh
clear all;
close all;
clc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Configure the DDC Parameters %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% DDC system register configuration parameters %
% Decimation mode
% 0 -> Decim_By_4_IQ [Single Band Support]
% 1 -> Decim_By_6_IQ [Single Band Support]
% 2 -> Decim_By_8_IQ [Dual Band Support]
% 3 -> Decim_By_9_IQ [Dual Band Support]
% 4 -> Decim_By_10_IQ [Dual Band Support]
% 5 -> Decim_By_12_IQ [Dual Band Support]
% 7 -> Decim_By_16_IQ [Dual Band Support]
% 8 -> Decim_By_18_IQ [Dual Band Support]
% 9 -> Decim_By_20_IQ [Dual Band Support]
% 10 -> Decim_By_24_IQ [Dual Band Support]
% 12 -> Decim_By_32_IQ [Dual Band Support]
ddcRegConfigParams.DecimFactorIndex_Ch0 = 1; 

%%% Select the number of bands
% 0 -> Single band  [Supported for all decimation factors] 
% 1 -> Dual band    [Supported only for decimation factors 8, 9, ..., 32
ddcRegConfigParams.NumBands_Ch0 = 0; 

%%% Set the DDC center frequency [16 bit value, with LSB = fs/65536]
% FreqWord0_1_Ch0 [Band 0 Center Frequency]
ddcRegConfigParams.FreqWord0_1_Ch0 = 12296;

% FreqWord1_Ch0 [Band 1 Center Frequency - Not used for decimation factors 4 & 6]
ddcRegConfigParams.FreqWord1_Ch0 = 19362;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load the Input Signal        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The input signal should be in integer format and in the range of (-16384,16383)
% DataAdc.txt is a sample signal file with 2 tones, with center frequencies
% at ~0.195*fs & ~0.288*fs
disp('Loading the Input Data File')
DataAdc = load('DataAdc.txt');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Run the DDC Top Level        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Run the top level DDC model
disp('Running the DDC Top code ...')
[ddcOut0,ddcOut1,ddcOutHBW] = DDCTop(ddcRegConfigParams, DataAdc);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Save the Results             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Decimated I/Q Output for decimation factors of 4 & 6 (HBW Mode). Would be
% zero for other decimation factors
disp('Saving the DDC Output Results')

dlmwrite('DdcHbwOut_I.txt', real(ddcOutHBW(:)), 'delimiter','\t', 'precision','%-15d', 'newline', 'pc');
dlmwrite('DdcHbwOut_Q.txt', imag(ddcOutHBW(:)), 'delimiter','\t', 'precision','%-15d', 'newline', 'pc');

% Band 0 Decimated I/Q Output for decimation factors of 8, 9, ..., 32 (LBW
% Mode). Would be zero for other decimation factors
dlmwrite('Ddc0Out_I.txt', real(ddcOut0(:)), 'delimiter','\t', 'precision','%-15d', 'newline', 'pc');
dlmwrite('Ddc0Out_Q.txt', imag(ddcOut0(:)), 'delimiter','\t', 'precision','%-15d', 'newline', 'pc');

% Band 1 Decimated I/Q Output for decimation factors of 8, 9, ..., 32 (LBW
% Mode). Would be zero for other decimation factors & single band
% configurations
dlmwrite('Ddc1Out_I.txt', real(ddcOut1(:)), 'delimiter','\t', 'precision','%-15d', 'newline', 'pc');
dlmwrite('Ddc1Out_Q.txt', imag(ddcOut1(:)), 'delimiter','\t', 'precision','%-15d', 'newline', 'pc');

return;

