// Arudino Sample Code to use ADS1256 library
// Switching channel for ADS1256. This sample code only write to MUX register and read it back.
// The purpose of this code is to show how to use switchChannel function.
// Written by Adien Akhmad, August 2015

#include "ADS1256.h"
#include <SPI.h>
int sensor1;

// Initialize ADS1256 object
ADS1256 adc(7.68, 2.5, false); // clockSpeed in Mhz, DRDY PIN, CS PIN, VREF in volt, RESET PIN are permanently tied to 3.3V

void setup()
{
  Serial.begin(9600);

  // Sending SDATAC to stop reading contionus data, so we can send other command
  adc.sendCommand(SDATAC);
  Serial.println("SDATAC command sent");

  /*  Single Ended Mode
      ADS1256 support 8 single ended channel
      use switchChannel(p) for this purpose, where p is the number of positive input channel between 0 and 7 (AIN0 to AIN7).
      AINCOM are automatically set as the negative input channel.
  */


  /*  Differential Mode
      ADS1256 support 4 differential channel
      use switchChannel(p,n) for this purpose, where
        p is the number of positive input channel between 0 and 7 (AIN0 to AIN7),
        n is the number of negative input channel between 0 and 7 (AIN0 to AIN7).
  */

  Serial.println("Changing channel for differential mode.");


  adc.waitDRDY();
  adc.setChannel(0, 1);
  Serial.print("Current Channel: ");
  Serial.println(adc.readRegister(MUX), HEX); // Read the multiplex register to see the current active channel
  
  // Please note that AINCOM are defined as channel 8
  // When you read the serial output,
  // 08h means AIN0 - AINCOM
  // 18h means AIN1 - AINCOM
  // 28h means AIN2 - AINCOM
  // etc

}

void loop()
{
sensor1 = adc.readChannel();
  Serial.println(sensor1,10);
}
