/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#include <stdint.h>
#include <cstring>
#include <stdio.h>
#include "TI_MSP430.h"
#include "TI_MSP430_hardware_board.h"
#include "host_interface.h"
#include "TI_MSP430_spi.h"

#define PCA9545AMUX 0x70
#define NO_ERROR 0
#define GRAPH_ARRAY_SIZE 24

extern uint8_t DAC128S085_continuous_all_read_flag;
void handle_reInit(uint8_t *pBuf, uint16_t pSize);
uint8_t char2nibble(uint8_t db);
uint16_t dac_graph[GRAPH_ARRAY_SIZE];
uint8_t count = 0;

// Parse Command, then execute
uint8_t handleHostCommand(uint8_t *pBuf, uint16_t pSize)
{
  uint8_t host_response = 0;
  uint8_t nxt_byte;
  uint8_t chan_address, byte_data;
  uint16_t word_data, dac_data;

//  uint32_t time_out_counter;
  
  nxt_byte = char2nibble(pBuf[0]);
  nxt_byte = (nxt_byte << 4) + char2nibble(pBuf[1]);
  switch(nxt_byte)
  {
    case Command_LoopPacket:  
    {
      pBuf[8] = NO_ERROR;
      host_response = 1;
      break;
    }
    case Command_ReInit: 
    {
      handle_reInit(pBuf, pSize);
      
      pBuf[8] = NO_ERROR;      
      host_response = 1;
//      WDTCTL = WDT_MDLY_32;
      break;
    }    
    case Command_SPI_Channel_Write:
    {
      chan_address = char2nibble(pBuf[2]);
      chan_address = (chan_address << 4) + char2nibble(pBuf[3]);
      // low byte first
      dac_data = char2nibble(pBuf[6]);
      dac_data = (dac_data << 4) + char2nibble(pBuf[7]);
      // high byte next
      dac_data = (dac_data << 4) + char2nibble(pBuf[4]);
      dac_data = (dac_data << 4) + char2nibble(pBuf[5]);      
      
      TI_DAC128S085_SPIWriteReg(chan_address, dac_data);      
//      host_response = 1;
      break;
    }
    case Command_SPI_Channel_Graph:
    {
      chan_address = char2nibble(pBuf[2]);
      chan_address = (chan_address << 4) + char2nibble(pBuf[3]);
      // low byte first
      dac_data = char2nibble(pBuf[6]);
      dac_data = (dac_data << 4) + char2nibble(pBuf[7]);
      // high byte next
      dac_data = (dac_data << 4) + char2nibble(pBuf[4]);
      dac_data = (dac_data << 4) + char2nibble(pBuf[5]);      
      
      dac_graph[count++] = dac_data;
      if (count == GRAPH_ARRAY_SIZE)
      {
        uint8_t i;
        
        count = 0;
        for(i=0; i < GRAPH_ARRAY_SIZE; i++)
          TI_DAC128S085_SPIWriteReg(chan_address, dac_graph[i]);
      }
            
//      host_response = 1;
      break;
    }    
  case Command_Firmware_Version_Read:
    {
      pBuf[8] = Firmware_VersionA;
      pBuf[9] = Firmware_VersionB;
      pBuf[10] = Firmware_VersionC;
      pBuf[11] = Firmware_VersionD;
      pBuf[12] = NO_ERROR;      
      host_response = 1;
      break;
    }
  case Command_LED_Toggle:
    {
      // toggle LED
      TI_DAC128S085_GLED_PxOUT ^= TI_DAC128S085_GLED_PIN;
      pBuf[8] = NO_ERROR;      
      host_response = 1;
      break;
    }
  case Command_MSP430SPI_Config_Read:
    {
      pBuf[8] = UCB0CTL0 & 0xC0;
      pBuf[9] = UCB0BR0;
      pBuf[10] = UCB0BR1;
      host_response = 1;
      break;
    }
  case Command_MSP430SPI_Config_Write:
    {
      byte_data = char2nibble(pBuf[2]);
      byte_data = (byte_data <<4) + char2nibble(pBuf[3]); 
      byte_data &= 0xC0;                                                       // make sure only top 2 bits are valid
      // low byte first
      word_data = char2nibble(pBuf[6]);
      word_data = (word_data <<4) + char2nibble(pBuf[7]);
      // high byte next
      word_data = (word_data <<4) + char2nibble(pBuf[4]);
      word_data = (word_data <<4) + char2nibble(pBuf[5]);      
      if (word_data < 1)
        word_data = 1;
      UCB0CTL1 |= UCSWRST;                                                     // **Disable USCI state machine**
      UCB0CTL0 &= 0x3F;                                                        // update 
      UCB0CTL0 |= byte_data;
      UCB0BRW = word_data;                                                     // UCLK divider;
      UCB0CTL1 &= ~UCSWRST;                                                    // **Initialize USCI state machine**
      host_response = 1;
      break;
    }    
    default:
    {
      host_response = 1;
      break;
    }    
  }
  return (host_response);
}

void handle_reInit(uint8_t *pBuf, uint16_t pSize)
{
}
      
uint8_t char2nibble(uint8_t db)
{
  if ((db >= '0') && (db <= '9'))
    return (db-'0');
  else if ((db >= 'A') && (db <= 'F'))
    return (db-'A'+0xa);
  else if ((db >= 'a') && (db <= 'f'))
    return (db-'a'+0xa);
  else
    return (db);
}