/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#define Firmware_VersionA 0
#define Firmware_VersionB 0                            // Major Rev: A + B
#define Firmware_VersionC 0
#define Firmware_VersionD 87                            // Minor Rev: C + D

uint8_t handleHostCommand(uint8_t *pBuf, uint16_t pSize);

//******************************************************************************
//Command and Packet definition
// 
// General & SPI Specific Commands: 0x00 - 0x1F (used in LMP92064, LMP93601, TPL7200)
// Add new I2C & SMBus specific commands: use 0x20 onwards

#define Command_LoopPacket 0x00                                                // Loop back entire packet
								               // PacketBuffer[0],[1] Command
                                                                               // PacketBuffer[8] Response: Error Code 

#define Command_ReInit 0x01                                                    // Controls the firmware settings
									       // PacketBuffer[0],[1] Command    													                                            	                                                	
                                                                               // PacketBuffer[8] Response: Error Code

#define Command_SPI_Byte_Write 2            // Writes data to SPI port
											    // PacketBuffer[0],[1] Command
											    // PacketBuffer[1],[2] SPI Address Byte											    
                                                                                            // PacketBuffer[3],[4] SPI Write Data Byte
  

#define Command_SPI_Byte_Read 3             // Read byte data from SPI port 
											    // PacketBuffer[0],[1] Command
											    // PacketBuffer[1],[2] SPI Address Byte
                                                                                            // PacketBuffer[8] Response: SPI Data Byte Read from device

#define Command_SPI_Word_Read 4             // Read word data from SPI port 
											    // PacketBuffer[0],[1] Command
											    // PacketBuffer[1],[2] SPI Address Byte
                                                                                            // PacketBuffer[8] Response: SPI Data word (low byte) 
                                                                                            // PacketBuffer[9] Response: SPI Data word (mid byte)
                                                                                            // PacketBuffer[9] Response: SPI Data word (high byte)

#define Command_SPI_Channel_Write 5             // Write channel data to SPI port 
											    // PacketBuffer[0],[1] Command
                                                                                            // PacketBuffer[2],[3] Channel Number
                                                                                            // PacketBuffer[4],[5] Channel data low byte 
                                                                                            // PacketBuffer[6],[7] Channel data high byte

#define Command_SPI_Channel_Graph 6             // Write channel Graph data to SPI port 
											    // PacketBuffer[0],[1] Command
                                                                                            // PacketBuffer[2],[3] Channel Number
                                                                                            // PacketBuffer[4],[5] Channel data low byte 
                                                                                            // PacketBuffer[6],[7] Channel data high byte

#define Command_Firmware_Version_Read 0x09                                     // Read firmware version 
									       // PacketBuffer[0],[1] Command
                                                                               // PacketBuffer[8] Response: Firmware VersionA 
                                                                               // PacketBuffer[9] Response: Firmware VersionB
                                                                               // PacketBuffer[10] Response: Firmware VersionC 
                                                                               // PacketBuffer[11] Response: Firmware VersionD
                                                                               // PacketBuffer[12] Response: Error Code

#define Command_LED_Toggle 0x0A                                                // Toggle LED
									       // PacketBuffer[0],[1] Command
                                                                               // PacketBuffer[8] Response: Error Code

#define Command_MSP430SPI_Config_Read 0x0B      // Read MSP430 SPI config info 
											    // PacketBuffer[0],[1] Command                            
                                                                                            // PacketBuffer[8] Response: SPI Clock Config   
                                                                                            // PacketBuffer[9] Response: SPI clock divider (low byte)
                                                                                            // PacketBuffer[10] Response: SPI clock divider (high byte)
                                                                                            // PacketBuffer[11] Response: Timer based Sampling Rate

#define Command_MSP430SPI_Config_Write 0x0C      // Write MSP430 SPI config info 
											    // PacketBuffer[0],[1] Command
											    // PacketBuffer[2],[3] SPI Clock Config
                                                                                            // PacketBuffer[4],[5] SPI Clock divider low byte
                                                                                            // PacketBuffer[6],[7] SPI Clock divider high byte
                                                                                            // Packet Buffer [8],[9] Timer based Sampling Rate

