/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#include <intrinsics.h>
#include <string.h>

#include <stdint.h>
#include <cstring>
#include <stdio.h>

#include "TI_MSP430.h"
#include "TI_MSP430_hardware_board.h"
#include "TI_MSP430_spi.h"    
#include "host_interface.h"
#include "TI_MSP430_spi.h"
#include "timer_queue.h"
#include "host_interface.h"

#include "USB_config/descriptors.h"

#include "USB_API/USB_Common/device.h"
#include "USB_API/USB_Common/types.h"               //Basic Type declarations
#include "USB_API/USB_Common/usb.h"                 //USB-specific functions

#include "F5xx_F6xx_Core_Lib/HAL_UCS.h"
#include "F5xx_F6xx_Core_Lib/HAL_PMM.h"

#include "USB_API/USB_CDC_API/UsbCdc.h"
#include "usbConstructs.h"

//******************************************************************************
#define MAX_STR_LENGTH 32
//******************************************************************************
void InitMCU(void);
void Init_Ports (void);
void Init_Clock (void);
void USBCommunicationTask(void);

volatile BYTE bCDCDataReceived_event = FALSE;   //Indicates data has been received without an open rcv operation

WORD w;

BYTE bufferX[BUF_LENGTH];
BYTE bufferY[BUF_LENGTH];

uint8_t *mbuf=bufferX;
uint8_t *ubuf;


uint8_t cmdResponseString[MAX_STR_LENGTH] = "";



/*----------------------------------------------------------------------------*/
uint32_t err_count = 0;
uint32_t clk_count;
int8_t err_code;
//******************************************************************************

void main(void)
{  
  
  WDTCTL = WDTPW + WDTHOLD;                                                    //Stop watchdog timer  

  TI_DAC128S085_GLED_PxOUT |= TI_DAC128S085_GLED_PIN;                                // Set LED ON
  TI_DAC128S085_GLED_PxDIR |= TI_DAC128S085_GLED_PIN;                                // Set pin direction output  

  TI_DAC128S085_RLED_PxOUT &= ~TI_DAC128S085_RLED_PIN;                               // Set RED OFF
  TI_DAC128S085_RLED_PxDIR |= TI_DAC128S085_RLED_PIN;                                // Set pin direction output  
   
  // oscillator fail if LED keeps flashing after InitMCU     
  InitMCU();
  
  // Initilaize MSP430 SPI Block 
  TI_DAC128S085_SPISetup();                                                       
  
#if 0
  // test code (next 4 lines)
  DAC128S085_channel = 7;
  
#endif
  
  while (1)
  {
//    __bis_SR_register(LPM0_bits + GIE);                                        // Enter LPM0, enable interrupts
    __no_operation();                                                          // For debugger     
      USBCommunicationTask(); 
      __no_operation();                                                          // For debugger     
  }

}

//******************************************************************************
/**
* @brief  Local functions.                           
*/

/**
* @brief Function Name:  InitMCU.                                                
* @brief Description  :  Initializes the MSP430 peripherals and modules.
* @param parameters   :  none                                                   
* @return Value       :  none                                                   
*/   
//******************************************************************************
void InitMCU(void)
{
  
  __disable_interrupt();                                                       // Disable global interrupts 
//    Init_Ports();                                                              //Init ports (do first ports because clocks do change ports)
    SetVCore(3);
    Init_Clock();                                                              //Init clocks
#if 1	
    USB_init();                 //Init USB

    USB_setEnabledEvents(
        kUSB_VbusOnEvent + kUSB_VbusOffEvent + kUSB_receiveCompletedEvent
        + kUSB_dataReceivedEvent + kUSB_UsbSuspendEvent + kUSB_UsbResumeEvent +
        kUSB_UsbResetEvent);

    //Check if we're already physically attached to USB, and if so, connect to it
    //This is the same function that gets called automatically when VBUS gets attached.
    if (USB_connectionInfo() & kUSB_vbusPresent){
        USB_handleVbusOnEvent();
    }
#endif
  __enable_interrupt();                                                        // enable global interrupts

}

//******************************************************************************
/**
* @brief Function Name: USBCommunicationTask     .                                             
* @brief Description  : Dumps data to the host over USB.
* @param parameters   : none                                                    
* @return Value       : none                                                    
*/   
//******************************************************************************
void USBCommunicationTask(void)
{
  WORD bytesSent, bytesReceived;
  uint16_t count;
  uint8_t send_error=0, receive_error=0, send_response, i;
  
        switch (USB_connectionState())
        {
            case ST_USB_DISCONNECTED:
//                __bis_SR_register(LPM3_bits + GIE);                     //Enter LPM3 w/interrupt
                _NOP();
                break;

            case ST_USB_CONNECTED_NO_ENUM:
                break;

            case ST_ENUM_ACTIVE:
                if (USBCDC_intfStatus(CDC0_INTFNUM,&bytesSent, &bytesReceived) & kUSBCDC_waitingForSend)
                    err_count++;
                // Exit LPM because of a data-receive event, and fetch the received data 
                if(bCDCDataReceived_event)
                {
                  bCDCDataReceived_event = FALSE;                                  // Clear flag early -- just in case execution breaks below because of an error
                  count = cdcReceiveDataInBuffer(cmdResponseString,MAX_STR_LENGTH,CDC0_INTFNUM);         // Count has the number of bytes received into dataBuffer    
                  send_response = handleHostCommand(cmdResponseString,count);
                  if (send_response)
                  {
                    if(cdcSendDataInBackground((BYTE*)cmdResponseString,MAX_STR_LENGTH,CDC0_INTFNUM,0))             // Send data to host
                    {
                      send_error = 1;                                            // Something went wrong -- exit
                      break;
                    }
                  }                  
                  for(i=0;i<MAX_STR_LENGTH;i++) 
                    cmdResponseString[i] = NULL;
                }      
                break;

            case ST_ENUM_SUSPENDED:
//                __bis_SR_register(LPM3_bits + GIE);             //Enter LPM3 until a resume or VBUS-off event
                break;

            case ST_ENUM_IN_PROGRESS:
                break;

            case ST_NOENUM_SUSPENDED:
//                __bis_SR_register(LPM3_bits + GIE);
                break;

            case ST_ERROR:
                _NOP();
                break;

            default:;
        }                                                                            //end of switch-case sentence
        if(send_error || receive_error)
        { 
          //TO DO: User can place code here to handle error
        }        
}
//******************************************************************************
void Init_Clock(void)
{
  
  // Enable XT2 (4MHz) XIN/XOUT Pins: XT2 is needed for USB
  P5SEL |= 0x0C;                            // Select XIN, XOUT on P5.3 and P5.2
  UCSCTL6 &= ~XT2OFF;                       // Enable XT2  
  UCSCTL6 |= XT2DRIVE_3; 
  
  // Enable XT1 (32kHz) Pins
  P5SEL |= BIT4+BIT5;                       // Select XT1

  UCSCTL6 &= ~(XT1OFF);                     // XT1 On
  UCSCTL6 |= XCAP_3;                        // Internal load cap
  
  // FLL Reference Clock = XT1
  UCSCTL3 = 0;                              // FLL Reference Clock = XT1

  // Loop until XT1,XT2 & DCO stabilizes - In this case loop until XT1 and DCo settle
  do
  {
    UCSCTL7 &= ~(XT2OFFG + XT1LFOFFG + DCOFFG);
                                            // Clear XT2,XT1,DCO fault flags
    SFRIFG1 &= ~OFIFG;                      // Clear fault flags
    TI_DAC128S085_RLED_PxOUT ^= TI_DAC128S085_RLED_PIN;                              // Toggle LED
    __delay_cycles(250000);    
  }while (SFRIFG1&OFIFG);                   // Test oscillator fault flag
  
  UCSCTL6 &= ~(XT1DRIVE_3);                 // Xtal is now stable, reduce drive strength

  UCSCTL4 |= SELA_0;                        // ACLK = LFTX1 (by default)

  // Set DCO freq to 24MHz
  __bis_SR_register(SCG0);                  // Disable the FLL control loop
  UCSCTL0 = 0x0000;                         // Set lowest possible DCOx, MODx
  UCSCTL1 = DCORSEL_7;                      // Select DCO range 50MHz operation
  UCSCTL2 = FLLD_0 + 747;                   // Set DCO Multiplier(762/498) for 25MHz/16MHz
                                            // (N + 1) * FLLRef = Fdco
                                            // (762 + 1) * 32768 = 25MHz
                                            // Set FLL Div = fDCOCLK/2
  __bic_SR_register(SCG0);                  // Enable the FLL control loop

  // Worst-case settling time for the DCO when the DCO range bits have been
  // changed is n x 32 x 32 x f_MCLK / f_FLL_reference. See UCS chapter in 5xx
  // UG for optimization.
  // 32 x 32 x 25 MHz / 32,768 Hz ~ 780k MCLK cycles for DCO to settle
  __delay_cycles(782000);

  // Loop until XT1,XT2 & DCO stabilizes - In this case only DCO has to stabilize
  do
  {
    UCSCTL7 &= ~(XT2OFFG + XT1LFOFFG + DCOFFG);
                                            // Clear XT2,XT1,DCO fault flags
    SFRIFG1 &= ~OFIFG;                      // Clear fault flags
    TI_DAC128S085_RLED_PxOUT ^= TI_DAC128S085_RLED_PIN;                              // Toggle LED
    __delay_cycles(250000);    
  }while (SFRIFG1&OFIFG);                   // Test oscillator fault flag  
  
  // SMCLK = MCLK = 24MHz DCO, ACLK = 32KHz XT1
  UCSCTL4 = SELA__XT1CLK + SELS__DCOCLKDIV + SELM__DCOCLKDIV;                  // SMCLK=MCLK=

  // Loop until XT1,XT2 & DCO stabilizes - In this case only DCO has to stabilize
  do
  {
    UCSCTL7 &= ~(XT2OFFG + XT1LFOFFG + DCOFFG);
                                            // Clear XT2,XT1,DCO fault flags
    SFRIFG1 &= ~OFIFG;                      // Clear fault flags
    TI_DAC128S085_RLED_PxOUT ^= TI_DAC128S085_RLED_PIN;                              // Toggle LED
    __delay_cycles(250000);    
  }while (SFRIFG1&OFIFG);                   // Test oscillator fault flag  
     
  TI_DAC128S085_RLED_PxOUT &= ~TI_DAC128S085_RLED_PIN;                                // turn off red          
}
//******************************************************************************
/*  
 * ======== UNMI_ISR ========
 */
#pragma vector = UNMI_VECTOR
__interrupt VOID UNMI_ISR (VOID)
{
    switch (__even_in_range(SYSUNIV, SYSUNIV_BUSIFG ))
    {
        case SYSUNIV_NONE:
            __no_operation();
            break;
        case SYSUNIV_NMIIFG:
            __no_operation();
            break;
        case SYSUNIV_OFIFG:
            UCSCTL7 &= ~(DCOFFG + XT1LFOFFG + XT2OFFG); //Clear OSC flaut Flags fault flags
            SFRIFG1 &= ~OFIFG;                          //Clear OFIFG fault flag
            break;
        case SYSUNIV_ACCVIFG:
            __no_operation();
            break;
        case SYSUNIV_BUSIFG:
            SYSBERRIV = 0;                                      //clear bus error flag
            USB_disable();                                      //Disable
    }
}
//******************************************************************************
//EOF