//******************************************************************************
//  Description:  This file contains functions that setups timerA0 for sampling.
//  Also, there are queue functions to queue and dequeue samples. Timer isr queues
//  the samples, while the usb communication task unqueues it to transmit out.
//  MSP430/ADC128S102 Interface Code Library v1.0
// 
//
//   Vishy Natarajan
//   Texas Instruments Inc.
//   February 2012
//   Built with CCE Version: 4.2 and IAR Embedded Workbench Version:  5.3x
//******************************************************************************
/*  Copyright 2011-2012 Texas Instruments Incorporated. All rights reserved.

  IMPORTANT: Your use of this Software is limited to those specific rights
  granted under the terms of a software license agreement between the user who
  downloaded the software, his/her employer (which must be your employer) and
  Texas Instruments Incorporated (the "License"). You may not use this Software
  unless you agree to abide by the terms of the License. The License limits your
  use, and you acknowledge, that the Software may not be modified, copied or
  distributed unless embedded on a Texas Instruments microcontroller which is 
  integrated into your product. Other than for the foregoing purpose, you may 
  not use, reproduce, copy, prepare derivative works of, modify, distribute, 
  perform, display or sell this Software and/or its documentation for any 
  purpose.

  YOU FURTHER ACKNOWLEDGE AND AGREE THAT THE SOFTWARE AND DOCUMENTATION ARE
  PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED,
  INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, TITLE,
  NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL TEXAS
  INSTRUMENTS OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER CONTRACT,
  NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR OTHER LEGAL
  EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES INCLUDING BUT NOT
  LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR CONSEQUENTIAL
  DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF SUBSTITUTE GOODS,
  TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
  LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

  Should you have any questions regarding your right to use this Software,
  contact Texas Instruments Incorporated at www.TI.com.
*******************************************************************************/

#include <stdint.h>
#include <cstring>
//#include <cstdio>
#include <stdio.h>
#include "TI_MSP430.h"
#include "TI_MSP430_hardware_board.h"
#include "TI_MSP430_spi.h"
#include "timer_queue.h"
/*----------------------------------------------------------------------------*/
#define INTERVAL_500us         3000                                            // SMCLK = 24MHz & %4
// smclk = 24mhz, div = 8
#define INT_5us               15
#define INT_8us               24
#define INT_10us               30 
#define INT_20us               60
/*----------------------------------------------------------------------------*/
extern volatile uint8_t ADC128S102_XYBufferReady;
extern uint8_t ADC128S102_continuous_all_read_flag;
extern uint8_t ADC128S102_channel;
extern uint8_t bufferX[], bufferY[];
extern uint8_t *mbuf, *ubuf;
//******************************************************************************

//------------------------------------------------------------------------------
//  void timerA1_init(void)
//
//  DESCRIPTION:
//  Initialize timer1 A0 to generat 1sec interrupt.   
//  Note: This function is for MSP430F5528 & might need modifications for other MSP430s
//------------------------------------------------------------------------------
void timerA1_init(void)
{
        
//  TA1CCTL0 = CCIE;                                                           // TA1CCR0 interrupt enabled
  // Use INT_10us for 100kHz interval, INT_20us for 50kHz
  TA1CCR0 = INT_10us * NUM_SAMPLES;                                            	
  TA1CTL = TASSEL_2 + MC_1 + TACLR + ID_3;                                     // SMCLK (24MHz), upmode, clear TAR, divide by 8 
    
}
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// Timer1 A0 interrupt service routine
// Note: This ISR is for MSP430F5528 & might need modifications for other MSP430s
//------------------------------------------------------------------------------
#pragma vector=TIMER1_A0_VECTOR
__interrupt void TIMER1_A0_ISR (void)
{  
  static uint16_t mbx = 0;
  uint16_t rdata;
    __no_operation();                                                          // Set Breakpoint here & see measured ain_plus 
    if (ADC128S102_continuous_all_read_flag)                                   // Continuous conversion 
    {
      
      rdata = TI_ADC128S102_SPIReadReg(ADC128S102_channel);                    // read adc output into read_buf
      mbuf[mbx++] = rdata;
      mbuf[mbx++] = rdata >> 8;
      if (mbx == BUF_LENGTH)
        
//      TI_ADC128S102_SPIReadRegContinuous(ADC128S102_channel, (mbuf+(mbx*NUM_SAMPLES*2)), NUM_SAMPLES);          // read adc output into read_buf
//      mbx++;
//      if (mbx == NUM_BLOCKS)
      {
        mbx = 0;
        ADC128S102_XYBufferReady = 1;
        ubuf = mbuf;
        if (mbuf == bufferX)
          mbuf = bufferY;
        else
          mbuf = bufferX;
      }
    } 
//    TI_ADC128S102_gpio_time1_PxOUT ^= TI_ADC128S102_gpio_time1_PIN;                        // toggle gpio                                                     
//  __bic_SR_register_on_exit(LPM0_bits);                                      // Exit active CPU  
}
//******************************************************************************
