/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#ifndef HEADER_FILE_TI_DAC128S085_MSP430_H

#define HEADER_FILE_TI_DAC128S085_MSP430_H

#include "msp430.h"

//******************************************************************************
// SPI port definitions
// Adjust the values for the chosen interfaces, according to the pin
// assignments indicated in the chosen MSP430 device datasheet.
//******************************************************************************
// SPI port definitions 

// USCIB0 for F552x
#define TI_DAC128S085_SPI_USCIB0_SIMO_PxSEL            P3SEL
#define TI_DAC128S085_SPI_USCIB0_SOMI_PxSEL            P3SEL
#define TI_DAC128S085_SPI_USCIB0_UCLK_PxSEL            P3SEL
#define TI_DAC128S085_SPI_USCIB0_SIMO_PxDIR            P3DIR
#define TI_DAC128S085_SPI_USCIB0_UCLK_PxDIR            P3DIR
#define TI_DAC128S085_SPI_USCIB0_PxIN    P3IN
#define TI_DAC128S085_SPI_USCIB0_SIMO    BIT0
#define TI_DAC128S085_SPI_USCIB0_SOMI    BIT1
#define TI_DAC128S085_SPI_USCIB0_UCLK    BIT2


//******************************************************************************
//  These constants are used to identify the chosen SPI and USART interfaces.
//******************************************************************************
#define TI_DAC128S085_SER_INTF_NULL         0
#define TI_DAC128S085_SER_INTF_USCIA0_5xx   1
#define TI_DAC128S085_SER_INTF_USCIA1_5xx   2
#define TI_DAC128S085_SER_INTF_USCIA2_5xx   3
#define TI_DAC128S085_SER_INTF_USCIA3_5xx   4
#define TI_DAC128S085_SER_INTF_USCIB0_5xx   5
#define TI_DAC128S085_SER_INTF_USCIB1_5xx   6
#define TI_DAC128S085_SER_INTF_USCIB2_5xx   7
#define TI_DAC128S085_SER_INTF_USCIB3_5xx   8
#define TI_DAC128S085_SER_INTF_USART0       9
#define TI_DAC128S085_SER_INTF_USART1       10
#define TI_DAC128S085_SER_INTF_USCIA0       11
#define TI_DAC128S085_SER_INTF_USCIA1       12
#define TI_DAC128S085_SER_INTF_USCIB0       13
#define TI_DAC128S085_SER_INTF_USCIB1       14
#define TI_DAC128S085_SER_INTF_USI          15
#define TI_DAC128S085_SPI_BITBANG           16

#endif                                                                         // HEADER_FILE_TI_DAC128S085_MSP430_H
