/* --COPYRIGHT--,BSD
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

#ifndef HEADER_FILE_TI_MSP430_HARDWARE_BOARD_H

#define HEADER_FILE_TI_MSP430_HARDWARE_BOARD_H

#define TI_DAC128S085_RLED_PxOUT            P1OUT
#define TI_DAC128S085_RLED_PxDIR            P1DIR
#define TI_DAC128S085_RLED_PIN              BIT0

#define TI_DAC128S085_GLED_PxOUT            P4OUT
#define TI_DAC128S085_GLED_PxDIR            P4DIR
#define TI_DAC128S085_GLED_PIN              BIT7

#define TI_DAC128S085_CSn_PxOUT             P6OUT
#define TI_DAC128S085_CSn_PxDIR             P6DIR
#define TI_DAC128S085_CSn_PIN               BIT5                                   


// GPIO Bit Bang (pins same as USCIA1) for DAC128S085 SPI Connection
#define TI_DAC128S085_SPI_BITBANG_SIMO_PxSEL           P3SEL
#define TI_DAC128S085_SPI_BITBANG_SOMI_PxSEL           P3SEL
#define TI_DAC128S085_SPI_BITBANG_UCLK_PxSEL           P3SEL

#define TI_DAC128S085_SPI_BITBANG_PxDIR                P3DIR
#define TI_DAC128S085_SPI_BITBANG_PxOUT                P3OUT
#define TI_DAC128S085_SPI_BITBANG_PxIN                 P3IN
#define TI_DAC128S085_SPI_BITBANG_SIMO                 BIT0
#define TI_DAC128S085_SPI_BITBANG_SOMI                 BIT1
#define TI_DAC128S085_SPI_BITBANG_UCLK                 BIT2

//----------------------------------------------------------------------------
// Select which port will be used for interface to DAC128S085
//----------------------------------------------------------------------------
#define TI_DAC128S085_SER_INTF            TI_DAC128S085_SER_INTF_USCIB0_5xx   // 5xx, 6xx family USCIB0 SPI Interface to DAC128S085
//#define TI_DAC128S085_SER_INTF            TI_DAC128S085_SPI_BITBANG             // BITBANG SPI connected to DAC128S085 SPI pins to DAC128S085


#endif                                                                         // HEADER_FILE_TI_MSP430_HARDWARE_BOARD_H