from ftd2xx_controller import ftd2xxController as ftd
from fileIO.parse_config import parse_HSC_config

import os

os.chdir(os.path.dirname(os.path.abspath(__file__))) # Make sure current working directory is location of this script so relaive directories work properly. 

serial = "" # If multiple FTDI devices are connected to PC, provide serial number of EVM serial from FT_PROG. 

if serial == "" or serial == None: # If the DAC EVM is the only FTDI device connected to PC the serial can be left blank and this script can blindly open it. 
    ftd.create_device_info_list()
    FTDI = ftd.open_FT(ftd.get_device_info_detail(1)['serial'].decode()) # SPI communication is performed on bus B (index 1) of FTDI chip. 
else:
    FTDI = ftd.open_FT(serial, "B") # SPI communication is performed on bus B of FTDI chip. 

DAC = FTDI.init_SPI(sclk = 0, mosi = 1, miso = 5, csb = 3, oe = 7, oe_pol = False, addr_bits = 7, data_bits = 16)   # DAC3XJ8X 3 wire SPI parameters. 
LMK = FTDI.init_SPI(sclk = 0, mosi = 1, miso = 6, csb = 4, oe = 7, oe_pol = False, addr_bits = 15, data_bits = 8)   # LMK04828 3 wire SPI parameters. 
 
DAC.write(0x02, 0x01) # Perform SPI reset of DAC.

DAC.write(0x12, 0x55A0)     # write to config 18 register (phaseoffsetab[15:0]) as all 16 bits of this register are writable. 
print(hex(DAC.read(0x12)))  # Ensure readback of config 18 register is correct on DAC. 

LMK.write(0x167, 0xAA)      # write to register address 0x167 (PLL2_N[15:8]) as all 8 bits of this register are writable. 
print(hex(LMK.read(0x167))) # Ensure readback of register address 0x167 is correct on LMK.  

addr, data = parse_HSC_config("./configuration_files/default_124.cfg", device_name = "DAC3XJ8X") # Load registers from .cfg file generated from DAC EVM GUI. 

print("Found", len(addr), "Registers in configuration file to write to DAC")
DAC.write(addr, data) # Can also write many registers to device in single call. 

addr, data = parse_HSC_config("./configuration_files/external_clock.cfg", device_name = "LMK04828") # Load registers from .cfg file generated from DAC EVM GUI. 

print("Found", len(addr), "Registers in configuration file to write to LMK")
LMK.write(addr, data) # Can also write many registers to device in single call. 






