/*
 * DAC53701EVM
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <Wire.h>

#define NVM_PROG 0 //write 1 to save settings to NVM

#define I2C_ADDR 0x48

/*#define I2C_ADDR_ALO 0x48 //I2C address definitions
#define I2C_ADDR_AHI 0x49 //EVM pulls A0 High
#define I2C_ADDR_ASDA 0x4A
#define I2C_ADDR_ASCL 0x4B */


void setup()
{
    
  int MSB=0, LSB=0; //MSB, LSB variables for reading back registers
  
  Serial.begin(9600);
  Serial.println("Starting Example...");
  Wire.begin(); // join i2c bus (address optional for master)
  
  //SYNTAX: WRITE <REGISTER NAME (Hex code)>, <MSB DATA>, <LSB DATA>
 
  //Set DAC_DATA to midscale
  //WRITE DAC_DATA(0x21), 0x08, 0x00
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0xD3)); // DAC_DATA Register
  Wire.write(byte(0x00)); // 
  Wire.write(byte(0x00)); // 
  Wire.endTransmission(); // stop transmitting
  
  //Power up DAC output, enable internal reference with VOUT gain = 4x
  //WRITE GENERAL_CONFIG(0xD1), 0x00, 0x00
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0xD1)); // GENERAL_CONFIG Register
  Wire.write(byte(0x4F)); // 
  Wire.write(byte(0x27)); // 
  Wire.endTransmission(); // stop transmitting
  
  
  //Set DAC_DATA to midscale
  //WRITE DAC_DATA(0x26), 0x08, 0x00
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0x21)); // DAC_DATA Register
  Wire.write(byte(0x88)); // 
  Wire.write(byte(0x00)); // 
  Wire.endTransmission(); // stop transmitting
  
  //Set DAC_DATA to midscale
  //WRITE DAC_DATA(0x26), 0x08, 0x00
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0x25)); // DAC_DATA Register
  Wire.write(byte(0x03)); // 
  Wire.write(byte(0x7C)); // 
  Wire.endTransmission(); // stop transmitting
  
  //Set DAC_DATA to midscale
  //WRITE DAC_DATA(0x26), 0x08, 0x00
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0x26)); // DAC_DATA Register
  Wire.write(byte(0x00)); // 
  Wire.write(byte(0xFC)); // 
  Wire.endTransmission(); // stop transmitting
  
  //Set DAC_DATA to midscale
  //WRITE DAC_DATA(0x21), 0x08, 0x00
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0xD3)); // DAC_DATA Register
  Wire.write(byte(0x01)); // 
  Wire.write(byte(0x00)); // 
  Wire.endTransmission(); // stop transmitting
  
  
  //Read DAC_DATA
  Wire.beginTransmission(I2C_ADDR); // DAC53401 Slave Address
  Wire.write(byte(0x21)); // DAC_DATA Register
  Wire.endTransmission(); // stop transmitting
  Wire.requestFrom(I2C_ADDR,2); // request 2 bytes from DAC53401 Slave Address
  MSB= Wire.read(); // read MSB
  LSB= Wire.read(); // read LSB
  Serial.print("DAC_DATA = ");
  Serial.println( ((MSB << 8) +LSB), HEX);
  
  
#if NVM_PROG
  //Trigger NVM write
  //WRITE TRIGGER(0xD3), 0x00, 0x10
  Wire.beginTransmission(I2C_ADDR); // 
  Wire.write(byte(0xD3)); // TRIGGER Register
  Wire.write(byte(0x00)); // 
  Wire.write(byte(0x10)); // Programs NVM
  Wire.endTransmission(); // stop transmitting
#endif

  Serial.println("...Done");

}


void loop()
{

    
}
