/*************************************************************************************************************************************************/
/*!     Thermocouple temperature application Code TIDA-00168
 *
 *       The Thermocouple Transmitter reference design is a system solution providing precision K type thermocouples measurements.
 *       This design is intended as an evaluation module for users to develop end products for factory automation and process control applications.
 *       The software is specifically written to execute on a MSP430FR5949.
 *
 *
 */
/**************************************************************************************************************************************************
 *       Copyright  2014 Texas Instruments Incorporated - http://www.ti.com/                                                                      *
 ***************************************************************************************************************************************************
 *  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: *
 *                                                                                                                                                 *
 *    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.                 *
 *                                                                                                                                                 *
 *    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the        *
 *    documentation and/or other materials provided with the distribution.                                                                         *
 *                                                                                                                                                 *
 *    Neither the name of Texas Instruments Incorporated nor the names of its contributors may be used to endorse or promote products derived      *
 *    from this software without specific prior written permission.                                                                                *
 *                                                                                                                                                 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          *
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT     *
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT         *
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    *
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE      *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                                           *
 **************************************************************************************************************************************************/

#include <msp430.h>
#include <stdint.h>
#include "ADS1220.h"
#include "main.h"


volatile unsigned char ReadConversionData = 0;

void portsInit (void);
void startWDT(void);
void config_clock (void);

//=================================================================================================================================================
//Main
//=================================================================================================================================================
void main (void)
{
    static volatile unsigned char tempData[3];
    volatile long ADS1220code;
    unsigned char configIN[4];
    unsigned char configOUT[4];

    WDTCTL = WDTPW | WDTHOLD;   // Stop watchdog timer
    portsInit ();
    config_clock ();
    __enable_interrupt();
    // Configure the SPI components
    Setup_SPI_Master ();

    // Reset the ADS1220
    ADS1220_Reset();

    // Configure ADS1220 for first measurement
    configIN[0]=ADS1220_MUX_AIN1_AIN0+ADS1220_GAIN_32+ADS1220_USE_PGA;
    ADS1220_Write_Regs (configIN, ADS1220_CONFIG_0_REG, 1);
    ADS1220_Read_Regs (&configOUT, ADS1220_CONFIG_0_REG, 1);


      // Delay 500ms to allow for IDAC and Input Filter settling
    __delay_cycles(CPU_CLK/2);

    LED_POUT |= LED_GREEN_BIT;
   while (1)
    {
   /*    __delay_cycles(CPU_CLK/10);
       ReadConversionData = 0;
       ADS1220_Start ();
        // measure internal Temperature Sensor
       Setup_ADS1220 (ADS1220_MUX_AIN0_AIN1, ADS1220_OP_MODE_NORMAL,
               ADS1220_CONVERSION_SINGLE_SHOT, ADS1220_DATA_RATE_20SPS, ADS1220_GAIN_1, ADS1220_USE_PGA,
               ADS1220_IDAC1_DISABLED, ADS1220_IDAC2_DISABLED , ADS1220_IDAC_CURRENT_OFF , ADS1220_VREF_INTERNAL , ADS1220_TEMP_SENSOR_ON);

             // Only one start needed for Continuous Mode
        while (!ReadConversionData);   // Wait for Data Ready interrupt
        ADS1220_Get_Conversion_Data((unsigned char *)tempData);
        ADS1220code = (((long)tempData[0] << 16) + ((long)tempData[1] << 8) + (long)tempData[2]) >> 10;   // take 3 bytes of voltage returned and place in word
    */}

}



/*************************************************************************************************************************************************
 *  portsInit
 **************************************************************************************************************************************************/
/*!
 * @brief Initialize the CLOCK at 8Mhz
 *
 * @return  none
 **************************************************************************************************************************************************/
void config_clock (void)
{
    /* MCLK/SMCLK: DCO */
    // Select lowest DCOx and MODx settings
    DCOCTL = 0;
    // Set DCO range
    BCSCTL1 = CALBC1_8MHZ;
    // Set DCO step + modulation
    DCOCTL = CALDCO_8MHZ;
}

/*************************************************************************************************************************************************
 *  portsInit
 **************************************************************************************************************************************************/
/*!
 * @brief Initialize the GPIO pins on the MSP430FR5949 for use with ADS1220
 *
 * This function is called once to configure the GPIO pins on the system.
 *
 * @return  none
 **************************************************************************************************************************************************/
void portsInit (void)
{
    P1OUT &= ~UNUSED_P1_BITS;
    P1DIR |= UNUSED_P1_BITS;
    P2OUT &= ~UNUSED_P2_BITS;
    P2DIR |= UNUSED_P2_BITS;
    P3OUT &= ~UNUSED_P3_BITS;
    P3DIR |= UNUSED_P3_BITS;


    //initialize LEDs
    LED_POUT &= ~(LED_GREEN_BIT);
    LED_PDIR |= (LED_GREEN_BIT);

    //ADS1220 nDRDY Interrupt
    P2IES |=  (ADS_DRDY_N_BIT);         // High to Low Edge
    P2IFG &= ~(ADS_DRDY_N_BIT);         // Clear any previous interrupt
    P2IE  |=  (ADS_DRDY_N_BIT);

    ADS_CS_N_POUT |= ADS_CS_N_BIT;
    ADS_CS_N_PDIR |= ADS_CS_N_BIT;

    P3SEL &= ~(ADS_CLK_BIT +  ADS_DIN_BIT +  ADS_DOUT_BIT);
    P3SEL |= (ADS_CLK_BIT +  ADS_DIN_BIT +  ADS_DOUT_BIT);
}

/**************************************************************************************************************************************************
 * PORT1_ISR
 **************************************************************************************************************************************************/
/*!
 * @brief Port 2 Interrupt Routine
 *
 *
 * @return None
 **************************************************************************************************************************************************/
#pragma vector = PORT2_VECTOR
__interrupt void PORT2_ISR (void)
{
    unsigned char interrupts = ADS_DRDY_N_PIFG;

    P2IFG &=~ADS_DRDY_N_BIT ;
    // Has a Data Ready occurred from the ADS1220?
        ReadConversionData = 1;
        //__bic_SR_register_on_exit(CPUOFF);      // Exit LPM0
}
