//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor             : Xilinx
// \   \   \/    Version            : $Name: i+IP+125372 $
//  \   \        Application        : MIG
//  /   /        Filename           : ads5463_ddrif.v
// /___/   /\    Date Last Modified : $Date: 2007/04/18 13:49:24 $
// \   \  /  \   Date Created       : Mon May 2 2005
//  \___\/\___\
//
// Device      : Virtex-4
// Design Name : DDR2 SERDES
// Purpose     : This module is the top level module for the interface.This
//               instantiates ddrif_main_0,infrastrucutre
//               and idelay_ctrl modules.
///////////////////////////////////////////////////////////////////////////////

//`timescale 1ns/1ps

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module ads5463_ddrif
       (
   input [`data_width-1:0] cntrl0_DDR2_DQ,
   input  REF_CLK200_IN,
   input  SYS_RESET_IN_N,
   input  cntrl0_DDR2_DQS,

   input		dlyen,
   input  		dlyinc,
   input  		dlyrst,
   input  		dlyclk_sel,
	input	[7:0]	capture_modes,
	input	[7:0]	channel_sel,
   input [`data_width-1:0]	dlydbit_sel,
   input [5:0]	dlyinc_val,

   output CLK,
   output CLK90,
   output CLKDIV_0,
   output CLKDIV_90,
   output RESET0,
   output RESET90,
   output RESET270,   

   output				  dqs_div,
   output [`dq_width-1:0] cntrl0_READ_DATA0,
   output [`dq_width-1:0] cntrl0_READ_DATA1,
   output [`dq_width-1:0] cntrl0_READ_DATA2,
   output [`dq_width-1:0] cntrl0_READ_DATA3,
	output [`dq_width-1:0] cntrl0_READ_DATA4,
   output [`dq_width-1:0] cntrl0_READ_DATA5,
   output [`dq_width-1:0] cntrl0_READ_DATA6,
   output [`dq_width-1:0] cntrl0_READ_DATA7

        );
   wire clk_200;
   wire idelay_ctrl_rdy;
   wire rst200;   
   wire [`dq_width-1:0] READ_DATA0;
   wire [`dq_width-1:0] READ_DATA1;
   wire [`dq_width-1:0] READ_DATA2;
   wire [`dq_width-1:0] READ_DATA3;
	wire [`dq_width-1:0] READ_DATA4;
   wire [`dq_width-1:0] READ_DATA5;
   wire [`dq_width-1:0] READ_DATA6;
   wire [`dq_width-1:0] READ_DATA7;

   
   reg			dlyen_sync_r;
   reg  		dlyinc_sync_r;
   reg  		dlyrst_sync_r;
   reg  		dlyclk_sel_sync_r;
   reg			dlyen_p;
   reg 		dlyinc_r;
   reg  		dlyrst_r;
   reg  		dlyclk_sel_r;
   reg			cnt_dq_nz;
   reg			cnt_dqs_nz;
   reg [`data_width-1:0]	dq_idly_inc_r;
   reg [`data_width-1:0]	dlydbit_sel_sync_r;
   reg [5:0]	dlyinc_val_sync_r;
   reg [`data_width-1:0]	dlydbit_sel_r;
   reg [5:0]	dlyinc_val_r;
   reg [5:0]	cnt_dq_r;
   reg [5:0]	cnt_dqs_r;
   reg [`data_strobe_width-1:0]  dqs_idly_inc_r;
   reg [`data_strobe_width-1:0]  dqs_idly_ce_r;
   reg [`data_strobe_width-1:0]  dqs_idly_rst_r;
   reg [`data_strobe_width-1:0]  dqs_idly_ce;
   reg [`data_strobe_width-1:0]  dqs_idly_rst;
   reg [`data_width-1:0]         dq_idly_ce;
   reg [`data_width-1:0]         dq_idly_rst;
   reg [`data_width-1:0]         dq_idly_ce_r;
   reg [`data_width-1:0]         dq_idly_rst_r;
	
	reg [`dq_width-1:0] READ_DATA0_r;
	reg [`dq_width-1:0] READ_DATA1_r;
	reg [`dq_width-1:0] READ_DATA2_r;
	reg [`dq_width-1:0] READ_DATA3_r;
	reg [`dq_width-1:0] READ_DATA4_r;
	reg [`dq_width-1:0] READ_DATA5_r;
	reg [`dq_width-1:0] READ_DATA6_r;
	reg [`dq_width-1:0] READ_DATA7_r;

	
ddrif_top_0     top_00
   (
   .DDR2_DQ		(cntrl0_DDR2_DQ),
   .READ_DATA0	(READ_DATA0),
   .READ_DATA1	(READ_DATA1),
   .READ_DATA2	(READ_DATA2),
   .READ_DATA3	(READ_DATA3),
	.READ_DATA4	(READ_DATA4),
   .READ_DATA5	(READ_DATA5),
   .READ_DATA6	(READ_DATA6),
   .READ_DATA7	(READ_DATA7),

   .dqs_div		(dqs_div),
   .DDR2_DQS	(cntrl0_DDR2_DQS),

   .dqs_idelay_inc	(dqs_idly_inc_r),
   .dqs_idelay_ce	(dqs_idly_ce_r),
   .dqs_idelay_rst	(dqs_idly_rst_r),
   .dq_idelay_inc	(dq_idly_inc_r),
   .dq_idelay_ce	(dq_idly_ce_r),
   .dq_idelay_rst	(dq_idly_rst_r),
   
   //infrastructure signals,
   .CLK             (CLK),
   .CLK90           (CLK90),
   .CLKDIV_0        (CLKDIV_0),
   .CLKDIV_90       (CLKDIV_90),
   .RESET0          (RESET0),
   .RESET90         (RESET90),
   .RESET270        (RESET270)
   );

   ddrif_infrastructure infrastructure0
     (
      .CLK              (CLK),
      .CLK90            (CLK90),
      .CLK200           (clk_200),
      .CLKDIV_90        (CLKDIV_90),
      .CLKDIV_0         (CLKDIV_0),
      .idelay_ctrl_rdy  (idelay_ctrl_rdy),      
      .sys_rst          (RESET0),
      .sys_rst_90       (RESET90),
      .sys_rst_270      (RESET270),      
      .rst200           (rst200),
      .REF_CLK200_IN	(REF_CLK200_IN),
      .SYS_RESET_IN_N	(SYS_RESET_IN_N)
      );

   ddrif_idelay_ctrl idelay_ctrl0
     (
      .CLK200           (clk_200),
      .RESET            (rst200),
      .RDY_STATUS       (idelay_ctrl_rdy)
      );

//-----------------------------------------------------------------------------

reg					dlyen_dly_r;
reg					dlyen_sync_dly_r;
reg					dlyen_sync_dly2_r;
reg					dlyen_syncb_r;
reg					dlyen_syncb_dly_r;

assign 		cntrl0_READ_DATA0 = READ_DATA0_r;
assign 		cntrl0_READ_DATA1 = READ_DATA1_r;
assign 		cntrl0_READ_DATA2 = READ_DATA2_r;
assign 		cntrl0_READ_DATA3 = READ_DATA3_r;
assign 		cntrl0_READ_DATA4 = READ_DATA4_r;
assign 		cntrl0_READ_DATA5 = READ_DATA5_r;
assign 		cntrl0_READ_DATA6 = READ_DATA6_r;
assign 		cntrl0_READ_DATA7 = READ_DATA7_r;


//  From EVBIF
//		ctrl18_r <=`DLY 8'h00;	
			// bit0 rsvd
			// bit1 0 = msb 1st,  	1 = lsb 1st
			// bit2 0 = offset b		1 = 2s complement
			// bit3 0 = 1-wire		1 = 2-wire
			// bit5:4 00 = 16b 		01 = 14b		10 = 12b		11 = 11b  # bits to not mask out

always @ (READ_DATA0 or READ_DATA1 or READ_DATA2 or READ_DATA3 or READ_DATA4 or READ_DATA5 or READ_DATA6 or READ_DATA7 or capture_modes)
begin

	if (capture_modes[6])  // mux to 4 wire
		begin  // 16b 4 wire  inverted because ADS5493 board inverts LVDS through connector
				READ_DATA0_r = {~READ_DATA3[6], ~READ_DATA2[6], ~READ_DATA1[6], ~READ_DATA0[6],
										~READ_DATA3[5], ~READ_DATA2[5], ~READ_DATA1[5], ~READ_DATA0[5],
										~READ_DATA3[4], ~READ_DATA2[4], ~READ_DATA1[4], ~READ_DATA0[4],
										~READ_DATA3[3], ~READ_DATA2[3], ~READ_DATA1[3], ~READ_DATA0[3]};
				READ_DATA1_r = {~READ_DATA7[6], ~READ_DATA6[6], ~READ_DATA5[6], ~READ_DATA4[6],
										~READ_DATA7[5], ~READ_DATA6[5], ~READ_DATA5[5], ~READ_DATA4[5],
										~READ_DATA7[4], ~READ_DATA6[4], ~READ_DATA5[4], ~READ_DATA4[4],
										~READ_DATA7[3], ~READ_DATA6[3], ~READ_DATA5[3], ~READ_DATA4[3]};
				READ_DATA2_r = 16'b0000000000000000;
				READ_DATA3_r = 16'b0000000000000000;
				READ_DATA4_r = 16'b0000000000000000;
				READ_DATA5_r = 16'b0000000000000000;
				READ_DATA6_r = 16'b0000000000000000;
				READ_DATA7_r = 16'b0000000000000000;
		end
	else if (capture_modes[3])  // mux 1w or 2w
		begin  // 2 wire
			if (capture_modes[5:4] == 2'b00)
			begin
				//16b 2w
				READ_DATA0_r = {READ_DATA0[7:0], READ_DATA1[7:0]};
				READ_DATA1_r = {READ_DATA2[7:0], READ_DATA3[7:0]};
				READ_DATA2_r = {READ_DATA4[7:0], READ_DATA5[7:0]};
				READ_DATA3_r = {READ_DATA6[7:0], READ_DATA7[7:0]};
				READ_DATA4_r = 16'b0000000000000000;
				READ_DATA5_r = 16'b0000000000000000;
				READ_DATA6_r = 16'b0000000000000000;
				READ_DATA7_r = 16'b0000000000000000;
			end
			else
			begin
				//12b 2w
				READ_DATA0_r = {4'b0000, READ_DATA0[5:0], READ_DATA1[5:0]};
				READ_DATA1_r = {4'b0000, READ_DATA2[5:0], READ_DATA3[5:0]};
				READ_DATA2_r = {4'b0000, READ_DATA4[5:0], READ_DATA5[5:0]};
				READ_DATA3_r = {4'b0000, READ_DATA6[5:0], READ_DATA7[5:0]};
				READ_DATA4_r = 16'b0000000000000000;
				READ_DATA5_r = 16'b0000000000000000;
				READ_DATA6_r = 16'b0000000000000000;
				READ_DATA7_r = 16'b0000000000000000;
			end
		end
	
	else

	begin
			//1w
			READ_DATA0_r = READ_DATA0;
			READ_DATA1_r = READ_DATA1;
			READ_DATA2_r = READ_DATA2;
			READ_DATA3_r = READ_DATA3;
			READ_DATA4_r = READ_DATA4;
			READ_DATA5_r = READ_DATA5;
			READ_DATA6_r = READ_DATA6;
			READ_DATA7_r = READ_DATA7;
	end

end



//-----------------------------------------------------------------------------

always @(posedge CLK)
begin
	if (RESET0)
		cnt_dq_r <=`DLY 0;
	else
	begin
		if(cnt_dq_nz)
			cnt_dq_r <=`DLY cnt_dq_r - 1'b1;
		else if(dlyen)
			cnt_dq_r <=`DLY dlyinc_val;
		else 
			cnt_dq_r <=`DLY 0;
	end
end

always @(cnt_dq_r)
begin
	cnt_dq_nz = |cnt_dq_r;
end

//-----------------------------------------------------------------------------

genvar m;
generate
	for(m=0;m<`data_width;m=m+1)
	begin	:	gen_dq_idly_ce
		always @(cnt_dq_nz or dlydbit_sel or dlyrst)
		begin
			dq_idly_ce[m] = cnt_dq_nz & dlydbit_sel[m];
			dq_idly_rst[m] = dlyrst & dlydbit_sel[m];
		end
	end
endgenerate

genvar o;
generate
	for(o=0;o<`data_width;o=o+1)
	begin	:	gen_dq_idly_ce_r
		always @(posedge CLK)
		begin
			dq_idly_ce_r[o] <= dq_idly_ce[o];
			dq_idly_rst_r[o] <= dq_idly_rst[o];
			dq_idly_inc_r[o] <= dlyinc;
		end
	end
endgenerate

//-----------------------------------------------------------------------------

always @(cnt_dq_nz or dlyclk_sel)
begin
	dqs_idly_ce	= cnt_dq_nz & dlyclk_sel;
end

always @(dlyrst or dlyclk_sel)
begin
	dqs_idly_rst = dlyrst & dlyclk_sel;
end

always @(posedge CLK)
begin
	dqs_idly_rst_r <= dqs_idly_rst;
	dqs_idly_ce_r <= dqs_idly_ce;
	dqs_idly_inc_r <= dlyinc;
end


endmodule
