//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor             : Xilinx
// \   \   \/    Version            : $Name: i+IP+125372 $
//  \   \        Application        : MIG
//  /   /        Filename           : ddrif_infrastructure.v
// /___/   /\    Date Last Modified : $Date: 2007/04/18 13:49:24 $
// \   \  /  \   Date Created       : Mon May 2 2005
//  \___\/\___\
//
// Device      : Virtex-4
// Design Name : DDR2 SERDES
// Purpose     : This module instantiates DCM_BASE primitive for the memory
//               interface for generating clocks with different phases and
//               the 200 MHz clock for the IDELAYCTRL module.It also generates
//               resets with different phases.
///////////////////////////////////////////////////////////////////////////////

//`timescale 1ns/1ps

module ddrif_infrastructure
  (
   input                REF_CLK200_IN,
   input                SYS_RESET_IN_N,
   input                idelay_ctrl_rdy,
   
   output 	            CLK,
   output               CLK90,
   output               CLK200,
   output               CLKDIV_90,
   output               CLKDIV_0,
   output               sys_rst,
   output               sys_rst_90,
   output               sys_rst_270,   
   output               rst200   
	 );



   localparam           RST_SYNC_NUM = 20;
   
   wire                 clk0_bufg_in;
   wire                 clk90_bufg_in;
   wire                 clkdv_90_bufg_in;
   wire                 clkdv_0_bufg_in;

   wire                 clk0_bufg_out;
   wire                 clk200_bufg_out;
   wire                 clkdv_90_bufg_out;
   wire                 clkdv_0_bufg_out;
   wire                 clk_90_bufg_out;
   
   wire                 clk0_dcm;
   wire                 clk90_dcm;
   wire                 clkdiv2_dcm;
   wire                 dcm_lock;
   wire                 SYS_RESET;
   wire                 rst_tmp;
   wire					rst_tmp2;

   reg [RST_SYNC_NUM-1:0] rst_dcm0_r;
   reg [RST_SYNC_NUM-1:0] rst0_sync_r;
   reg [RST_SYNC_NUM-1:0] rst200_sync_r;
   reg [RST_SYNC_NUM-1:0] rst90_sync_r;
   reg [RST_SYNC_NUM-1:0] rst270_sync_r;   
   
   wire                    dcm_lock_w;


   wire	sysdcm_locked;
   clocks_sysdcm clocks_sysdcm_inst(
				.CLKIN_IBUFG		(clk200_bufg_out), 
                .RST_IN				(SYS_RESET), 
                .CLKFX_OUT			(SYS_CLK),
                .CLKFX180_OUT		(), 
                .CLK0_OUT			(), 
                .LOCKED_OUT			(sysdcm_locked)
                );




   assign                 SYS_RESET  = 1'b0; //(`reset_active_low ==1'b1)? ~SYS_RESET_IN_N : SYS_RESET_IN_N ;
														// hijacked reset pin for external trigger 2/20/10 rmp/hf

   assign                 CLK        = clk0_bufg_out;
   assign                 CLK90      = clk_90_bufg_out;
   assign                 CLK200     = clk200_bufg_out;
   assign                 CLKDIV_0   = clkdv_0_bufg_out;
   assign                 CLKDIV_90  = clkdv_90_bufg_out;



   assign #0.1 dcm_lock_w  =  dcm_lock;  // Added for simulation only
   assign rst_tmp2 = SYS_RESET | ~sysdcm_locked;

   always @(posedge SYS_CLK or posedge rst_tmp2)
     if (rst_tmp2)
       rst_dcm0_r <= {RST_SYNC_NUM{1'b1}};
     else
       rst_dcm0_r <= rst_dcm0_r << 1;

   wire GND_BIT;
   wire [6:0] GND_BUS_7;
   wire [15:0] GND_BUS_16;
   assign GND_BIT = 0;
   assign GND_BUS_7 = 7'b0000000;
   assign GND_BUS_16 = 16'b0000000000000000;

   defparam DCM_ADV0.CLK_FEEDBACK = "1X";
   defparam DCM_ADV0.CLKDV_DIVIDE = 2.0;
   defparam DCM_ADV0.CLKFX_DIVIDE = 1;
   defparam DCM_ADV0.CLKFX_MULTIPLY = 4;
   defparam DCM_ADV0.CLKIN_DIVIDE_BY_2 = "FALSE";
   defparam DCM_ADV0.CLKIN_PERIOD = 4.000;
   defparam DCM_ADV0.CLKOUT_PHASE_SHIFT = "NONE";
   defparam DCM_ADV0.DCM_AUTOCALIBRATION = "TRUE";
   defparam DCM_ADV0.DCM_PERFORMANCE_MODE = "MAX_SPEED";
   defparam DCM_ADV0.DESKEW_ADJUST = "SYSTEM_SYNCHRONOUS";
   defparam DCM_ADV0.DFS_FREQUENCY_MODE = "HIGH";
   defparam DCM_ADV0.DLL_FREQUENCY_MODE = "HIGH";
   defparam DCM_ADV0.DUTY_CYCLE_CORRECTION = "TRUE";
   defparam DCM_ADV0.FACTORY_JF = 16'hF0F0;
   defparam DCM_ADV0.PHASE_SHIFT = 0;
   defparam DCM_ADV0.STARTUP_WAIT = "FALSE";
   DCM_ADV DCM_ADV0 (
	                     .CLKFB		(clk0_bufg_out),
	                     .CLKIN		(SYS_CLK),
                         .DADDR		(GND_BUS_7[6:0]), 
                         .DCLK		(GND_BIT), 
                         .DEN		(GND_BIT), 
                         .DI		(GND_BUS_16[15:0]), 
                         .DWE		(GND_BIT), 
                         .PSCLK		(GND_BIT), 
                         .PSEN		(GND_BIT), 
                         .PSINCDEC	(GND_BIT), 
	                     .RST		(rst_dcm0_r[RST_SYNC_NUM-1]),
	                     .CLKDV		(clkdiv2_dcm),
                         .CLKFX		(), 
                         .CLKFX180	(), 
	                     .CLK0		(clk0_dcm),
                         .CLK2X		(), 
                         .CLK2X180	(), 
	                     .CLK90		(clk90_dcm),
                         .CLK180	(), 
                         .CLK270	(), 
                         .DO		(), 
                         .DRDY		(), 
	                     .LOCKED	(dcm_lock),
                         .PSDONE	()
                    );

   defparam               pmcd0.EN_REL = "TRUE";
   defparam               pmcd0.RST_DEASSERT_CLK = "CLKB";
   
   PMCD pmcd0 (
               .CLKA1(clk90_bufg_in),
               .CLKA1D2(clkdv_90_bufg_in),
               .CLKA1D4(),
               .CLKA1D8(),
               .CLKB1(clk0_bufg_in),
               .CLKC1(clkdv_0_bufg_in),
               .CLKD1(),
               .CLKA(clk90_dcm),
               .CLKB(clk0_dcm),
               .CLKC(clkdiv2_dcm),
               .CLKD(),
               .REL(dcm_lock_w),
              .RST(SYS_RESET)
               );
   
   

   
   BUFG dcm_clk0 (
                  .O(clk0_bufg_out),
                  .I(clk0_bufg_in) 
                  );
   
   BUFG pmcd_clk90 (
                    .O(clk_90_bufg_out),
                    .I(clk90_bufg_in)
                    );
   
   BUFG dcm_clkdv (
                   .O(clkdv_0_bufg_out),
                   .I(clkdv_0_bufg_in)
                   );
   
   BUFG dcm_clkdv_90 (
                      .O(clkdv_90_bufg_out),
                      .I(clkdv_90_bufg_in)
                      );
   
   BUFG clk200 (
                .O(clk200_bufg_out),
                .I(REF_CLK200_IN)
                );
   


   assign                 rst_tmp = SYS_RESET | ~dcm_lock | ~idelay_ctrl_rdy;

   

   always @(negedge clkdv_0_bufg_out or posedge rst_tmp)
     if (rst_tmp)
       rst0_sync_r <= {RST_SYNC_NUM{1'b1}};
     else
       // logical left shift by one (pads with 0)
       rst0_sync_r <= rst0_sync_r << 1;
   
   always @(posedge clkdv_90_bufg_out or posedge rst_tmp)
     if (rst_tmp)
       rst90_sync_r <= {RST_SYNC_NUM{1'b1}};
     else
       rst90_sync_r <= rst90_sync_r << 1;
   
   always @(negedge clk_90_bufg_out or posedge rst_tmp)
     if (rst_tmp)
       rst270_sync_r <= {RST_SYNC_NUM{1'b1}};
     else
       rst270_sync_r <= rst270_sync_r << 1;
   
   always @(posedge clk200_bufg_out or negedge dcm_lock)
     if (!dcm_lock)
       rst200_sync_r <= {RST_SYNC_NUM{1'b1}};
     else
       rst200_sync_r <= rst200_sync_r << 1;
   

   assign                 sys_rst     = rst0_sync_r[RST_SYNC_NUM-1];   
   assign                 sys_rst_90  = rst90_sync_r[RST_SYNC_NUM-1];
   assign                 sys_rst_270 = rst270_sync_r[RST_SYNC_NUM-1];   
   assign                 rst200      = rst200_sync_r[RST_SYNC_NUM-1];   



endmodule
