//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor             : Xilinx
// \   \   \/    Version            : $Name: i+IP+125372 $
//  \   \        Application        : MIG
//  /   /        Filename           : ddrif_iobs_0.v
// /___/   /\    Date Last Modified : $Date: 2007/04/18 13:49:24 $
// \   \  /  \   Date Created       : Mon May 2 2005
//  \___\/\___\
//
// Device      : Virtex-4
// Design Name : DDR2 SERDES
// Purpose     : This module instantiates ddrif_data_path_iobs_0,
//               ddrif_controller_iobs_0 and
//               ddrif_infrastructure_iobs_0 modules which
//               ganerates data,strobes,commands and clocks to the memory.
///////////////////////////////////////////////////////////////////////////////

//`timescale 1ns/1ps

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module ddrif_iobs_0
  (
   input                            CLK,
   input                            CLK90,
   input                            RESET0,
   input                            RESET90,
   input                            RESET270,   
   input                            CLKDIV_0,
   input                            CLKDIV_90,
   input [`data_strobe_width-1:0]   dp_dqs_idelay_inc,
   input [`data_strobe_width-1:0]   dp_dqs_idelay_ce,
   input [`data_strobe_width-1:0]   dp_dqs_idelay_rst,
   input [`data_width-1:0]          dp_dq_idelay_inc,
   input [`data_width-1:0]          dp_dq_idelay_ce,
   input [`data_width-1:0]          dp_dq_idelay_rst,   
   input [`data_width-1:0]          DDR_DQ,
   input [`data_strobe_width-1:0]   DDR_DQS,
   
   output							dqs_div,
   output [`dq_width-1:0]         iobs_read_data0,
   output [`dq_width-1:0]         iobs_read_data1,
   output [`dq_width-1:0]         iobs_read_data2,
   output [`dq_width-1:0]         iobs_read_data3,
	output [`dq_width-1:0]         iobs_read_data4,
   output [`dq_width-1:0]         iobs_read_data5,
   output [`dq_width-1:0]         iobs_read_data6,
   output [`dq_width-1:0]         iobs_read_data7

   );


   ddrif_data_path_iobs_0 data_path_iobs_0
     (
      .CLK                    (CLK),
      .CLK90                  (CLK90),
      .CLKDIV_0               (CLKDIV_0),
      .CLKDIV_90              (CLKDIV_90),
      .RESET0                 (RESET0),
      .RESET90                (RESET90),
      .RESET270               (RESET270),
      .dqs_idelay_inc         (dp_dqs_idelay_inc),
      .dqs_idelay_ce          (dp_dqs_idelay_ce),
      .dqs_idelay_rst         (dp_dqs_idelay_rst),
      .dq_idelay_inc          (dp_dq_idelay_inc),
      .dq_idelay_ce           (dp_dq_idelay_ce),
      .dq_idelay_rst          (dp_dq_idelay_rst),
      .dqs_div				  (dqs_div),      
      .dp_iobs_read_data0     (iobs_read_data0),
      .dp_iobs_read_data1     (iobs_read_data1),
      .dp_iobs_read_data2     (iobs_read_data2),
      .dp_iobs_read_data3     (iobs_read_data3),
		.dp_iobs_read_data4     (iobs_read_data4),
      .dp_iobs_read_data5     (iobs_read_data5),
      .dp_iobs_read_data6     (iobs_read_data6),
      .dp_iobs_read_data7     (iobs_read_data7),

      .DDR_DQ                 (DDR_DQ),
      .DDR_DQS                (DDR_DQS)
      );


endmodule
