
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module dumpmem_blk(
				rdlen0,
				rdlen1,
				rdlen2,
				tx_bz,
				din,
				rd_clk,
				rd_en,
				rst,
				ch_rst0,
				ch_rst1,
				wr_clk,
				wr_en,
				dout_r,
				valid_r,
				rdlim_hit,
				full
				);

input	[`READCNT_BITS0-1:0]	rdlen0;
input	[`READCNT_BITS1-1:0]	rdlen1;
input	[`READCNT_BITS2-1:0]	rdlen2;
input	[15:0]	din;
input			tx_bz;
input			rd_clk;
input			rd_en;
input			rst;
input			ch_rst0;
input			ch_rst1;
input			wr_clk;
input			wr_en;

output	[7:0]	dout_r;
output			valid_r;
output			rdlim_hit;
output			full;

//-----------------------------------------------------------------------------

reg		[7:0]	dout_r;
reg		[7:0]	dout;
reg				valid_r;
reg				rd_en_r;
reg				rdlim_hit;
reg				full;
reg				wr_en0;
reg				wr_en1;
reg				rd_en0;
reg				rd_en1;
reg				rd_en12;
reg				almost_full0;
reg				almost_full0_r;
reg				almost_full0_p;
reg				almost_full1;
reg				almost_full1_r;
reg				almost_full1_p;
reg				wpingpong_r;
reg				rdlim_hit0;
reg				rdlim_hit1;
reg				rdlim_hit2;
reg				rdlim_hit0_r;
reg				rdlim_hit1_r;
reg				rdlim_hit2_r;
reg				rd_en2;

wire			afull0;
wire			afull1;
wire	[7:0]	dout0;
wire	[7:0]	dout1;
wire	[7:0]	dout2;
wire	[`READCNT_BITS0-1:0]	rd_data_count0;
wire	[`READCNT_BITS1-1:0]	rd_data_count1;
wire	[`READCNT_BITS2-1:0]	rd_data_count2;

//-----------------------------------------------------------------------------

always @(afull0 or wr_en0)
begin
	almost_full0 = afull0 & wr_en0;
end

always @(afull1 or wr_en1)
begin
	almost_full1 = afull1 & wr_en1;
end

always @(posedge wr_clk)
begin
	almost_full0_r <=`DLY almost_full0;
	almost_full1_r <=`DLY almost_full1;
end

always @(almost_full0_r or almost_full0)
begin
	almost_full0_p = almost_full0 & ~almost_full0_r;
end

always @(almost_full1_r or almost_full1)
begin
	almost_full1_p = almost_full1 & ~almost_full1_r;
end

always @(posedge wr_clk)
begin
	if(rst)
		wpingpong_r <=`DLY 1'b0;
	else if(almost_full0_p)
		wpingpong_r <=`DLY 1'b1;
	else if(almost_full1_p)
		wpingpong_r <=`DLY 1'b0;
end

always @(wpingpong_r or wr_en)
begin
	case(wpingpong_r)	// synopsys parallel_case
		1'b0	:	{wr_en1,wr_en0} = {1'b0,wr_en};
		1'b1	:	{wr_en1,wr_en0} = {wr_en,1'b0};
	endcase
end

//-----------------------------------------------------------------------------

always @(rdlim_hit0_r or rd_en)
begin
	case(rdlim_hit0_r)	// synopsys parallel_case
		1'b0	:	{rd_en12,rd_en0} = {1'b0,rd_en};
		1'b1	:	{rd_en12,rd_en0} = {rd_en,1'b0};
	endcase
end

//-----------------------------------------------------------------------------
//Use 8kb memories for 8 ch 
fifo16kb blk_fifo16kb_inst0(
				.din			(din),	// Bus [15 : 0]
				.rd_clk			(rd_clk),
				.rd_en			(rd_en0),
				.rst			(ch_rst0),
				.wr_clk			(wr_clk),
				.wr_en			(wr_en0),
				.dout			(dout0),	// Bus [7 : 0]
				.rd_data_count	(rd_data_count0),
				.almost_empty	(),
				.almost_full	(afull0),
				.empty			(),
				.full			()
	);
//Use 8kb memories for 8 ch 
fifo16kb blk_fifo16kb_inst1(
				.din			(din),	// Bus [15 : 0]
				.rd_clk			(rd_clk),
				.rd_en			(rd_en1),
				.rst			(ch_rst1),
				.wr_clk			(wr_clk),
				.wr_en			(wr_en1),
				.dout			(dout1),	// Bus [7 : 0]
				.rd_data_count	(rd_data_count1),
				.almost_empty	(),
				.almost_full	(),
				.empty			(),
				.full			(full1)
	);

fifo32b blk_fifo32b_inst(
				.din			(din),	// Bus [15 : 0]
				.rd_clk			(rd_clk),
				.rd_en			(rd_en2),
				.rst			(ch_rst1),
				.wr_clk			(wr_clk),
				.wr_en			(wr_en1 & full1),
				.dout			(dout2),	// Bus [7 : 0]
				.rd_data_count	(rd_data_count2),
				.almost_empty	(),
				.almost_full	(afull1),
				.empty			(),
				.full			()
	);

//-----------------------------------------------------------------------------

always @(rd_en12 or rdlim_hit1_r)
begin
	rd_en1 = rd_en12 & ~rdlim_hit1_r;
	rd_en2 = rd_en12 &  rdlim_hit1_r;
end

//-----------------------------------------------------------------------------

always @(rdlim_hit0_r or rdlim_hit1_r or dout1 or dout0 or dout2)
begin
	casex({rdlim_hit0_r,rdlim_hit1_r})	// synopsys parallel_case
		2'b0x	:	dout = dout0;
		2'b10	:	dout = dout1;
		2'b11	:	dout = dout2;
	endcase
end

always @(posedge rd_clk)
begin
	dout_r <=`DLY dout;
end

//-----------------------------------------------------------------------------

always @(rdlim_hit0_r or rdlim_hit1_r or rdlim_hit2_r)
begin
	rdlim_hit = rdlim_hit0_r & rdlim_hit1_r & rdlim_hit2_r;
end

//-----------------------------------------------------------------------------

always @(posedge rd_clk)
begin
	rd_en_r	<=`DLY rd_en;
	valid_r	<=`DLY rd_en_r;
end

//-----------------------------------------------------------------------------

always @(posedge rd_clk)
begin
	rdlim_hit0_r <=`DLY rdlim_hit0; 
	rdlim_hit1_r <=`DLY rdlim_hit1; 
	rdlim_hit2_r <=`DLY rdlim_hit2; 
end

//-----------------------------------------------------------------------------

always @(almost_full1_p)
begin
	full = almost_full1_p;
end

//-----------------------------------------------------------------------------

always @(rdlen0 or rd_data_count0 or tx_bz)
begin
	rdlim_hit0 = (rdlen0 == rd_data_count0) & tx_bz;
end

always @(rdlen1 or rd_data_count1 or tx_bz)
begin
	rdlim_hit1 = (rdlen1 == rd_data_count1) & tx_bz;
end

always @(rdlen2 or rd_data_count2 or tx_bz)
begin
	rdlim_hit2 = (rdlen2 == rd_data_count2) & tx_bz;
end

//-----------------------------------------------------------------------------

endmodule
