
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
// Modified		RMP pass ctrl18 up to toplevel as caapture_modes 4/3/08
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module evbif(
			sys_clk,  //Given by interface fabric --200M for XAPP, 250M for IDDR
			reset,

			tusb_bclk, //UART cntrl, use CLKOUT of USB chip)
			sin,
			rts_n,  //UART cntrl, never use
			dtr_n,  //UART cntrl, never use

			ext_trig,		// hf@091009

			ch1_clk,  //ADC clk
			ch2_clk,  //ADC clk
			ch3_clk,  //ADC clk
			ch4_clk,  //ADC clk
			ch1_din,
			ch2_din,
			ch3_din,
			ch4_din,

			ibz,   //LED "I am busy"
			capture_modes,
			channel_sel,
			spi_ss,
			spi_sclk,
			spi_mosi,
			spi_miso,
			dlyinc,  //Not used in XAPP - control skew on clock and data
			dlyrst,  //Not used in XAPP - control skew on clock and data
			dlyinc_val,  //Not used in XAPP - control skew on clock and data
			dlydbit_sel,  //Not used in XAPP - control skew on clock
			dlyclk_sel,  //Not used in XAPP - control skew on data
			dlyen,//Not used in XAPP - control skew on clock and data
			cts_n,//UART cntrl, never use
			dsr_n,//UART cntrl, never use
			dcd_n,//UART cntrl, never use
			ri_n,//UART cntrl, never use
			sout
			);

input			sys_clk;
input			reset;
input			tusb_bclk;
input			ext_trig;		// hf@091009

input			sin;
input			rts_n;
input			dtr_n;
input			spi_miso;

input			ch1_clk;
input			ch2_clk;
input			ch3_clk;
input			ch4_clk;
input	[15:0]	ch1_din;
input	[15:0]	ch2_din;
input	[15:0]	ch3_din;
input	[15:0]	ch4_din;

output			ibz;
output			cts_n;
output			dsr_n;
output			dcd_n;
output			ri_n;
output			sout;
output			spi_ss;
output			spi_sclk;
output			spi_mosi;
output			dlyinc;
output			dlyrst;
output			dlyclk_sel;
output			dlyen;
output	[7:0]		capture_modes;
output	[7:0]		channel_sel;
output	[15:0]	dlydbit_sel;
output	[5:0]	dlyinc_val;

//-----------------------------------------------------------------------------

reg				ibz;
reg				cts_n;
reg				dsr_n;
reg				dcd_n;
reg				ri_n;
reg				uart_we;
reg				ch1_we_r;
reg				ch1_we_sync_r;
reg				ch2_we_r;
reg				ch2_we_sync_r;
reg				ch3_we_r;
reg				ch3_we_sync_r;
reg				ch4_we_r;
reg				ch4_we_sync_r;
reg				ch1_rst_r;
reg				ch1_rst_sync_r;
reg				ch2_rst_r;
reg				ch2_rst_sync_r;
reg				ch3_rst_r;
reg				ch3_rst_sync_r;
reg				ch4_rst_r;
reg				ch4_rst_sync_r;
reg				ch1_dvalid_r;
reg				ch2_dvalid_r;
reg				ch3_dvalid_r;
reg				ch4_dvalid_r;
reg				dlyinc;
reg				dlyrst;
reg				dlyclk_sel;
reg		[15:0]	ch1_dout_r;
reg		[15:0]	ch2_dout_r;
reg		[15:0]	ch3_dout_r;
reg		[15:0]	ch4_dout_r;
reg		[7:0]	uart_din;
reg		[15:0]	dlydbit_sel;
reg		[7:0]		capture_modes;
reg		[7:0]		channel_sel;
reg		[5:0]	dlyinc_val;
// hf@091009 begin
reg				ext_trig_r;
reg				ext_trig_d1_r;
reg				ext_trig_d2_r;
wire			ext_trig_p;
// hf@091009 end

wire	[23:0]	spi_dout;
wire	[15:0]	ch1_dout;
wire	[15:0]	ch2_dout;
wire	[15:0]	ch3_dout;
wire	[15:0]	ch4_dout;
wire	[7:0]	uart_mdin;
wire	[7:0]	uart_cdin;
wire	[7:0]	uart_dout;
wire	[11:0]	copy_ctrl0;
wire	[7:0]	copy_ctrl2;
wire	[7:0]	copy1_ctrl2;
wire	[7:0]	copy2_ctrl2;
wire	[7:0]	copy3_ctrl2;
wire	[7:0]	copy4_ctrl2;
wire	[7:0]	ctrl0;
wire	[7:0]	ctrl1;
wire	[7:0]	ctrl2;
wire	[7:0]	ctrl3;
wire	[7:0]	ctrl4;
wire	[7:0]	ctrl5;
wire	[7:0]	ctrl6;
wire	[7:0]	ctrl7;
wire	[7:0]	ctrl8;
wire	[7:0]	ctrl9;
wire	[7:0]	ctrl10;
wire	[7:0]	ctrl11;
wire	[7:0]	ctrl12;
wire	[7:0]	ctrl13;
wire	[7:0]	ctrl14;
wire	[7:0]	ctrl15;
wire  [7:0] ctrl18;
wire  [7:0] ctrl19;
wire			uart_cwe;
wire			uart_mwe;

//-----------------------------------------------------------------------------

evbif_ctrl evbif_ctrl_inst(
					.clk			(sys_clk),
					.reset			(reset),

					.spi_dout		(spi_dout),
					.spi_dp			(spi_dp),
					.tx_done_p		(tx_done_p),
					.uart_dout		(uart_dout),
					.uart_dp		(uart_dp),
					.tx_buffer_full	(uart_txbuf_full),

					.ext_trig_p		(ext_trig_p),

					.v5_r			(dlyen),
					.uart_oe_r		(uart_oe),
					.uart_we		(uart_cwe),
					.uart_din		(uart_cdin),
					.copy_ctrl0_r	(copy_ctrl0),
					.copy_ctrl2_r	(copy_ctrl2),
					.copy1_ctrl2_r	(copy1_ctrl2),
					.copy2_ctrl2_r	(copy2_ctrl2),
					.copy3_ctrl2_r	(copy3_ctrl2),
					.copy4_ctrl2_r	(copy4_ctrl2),
					.ctrl0_r		(ctrl0),
					.ctrl1_r		(ctrl1),
					.ctrl2_r		(ctrl2),
					.ctrl3_r		(ctrl3),
					.ctrl4_r		(ctrl4),
					.ctrl5_r		(ctrl5),
					.ctrl6_r		(ctrl6),
					.ctrl7_r		(ctrl7),
					.ctrl8_r		(ctrl8),
					.ctrl9_r		(ctrl9),
					.ctrl10_r		(ctrl10),
					.ctrl11_r		(ctrl11),
					.ctrl12_r		(ctrl12),
					.ctrl13_r		(ctrl13),
					.ctrl14_r		(ctrl14),
					.ctrl15_r		(ctrl15),
					.ctrl18_r		(ctrl18),
					.ctrl19_r		(ctrl19)
					);

evbif_uart evbif_uart_inst(
				.clk			(sys_clk),
				.reset			(reset),
				.div_val		(ctrl6),
				.din			(uart_din),
				.write			(uart_we),
				.tusb_bclk		(tusb_bclk),
				.sout			(sout),
				.sin			(sin),
				.read			(uart_oe),
				.dout			(uart_dout),
				.data_present	(uart_dp),
				.tx_buffer_full	(uart_txbuf_full),
				.rx_buffer_full	()
			);

evbif_spi evbif_spi_inst(
			.clk			(sys_clk),
			.reset			(reset),
			.din			({ctrl12,ctrl11,ctrl10}),
			.dout			(spi_dout),
			.spi_ctrl		(ctrl8),
			.div_val		(ctrl9),
			.done			(spi_dp),
  // SPI signals
			.spi_ss			(spi_ss),
			.spi_sclk		(spi_sclk),
			.spi_mosi		(spi_mosi),
			.spi_miso		(spi_miso)
		);

evbif_dumpmem evbif_dumpmem_inst(
				.clk				(sys_clk),
				.reset				(ctrl0[0]),
				.rst				(ctrl0[1]),
				.reset_				(ctrl0[2]),
				.rst_				(ctrl0[3]),
				.ch1_rst0			(copy_ctrl0[0]),
				.ch1_rst1			(copy_ctrl0[1]),
				.ch2_rst0			(copy_ctrl0[2]),
				.ch2_rst1			(copy_ctrl0[3]),
				.ch3_rst0			(copy_ctrl0[4]),
				.ch3_rst1			(copy_ctrl0[5]),
				.ch4_rst0			(copy_ctrl0[6]),
				.ch4_rst1			(copy_ctrl0[7]),
				.ch1_rst2			(copy_ctrl0[8]),
				.ch2_rst2			(copy_ctrl0[9]),
				.ch3_rst2			(copy_ctrl0[10]),
				.ch4_rst2			(copy_ctrl0[11]),

				.dcaptxgo			(ctrl1[0]),
				.ch_cnfg			(ctrl2[3:0]),
				.ch_cnfg1			(copy1_ctrl2[3:0]),
				.ch_cnfg2			(copy2_ctrl2[3:0]),
				.ch_cnfg3			(copy3_ctrl2[3:0]),
				.ch_cnfg4			(copy4_ctrl2[3:0]),

				.rdlen_enc			(ctrl4),

				.ch1_dvalid			(ch1_dvalid_r),
				.ch2_dvalid			(ch2_dvalid_r),
				.ch3_dvalid			(ch3_dvalid_r),
				.ch4_dvalid			(ch4_dvalid_r),
				.ch1_din			(ch1_dout_r),
				.ch2_din			(ch2_dout_r),
				.ch3_din			(ch3_dout_r),
				.ch4_din			(ch4_dout_r),
				.uart_txbuf_full	(uart_txbuf_full),

				.tx_done_p			(tx_done_p),
				.uart_we			(uart_mwe),
				.uart_din			(uart_mdin)
				);

evbif_obufdes evbif_obufdes_inst(
			.sys_clk		(sys_clk),

			.ch1_wrst		(ch1_rst_sync_r),
			.ch2_wrst		(ch2_rst_sync_r),
			.ch3_wrst		(ch3_rst_sync_r),
			.ch4_wrst		(ch4_rst_sync_r),
			.ch1_rrst		(ctrl0[4]),
			.ch2_rrst		(ctrl0[5]),
			.ch3_rrst		(ctrl0[6]),
			.ch4_rrst		(ctrl0[7]),

			.ch1_clk		(ch1_clk),
			.ch2_clk		(ch2_clk),
			.ch3_clk		(ch3_clk),
			.ch4_clk		(ch4_clk),
			.ch1_din		(ch1_din),
			.ch2_din		(ch2_din),
			.ch3_din		(ch3_din),
			.ch4_din		(ch4_din),
			.ch1_we			(ch1_we_sync_r),
			.ch2_we			(ch2_we_sync_r),
			.ch3_we			(ch3_we_sync_r),
			.ch4_we			(ch4_we_sync_r),

			.ch1_dvalid		(ch1_dvalid),
			.ch2_dvalid		(ch2_dvalid),
			.ch3_dvalid		(ch3_dvalid),
			.ch4_dvalid		(ch4_dvalid),
			.ch1_dout		(ch1_dout),
			.ch2_dout		(ch2_dout),
			.ch3_dout		(ch3_dout),
			.ch4_dout		(ch4_dout)
			);

//-----------------------------------------------------------------------------

// synchronization -- trasfer clock domains from sys_clk to ch clks
always @(posedge ch1_clk)
begin
	ch1_we_r		<=`DLY copy_ctrl2[0];  //Go - capture data
	ch1_we_sync_r	<=`DLY ch1_we_r;  //Latch it twice on ch 1 clock to synchronize

	ch1_rst_r		<=`DLY ctrl0[4];  //Reset
	ch1_rst_sync_r	<=`DLY ch1_rst_r; // Latch it twice on ch 1 clock to synchronize
end

always @(posedge ch2_clk)
begin
	ch2_we_r		<=`DLY copy_ctrl2[1];
	ch2_we_sync_r	<=`DLY ch2_we_r;

	ch2_rst_r		<=`DLY ctrl0[5];
	ch2_rst_sync_r	<=`DLY ch2_rst_r;
end

always @(posedge ch3_clk)
begin
	ch3_we_r		<=`DLY copy_ctrl2[2];
	ch3_we_sync_r	<=`DLY ch3_we_r;

	ch3_rst_r		<=`DLY ctrl0[6];
	ch3_rst_sync_r	<=`DLY ch3_rst_r;
end

always @(posedge ch4_clk)
begin
	ch4_we_r		<=`DLY copy_ctrl2[3];
	ch4_we_sync_r	<=`DLY ch4_we_r;

	ch4_rst_r		<=`DLY ctrl0[7];
	ch4_rst_sync_r	<=`DLY ch4_rst_r;
end

//-----------------------------------------------------------------------------
// Pipeline register addded to close timing at 250M, added between FIFO an BRAM
always @(posedge sys_clk)
begin
	ch1_dvalid_r	<=`DLY ch1_dvalid;
	ch2_dvalid_r	<=`DLY ch2_dvalid;
	ch3_dvalid_r	<=`DLY ch3_dvalid;
	ch4_dvalid_r	<=`DLY ch4_dvalid;
	ch1_dout_r		<=`DLY ch1_dout;
	ch2_dout_r		<=`DLY ch2_dout;
	ch3_dout_r		<=`DLY ch3_dout;
	ch4_dout_r		<=`DLY ch4_dout;
end

//-----------------------------------------------------------------------------
//Modem control registers -- not used tied to "1"
always @(ctrl7)
begin
	cts_n	<=`DLY ctrl7[0];
	dsr_n	<=`DLY ctrl7[1];
	dcd_n	<=`DLY ctrl7[2];
	ri_n	<=`DLY ctrl7[3];
end

//-----------------------------------------------------------------------------
// Mux to determine whether UART should transfer data from controller or BRAM
always @(ctrl1 or uart_cwe or uart_mwe)
begin
	case(ctrl1[0])
		1'b1	:	uart_we = uart_mwe;
		1'b0	:	uart_we = uart_cwe;
	endcase
end

always @(ctrl1 or uart_cdin or uart_mdin)
begin
	case(ctrl1[0])
		1'b1	:	uart_din = uart_mdin;
		1'b0	:	uart_din = uart_cdin;
	endcase
end

//-----------------------------------------------------------------------------
// Signal Renaming
always @(ctrl13 or ctrl14)
	dlydbit_sel = {ctrl14,ctrl13};  //Make 16bits

always @(ctrl15)
	dlyclk_sel = ctrl15[0];

always @(ctrl5)
begin
	dlyinc_val	= ctrl5[5:0];
	dlyinc		= ctrl5[6];
	dlyrst		= ctrl5[7];
end

always @(ctrl18 or ctrl19)
	capture_modes = {ctrl19[0], ctrl18[6:0]};

always @(ctrl2)
	channel_sel = ctrl2;

//-----------------------------------------------------------------------------

// hf@091009 begin
always @(posedge sys_clk)
begin
	ext_trig_r		<=`DLY ext_trig;
	ext_trig_d1_r	<=`DLY ext_trig_r;
	ext_trig_d2_r	<=`DLY ext_trig_d1_r;
end

assign	ext_trig_p = ext_trig_d1_r & ~ext_trig_d2_r;
// hf@091009 end

//-----------------------------------------------------------------------------
// Rename LED light
always @(ctrl1)
begin
	ibz = ctrl1[1];
end

//-----------------------------------------------------------------------------

endmodule
