
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
	`define	READLEN1_A	15 - 4
	`define	READLEN1_B	15 - 0
	`define	READLEN1_C	15 - 0

	`define	READLEN2_A	15 - 8
	`define	READLEN2_B	15 - 0
	`define	READLEN2_C	15 - 0

	`define	READLEN3_A	15 - 15
	`define	READLEN3_B	15 - 1 
	`define	READLEN3_C	15 - 0 

	`define	READLEN4_A	15 - 15
	`define	READLEN4_B	15 - 15
	`define	READLEN4_C	15 - 15
`else
	`include "defines.vh"

	`define	READLEN1_A	8191 - 2048
	`define	READLEN1_B	8191 - 0   
	`define	READLEN1_C	15   - 0   

	`define	READLEN2_A	8191 - 4096
	`define	READLEN2_B	8191 - 0   
	`define	READLEN2_C	15   - 0   

	`define	READLEN3_A	8191 - 8191
	`define	READLEN3_B	8191 - 1   
	`define	READLEN3_C	15   - 0   

	`define	READLEN4_A	8191 - 8191
	`define	READLEN4_B	8191 - 8191
	`define	READLEN4_C	15   - 15   
`endif

module evbif_dumpmem(
				clk,
				reset,
				reset_,

				rst,
				rst_,
				ch1_rst0,
				ch1_rst1,
				ch2_rst0,
				ch2_rst1,
				ch3_rst0,
				ch3_rst1,
				ch4_rst0,
				ch4_rst1,
				ch1_rst2,
				ch2_rst2,
				ch3_rst2,
				ch4_rst2,

				dcaptxgo,   //Go bit
				ch_cnfg,		
				ch_cnfg1,  //To eliminate the fanout of ch config register
				ch_cnfg2,  //To eliminate the fanout of ch config register
				ch_cnfg3,  //To eliminate the fanout of ch config register
				ch_cnfg4,  //To eliminate the fanout of ch config register

				rdlen_enc,  //Read lengh

				ch1_dvalid,  //increase to accomidate 8 ch.
				ch2_dvalid,
				ch3_dvalid,
				ch4_dvalid,
				ch1_din,
				ch2_din,
				ch3_din,
				ch4_din,
				uart_txbuf_full,

				tx_done_p,  //clear LED, all memories have been transferred
				uart_we,
				uart_din
				);

input			clk;
input			reset;
input			rst;
input			reset_;
input			rst_;
input			ch1_rst0;
input			ch1_rst1;
input			ch2_rst0;
input			ch2_rst1;
input			ch3_rst0;
input			ch3_rst1;
input			ch4_rst0;
input			ch4_rst1;
input			ch1_rst2;
input			ch2_rst2;
input			ch3_rst2;
input			ch4_rst2;
input			dcaptxgo;
input			ch1_dvalid;
input			ch2_dvalid;
input			ch3_dvalid;
input			ch4_dvalid;
input	[15:0]	ch1_din;
input	[15:0]	ch2_din;
input	[15:0]	ch3_din;
input	[15:0]	ch4_din;
input	[3:0]	ch_cnfg;
input	[3:0]	ch_cnfg1;
input	[3:0]	ch_cnfg2;
input	[3:0]	ch_cnfg3;
input	[3:0]	ch_cnfg4;
input	[7:0]	rdlen_enc;
input			uart_txbuf_full;

output			tx_done_p;
output			uart_we;
output	[7:0]	uart_din;

//-----------------------------------------------------------------------------

wire			full4;
wire			full3;
wire			full2;
wire			full1;
wire			empty4;
wire			empty3;
wire			empty2;
wire			empty1;
wire			valid4;
wire			valid3;
wire			valid2;
wire			valid1;
wire	[7:0]	fifo1_dout;
wire	[7:0]	fifo2_dout;
wire	[7:0]	fifo3_dout;
wire	[7:0]	fifo4_dout;

reg				tx_bz_r;
reg				tx_bz_d1_r;
reg				tx_done_p;
reg				cnt_z;
reg				rrcnt_z;
reg				empty;
reg				full1_r;
reg				full2_r;
reg				full3_r;
reg				full4_r;
reg				fifo1_oe;
reg				fifo2_oe;
reg				fifo3_oe;
reg				fifo4_oe;
reg				fifo1_oe_r;
reg				fifo2_oe_r;
reg				fifo3_oe_r;
reg				fifo4_oe_r;
reg				fifo1_we;
reg				fifo2_we;
reg				fifo3_we;
reg				fifo4_we;
reg				fifo1_we_r;
reg				fifo2_we_r;
reg				fifo3_we_r;
reg				fifo4_we_r;
reg				fifo4_first_write;
reg				fifo3_first_write;
reg				fifo2_first_write;
reg				uart_we;
reg				cntd_nz;
reg		[7:0]	uart_din;
reg		[2:0]	cnt_r;
reg		[2:0]	cnt_c;
reg		[2:0]	cnt_dec;
reg		[2:0]	cnt_ldval_r;
reg		[2:0]	cnt_ldv;
reg		[2:0]	rrcnt_r;
reg		[2:0]	rrcnt_c;
reg		[2:0]	rrcnt_dec;
reg		[2:0]	cntd_r;
reg		[2:0]	rrcnt_dly1_r;
reg		[15:0]	fifo1_din;
reg		[15:0]	fifo2_din;
reg		[15:0]	fifo3_din;
reg		[15:0]	fifo4_din;
reg		[15:0]	fifo1_din_r;
reg		[15:0]	fifo2_din_r;
reg		[15:0]	fifo3_din_r;
reg		[15:0]	fifo4_din_r;
reg		[`READCNT_BITS0-1:0]	rdlen_a;
reg		[`READCNT_BITS1-1:0]	rdlen_b;
reg		[`READCNT_BITS2-1:0]	rdlen_c;

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	full4_r	<=`DLY full4;
	full3_r	<=`DLY full3;
	full2_r	<=`DLY full2;
	full1_r	<=`DLY full1;
end
//counter intialization value for how to count throug the memories
always @(ch_cnfg)
begin
	case(ch_cnfg)	// synopsys parallel_case full_case
		4'b0000	:	cnt_ldv = 3'd0;  
		4'b0001	:	cnt_ldv = 3'd4;  //Case 1 Chan 1 goes to all 4 BRAMs
		4'b0010	:	cnt_ldv = 3'd4;  //Case 2 Chan 2 goes to all 4 BRAMs
		4'b0100	:	cnt_ldv = 3'd4;  //Case 4 Chan 3 goes to all 4 BRAMs
		4'b1000	:	cnt_ldv = 3'd4;  //Case 8 Chan 4 goes to all 4 BRAMs
		4'b0011	:	cnt_ldv = 3'd2;  //Case 3 Chan 1&2 goes to 2 BRAMs each
		4'b1100	:	cnt_ldv = 3'd2;  //Case C Chan 3&4 goes to 2 BRAMs each
		4'b1111	:	cnt_ldv = 3'd1;  //Case F Chan 1,2,3,4 goto 1 BRAM each
	endcase
end

always @(posedge clk)
begin
	cnt_ldval_r	<=`DLY cnt_ldv;
end

//-----------------------------------------------------------------------------
//counter: wait for full signal then decrement
always @(cnt_r or cnt_z or cnt_dec or cnt_ldval_r or full4_r or full3_r or full2_r or full1_r)
begin
	case(cnt_r)	// synopsys parallel_case full_case
		3'd4	:	cnt_c = full1_r ? cnt_dec : cnt_r;
		3'd3	:	cnt_c = full2_r ? cnt_dec : cnt_r;
		3'd2	:	cnt_c = full3_r ? cnt_dec : cnt_r;
		3'd1	:	cnt_c = full4_r ? cnt_dec : cnt_r;
		3'd0	:	cnt_c = cnt_ldval_r;
	endcase
end

always @(cnt_r)
begin
	cnt_dec = cnt_r - 1'b1;
	cnt_z	= ~|cnt_r;
end

always @(posedge clk)
begin
	if(rst_)
		cnt_r <=`DLY 3'd0;
	else if(dcaptxgo && !(tx_bz_r || tx_bz_d1_r))
		cnt_r <=`DLY cnt_c;
	else
		cnt_r <=`DLY 3'd0;
end

//-----------------------------------------------------------------------------

reg			v1;
reg			v2;
reg			v3;
reg			v4;
reg			fifo1_write;
reg			fifo2_write;
reg			fifo3_write;
reg			fifo4_write;
reg			fifo1_en;
reg			fifo2_en;
reg			fifo3_en;
reg			fifo4_en;
always @(ch1_dvalid or ch2_dvalid or ch3_dvalid or ch4_dvalid)
begin
	v1 = ch1_dvalid;
	v2 = ch2_dvalid;
	v3 = ch3_dvalid;
	v4 = ch4_dvalid;
end

//-----------------------------------------------------------------------------
// Valid Mux for routing valid signal to memories
always @(ch_cnfg1 or v1 or v2 or v3 or v4 or fifo1_en)
begin
	case(ch_cnfg1)	// synopsys parallel_case full_case
		4'b0000	:	fifo1_we = 1'b0;
		4'b0001	:	fifo1_we = v1;
		4'b0010	:	fifo1_we = v2;
		4'b0100	:	fifo1_we = v3;
		4'b1000	:	fifo1_we = v4;
		4'b0011	:	fifo1_we = v1;
		4'b1100	:	fifo1_we = v3;
		4'b1111	:	fifo1_we = v1;
	endcase
	fifo1_write = fifo1_we & fifo1_en;
end

//Counter value and mode determine the value, determines what order to fill up memories
always @(ch_cnfg1 or cnt_c)
begin
	case(ch_cnfg1)	// synopsys parallel_case full_case
		4'b0001	:	fifo1_en = (cnt_c == 3'd4);
		4'b0010	:	fifo1_en = (cnt_c == 3'd4);
		4'b0100	:	fifo1_en = (cnt_c == 3'd4);
		4'b1000	:	fifo1_en = (cnt_c == 3'd4);
		4'b0011	:	fifo1_en = (cnt_c == 3'd2);
		4'b1100	:	fifo1_en = (cnt_c == 3'd2);
		4'b1111	:	fifo1_en = (cnt_c == 3'd1);
	endcase
end

//-----------------------------------------------------------------------------
// Valid Mux for routing valid signal to memories
always @(ch_cnfg2 or v1 or v2 or v3 or v4 or fifo2_en)
begin
	case(ch_cnfg2)	// synopsys parallel_case full_case
		4'b0000	:	fifo2_we = 1'b0;
		4'b0001	:	fifo2_we = v1;
		4'b0010	:	fifo2_we = v2;
		4'b0100	:	fifo2_we = v3;
		4'b1000	:	fifo2_we = v4;
		4'b0011	:	fifo2_we = v1;
		4'b1100	:	fifo2_we = v3;
		4'b1111	:	fifo2_we = v2;
	endcase
	fifo2_write = fifo2_we & fifo2_en;
end
//Counter value and mode determine the value, determines what order to fill up memories
always @(ch_cnfg2 or cnt_c)
begin
	case(ch_cnfg2)	// synopsys parallel_case full_case
		4'b0001	:	fifo2_en = (cnt_c == 3'd3);
		4'b0010	:	fifo2_en = (cnt_c == 3'd3);
		4'b0100	:	fifo2_en = (cnt_c == 3'd3);
		4'b1000	:	fifo2_en = (cnt_c == 3'd3);
		4'b0011	:	fifo2_en = (cnt_c == 3'd1);
		4'b1100	:	fifo2_en = (cnt_c == 3'd1);
		4'b1111	:	fifo2_en = (cnt_c == 3'd1);
	endcase
end

//-----------------------------------------------------------------------------
// Valid Mux for routing valid signal to memories
always @(ch_cnfg3 or v1 or v2 or v3 or v4 or fifo3_en)
begin
	case(ch_cnfg3)	// synopsys parallel_case full_case
		4'b0000	:	fifo3_we = 1'b0;
		4'b0001	:	fifo3_we = v1;
		4'b0010	:	fifo3_we = v2;
		4'b0100	:	fifo3_we = v3;
		4'b1000	:	fifo3_we = v4;
		4'b0011	:	fifo3_we = v2;
		4'b1100	:	fifo3_we = v4;
		4'b1111	:	fifo3_we = v3;
	endcase
	fifo3_write = fifo3_we & fifo3_en;
end
//Counter value and mode determine the value, determines what order to fill up memories
always @(ch_cnfg3 or cnt_c)
begin
	case(ch_cnfg3)	// synopsys parallel_case full_case
		4'b0001	:	fifo3_en = (cnt_c == 3'd2);
		4'b0010	:	fifo3_en = (cnt_c == 3'd2);
		4'b0100	:	fifo3_en = (cnt_c == 3'd2);
		4'b1000	:	fifo3_en = (cnt_c == 3'd2);
		4'b0011	:	fifo3_en = (cnt_c == 3'd2);
		4'b1100	:	fifo3_en = (cnt_c == 3'd2);
		4'b1111	:	fifo3_en = (cnt_c == 3'd1);
	endcase
end

//-----------------------------------------------------------------------------
// Valid Mux for routing valid signal to memories
always @(ch_cnfg4 or v1 or v2 or v3 or v4 or fifo4_en)
begin
	case(ch_cnfg4)	// synopsys parallel_case full_case
		4'b0000	:	fifo4_we = 1'b0;
		4'b0001	:	fifo4_we = v1;
		4'b0010	:	fifo4_we = v2;
		4'b0100	:	fifo4_we = v3;
		4'b1000	:	fifo4_we = v4;
		4'b0011	:	fifo4_we = v2;
		4'b1100	:	fifo4_we = v4;
		4'b1111	:	fifo4_we = v4;
	endcase
	fifo4_write = fifo4_we & fifo4_en;
end
//Counter value and mode determine the value, determines what order to fill up memories
always @(ch_cnfg4 or cnt_c)
begin
	case(ch_cnfg4)	// synopsys parallel_case full_case
		4'b0001	:	fifo4_en = (cnt_c == 3'd1);
		4'b0010	:	fifo4_en = (cnt_c == 3'd1);
		4'b0100	:	fifo4_en = (cnt_c == 3'd1);
		4'b1000	:	fifo4_en = (cnt_c == 3'd1);
		4'b0011	:	fifo4_en = (cnt_c == 3'd1);
		4'b1100	:	fifo4_en = (cnt_c == 3'd1);
		4'b1111	:	fifo4_en = (cnt_c == 3'd1);
	endcase
end

//-----------------------------------------------------------------------------
// Data Mux for routing data signal to memories
always @(ch_cnfg1 or cnt_r or ch1_din or ch2_din or ch3_din or ch4_din)
begin
	case(ch_cnfg1)	// synopsys parallel_case full_case
		4'b0001	:	fifo1_din = ch1_din;
		4'b0010	:	fifo1_din = ch2_din;
		4'b0100	:	fifo1_din = ch3_din;
		4'b1000	:	fifo1_din = ch4_din;
		4'b0011	:	fifo1_din = ch1_din;
		4'b1100	:	fifo1_din = ch3_din;
		4'b1111	:	fifo1_din = ch1_din;
	endcase
end
// Data Mux for routing data signal to memories
always @(ch_cnfg2 or cnt_r or ch1_din or ch2_din or ch3_din or ch4_din)
begin
	case(ch_cnfg2)	// synopsys parallel_case full_case
		4'b0001	:	fifo2_din = ch1_din;
		4'b0010	:	fifo2_din = ch2_din;
		4'b0100	:	fifo2_din = ch3_din;
		4'b1000	:	fifo2_din = ch4_din;
		4'b0011	:	fifo2_din = ch1_din;
		4'b1100	:	fifo2_din = ch3_din;
		4'b1111	:	fifo2_din = ch2_din;
	endcase
end
// Data Mux for routing data signal to memories
always @(ch_cnfg3 or cnt_r or ch1_din or ch2_din or ch3_din or ch4_din)
begin
	case(ch_cnfg3)	// synopsys parallel_case full_case
		4'b0001	:	fifo3_din = ch1_din;
		4'b0010	:	fifo3_din = ch2_din;
		4'b0100	:	fifo3_din = ch3_din;
		4'b1000	:	fifo3_din = ch4_din;
		4'b0011	:	fifo3_din = ch2_din;
		4'b1100	:	fifo3_din = ch4_din;
		4'b1111	:	fifo3_din = ch3_din;
	endcase
end
// Data Mux for routing data signal to memories
always @(ch_cnfg4 or cnt_r or ch1_din or ch2_din or ch3_din or ch4_din)
begin
	case(ch_cnfg4)	// synopsys parallel_case full_case
		4'b0001	:	fifo4_din = ch1_din;
		4'b0010	:	fifo4_din = ch2_din;
		4'b0100	:	fifo4_din = ch3_din;
		4'b1000	:	fifo4_din = ch4_din;
		4'b0011	:	fifo4_din = ch2_din;
		4'b1100	:	fifo4_din = ch4_din;
		4'b1111	:	fifo4_din = ch4_din;
	endcase
end

//-----------------------------------------------------------------------------
// Pipeiline Registers to meet the timing
always @(posedge clk)
begin
	if(!cnt_z)
	begin
		fifo1_we_r	<=`DLY fifo1_write;
		fifo2_we_r	<=`DLY fifo2_write | fifo2_first_write;
		fifo3_we_r	<=`DLY fifo3_write | fifo3_first_write;
		fifo4_we_r	<=`DLY fifo4_write | fifo4_first_write;
	end
	else
	begin
		fifo1_we_r	<=`DLY 1'b0;
		fifo2_we_r	<=`DLY 1'b0;
		fifo3_we_r	<=`DLY 1'b0;
		fifo4_we_r	<=`DLY 1'b0;
	end
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	fifo1_din_r	<=`DLY fifo1_din;
	fifo2_din_r	<=`DLY fifo2_din;
	fifo3_din_r	<=`DLY fifo3_din;
	fifo4_din_r	<=`DLY fifo4_din;
end

//-----------------------------------------------------------------------------
//special condition muxes when memories are full
always @(ch_cnfg2 or full1 or fifo1_we)
begin
	case(ch_cnfg2)	// synopsys parallel_case full_case
		4'b0001	,
		4'b0010	,
		4'b0100	,
		4'b1000	,
		4'b0011	,
		4'b1100	:	fifo2_first_write = full1 & fifo1_we;
		4'b0000	,
		4'b1111	:	fifo2_first_write = 1'b0;
	endcase
end

always @(ch_cnfg3 or full2 or fifo2_we)
begin
	case(ch_cnfg3)	// synopsys parallel_case full_case
		4'b0001	,
		4'b0010	,
		4'b0100	,
		4'b1000	:	fifo3_first_write = full2 & fifo2_we;
		4'b0011	,
		4'b1100	,
		4'b0000	,
		4'b1111	:	fifo3_first_write = 1'b0;
	endcase
end

always @(ch_cnfg4 or full3 or fifo3_we)
begin
	case(ch_cnfg4)	// synopsys parallel_case full_case
		4'b0001	,
		4'b0010	,
		4'b0100	,
		4'b1000	,
		4'b0011	,
		4'b1100	:	fifo4_first_write = full3 & fifo3_we;
		4'b0000	,
		4'b1111	:	fifo4_first_write = 1'b0;
	endcase
end

//-----------------------------------------------------------------------------
//16kwords each
dumpmem_blk dumpmem_blk_inst1(
				.rdlen0		(rdlen_a),
				.rdlen1		(rdlen_b),
				.rdlen2		(rdlen_c),
				.tx_bz		(tx_bz_r),
				.din		(fifo1_din_r),	// Bus [15 : 0]
				.rd_clk		(clk),
				.rd_en		(fifo1_oe),
				.rst		(ch1_rst2),
				.ch_rst0	(ch1_rst0),
				.ch_rst1	(ch1_rst1),
				.wr_clk		(clk),
				.wr_en		(fifo1_we_r),
				.dout_r		(fifo1_dout),	// Bus [7 : 0]
				.valid_r	(valid1),
				.rdlim_hit	(empty1),
				.full		(full1)
	);

dumpmem_blk dumpmem_blk_inst2(
				.rdlen0		(rdlen_a),
				.rdlen1		(rdlen_b),
				.rdlen2		(rdlen_c),
				.tx_bz		(tx_bz_r),
				.din		(fifo2_din_r),	// Bus [15 : 0]
				.rd_clk		(clk),
				.rd_en		(fifo2_oe),
				.rst		(ch2_rst2),
				.ch_rst0	(ch2_rst0),
				.ch_rst1	(ch2_rst1),
				.wr_clk		(clk),
				.wr_en		(fifo2_we_r),
				.dout_r		(fifo2_dout),	// Bus [7 : 0]
				.valid_r	(valid2),
				.rdlim_hit	(empty2),
				.full		(full2)
	);

dumpmem_blk dumpmem_blk_inst3(
				.rdlen0		(rdlen_a),
				.rdlen1		(rdlen_b),
				.rdlen2		(rdlen_c),
				.tx_bz		(tx_bz_r),
				.din		(fifo3_din_r),	// Bus [15 : 0]
				.rd_clk		(clk),
				.rd_en		(fifo3_oe),
				.rst		(ch3_rst2),
				.ch_rst0	(ch3_rst0),
				.ch_rst1	(ch3_rst1),
				.wr_clk		(clk),
				.wr_en		(fifo3_we_r),
				.dout_r		(fifo3_dout),	// Bus [7 : 0]
				.valid_r	(valid3),
				.rdlim_hit	(empty3),
				.full		(full3)
	);

dumpmem_blk dumpmem_blk_inst4(
				.rdlen0		(rdlen_a),
				.rdlen1		(rdlen_b),
				.rdlen2		(rdlen_c),
				.tx_bz		(tx_bz_r),
				.din		(fifo4_din_r),	// Bus [15 : 0]
				.rd_clk		(clk),
				.rd_en		(fifo4_oe),
				.rst		(ch4_rst2),
				.ch_rst0	(ch4_rst0),
				.ch_rst1	(ch4_rst1),
				.wr_clk		(clk),
				.wr_en		(fifo4_we_r),
				.dout_r		(fifo4_dout),	// Bus [7 : 0]
				.valid_r	(valid4),
				.rdlim_hit	(empty4),
				.full		(full4)
	);

//-----------------------------------------------------------------------------

always @(empty4 or empty3 or empty2 or empty1)
begin
	empty = empty4 & empty3 & empty2 & empty1;
end

//-----------------------------------------------------------------------------
// Empties the memories sequentially, always strats with mem1 downto mem 4
always @(rrcnt_r or ch_cnfg or rrcnt_dec or rrcnt_z or empty4 or empty3 or empty2 or empty1)
begin
	case(rrcnt_r)	// synopsys parallel_case full_case
		3'd4	:	rrcnt_c = empty1 ? rrcnt_dec : rrcnt_r;
		3'd3	:	rrcnt_c = empty2 ? rrcnt_dec : rrcnt_r;
		3'd2	:	rrcnt_c = empty3 ? rrcnt_dec : rrcnt_r;
		3'd1	:	rrcnt_c = empty4 ? rrcnt_dec : rrcnt_r;
		3'd0	:	rrcnt_c = 3'd4;
	endcase
end

always @(rrcnt_r)
begin
	rrcnt_dec = rrcnt_r - 1'b1;
	rrcnt_z	= ~|rrcnt_r;
end

always @(posedge clk)
begin
	if(rst_)
		rrcnt_r <=`DLY 3'd0;
	else if(dcaptxgo && tx_bz_r)
		rrcnt_r <=`DLY rrcnt_c;
	else
		rrcnt_r <=`DLY 3'd0;
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	if(reset)
		tx_bz_r <=`DLY 1'b0;
	else if(full4_r)
		tx_bz_r <=`DLY 1'b1;
	else if(empty)
		tx_bz_r <=`DLY 1'b0;
end

always @(posedge clk)
begin
	tx_bz_d1_r <=`DLY tx_bz_r;
end

always @(tx_bz_d1_r or tx_bz_r)
begin
	tx_done_p = ~tx_bz_r & tx_bz_d1_r;
end

//-----------------------------------------------------------------------------
// Uart doesn't want to be disturbed when transferring data, use uart_txbuf_full flag
always @(posedge clk)
begin
	if(reset_)
	begin
		fifo1_oe_r <=`DLY 1'b0;
		fifo2_oe_r <=`DLY 1'b0;
		fifo3_oe_r <=`DLY 1'b0;
		fifo4_oe_r <=`DLY 1'b0;
	end
	else
	begin
		fifo1_oe_r <=`DLY ~(uart_txbuf_full | cntd_nz) & (rrcnt_r == 3'd4);
		fifo2_oe_r <=`DLY ~(uart_txbuf_full | cntd_nz) & (rrcnt_r == 3'd3);
		fifo3_oe_r <=`DLY ~(uart_txbuf_full | cntd_nz) & (rrcnt_r == 3'd2);
		fifo4_oe_r <=`DLY ~(uart_txbuf_full | cntd_nz) & (rrcnt_r == 3'd1);
	end
end

always @(posedge clk)
begin
	if(~cntd_nz && ~rrcnt_z)
		cntd_r <=`DLY 3'd7;
	else if(cntd_nz)
		cntd_r <=`DLY cntd_r - 1'b1;
	else
		cntd_r <=`DLY 3'd0;
end

always @(fifo4_oe_r or fifo3_oe_r or fifo2_oe_r or fifo1_oe_r)
begin
	fifo1_oe = fifo1_oe_r;
	fifo2_oe = fifo2_oe_r;
	fifo3_oe = fifo3_oe_r;
	fifo4_oe = fifo4_oe_r;
end

always @(cntd_r)
begin
	cntd_nz = |cntd_r;
end

//-----------------------------------------------------------------------------

always @(valid4 or valid3 or valid2 or valid1 or rdlen_enc)
begin
	uart_we =	(valid4 & rdlen_enc[7]) | 
				(valid3 & rdlen_enc[6]) | 
				(valid2 & rdlen_enc[5]) | 
				(valid1 & rdlen_enc[4]);
end

//-----------------------------------------------------------------------------

always @(posedge clk)
begin
	rrcnt_dly1_r <=`DLY rrcnt_r;
end

always @(fifo4_dout or fifo3_dout or fifo2_dout or fifo1_dout or rrcnt_dly1_r)
begin
	case(rrcnt_dly1_r)	// synopsys parallel_case full_case
		3'd4	:	uart_din = fifo1_dout;
		3'd3	:	uart_din = fifo2_dout;
		3'd2	:	uart_din = fifo3_dout;
		3'd1	:	uart_din = fifo4_dout;
	endcase
end

//-----------------------------------------------------------------------------

always @(rdlen_enc)
begin
	case(rdlen_enc[3:0])	// synthesis parallel_case full_case
		4'b0001	:	rdlen_a = `READLEN1_A;
		4'b0010	:	rdlen_a = `READLEN2_A;
		4'b0100	:	rdlen_a = `READLEN3_A;
		4'b1000	:	rdlen_a = `READLEN4_A;
	endcase
end

always @(rdlen_enc)
begin
	case(rdlen_enc[3:0])	// synthesis parallel_case full_case
		4'b0001	:	rdlen_b = `READLEN1_B;
		4'b0010	:	rdlen_b = `READLEN2_B;
		4'b0100	:	rdlen_b = `READLEN3_B;
		4'b1000	:	rdlen_b = `READLEN4_B;
	endcase
end

always @(rdlen_enc)
begin
	case(rdlen_enc[3:0])	// synthesis parallel_case full_case
		4'b0001	:	rdlen_c = `READLEN1_C;
		4'b0010	:	rdlen_c = `READLEN2_C;
		4'b0100	:	rdlen_c = `READLEN3_C;
		4'b1000	:	rdlen_c = `READLEN4_C;
	endcase
end

//-----------------------------------------------------------------------------

endmodule
