
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module evbif_obufdes(
			sys_clk,			// system clock

			ch1_wrst,  // write reset
			ch2_wrst,
			ch3_wrst,
			ch4_wrst,
			ch1_rrst,  // read reset
			ch2_rrst,
			ch3_rrst,
			ch4_rrst,

			ch1_clk,			// channel 1 clock
			ch2_clk,			// channel 2 clock
			ch3_clk,			// channel 3 clock
			ch4_clk,			// channel 4 clock
			ch1_din,			// input data from ch 1
			ch2_din,			// input data from ch 2
			ch3_din,			// input data from ch 3
			ch4_din,			// input data from ch 4
			ch1_we,		// write enable	for ch 1 buffer
			ch2_we,		// write enable	for ch 2 buffer
			ch3_we,		// write enable	for ch 3 buffer
			ch4_we,		// write enable	for ch 4 buffer

			ch1_dvalid,			// output data from channel 1 is valid
			ch2_dvalid,			// output data from channel 2 is valid
			ch3_dvalid,			// output data from channel 3 is valid
			ch4_dvalid,			// output data from channel 4 is valid
			ch1_dout,			// output data from channel 1
			ch2_dout,			// output data from channel 2
			ch3_dout,			// output data from channel 3
			ch4_dout			// output data from channel 4
			);

input			ch1_clk;
input			ch2_clk;
input			ch3_clk;
input			ch4_clk;
input			sys_clk;
input			ch1_wrst;
input			ch2_wrst;
input			ch3_wrst;
input			ch4_wrst;
input			ch1_rrst;
input			ch2_rrst;
input			ch3_rrst;
input			ch4_rrst;
input			ch1_we;
input			ch2_we;
input			ch3_we;
input			ch4_we;
input	[15:0]	ch1_din;
input	[15:0]	ch2_din;
input	[15:0]	ch3_din;
input	[15:0]	ch4_din;

output			ch1_dvalid;
output			ch2_dvalid;
output			ch3_dvalid;
output			ch4_dvalid;
output	[15:0]	ch1_dout;
output	[15:0]	ch2_dout;
output	[15:0]	ch3_dout;
output	[15:0]	ch4_dout;

//-----------------------------------------------------------------------------

obufdes_safifo obufdes_safifo_inst1(
			.wr_clk		(ch1_clk),
			.rd_clk		(sys_clk),
			.din		(ch1_din),		// Bus [15 : 0]
			.wreset		(ch1_wrst),
			.rreset		(ch1_rrst),
			.we			(ch1_we),
			.dvalid		(ch1_dvalid),
			.dout		(ch1_dout)		// Bus [15 : 0]
			);

obufdes_safifo obufdes_safifo_inst2(
			.wr_clk		(ch2_clk),
			.rd_clk		(sys_clk),
			.din		(ch2_din),		// Bus [15 : 0]
			.wreset		(ch2_wrst),
			.rreset		(ch2_rrst),
			.we			(ch2_we),
			.dvalid		(ch2_dvalid),
			.dout		(ch2_dout)		// Bus [15 : 0]
			);

obufdes_safifo obufdes_safifo_inst3(
			.wr_clk		(ch3_clk),
			.rd_clk		(sys_clk),
			.din		(ch3_din),		// Bus [15 : 0]
			.wreset		(ch3_wrst),
			.rreset		(ch3_rrst),
			.we			(ch3_we),
			.dvalid		(ch3_dvalid),
			.dout		(ch3_dout)		// Bus [15 : 0]
			);

obufdes_safifo obufdes_safifo_inst4(
			.wr_clk		(ch4_clk),
			.rd_clk		(sys_clk),
			.din		(ch4_din),		// Bus [15 : 0]
			.wreset		(ch4_wrst),
			.rreset		(ch4_rrst),
			.we			(ch4_we),
			.dvalid		(ch4_dvalid),
			.dout		(ch4_dout)		// Bus [15 : 0]
			);

//-----------------------------------------------------------------------------

endmodule
