
//============================================================================
//
//This confidential	and	proprietary	software may be	used only as authorized
//by a licensing agreement from	Texas Instruments, US.
//
//	   In the event	of publication,	the	following notice is	applicable:
//
//						  (C) COPYRIGHT	2007 TI
//							ALL	RIGHTS RESERVED
//
// Entire notice above must	be reproduced on all authorized	copies.
//
//
// Title:	   %M%
// Version:	   %I%
// Date:	   %G%
// Author:	   Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module evbif_spi(
			clk,
			reset,
			din,
			dout,
			div_val,
			done,
			spi_ctrl,
  // SPI signals
			spi_ss,  //CS
			spi_sclk, //SCLK
			spi_mosi, //SDATA 
			spi_miso  //Not used on ADC - only for readback
		);

  // CPU signals
input							clk;	// master clock input
input							reset;	// synchronous active high reset
input							spi_miso;	// master in slave out
input	[23:0]					din;	// databus input
input	[7:0]					div_val;
input	[7:0]					spi_ctrl;

output	[23:0]					dout;	// databus output
output							done;
// SPI signals									   
output							spi_ss;	//	slave select
output							spi_sclk;	// serial clock
output							spi_mosi;	// master out slave in

//-----------------------------------------------------------------------------

wire							tip;
wire							last_bit;
wire							pos_edge;

reg								rx_clk_edge;
reg								tx_clk_edge;
reg								tx_clk_edge_r;
reg								rx_clk_edge_r;

//-----------------------------------------------------------------------------

assign	done = (tip & last_bit & pos_edge);
assign	spi_ss = ~tip;

//-----------------------------------------------------------------------------

spi_clkgen spi_clkgen_inst(
				.clk_in		(clk),
				.rst		(reset),
				.enable		(tip),
				.last_clk	(last_bit),
`ifdef SIMULATE_IN_MODELSIM
				.divider	(8'd10),
`else
				.divider	(div_val),
`endif
				.clk_out	(spi_sclk),
				.pos_edge	(pos_edge), 
				.neg_edge	(neg_edge)
				);

spi_shift spi_shift_inst (
				.clk			(clk),
				.rst			(reset),
				.go				(spi_ctrl[7]),
				.bit_cnt		(spi_ctrl[4:0]),
				.rx_clk_edge	(rx_clk_edge_r),
				.tx_clk_edge	(tx_clk_edge_r),
				.tip			(tip),
				.last			(last_bit), 
				.p_in			(din),
				.p_out			(dout), 
				.s_in			(spi_miso),
				.s_out			(spi_mosi)
				);

//-----------------------------------------------------------------------------

assign	sel_rxclk_edge = spi_ctrl[6];
assign	sel_txclk_edge = spi_ctrl[5];

always @(pos_edge or neg_edge or sel_txclk_edge)
begin
	case(sel_txclk_edge)	// synopsys parallel_case
		1'b1	:	tx_clk_edge = pos_edge;
		1'b0	:	tx_clk_edge = neg_edge;
	endcase
end

always @(pos_edge or neg_edge or sel_rxclk_edge)
begin
	case(sel_rxclk_edge)	// synopsys parallel_case
		1'b1	:	rx_clk_edge = pos_edge;
		1'b0	:	rx_clk_edge = neg_edge;
	endcase
end

always @(posedge clk)
begin
	tx_clk_edge_r	<=`DLY tx_clk_edge;
	rx_clk_edge_r	<=`DLY rx_clk_edge;
end

//-----------------------------------------------------------------------------

endmodule
