
//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
//
// Title:      %M%
// Version:    %I%
// Date:       %G%
// Author:     Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module evbif_uart(
				clk,
				div_val,
				din,
				write,
				reset,
				tusb_bclk,
				sout,
				sin,
				read,
				dout,
				data_present,
				tx_buffer_full,
				rx_buffer_full
			);

input			clk;
input			tusb_bclk;
input			reset;
input			write;
input			read;
input			sin;
input	[7:0]	din;
input	[7:0]	div_val;

output			tx_buffer_full;
output			rx_buffer_full;
output			sout;
output			data_present;
output	[7:0]	dout;

//-----------------------------------------------------------------------------

// wire			en_16_x_baud;

//-----------------------------------------------------------------------------

uart_tx uart_tx_inst(
				.data_in 			(din),
				.write_buffer		(write),
				.reset_buffer		(reset),
				.en_16_x_baud		(en_16_x_baud),
				.clk				(clk),
				.serial_out			(sout),
				.buffer_half_full	(),
				.buffer_full		(tx_buffer_full)
				);

uart_rx uart_rx_inst(
				.serial_in				(sin),
				.read_buffer 			(read),
				.reset_buffer			(reset),
				.en_16_x_baud			(en_16_x_baud),
				.clk					 	(clk),
				.data_out				(dout),
				.buffer_data_present	(data_present),
				.buffer_half_full		(),
				.buffer_full			(rx_buffer_full)
				);

uart_baudgen uart_baudgen_inst(
				.clk			(clk),
				.tusb_bclk		(tusb_bclk),
				.reset			(reset),
				.div_val		(div_val),
				.en_16_x_baud	(en_16_x_baud)
				); 

//-----------------------------------------------------------------------------

endmodule
