//============================================================================
//
//This confidential and proprietary software may be used only as authorized
//by a licensing agreement from Texas Instruments, US.
//
//     In the event of publication, the following notice is applicable:
//
//                        (C) COPYRIGHT 2007 TI
//                          ALL RIGHTS RESERVED
//
// Entire notice above must be reproduced on all authorized copies.
//
// Title:      life pulse to LED if clock is toggling
// Version:    initial
// Date:       3/18/08
// Author:     R Prentice
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif
module Life_Pulse(
				clkin,
				enable,	
				life_out
				); 

input				clkin;
input				enable;

output			life_out;


//-----------------------------------------------------------------------------

reg		[29:0]	count;
reg				life_out;

//-----------------------------------------------------------------------------

// easy way - 30b counter counts 200MHz down to about a second pulse.  More elegant would be to copy
// the srle16 cell approach used in the deser code.  And bits 27 and 29 to get unique blink blink pause pause

always @(posedge clkin)
begin
	if(~enable)
	count <= count + 1;
end

always @(count[29])
begin
	life_out = count[29] & count[27];
end



endmodule
