
//============================================================================
//
//This confidential	and	proprietary	software may be	used only as authorized
//by a licensing agreement from	Texas Instruments, US.
//
//	   In the event	of publication,	the	following notice is	applicable:
//
//						  (C) COPYRIGHT	2007 TI
//							ALL	RIGHTS RESERVED
//
// Entire notice above must	be reproduced on all authorized	copies.
//
//
// Title:	   %M%
// Version:	   %I%
// Date:	   %G%
// Author:	   Hamza Fraz
//============================================================================

`ifdef SIMULATE_IN_MODELSIM
`else
	`include "defines.vh"
`endif

module spi_shift(
			clk,
			rst,
			go,
			bit_cnt,
			rx_clk_edge,
			tx_clk_edge,
			tip,
			last,
			p_in,
			p_out,
			s_in,
			s_out
			);

input			clk;		// system clock
input			rst;		// reset
input			go;			// start	transfer
input			s_in;		// serial in
input			rx_clk_edge;
input			tx_clk_edge;
input	[23:0]	p_in;		// parallel in
input	[4:0]	bit_cnt;

output			tip;		// transfer in progress
output			last;		// last bit
output			s_out;		// serial out
output	[23:0]	p_out;		// parallel out

reg				s_out;
reg				tip;
reg				bit_o;
reg				bit_i;
reg				cnt_non_0;
reg				last;		// last bit
reg		[4:0]	cnt;		//	data bit count
reg		[23:0] 	txdata;		// shift	register
reg		[23:0] 	rxdata;		// shift	register
reg		[4:0]	cnt_c;
reg		[4:0]	bit_pos;	//	next bit position

wire			rx_clk;		// rx clock enable
wire			tx_clk;		// tx clock enable

always @(cnt)
begin
	cnt_non_0	= |cnt;
	cnt_c		= cnt_non_0 ? cnt - 1'b1 : cnt;
	last		= (cnt == 5'b00001);
end

assign p_out = rxdata;

always @(posedge clk)
begin
	bit_pos <=`DLY cnt_c;
end

assign rx_clk = rx_clk_edge;
assign tx_clk = tx_clk_edge;

// Character bit counter
always @(posedge clk)
begin
	if(tip)
		cnt <=`DLY tx_clk ? cnt_c : cnt;
	else 
		cnt <=`DLY bit_cnt;
end

// Transfer in progress
always @(posedge clk or posedge rst)
begin
	if(rst)
		tip <=`DLY 1'b0;
	else if(go && ~tip)
		tip	<=`DLY 1'b1;
	else if(tip && last && tx_clk_edge)
		tip	<=`DLY 1'b0;
end

// Sending bits to the line
always @(posedge clk)
begin
		s_out <=`DLY bit_o;
end

always @(bit_pos or txdata)
begin
	case(bit_pos)	// synopsys	parallel_case full_case
	5'd00	:	bit_o =	txdata[00];
	5'd01	:	bit_o =	txdata[01];
	5'd02	:	bit_o =	txdata[02];
	5'd03	:	bit_o =	txdata[03];
	5'd04	:	bit_o =	txdata[04];
	5'd05	:	bit_o =	txdata[05];
	5'd06	:	bit_o =	txdata[06];
	5'd07	:	bit_o =	txdata[07];
	5'd08	:	bit_o =	txdata[08];
	5'd09	:	bit_o =	txdata[09];
	5'd10	:	bit_o =	txdata[10];
	5'd11	:	bit_o =	txdata[11];
	5'd12	:	bit_o =	txdata[12];
	5'd13	:	bit_o =	txdata[13];
	5'd14	:	bit_o =	txdata[14];
	5'd15	:	bit_o =	txdata[15];
	5'd16	:	bit_o =	txdata[16];
	5'd17	:	bit_o =	txdata[17];
	5'd18	:	bit_o =	txdata[18];
	5'd19	:	bit_o =	txdata[19];
	5'd20	:	bit_o =	txdata[20];
	5'd21	:	bit_o =	txdata[21];
	5'd22	:	bit_o =	txdata[22];
	5'd23	:	bit_o =	txdata[23];
	// synopsys	translate_off
	default	:	bit_o =	1'bx;
	// synopsys	translate_on
	endcase
end

always @(posedge clk)
begin
	if(!tip)
		txdata <=`DLY p_in;
end

always @(posedge clk)
begin
	rxdata[bit_pos] <=`DLY rx_clk ? s_in : bit_i;
end

always @(bit_pos or rxdata)
begin
	case(bit_pos)	// synopsys	parallel_case full_case
	5'd00	:	bit_i =	rxdata[00];
	5'd01	:	bit_i =	rxdata[01];
	5'd02	:	bit_i =	rxdata[02];
	5'd03	:	bit_i =	rxdata[03];
	5'd04	:	bit_i =	rxdata[04];
	5'd05	:	bit_i =	rxdata[05];
	5'd06	:	bit_i =	rxdata[06];
	5'd07	:	bit_i =	rxdata[07];
	5'd08	:	bit_i =	rxdata[08];
	5'd09	:	bit_i =	rxdata[09];
	5'd10	:	bit_i =	rxdata[10];
	5'd11	:	bit_i =	rxdata[11];
	5'd12	:	bit_i =	rxdata[12];
	5'd13	:	bit_i =	rxdata[13];
	5'd14	:	bit_i =	rxdata[14];
	5'd15	:	bit_i =	rxdata[15];
	5'd16	:	bit_i =	rxdata[16];
	5'd17	:	bit_i =	rxdata[17];
	5'd18	:	bit_i =	rxdata[18];
	5'd19	:	bit_i =	rxdata[19];
	5'd20	:	bit_i =	rxdata[20];
	5'd21	:	bit_i =	rxdata[21];
	5'd22	:	bit_i =	rxdata[22];
	5'd23	:	bit_i =	rxdata[23];
	// synopsys	translate_off
	default	:	bit_i =	1'bx;
	// synopsys	translate_on
	endcase
end

endmodule
