/*
 * cyfxconfigfpga.c
 *
 *  Created on: Sep 18, 2014
 *      Author: Gokul Prasath Nallasamy
 */


#include "cyu3system.h"
#include "cyu3os.h"
#include "cyu3dma.h"
#include "cyu3error.h"
#include "cyu3usb.h"
#include "cyu3gpio.h"
#include "cyu3spi.h"
#include "cyu3uart.h"
#include "cyfxslfifosync.h"
#include "cyu3gpif.h"
#include "cyu3pib.h"
#include "pib_regs.h"
#include "cyfxconfigfpga.h"
#include "cyfxslfifogpifreconfig.h"

/* This file illustrates the configure FPGA using FX3 in FPP Mode*/


CyU3PDmaChannel glChHandleUtoCPU;   /* DMA Channel handle for U2CPU transfer. */

CyBool_t glConfigDone = CyTrue;			/* Flag to indicate that FPGA configuration is done */

uint32_t filelen = 0;					/* length of Configuration file (.rbf) */

CyU3PEvent glFxConfigFpgaAppEvent;    /* Configure FPGA event group. */

uint16_t uiPacketSize = 0;

CyBool_t config_fpga = CyFalse;

/*----------------------------------------------------------------------------------*/
/*-------------------- FPGA Programming Related Functions Starts--------------------*/
/*----------------------------------------------------------------------------------*/

/*Starts Fw Loading by Clearing and Setting
 *the nConfig pin and monitors nStatus. */
CyU3PReturnStatus_t Fpga_Begin_Prog(void)
{
    CyBool_t value;
    unsigned tEnd;
    CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;

    //Making nconfig to go low and high to start reconfiguration (or configuration)

    apiRetStatus = CyU3PGpioSetValue(GPIO_nCONFIG, CyFalse);

    tEnd = CyU3PGetTime() + 10;
    while (CyU3PGetTime() < tEnd);

    apiRetStatus = CyU3PGpioSetValue(GPIO_nCONFIG, CyTrue);

    tEnd = CyU3PGetTime() + 1000;

    //Checking for nstatus to go high to continue the configuration and to ensure fpga reacting
    do
    {
        apiRetStatus = CyU3PGpioGetValue(GPIO_nSTATUS, &value);
        if (CyU3PGetTime() > tEnd)
            return CY_U3P_ERROR_TIMEOUT;	//Initialization Timed Out
    } while (!value);

    return CY_U3P_SUCCESS;
}

/* This function writes configuration data to the FPGA */
/* Called from SlFifoAppThread_Entry(), length will be set through vendor request Data Bus.*/
CyU3PReturnStatus_t CyFxConfigFpgaStart(uint32_t uiLen)
{
	CyU3PReturnStatus_t apiRetStatus;
	/*
	uint32_t ConfgLen;
	int i = 0;

	CyU3PDmaBuffer_t inBuf_p;
	CyBool_t Fpga_Confg_Done;
	 */
	filelen = uiLen;

#ifdef UART_ENABLE
	CyU3PDebugPrint (4, "FPGA Config file length: %d\n", uiLen);
#endif

	/*Initialize the FPGA for Configuring*/
	apiRetStatus = Fpga_Begin_Prog();	//for testing
	if(apiRetStatus != CY_U3P_SUCCESS)
	{
		/*Programming of FPGA failed*/
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "Failed at 1, error code = %d\n", apiRetStatus);
#endif
		glConfigDone = CyFalse;
		return apiRetStatus;
	}

	config_fpga = CyTrue;

	//TODO changed from '0 to less than uiLen' to 'uiLen to greater than 0'; verify; Gokul

	/* Start sending out the configuration data */
	/*for(ConfgLen = uiLen; (ConfgLen > 0) && glIsApplnActive; ConfgLen -= uiPacketSize )
	{
		apiRetStatus = CyU3PDmaChannelGetBuffer (&glChHandleUtoCPU, &inBuf_p, 3000);
		if(apiRetStatus != CY_U3P_SUCCESS)
		{
			// Wait 2000 ms (Timeout Value)
#ifdef UART_ENABLE
			CyU3PDebugPrint (4, "Failed at 2, error code = %d\n", apiRetStatus);
#endif
			glConfigDone = CyFalse;
			break;
		}

		apiRetStatus = CyU3PDmaChannelCommitBuffer (&glChHandleUtoCPU, uiPacketSize, 0);
		if (apiRetStatus != CY_U3P_SUCCESS)
		{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "Failed at 3, error code = %d\n", apiRetStatus);
#endif
			glConfigDone = CyFalse;
			break;
		}
	}

	CyU3PThreadSleep(1);

	apiRetStatus = CyU3PGpioGetValue(GPIO_CONFDONE, &Fpga_Confg_Done);
	if( (Fpga_Confg_Done != CyTrue) )
	{
		glConfigDone = CyFalse;
		apiRetStatus = CY_U3P_ERROR_FAILURE;
	}
	else
	{
		// Giving 2 DCLK after conf_done, for FPGA initialization cycle
		for(i=0; i<2; i++)
		{
			apiRetStatus = CyU3PDmaChannelCommitBuffer (&glChHandleUtoCPU,uiPacketSize,0);
			if (apiRetStatus != CY_U3P_SUCCESS)
			{
				glConfigDone = CyFalse;
				break;
			}*//*
		}
	}*/

	while(config_fpga == CyFalse);
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "coming out of configfpgastart()\n");
#endif
	return apiRetStatus;

}

/*----------------------------------------------------------------------------------*/
/*---------------------- FPGA Programming Related Functions Ends--------------------*/
/*----------------------------------------------------------------------------------*/

/************************************************************************************/
/*						FX3 Initialization and FX3 Related Functions Starts			*/
/************************************************************************************/
#if 0
/*Configures each GPIO Pin*/
CyU3PReturnStatus_t CyFxConfigFpgaGpioReConfig(void)
{
	CyU3PGpioSimpleConfig_t gpioConfig;
	CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;

	/* Configure GPIO_nSTATUS as input */
	gpioConfig.outValue = CyTrue;
	gpioConfig.inputEn = CyTrue;
	gpioConfig.driveLowEn = CyFalse;
	gpioConfig.driveHighEn = CyFalse;
	gpioConfig.intrMode = CY_U3P_GPIO_NO_INTR;
	apiRetStatus = CyU3PGpioSetSimpleConfig(GPIO_nSTATUS, &gpioConfig);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
	  /* Error handling */
		#ifdef UART_ENABLE
			CyU3PDebugPrint (4, "CyU3PGpioSetSimpleConfig for GPIO Id %d failed, error code = %d\n",
					GPIO_nSTATUS, apiRetStatus);
		#endif
	  CyFxAppErrorHandler(apiRetStatus);
	}

	/* Configure GPIO_CONFDONE as input */
	gpioConfig.outValue = CyTrue;
	gpioConfig.inputEn = CyTrue;
	gpioConfig.driveLowEn = CyFalse;
	gpioConfig.driveHighEn = CyFalse;
	gpioConfig.intrMode = CY_U3P_GPIO_NO_INTR;
	apiRetStatus = CyU3PGpioSetSimpleConfig(GPIO_CONFDONE, &gpioConfig);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
	  /* Error handling */
	  /*CyU3PDebugPrint (4,
	   "CyU3PGpioSetSimpleConfig failed, error code = %d\n",apiRetStatus);*/
	  CyFxAppErrorHandler(apiRetStatus);
	}

	/* Configure GPIO_nCONFIG as output */
	gpioConfig.outValue = CyFalse;
	gpioConfig.inputEn = CyFalse;
	gpioConfig.driveLowEn = CyTrue;
	gpioConfig.driveHighEn = CyTrue;
	gpioConfig.intrMode = CY_U3P_GPIO_NO_INTR;
	apiRetStatus = CyU3PGpioSetSimpleConfig(GPIO_nCONFIG, &gpioConfig);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
	  /* Error handling */
	  /* CyU3PDebugPrint (4,
	    "CyU3PGpioSetSimpleConfig failed, error code = %d\n",apiRetStatus);*/
	  CyFxAppErrorHandler(apiRetStatus);
	}
	return apiRetStatus;
}

/*Initializes GPIO Block */
CyU3PReturnStatus_t CyFxConfigFpgaGpioInit(void)
{
	CyU3PGpioClock_t gpioClock;
	CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;

	/* Init the GPIO module */
	gpioClock.fastClkDiv = 2;
	gpioClock.slowClkDiv = 0;
	gpioClock.simpleDiv = CY_U3P_GPIO_SIMPLE_DIV_BY_2;
	gpioClock.clkSrc = CY_U3P_SYS_CLK;
	gpioClock.halfDiv = 0;

	/* Initialize Gpio interface */
	apiRetStatus = CyU3PGpioInit(&gpioClock, NULL);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
		/* Error Handling */
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "GPIO Clock Init failed, Error Code = %d\n",apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
		return apiRetStatus;
	}

	apiRetStatus = CyFxConfigFpgaGpioReConfig();
if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "GIO Set Failed, Error Code = %d\n",apiRetStatus);
#endif
	}

	return apiRetStatus;
}
#endif

/************************************************************************************/
/*						FX3 Initialization and FX3 Related Functions Ends			*/
/************************************************************************************/

/* DMA callback function to handle the produce events for U to P transfers. */
void
CyFxFpgaUtoPDmaCallback (
        CyU3PDmaChannel   *chHandle,
        CyU3PDmaCbType_t  type,
        CyU3PDmaCBInput_t *input
        )
{
    CyU3PReturnStatus_t status = CY_U3P_SUCCESS;
    CyBool_t Fpga_Confg_Done = CyFalse;

    static uint32_t glDMARxCount = 0;     /* Counter to track the number of buffers received from USB. */
    //uint32_t ConfgLen = filelen;

    //TODO: add controls here
    if ((type == CY_U3P_DMA_CB_PROD_EVENT)&(config_fpga == CyTrue))
    {
        /* This is a produce event notification to the CPU. This notification is
         * received upon reception of every buffer. The buffer will not be sent
         * out unless it is explicitly committed. The call shall fail if there
         * is a bus reset / usb disconnect or if there is any application error. */
    	if((filelen > 0) && glIsApplnActive)
		{
			status = CyU3PDmaChannelCommitBuffer (chHandle, input->buffer_p.count, 0);
			if (status != CY_U3P_SUCCESS)
			{
#ifdef UART_ENABLE
				CyU3PDebugPrint (4, "CyU3PDmaChannelCommitBuffer failed, Error code = %d\n", status);
#endif
			}
			filelen -= input->buffer_p.count;
			 if(filelen <= 0)
			{
#ifdef UART_ENABLE
				 CyU3PDebugPrint (4, "Transfer complete 1\n");
#endif
				status = CyU3PGpioGetValue(GPIO_CONFDONE, &Fpga_Confg_Done);
				if( (Fpga_Confg_Done != CyTrue) )
				{
					glConfigDone = CyFalse;
				}
				else
				{
#ifdef UART_ENABLE
			CyU3PDebugPrint (4, "Transfer complete 2\n");
#endif
					config_fpga = CyFalse;

				//Add two more transfer for FPGA to initialize (two more DCLK); TODO gokul
				}
			}
		}
        /* Increment the counter. */
        glDMARxCount++;
    }
}

void
CyFxConfigFpgaApplnStart (
        void)
{
    uint16_t size = 0;
    CyU3PEpConfig_t epCfg;
    CyU3PDmaChannelConfig_t dmaCfg;
    CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;
    CyU3PUSBSpeed_t usbSpeed = CyU3PUsbGetSpeed();
    uint8_t burstLength =0;

    /* First identify the usb speed. Once that is identified,
     * create a DMA channel and start the transfer on this. */

#ifdef UART_ENABLE
	CyU3PDebugPrint (4, "\n...CyFxConfigFpgaApplnStart()...\n");
#endif

    /* Based on the Bus Speed configure the endpoint packet size */
    switch (usbSpeed)
    {
        case CY_U3P_FULL_SPEED:
            size = 64;
            break;

        case CY_U3P_HIGH_SPEED:
            size = 512;
            burstLength=1;
            break;

        case  CY_U3P_SUPER_SPEED:
            size = 1024;
            burstLength=16;
            break;

        default:
            /*CyU3PDebugPrint (4, "Error! Invalid USB speed.\n");*/
            CyFxAppErrorHandler (CY_U3P_ERROR_FAILURE);
            break;
    }

    CyU3PMemSet ((uint8_t *)&epCfg, 0, sizeof (epCfg));
    epCfg.enable = CyTrue;
    epCfg.epType = CY_U3P_USB_EP_BULK;
    epCfg.burstLen = burstLength;
    epCfg.streams = 0;
    epCfg.pcktSize = size;

    uiPacketSize = size;

    /* Producer endpoint configuration */
    apiRetStatus = CyU3PSetEpConfig(CY_FX_FW_LD_EP_PRODUCER, &epCfg);
    if (apiRetStatus != CY_U3P_SUCCESS)
    {
#ifdef UART_ENABLE
        CyU3PDebugPrint (4, "CyU3PSetEpConfig failed, Error code = %d\n", apiRetStatus);
        CyFxAppErrorHandler (apiRetStatus);
#endif
    }

//    apiRetStatus = CyU3PUsbSetEpSeqNum(CY_FX_FW_LD_EP_PRODUCER, *seqnum_slfifo);
//   if (apiRetStatus != CY_U3P_SUCCESS)
//   {
//	#ifdef UART_ENABLE
//	   CyU3PDebugPrint (4, "CyU3PUsbSetEpSeqNum failed, Error code = %d\n", apiRetStatus);
//	#endif
//   }

    /* Create a DMA MANUAL channel for U2CPU transfer.
     * DMA size is set based on the USB speed. */
    dmaCfg.size  = size * CONFIG_FPGA_DMA_BUF_SIZE;
    dmaCfg.count = CY_FX_FW_LD_DMA_BUF_COUNT;
    dmaCfg.prodSckId = CY_FX_FPGA_CONFIG_PRODUCER_SOCKET;
    dmaCfg.consSckId = CY_FX_FPGA_CONFIG_CONSUMER_SOCKET;
    dmaCfg.dmaMode = CY_U3P_DMA_MODE_BYTE;
    dmaCfg.notification = CY_U3P_DMA_CB_PROD_EVENT; 									//0;
    dmaCfg.cb = CyFxFpgaUtoPDmaCallback;											//NULL;
    dmaCfg.prodHeader = 0;
    dmaCfg.prodFooter = 0;
    dmaCfg.consHeader = 0;
    dmaCfg.prodAvailCount = 0;

    apiRetStatus = CyU3PDmaChannelCreate (&glChHandleUtoCPU,
    		CY_U3P_DMA_TYPE_MANUAL, &dmaCfg);
    if (apiRetStatus != CY_U3P_SUCCESS)
    {
#ifdef UART_ENABLE
        CyU3PDebugPrint (4, "CyU3PDmaChannelCreate failed, Error code = %d\n", apiRetStatus);
        CyFxAppErrorHandler(apiRetStatus);
#endif
    }

    /* Flush the Endpoint memory */
    CyU3PUsbFlushEp(CY_FX_EP_PRODUCER);


    /* Set DMA channel transfer size. */
    apiRetStatus = CyU3PDmaChannelSetXfer (&glChHandleUtoCPU, CY_FX_SLFIFO_DMA_TX_SIZE);
    if (apiRetStatus != CY_U3P_SUCCESS)
    {
#ifdef UART_ENABLE
        CyU3PDebugPrint (4, "CyU3PDmaChannelSetXfer Failed, Error code = %d\n", apiRetStatus);
        CyFxAppErrorHandler(apiRetStatus);
#endif
    }

    /* Update the status flag. */
    glIsApplnActive = CyTrue;
}

void
CyFxConfigFpgaApplnStop (
        void)
{
    CyU3PEpConfig_t epCfg;
    CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;

    /* Update the flag. */
    glIsApplnActive = CyFalse;

#ifdef UART_ENABLE
	CyU3PDebugPrint (4, "\n...CyFxConfigFpgaApplnStop()...\n");
#endif

    /* Abort and clear the channel */
	CyU3PDmaChannelReset(&glChHandleUtoCPU);

    /* Flush the endpoint memory */
    CyU3PUsbFlushEp(CY_FX_FW_LD_EP_PRODUCER);

    /* Destroy the channel */
    CyU3PDmaChannelDestroy (&glChHandleUtoCPU);

    /* Disable endpoints. */
	CyU3PMemSet ((uint8_t *)&epCfg, 0, sizeof (epCfg));
	epCfg.enable = CyFalse;

    /* Producer endpoint configuration. */
    apiRetStatus = CyU3PSetEpConfig(CY_FX_FW_LD_EP_PRODUCER, &epCfg);
    if (apiRetStatus != CY_U3P_SUCCESS)
    {
		#ifdef UART_ENABLE
        CyU3PDebugPrint (4, "CyU3PSetEpConfig failed, Error code = %d\n", apiRetStatus);
		#endif
        CyFxAppErrorHandler (apiRetStatus);
    }

    //CyU3PGpioDeInit();
	//CyU3PSpiDeInit();

    //GPIF No Config
//	apiRetStatus = Fx3_Gpif_Configure(GPIF_CONFIG_DISABLED);
//	if (apiRetStatus != CY_U3P_SUCCESS)
//	{
//		#ifdef UART_ENABLE
//				CyU3PDebugPrint (4, "Gpif Configuration Failed, Error Code = %d\n",apiRetStatus);
//		#endif
//				CyFxAppErrorHandler(apiRetStatus);
//	}

    //LPM = true
	CyFxApplnLPMSuspend(CyTrue);
	glApplnMode = MODE_NO_CONFIG;

}

void
cyfx_gpif_error_cb(CyU3PPibIntrType cbType, uint16_t cbArg)
{
#ifdef UART_ENABLE
	if(cbType==CYU3P_PIB_INTR_ERROR)
	{
		switch (CYU3P_GET_PIB_ERROR_TYPE(cbArg))
		{
			case CYU3P_PIB_ERR_THR0_WR_OVERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR0_WR_OVERRUN");
			break;
			case CYU3P_PIB_ERR_THR1_WR_OVERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR1_WR_OVERRUN");
			break;
			case CYU3P_PIB_ERR_THR2_WR_OVERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR2_WR_OVERRUN");
			break;
			case CYU3P_PIB_ERR_THR3_WR_OVERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR3_WR_OVERRUN");
			break;

			case CYU3P_PIB_ERR_THR0_RD_UNDERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR0_RD_UNDERRUN");
			break;
			case CYU3P_PIB_ERR_THR1_RD_UNDERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR1_RD_UNDERRUN");
			break;
			case CYU3P_PIB_ERR_THR2_RD_UNDERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR2_RD_UNDERRUN");
			break;
			case CYU3P_PIB_ERR_THR3_RD_UNDERRUN:
			CyU3PDebugPrint (4, "CYU3P_PIB_ERR_THR3_RD_UNDERRUN");
			break;

			default:
			CyU3PDebugPrint (4, "No Error :%d\n ",CYU3P_GET_PIB_ERROR_TYPE(cbArg));
				break;
		}
	}
#endif

}

void
CyFxConfigFpgaApplnInit(void)
{
	CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;

#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "Configuring GPIF and GPIO for FPGA FW Load\n");
#endif

	apiRetStatus = Fx3_Gpif_Configure(GPIF_CONFIG_FPGA_FW_LOAD);
		if (apiRetStatus != CY_U3P_SUCCESS)
		{
	#ifdef UART_ENABLE
			CyU3PDebugPrint (4, "Gpif Configuration Failed, Error Code = %d\n",apiRetStatus);
	#endif
			CyFxAppErrorHandler(apiRetStatus);
		}

		/*Initialises GPIO for Configuration */
		/*apiRetStatus = CyFxSlFifoGpioReConfig();
		if (apiRetStatus != CY_U3P_SUCCESS)
		{
	#ifdef UART_ENABLE
			CyU3PDebugPrint (4, "GIO Set Failed, Error Code = %d\n",apiRetStatus);
	#endif
			CyFxAppErrorHandler(apiRetStatus);
		}*/
}

void
CyFxUsbInit (void)
{
	CyU3PReturnStatus_t apiRetStatus = CY_U3P_SUCCESS;

	apiRetStatus = CyU3PEventCreate(&glFxConfigFpgaAppEvent);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "Event create failed, Error Code = %d\n",apiRetStatus);
#endif
	}

//	apiRetStatus = Fx3_Gpif_Configure(GPIF_CONFIG_DISABLED);
//	if (apiRetStatus != CY_U3P_SUCCESS)
//	{
//#ifdef UART_ENABLE
//		CyU3PDebugPrint (4, "Gpif Configuration Failed, Error Code = %d\n",apiRetStatus);
//#endif
//		CyFxAppErrorHandler(apiRetStatus);
//	}


	/* Start the USB functionality. */
	apiRetStatus = CyU3PUsbStart();
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "CyU3PUsbStart failed to Start, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* callback to see if there is any overflow of data on the GPIF II side*/
	CyU3PPibRegisterCallback(cyfx_gpif_error_cb,0xffff);

	/* The fast enumeration is the easiest way to setup a USB connection,
	 * where all enumeration phase is handled by the library. Only the
	 * class / vendor requests need to be handled by the application. */
	CyU3PUsbRegisterSetupCallback(CyFxSlFifoApplnUSBSetupCB, CyTrue);

	/* Setup the callback to handle the USB events. */
	CyU3PUsbRegisterEventCallback(CyFxSlFifoApplnUSBEventCB);

	/* Register a callback to handle LPM requests from the USB 3.0 host. */
	CyU3PUsbRegisterLPMRequestCallback(CyFxApplnLPMRqtCB);

	/* Set the USB Enumeration descriptors */

	/* Super speed device descriptor. */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_SS_DEVICE_DESCR, NULL, (uint8_t *)CyFxUSB30DeviceDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set device descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* High speed device descriptor. */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_HS_DEVICE_DESCR, NULL, (uint8_t *)CyFxUSB20DeviceDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set device descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* BOS descriptor */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_SS_BOS_DESCR, NULL, (uint8_t *)CyFxUSBBOSDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set configuration descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* Device qualifier descriptor */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_DEVQUAL_DESCR, NULL, (uint8_t *)CyFxUSBDeviceQualDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set device qualifier descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* Super speed configuration descriptor */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_SS_CONFIG_DESCR, NULL, (uint8_t *)CyFxUSBSSConfigDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set configuration descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* High speed configuration descriptor */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_HS_CONFIG_DESCR, NULL, (uint8_t *)CyFxUSBHSConfigDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB Set Other Speed Descriptor failed, Error Code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* Full speed configuration descriptor */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_FS_CONFIG_DESCR, NULL, (uint8_t *)CyFxUSBFSConfigDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB Set Configuration Descriptor failed, Error Code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* String descriptor 0 */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_STRING_DESCR, 0, (uint8_t *)CyFxUSBStringLangIDDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set string descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* String descriptor 1 */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_STRING_DESCR, 1, (uint8_t *)CyFxUSBManufactureDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set string descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* String descriptor 2 */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_STRING_DESCR, 2, (uint8_t *)CyFxUSBProductDscr);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set string descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* String descriptor 3 */
	apiRetStatus = CyU3PUsbSetDesc(CY_U3P_USB_SET_STRING_DESCR, 3, (uint8_t *)CyFxUSBSerialNumDesc);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB set string descriptor failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	/* Connect the USB Pins with super speed operation enabled. */
	apiRetStatus = CyU3PConnectState(CyTrue, CyTrue);
	if (apiRetStatus != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "USB Connect failed, Error code = %d\n", apiRetStatus);
#endif
		CyFxAppErrorHandler(apiRetStatus);
	}

	//CyU3PUsbLPMDisable();
	 glApplnMode = MODE_SLFIFO_CONFIG;
}

/*
 * Main function
 */
int
main (void)
{

	CyU3PIoMatrixConfig_t io_cfg;
	CyU3PReturnStatus_t status = CY_U3P_SUCCESS;
	CyU3PSysClockConfig_t clkCfg;

		/* setSysClk400 clock configurations */
		clkCfg.setSysClk400 = CyTrue;   /* FX3 device's master clock is set to a frequency > 400 MHz */
		clkCfg.cpuClkDiv = 2;           /* CPU clock divider */
		clkCfg.dmaClkDiv = 2;           /* DMA clock divider */
		clkCfg.mmioClkDiv = 2;          /* MMIO clock divider */
		clkCfg.useStandbyClk = CyFalse; /* device has no 32KHz clock supplied */
		clkCfg.clkSrc = CY_U3P_SYS_CLK; /* Clock source for a peripheral block  */

	/* Initialize the device */
	status = CyU3PDeviceInit (&clkCfg);
	if (status != CY_U3P_SUCCESS)
	{
		goto handle_fatal_error;
	}

	/* Initialize the caches. Enable instruction cache and keep data cache disabled.
	 * The data cache is useful only when there is a large amount of CPU based memory
	 * accesses. When used in simple cases, it can decrease performance due to large
	 * number of cache flushes and cleans and also it adds to the complexity of the
	 * code. */
	status = CyU3PDeviceCacheControl (CyTrue, CyTrue, CyTrue);
	if (status != CY_U3P_SUCCESS)
	{
		goto handle_fatal_error;
	}

	/* Configure the IO matrix for the device. On the FX3 DVK board, the COM port
	 * is connected to the IO(53:56). This means that either DQ32 mode should be
	 * selected or lppMode should be set to UART_ONLY. Here we are choosing
	 * UART_ONLY configuration for 16 bit slave FIFO configuration and setting
	 * isDQ32Bit for 32-bit slave FIFO configuration. */

	CyU3PMemSet ((uint8_t *)&io_cfg, 0, sizeof(io_cfg));
	io_cfg.s0Mode = CY_U3P_SPORT_INACTIVE;
	io_cfg.s1Mode = CY_U3P_SPORT_INACTIVE;

#ifdef UART_ENABLE
	io_cfg.useUart   = CyTrue;
#else
	io_cfg.useUart   = CyFalse;
#endif

	io_cfg.useI2C    = CyTrue;
	io_cfg.useI2S    = CyFalse;
	io_cfg.useSpi   = CyFalse;
	io_cfg.isDQ32Bit = CyTrue;
	io_cfg.lppMode   = CY_U3P_IO_MATRIX_LPP_DEFAULT;
	/* GPIO's are enabled. */
	io_cfg.gpioSimpleEn[0]  = 0;

	//io_cfg.gpioSimpleEn[1]  = 0x001C0000; /* GPIO 52,51,50 - For FPGA Configuration*/
#ifdef SPI_ENABLE
	io_cfg.gpioSimpleEn[1]  = 0x01FC0000; /* GPIO 50,51,52 - i/p; SPI - GPIO 53,54,55,56; (BitBanged JTAG -GPIO 57,52,51,50 = 0x021C0000;) - Not Added*/
#else
	io_cfg.gpioSimpleEn[1] = 0x001C0000;	/* GPIO 52,51,50 - For FPGA Configuration*/ /* GPIO 50,51,52 - without spi signals ; because uart is using it*/
#endif
	io_cfg.gpioComplexEn[0] = 0;
	io_cfg.gpioComplexEn[1] = 0;
	status = CyU3PDeviceConfigureIOMatrix (&io_cfg);
	if (status != CY_U3P_SUCCESS)
	{
		goto handle_fatal_error;
	}

	/* This is a non returnable call for initializing the RTOS kernel */
	CyU3PKernelEntry ();

	/* Dummy return to make the compiler happy */
	return 0;

handle_fatal_error:

	/* Cannot recover from this error. */
	while (1);
}
