/*
 * cyfxconfigfpga.h
 *
 *  Created on: Sep 18, 2014
 *      Author: Gokul Prasath Nallasamy
 */

#ifndef CYFXCONFIGFPGA_H_
#define CYFXCONFIGFPGA_H_

/*This file contains the constants and definitions used by configfpga.c*/

#define GPIO_nSTATUS    							52
#define GPIO_nCONFIG    							51
#define GPIO_CONFDONE   							50

//Vendor command code used in FPGA slave serial application
#define FPGA_FW_LOAD 								0xB2
#define FPGA_FW_STATUS 								0xB1

#define CY_FX_FW_LD_DMA_BUF_COUNT      				(4)   /* Slave FIFO channel U to CPU buffer count */
#define CONFIG_FPGA_DMA_BUF_SIZE					(16)

//Events
/* event to initiate FPGA configuration */
#define CY_FX_CONFIGFPGAAPP_START_EVENT    			(1 << 0)
/* event to initiate switch back to slave FIFO*/
#define CY_FX_CONFIGFPGAAPP_SW_TO_SLFIFO_EVENT     	(1 << 1)




extern CyU3PDmaChannel glChHandleUtoCPU;   		/* DMA Channel handle for U2CPU transfer. */

extern CyBool_t glConfigDone;					/* Flag to indicate the status of FPGA configuration */

extern uint32_t filelen;						/* length of Configuration file (.bin) */

extern uint16_t uiPacketSize;

extern CyBool_t glIsApplnActive;				/*Application active for access or busy with switching*/

extern uint32_t glApplnMode;					/*Firmware working mode*/

extern CyU3PEvent glFxConfigFpgaAppEvent;    		/* Configure FPGA event group. */

extern uint8_t *seqnum_slfifo;					/*	Extern sequence Number */



extern void
CyFxAppErrorHandler (
        CyU3PReturnStatus_t apiRetStatus    		/* API return status */
        );

extern CyBool_t
CyFxSlFifoApplnUSBSetupCB (
        uint32_t setupdat0,
        uint32_t setupdat1
    );

extern void
CyFxSlFifoApplnUSBEventCB (
    CyU3PUsbEventType_t evtype,
    uint16_t            evdata
    );

extern void
CyFxApplnLPMSuspend(CyBool_t set_allow_suspend);

extern CyBool_t
CyFxApplnLPMRqtCB (CyU3PUsbLinkPowerMode link_mode);

extern void
CyFxConfigFpgaApplnStart (void);

extern void
CyFxUsbInit (void);

extern void
CyFxConfigFpgaApplnInit (void);

extern CyU3PReturnStatus_t
CyFxConfigFpgaStart(uint32_t uiLen);

extern CyU3PReturnStatus_t
CyFxGpioInitialization();

extern CyU3PReturnStatus_t
CyFxSlFifoGpioReConfig (void);

extern void
CyFxConfigFpgaApplnStop (void);

extern void
CyFxSlFifoApplnDebugInit (void);

extern void
CyFxApplnI2CInit (void);

extern void
CyFxSlFifoApplnInit (void);

#endif /* CYFXCONFIGFPGA_H_ */
