/*
 * cyfxslfifogpifreconfig.c
 *
 *  Created on: Sep 17, 2014
 *      Author: Gokul Prasath Nallasamy
 */

#include <cyu3error.h>
#include <cyu3gpif.h>
#include <cyu3pib.h>
#include "cyfxslfifogpifreconfig.h"
#include "cyfxslfifosync.h"

/* These generated headers contain declarations,
 * and must be included in only once in the firmware
 * as it contains structure definitions. Including it
 * in multiple places can result in linker error.
*/

#include "cyfxgpif2config.h"	//Sync Slave FIFO Interface GPIF II header file
#include "cyfxfpgagpif2config.h"	//FPGA FPP FW Load GPIF II header file



CyU3PReturnStatus_t Fx3_Gpif_Configure(Fx3_Gpif_Config Gpif_Config)
{
    CyU3PReturnStatus_t status;
    CyU3PPibClock_t pibClock;
    const CyU3PGpifConfig_t *gpif_config;
    uint8_t gpif_state_index;
    uint8_t gpif_initial_alpha;

    static CyBool_t gpif_active = CyFalse;
    static CyBool_t pib_active = CyFalse;

    /* Restart the GPIF and PIB block for safe measure.
     *
     * Previously, a bug had been observed where 16-bit to 32-bit GPIF
     * transitions messes up the first DMA transaction, requiring these
     * resets. */

    if (gpif_active)
    {
        CyU3PGpifDisable(CyTrue);
        gpif_active = CyFalse;
    }

    if (pib_active)
    {
        status = CyU3PPibDeInit();
        if (status != CY_U3P_SUCCESS)
        {
            return status;
        }
        pib_active = CyFalse;
    }

    switch (Gpif_Config) {
        case GPIF_CONFIG_SlFIFO:
            gpif_config = &SlfifoCyFxGpifConfig;
            gpif_state_index = SLFIFO_RESET;
            gpif_initial_alpha = SLFIFO_ALPHA_RESET;
#ifdef UART_ENABLE
            CyU3PDebugPrint (4, "GPIF = Slave FIFO\n");
#endif
            break;

        case GPIF_CONFIG_FPGA_FW_LOAD:
            gpif_config = &FPGA_FW_LOAD_CyFxGpifConfig;
            gpif_state_index = FPGA_FW_LOAD_START;
            gpif_initial_alpha = FPGA_FW_LOAD_ALPHA_START;
#ifdef UART_ENABLE
            CyU3PDebugPrint (4, "GPIF = FPGA Fw Load\n");
#endif
            break;

        case GPIF_CONFIG_DISABLED:
            /* No GPIF Configuration to set*/
            return CY_U3P_SUCCESS;

        default:
            return CY_U3P_ERROR_BAD_ARGUMENT;
    }

    /* Initialize the p-port block. */
	pibClock.clkDiv = 2;
	pibClock.clkSrc = CY_U3P_SYS_CLK;
	pibClock.isHalfDiv = CyFalse;
	/* Disable DLL for sync GPIF */
	pibClock.isDllEnable = CyFalse;

	status = CyU3PPibInit(CyTrue, &pibClock);
	if (status != CY_U3P_SUCCESS)
	{
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "Pib initialization failed\n");
#endif
		//CyFxAppErrorHandler(status);
		return status;
	}
    pib_active = CyTrue;

    /* Load the GPIF configuration */
    status = CyU3PGpifLoad(gpif_config);
    if (status != CY_U3P_SUCCESS)
    {
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "GPIF load failed\n");
#endif
        return status;
    }
    if(Gpif_Config == GPIF_CONFIG_SlFIFO)
    {
    	CyU3PGpifSocketConfigure (0,CY_U3P_PIB_SOCKET_0,10,CyFalse,1);	//working code for RevD is 10 - Gokul

    	CyU3PGpifSocketConfigure (3,CY_U3P_PIB_SOCKET_3,6,CyFalse,1);	//RevB- 7 working; For RevD - 6 - Gokul
    }
    else if(Gpif_Config == GPIF_CONFIG_FPGA_FW_LOAD)
    {
    	CyU3PGpifSocketConfigure (3,CY_FX_FPGA_CONFIG_CONSUMER_SOCKET,7,CyFalse,1);
    }
    gpif_active = CyTrue;

    /* Start the state machine. */
    status = CyU3PGpifSMStart (gpif_state_index,gpif_initial_alpha);
    if (status != CY_U3P_SUCCESS)
    {
#ifdef UART_ENABLE
		CyU3PDebugPrint (4, "GPIF SM Start failed\n");
#endif
        return status;
    }

    return CY_U3P_SUCCESS;
}
