/*
 ## USB 3.0 Platform header file (cyfxslfifosync.h)
 ## =========================================
 ##
 ##	 Soliton Technologies Private Limited
 ##	 Interface Between J56 and PC
 ##
 ##  Designer :- Gokul Prasath Nallasamy
 ##
 ##
 ## =========================================
*/

/* This file contains the constants and definitions used by the SPI Flash and Sync Slave FIFO Functions*/

#ifndef _INCLUDED_CYFXSLFIFOASYNC_H_
#define _INCLUDED_CYFXSLFIFOASYNC_H_

#include "cyu3externcstart.h"
#include "cyu3types.h"
#include "cyu3usbconst.h"

/* 16/32 bit GPIF Configuration select */
/* Set CY_FX_SLFIFO_GPIF_16_32BIT_CONF_SELECT = 0 for 16 bit GPIF data bus.
 * Set CY_FX_SLFIFO_GPIF_16_32BIT_CONF_SELECT = 1 for 32 bit GPIF data bus.
 */

/*
 * size of the control transfer buffer configured to 16384 bytes;
 * Maximum compiled: 22732 bytes, but did not tried with this because of giving some space for controller
 * Modified on: 29 Oct 2016
 */

#define CTRL_XFER_BUF_LEN						(16384)

/* USB vendor request to RESET the FX3.
 * Calling this vendor command will Cold Reset the FX3 */
#define CY_FX_COLD_RESET                     	(0xA8)

/**************************  UART/SPI Selection ***************************/

//#define UART_ENABLE		//Uncomment it when UART is needed, Don't forget to comment SPI - Gokul Prasath N
#define SPI_ENABLE			//Comment it when UART is needed - Gokul Prasath N

/**************************************************************************/

//---------------------SPI part------------------------------------------------------------
#ifdef SPI_ENABLE

/* NOTE:
 * By default this code makes use of the GPIO SDK APIs to access the GPIO functionality.
 * If direct GPIO register access is desired then FX3_USE_GPIO_REGS has to be defined.
 * */
/*
#define FX3_USE_GPIO_REGS
*/

/* GPIO Ids used to control the SPI flash */
#define FX3_SPI_CLK             (53) /* GPIO Id 53 will be used for providing SPI Clock */
#define FX3_SPI_SS              (54) /* GPIO Id 54 will be used as slave select line */
#define FX3_SPI_MISO            (55) /* GPIO Id 55 will be used as MISO line */
#define FX3_SPI_MOSI            (56) /* GPIO Id 56 will be used as MOSI line */
#define FX3_SPI_PAGE_SIZE		0x100	/*Each Page size is 256 Bytes*/

/********************************For TI User Only***************************/
#define DISABLE_SERIAL_NUMBER_PROTECTION		(0xD0)
#define WRITE_SERIAL_NUMBER_AND_PROTECT			(0xD1)
#define WRITE_FPGA_BOARD_NAME					(0xD2)

/* TODO: Change Serial Number Location Accordingly */
#define fpga_board_name_addr					(0x7FE) /*Last sector and last before page memory in SPI Flash*/
#define fpga_board_name_byte_count				(16)	 	/*64bit = 8bytes serial number*/
#define fpga_serial_number_addr					(0x7FF)	/*Last sector and Last Page Memory in SPI Flash(Each Page =  256bytes)*/
#define fpga_serial_number_byte_count			(16)	 	/*64bit = 8bytes serial number*/
/***************************************************************************/

/*USB vendor request to Read the Serial Number of FPGA written to the SPI Flash
 * Predefined memory location of 0xFF00. Memory location needs to be handled properly
 * and the Serial Number should be written during the firmware loading into Flash
 */

//Read FPGA Board Name
#define READ_FPGA_BOARD_NAME					(0xE0)

//Read FPGA S.No.
#define READ_FPGA_SERIAL_NUMBER					(0xE1)

/* USB vendor request to write data to SPI flash connected. The flash page size is
 * fixed to 256 bytes. The memory address to start the write is provided in the
 * index field of the request. The maximum allowed request length is 4KB. */
#define CY_FX_RQT_SPI_FLASH_WRITE               (0xC2)

/* USB vendor request to read data from SPI flash connected. The flash page size is
 * fixed to 256 bytes. The memory address to start the read is provided in the index
 * field of the request. The maximum allowed request length is 4KB. */
#define CY_FX_RQT_SPI_FLASH_READ                (0xC3)

/* USB vendor request to erase a sector on SPI flash connected. The flash sector
 * size is fixed to 64KB. The sector address is provided in the index field of
 * the request. The erase is carried out if the value field is non-zero. If this
 * is zero, then the request returns the write in progress (WIP) bit. WIP should
 * be 0 before issuing any further transactions. */
#define CY_FX_RQT_SPI_FLASH_ERASE_POLL          (0xC4)

/* USB vendor request to erase all sectors(Bulk Erase) on SPI flash connected.
 *The erase is carried out if the value field is non-zero. If this
 * is zero, then the request returns the write in progress (WIP) bit. WIP should
 * be 0 before issuing any further transactions. */
#define CY_FX_RQT_SPI_FLASH_BULK_ERASE          (0xC5)

#endif
//-------------------------------------------------------------------------------------------
#define CY_FX_SLFIFO_GPIF_16_32BIT_CONF_SELECT (1)
/* set up DMA channel for loopback/short packet/ZLP transfers */
//#define LOOPBACK_SHRT_ZLP
/* set up DMA channel for stream IN/OUT transfers */
#define STREAM_IN_OUT

//#define USB_2_0

#ifdef LOOPBACK_SHRT_ZLP
#define DMA_BUF_SIZE						  (1)
#define CY_FX_SLFIFO_DMA_BUF_COUNT_P_2_U      (2)                       /* Slave FIFO P_2_U channel buffer count */
#define CY_FX_SLFIFO_DMA_BUF_COUNT_U_2_P 	  (2)						/* Slave FIFO U_2_P channel buffer count */
#endif

#ifdef STREAM_IN_OUT
#define DMA_BUF_SIZE						 (16)
/* Slave FIFO P_2_U channel buffer count */
#define CY_FX_SLFIFO_DMA_BUF_COUNT_P_2_U      (8)		//(8) changed to 7
/* Slave FIFO U_2_P channel buffer count */
#define CY_FX_SLFIFO_DMA_BUF_COUNT_U_2_P 	  (4)
#endif

#define CY_FX_SLFIFO_DMA_TX_SIZE        (0)	                  /* DMA transfer size is set to infinite */
#define CY_FX_SLFIFO_DMA_RX_SIZE        (0)	                  /* DMA transfer size is set to infinite */
#define CY_FX_SLFIFO_THREAD_STACK       (0x0400)                  /* Slave FIFO application thread stack size */
#define CY_FX_SLFIFO_THREAD_PRIORITY    (8)                       /* Slave FIFO application thread priority */

/* Endpoint and socket definitions for the Slave FIFO application */

/* To change the Producer and Consumer EP enter the appropriate EP numbers for the #defines.
 * In the case of IN endpoints enter EP number along with the direction bit.
 * For eg. EP 6 IN endpoint is 0x86
 *     and EP 6 OUT endpoint is 0x06.
 * To change sockets mention the appropriate socket number in the #defines. */

/* Note: For USB 2.0 the endpoints and corresponding sockets are one-to-one mapped
         i.e. EP 1 is mapped to UIB socket 1 and EP 2 to socket 2 so on */

#define CY_FX_EP_PRODUCER               0x01    /* EP 1 OUT */
#define CY_FX_EP_CONSUMER               0x81    /* EP 1 IN */

#define CY_FX_PRODUCER_USB_SOCKET    CY_U3P_UIB_SOCKET_PROD_1    /* USB Socket 1 is producer */
#define CY_FX_CONSUMER_USB_SOCKET    CY_U3P_UIB_SOCKET_CONS_1    /* USB Socket 1 is consumer */


/* Used with FX3 Silicon. */
#define CY_FX_PRODUCER_PPORT_SOCKET    CY_U3P_PIB_SOCKET_0    /* P-port Socket 0 is producer */
#define CY_FX_CONSUMER_PPORT_SOCKET    CY_U3P_PIB_SOCKET_3    /* P-port Socket 3 is consumer */

#ifdef STREAM_IN_OUT
#ifdef USB_2_0
#define BURST_LEN 		1  		//for USB2.0
#else
#define BURST_LEN 		16 		//for USB3.0
#endif
#endif
#ifdef LOOPBACK_SHRT_ZLP
#define BURST_LEN 1
#endif

//--------------------------- Firmware Modes  --------------------------
#define MODE_NO_CONFIG   		(0)
#define MODE_FPGA_CONFIG 		(1)
#define MODE_SLFIFO_CONFIG   	(2)

//------------------------------------------------------------------------

/* Extern definitions for the USB Descriptors */
extern const uint8_t CyFxUSB20DeviceDscr[];
extern const uint8_t CyFxUSB30DeviceDscr[];
extern const uint8_t CyFxUSBDeviceQualDscr[];
extern const uint8_t CyFxUSBFSConfigDscr[];
extern const uint8_t CyFxUSBHSConfigDscr[];
extern const uint8_t CyFxUSBBOSDscr[];
extern const uint8_t CyFxUSBSSConfigDscr[];
extern const uint8_t CyFxUSBStringLangIDDscr[];
extern const uint8_t CyFxUSBManufactureDscr[];
extern const uint8_t CyFxUSBProductDscr[];
extern const uint8_t CyFxUSBSerialNumDesc[];

#include "cyu3externcend.h"

#endif /* _INCLUDED_CYFXSLFIFOASYNC_H_ */

/*[]*/
