/*
 ## USB 3.0 Platform header file (fx3_i2c_reg_mode.h)
 ## =========================================
 ##
 ##	 Soliton Technologies Private Limited
 ##	 Interface Between J56 and PC
 ##
 ##  Designer :- Gokul Prasath Nallasamy
 ##
 ##
 ## =========================================
*/

/* This file contains the definitions and constants used by I2C Register Write Functions */

#ifndef _INCLUDED_FX3_I2C_REGMODE_H_
#define _INCLUDED_FX3_I2C_REGMODE_H_

#include "cyu3types.h"
#include "cyu3usbconst.h"

/* This application uses EEPROM as the slave I2C device. The I2C EEPROM
 * part number used is 24LC256. The capacity of the EEPROM is 256K bits */
#define CY_FX_USBI2C_I2C_MAX_CAPACITY   (32 * 1024) /* Capacity in bytes */

/* The following constant is defined based on the page size that the I2C
 * device support. 24LC256 support 2 (64) byte page write access. */
#define CY_FX_USBI2C_I2C_PAGE_SIZE      (2)		//(64)

/* I2C Data rate */
#define CY_FX_USBI2C_I2C_BITRATE        (1000000)

/* Give a timeout value of 5s for any programming. */
#define CY_FX_USB_I2C_TIMEOUT                (5000)

/* USB vendor requests supported by the application. */

/* USB vendor request to read the 8 byte firmware ID. This will return content
 * of glFirmwareID array. */
#define CY_FX_RQT_ID_CHECK                      (0xB0)

/* USB vendor request to read the 8 byte Unique FX3 Die ID. This will return content
 * of Unique ID in Register Address 0xE0055010. */
#define CY_FX_UNIQUE_ID                      	(0xC0)

/* USB vendor request to write to I2C EEPROM connected. The EEPROM page size is
 * fixed to 64 bytes. The I2C EEPROM address is provided in the value field. The
 * memory address to start writing is provided in the index field of the request.
 * The maximum allowed request length is 4KB. */
#define CY_FX_RQT_I2C_WRITE              (0xBA)

/* USB vendor request to read from I2C EEPROM connected. The EEPROM page size is
 * fixed to 64 bytes. The I2C EEPROM address is provided in the value field. The
 * memory address to start reading from is provided in the index field of the
 * request. The maximum allowed request length is 4KB. */
#define CY_FX_RQT_I2C_READ               (0xBB)

#define Bit_Banged_Write               (0xAA)


#endif /* _INCLUDED_FX3_I2C_REGMODE_H_ */

/*[]*/
