import json 
import os

class JMODE():
    def __init__(self, entry):
        self.description = str(entry["description"])
        self.jmode = int(entry["JMODE"])
        self.kmin = int(entry["K"]["Kmin"])
        self.kmax = int(entry["K"]["Kmax"])+1
        self.kstep = int(entry["K"]["Kstep"])
        self.k = list(range(self.kmin, self.kmax, self.kstep))
        self.encoding = str(entry["Encoding"])
        self.n = int(entry["N"])
        self.nprime = int(entry["N'"])
        self.l = int(entry["L"])
        self.m = int(entry["M"])
        self.f = int(entry["F"])
        self.s = int(entry["S"])
        self.hd = int(entry["HD"])
        self.r = float(entry["R"])
        self.clock_range_min = float(entry["Input Clock range min"])
        self.clock_range_max = float(entry["Input Clock range max"])

    def __str__(self):
        out = f"JMODE {self.jmode}\n"
        out = out + f"Description: {self.description}\n"
        out = out + f"Kmin {self.kmin}, Kmax {self.kmax}, Kstep {self.kstep}\n"
        out = out + f"Encoding: {self.encoding}\n"
        out = out + f"Resolution: {self.n}\n"
        out = out + f"Nprime: {self.nprime}\n"
        out = out + f"Lanes: {self.l}\n"
        out = out + f"Channels: {self.m}\n"
        out = out + f"Frame Octets: {self.f}\n"
        out = out + f"Samples Per Frame: {self.s}\n"
        out = out + f"HD Mode: {self.hd}\n"
        out = out + f"R: {self.r}\n"
        out = out + f"Input clock range min: {self.clock_range_min}\n"
        out = out + f"Input clock range max: {self.clock_range_max}\n"
        return out        

class ADC12QJ1600_JMODE():
    def __init__(self):
        self.sub_dir = os.path.dirname(os.path.abspath(__file__))
        self.jmode_file_path = os.path.join(self.sub_dir, 'jmode_table.json')
        
    def set_jmode_table(self):
        with open(self.jmode_file_path) as json_file:
            adc1600_jmode_table = json.load(json_file)
            jmode_table = {}
            for key, val in adc1600_jmode_table.items():
                jmode_table[int(key)] = JMODE(val)

            return jmode_table