import adc12qj1600_api
from ftd2xx_controller import ftd2xxController as ftd

jmode = 8
sampling_frequnecy = 1000e6
adc_ref_clock = 50e6
serial_number = "FT4HO0AH"

try:
    ADC_FTDI = ftd.open_FT(serial_number, "A")
    # LMK_FTDI = ftd.open_FT(serial_number, "A")

    ADC0_SPI = ADC_FTDI.init_SPI(sclk=0, csb = 2, mosi=1, miso=4, addr_bits=15, data_bits=8)
    ADC1_SPI = ADC_FTDI.init_SPI(sclk=0, csb = 3, mosi=1, miso=4, addr_bits=15,data_bits=8)

except RuntimeError as err:
            print(f"Error: {err}, Check the deivce is plugged in, turned on and the serial number is correct in the script")
            raise SystemExit()


adc0 = adc12qj1600_api.ADC12QJ1600(device_name="ADC12QJ1600", sampling_frequency=sampling_frequnecy, spi_interface=ADC0_SPI)
adc1 = adc12qj1600_api.ADC12QJ1600(device_name="ADC12QJ1600", sampling_frequency=sampling_frequnecy, spi_interface=ADC1_SPI)

adc0.device_reset()
adc0.configure_cpll(ref_clock_source="SE") 
adc0.configure_trigout_fpga_ref(refclk_ratio=64)
adc0.configure_clock_noise_supression()
adc0.configure_jesd(jmode=jmode, k=4)
adc0.toggle_software_cal()


adc1.device_reset()
adc1.configure_cpll(ref_clock_source="SE") 
adc1.configure_trigout_fpga_ref(refclk_ratio=64)
adc1.configure_clock_noise_supression()
adc1.configure_jesd(jmode=jmode, k=4)
adc1.toggle_software_cal()

print("Done")