#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include "inc/tm4c123gh6pz.h"
#include "inc/hw_memmap.h"
#include "inc/hw_ssi.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "driverlib/ssi.h"
#include "utils/uartstdio.h"
#include "ads1292r.h"


ads1292r ADS1292;

/*
void printBin(char num){
	volatile uint8_t ch[8];
	volatile int i = 0, j;
	for(i=0; i<8; i++) ch[i] = 0;
	i=0;
	do{
		ch[i] = num % 2;
		num /= 2;
		i++;
		delay(10);
	} while(i<8);
	i=0;
	for(j = 7; j>=0; j--){
		UARTCharPut(UART2_BASE, ch[j] + '0');
	}
}


void print( char ch[]){
	int i;
	for(i=0; i< strlen(ch); i++){
		UARTCharPut(UART2_BASE, ch[i]);
	}
}

*/
void Delay(void){
  unsigned long i;
  i = 1333333;  // this number means 100ms
  while(i > 0){
    i = i - 1;
  }
}

void configureGPIOA(){
	GPIO_PORTA_PCTL_R = 0x00;
}



void unlockPortD(){
	GPIO_PORTD_LOCK_R = 0x4C4F434B;
	GPIO_PORTD_CR_R = 0xFF;
}

void UART_init(){
	
	SysCtlPeripheralEnable(SYSCTL_PERIPH_UART2);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
	
	while(!SysCtlPeripheralReady(SYSCTL_PERIPH_UART2)){}
			
	unlockPortD();
			
	GPIOPinConfigure(GPIO_PD6_U2RX);
	GPIOPinConfigure(GPIO_PD7_U2TX);
			
	GPIOPinTypeUART(GPIO_PORTD_BASE, GPIO_PIN_6|GPIO_PIN_7);
			
	//UARTConfigSetExpClk(UART2_BASE, SysCtlClockGet(), 115200,
     //  (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
		
	UARTStdioInit(2);
		
}

void SSI0_init(){
	
	SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI0);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
	
	GPIOPinConfigure(GPIO_PA2_SSI0CLK);
	GPIOPinConfigure(GPIO_PA4_SSI0RX);
	GPIOPinConfigure(GPIO_PA5_SSI0TX);
	configureGPIOA(); // sets the port A pins 0 and 1 to non-alternate function
	
	GPIOPinTypeSSI(GPIO_PORTA_BASE,GPIO_PIN_5|GPIO_PIN_4|GPIO_PIN_2);
	GPIOPinTypeGPIOInput(GPIO_PORTA_BASE, GPIO_PIN_1);	//DRDY
	GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_0);	//CS
	GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_6);	//PWDN
	// CPOL = 0, CPHA = 1 --> SSI_FRF_MOTO_MODE_1
	SSIConfigSetExpClk(SSI0_BASE, SysCtlClockGet(), SSI_FRF_MOTO_MODE_1, SSI_MODE_MASTER, 1000000, 8);
	SSIEnable(SSI0_BASE);
	
}

/*
void portEInit(){
	SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
	GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_2);
	GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_2, 0x00);
}
*/


int main(void) {
		
		SysCtlClockSet(SYSCTL_SYSDIV_2_5|SYSCTL_USE_PLL|SYSCTL_OSC_MAIN|SYSCTL_XTAL_16MHZ);
		
		UART_init();
		SSI0_init();
		ADS1292.ads1292_Init();
	
		char readData;

		// Trying to read the WHOAMI (ID) register:
		readData = ADS1292.ads1292_Reg_Read(ADS1292_REG_ID);
		UARTprintf("WHOAMI REGISTAR %d\n", readData & 0xFF);
		
		while(1){
			char *SPIDataPtr;
			volatile uint32_t status, ecg, respiration;
			char SPIbuffer[10];
			volatile uint32_t data = 0;
			
			// if DRDY pin is low, then read data
			if(GPIOPinRead(GPIO_PORTA_BASE, GPIO_PIN_1) == 0x00){			
					SPIDataPtr = ADS1292.ads1292_Read_Data();
				
					for(int i = 0; i < 9; i++){
						SPIbuffer[i] = *(SPIDataPtr + i);
						//UARTprintf("%d ", SPIbuffer[i]);
					}
					status = SPIbuffer[0] * 256 * 256 + SPIbuffer[1] * 256 + SPIbuffer[2];  
					ecg = SPIbuffer[3] * 256 * 256 + SPIbuffer[4] * 256 + SPIbuffer[5];
					respiration = SPIbuffer[6] * 256 * 256 + SPIbuffer[7] * 256 + SPIbuffer[8];
					
					UARTprintf("%d %d %d\n", status & 0xFFFFFF, ecg & 0xFFFFFF, respiration & 0xFFFFFF); // print the 24 bit data
				}
			}
}





//FORMER VERSION
/*
					for(int i = 0; i < 3 ; i++){
						data = data << 8;
						data |= (uint32_t) SPIbuffer[i];
						
					}
					//UARTprintf("%d ", data);
					data = (unsigned int) data << 8;
					//UARTprintf("%d ", data);
					data = (signed int) data;
					data = (signed int)data >> 8;
					//printBin(data);
					//UARTprintf("%d ", data);
					
					data = 0;
					for(int i = 3; i < 6 ; i++){
						data = data << 8;
						data |= (uint32_t) SPIbuffer[i];
					}
					data = (unsigned int) data << 8;
					data = (signed int) data;
					data = (signed int)data >> 8;
					//printBin(data);
					//UARTprintf("%d ", data);
					
					data = 0;
					for(int i = 6; i < 9 ; i++){
						data = data << 8;
						data |= (uint32_t) SPIbuffer[i];
					}
					data = (unsigned int) data << 8;
					data = (signed int) data;
					data = (signed int)data >> 8;
					//printBin(data);
					//UARTprintf("%d", data);
					UARTCharPut(UART2_BASE, '\r');
					UARTCharPut(UART2_BASE, '\n');
					
}

}
*/
