#include <stdint.h>
#include <stdbool.h>
#include "inc/tm4c123gh6pz.h"
#include "inc/hw_memmap.h"
#include "inc/hw_ssi.h"
#include "inc/hw_types.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
#include "driverlib/ssi.h"

// Bit-wise reverses a number.


uint8_t Reverse(uint8_t ui8Number)
{
	uint8_t ui8Index;
	uint8_t ui8ReversedNumber = 0;
	for(ui8Index=0; ui8Index<8; ui8Index++)
	{
		ui8ReversedNumber = ui8ReversedNumber << 1;
		ui8ReversedNumber |= ((1 << ui8Index) & ui8Number) >> ui8Index;
	}
	return ui8ReversedNumber;
}


void Delay(void){
  unsigned long i;
  i = 1333333;  // this number means 100ms
  while(i > 0){
    i = i - 1;
  }
}

void unlockPortD(){
	GPIO_PORTD_LOCK_R = 0x4C4F434B;
	GPIO_PORTD_CR_R = 0xFFFFFFFF;
}

int main(void) {

		uint32_t *pui32Data;
		//uint8_t data;
		
		SysCtlClockSet(SYSCTL_SYSDIV_2_5|SYSCTL_USE_PLL|SYSCTL_OSC_MAIN|SYSCTL_XTAL_16MHZ);
		
		
		SysCtlPeripheralEnable(SYSCTL_PERIPH_SSI0);
		SysCtlPeripheralReset(SYSCTL_PERIPH_SSI0);
		SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART2);
		SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOD);
		SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOE);
	
		while(!SysCtlPeripheralReady(SYSCTL_PERIPH_UART2)){}
		
		unlockPortD();
		
		
		GPIOPinConfigure(GPIO_PA2_SSI0CLK);
		GPIOPinConfigure(GPIO_PA3_SSI0FSS);
		GPIOPinConfigure(GPIO_PA4_SSI0RX);
		GPIOPinConfigure(GPIO_PA5_SSI0TX);
    GPIOPinConfigure(GPIO_PD6_U2RX);
		GPIOPinConfigure(GPIO_PD7_U2TX);
		
		GPIOPinTypeGPIOInput(GPIO_PORTA_BASE, GPIO_PIN_1);	//DRDY
		GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_0);	//CS
		GPIOPinTypeSSI(GPIO_PORTA_BASE,GPIO_PIN_5|GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2);
    GPIOPinTypeUART(GPIO_PORTD_BASE, GPIO_PIN_6|GPIO_PIN_7);
		GPIOPinTypeGPIOOutput(GPIO_PORTE_BASE, GPIO_PIN_2|GPIO_PIN_3);
		
		SSIDisable(SSI0_BASE);
		SSIClockSourceSet(SSI0_BASE, SSI_CLOCK_SYSTEM);
			
    UARTConfigSetExpClk(UART2_BASE, SysCtlClockGet(), 115200,
        (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
		SSIConfigSetExpClk(SSI0_BASE, SysCtlClockGet(), SSI_FRF_MOTO_MODE_0, SSI_MODE_MASTER, 1000000, 8); //500SPS * 24 = 12000
		
		SSIIntDisable(SSI0_BASE,SSI_TXFF | SSI_RXFF | SSI_RXOR | SSI_RXTO);
		SSIEnable(SSI0_BASE);
			
    UARTCharPut(UART2_BASE, 'E');
    UARTCharPut(UART2_BASE, 'n');
    UARTCharPut(UART2_BASE, 't');
    UARTCharPut(UART2_BASE, 'e');
    UARTCharPut(UART2_BASE, 'r');
    UARTCharPut(UART2_BASE, ' ');
    UARTCharPut(UART2_BASE, 'T');
    UARTCharPut(UART2_BASE, 'e');
    UARTCharPut(UART2_BASE, 'x');
    UARTCharPut(UART2_BASE, 't');
    UARTCharPut(UART2_BASE, ':');
    UARTCharPut(UART2_BASE, ' ');
		UARTCharPut(UART2_BASE, '\r');
		UARTCharPut(UART2_BASE, '\n');
		
		GPIOPinWrite(GPIO_PORTE_BASE, GPIO_PIN_2|GPIO_PIN_3, 0xFF);
		
		//CS bit low
		GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_0, GPIO_PIN_0);
		Delay();
		SSIDataPut(SSI0_BASE, 0x08);	// START
		GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_0, GPIO_PIN_0);
		SSIDataPut(SSI0_BASE, 0x08);
		
    while (1)
    { 
			SSIDataPut(SSI0_BASE, 0x02); // ukljuci continuous mode
			Delay();
			if( GPIOPinRead(GPIO_PORTA_BASE, GPIO_PIN_1) == 0 ){
				SSIDataPut(SSI0_BASE, 0x11);	//iskljuci continuous
				Delay();
				SSIDataPut(SSI0_BASE, 0x20);
				SSIDataPut(SSI0_BASE, 0x00);
				SSIDataGet(SSI0_BASE, pui32Data);
				Delay();
				UARTCharPut(UART2_BASE, Reverse(*pui32Data));
    	
			}
    }

}
