/* ============================================================================
 * Copyright (c) 2008-2012 Texas Instruments Incorporated.  
 * Except for those rights granted to you in your license from TI, all rights 
 * reserved.
 * 
 * Software License Agreement
 * Texas Instruments (TI) is supplying this software for use solely and 
 * exclusively on TI devices. The software is owned by TI and/or its suppliers, 
 * and is protected under applicable patent and copyright laws.  You may not 
 * combine this software with any open-source software if such combination would 
 * cause this software to become subject to any of the license terms applicable 
 * to such open source software.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITH ALL FAULTS.
 * NO WARRANTIES APPLY TO THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY. 
 * EXAMPLES OF EXCLUDED WARRANTIES ARE IMPLIED WARRANTIES OF MERCHANTABILITY 
 * AND FITNESS FOR A PARTICULAR PURPOSE AND WARRANTIES OF NON-INFRINGEMENT, 
 * BUT ALL OTHER WARRANTY EXCLUSIONS ALSO APPLY. FURTHERMORE, TI SHALL NOT, 
 * UNDER ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, CONSEQUENTIAL 
 * OR PUNITIVE DAMAGES, FOR ANY REASON WHATSOEVER.
 * ============================================================================
 */
 
/** @file cslr_mmcsd.h
 *
 *  @brief MMC/SD register layer header file
 *
 *  Path: \(CSLPATH)/inc
 */

/* ============================================================================
 * Revision History
 * ================
 * 17-Sept-2008 Added copy right and file prologue.
 * 14-Oct-2008  Updated as per change the name of structure fields.
 * 06-Apr-2010  Changed the name of response register from MMCDRSP4 to MMCRSP4
 * ============================================================================
 */
#ifndef _CSLR_MMCSD_H_
#define _CSLR_MMCSD_H_
#include <cslr.h>

/* Minimum unit = 2 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 MMCCTL;
    volatile Uint16 RSVD0[3];
    volatile Uint16 MMCCLK;
    volatile Uint16 RSVD1[3];
    volatile Uint16 MMCST0;
    volatile Uint16 RSVD2[3];
    volatile Uint16 MMCST1;
    volatile Uint16 RSVD3[3];
    volatile Uint16 MMCIM;
    volatile Uint16 RSVD4[3];
    volatile Uint16 MMCTOR;
    volatile Uint16 RSVD5[3];
    volatile Uint16 MMCTOD;
    volatile Uint16 RSVD6[3];
    volatile Uint16 MMCBLEN;
    volatile Uint16 RSVD7[3];
    volatile Uint16 MMCNBLK;
    volatile Uint16 RSVD8[3];
    volatile Uint16 MMCNBLC;
    volatile Uint16 RSVD9[3];
    volatile Uint16 MMCDRR1;
    volatile Uint16 MMCDRR2;
    volatile Uint16 RSVD10[2];
    volatile Uint16 MMCDXR1;
    volatile Uint16 MMCDXR2;
    volatile Uint16 RSVD11[2];
    volatile Uint16 MMCCMD1;
    volatile Uint16 MMCCMD2;
    volatile Uint16 RSVD12[2];
    volatile Uint16 MMCARG1;
    volatile Uint16 MMCARG2;
    volatile Uint16 RSVD13[2];
    volatile Uint16 MMCRSP0;
    volatile Uint16 MMCRSP1;
    volatile Uint16 RSVD14[2];
    volatile Uint16 MMCRSP2;
    volatile Uint16 MMCRSP3;
    volatile Uint16 RSVD15[2];
    volatile Uint16 MMCRSP4;
    volatile Uint16 MMCRSP5;
    volatile Uint16 RSVD16[2];
    volatile Uint16 MMCRSP6;
    volatile Uint16 MMCRSP7;
    volatile Uint16 RSVD17[2];
    volatile Uint16 MMCDRSP;
    volatile Uint16 RSVD18[7];
    volatile Uint16 MMCCIDX;
    volatile Uint16 RSVD19[19];
    volatile Uint16 SDIOCTL;
    volatile Uint16 RSVD20[3];
    volatile Uint16 SDIOST0;
    volatile Uint16 RSVD21[3];
    volatile Uint16 SDIOIEN;
    volatile Uint16 RSVD22[3];
    volatile Uint16 SDIOIST;
    volatile Uint16 RSVD23[3];
    volatile Uint16 MMCFIFOCTL;
} CSL_MmcsdRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* MMCCTL */


#define CSL_MMCSD_MMCCTL_PERMDX_MASK     (0x0400u)
#define CSL_MMCSD_MMCCTL_PERMDX_SHIFT    (0x000Au)
#define CSL_MMCSD_MMCCTL_PERMDX_RESETVAL (0x0000u)
/*----PERMDX Tokens----*/
#define CSL_MMCSD_MMCCTL_PERMDX_LEND     (0x0000u)
#define CSL_MMCSD_MMCCTL_PERMDX_BEND     (0x0001u)

#define CSL_MMCSD_MMCCTL_PERMDR_MASK     (0x0200u)
#define CSL_MMCSD_MMCCTL_PERMDR_SHIFT    (0x0009u)
#define CSL_MMCSD_MMCCTL_PERMDR_RESETVAL (0x0000u)
/*----PERMDR Tokens----*/
#define CSL_MMCSD_MMCCTL_PERMDR_LEND     (0x0000u)
#define CSL_MMCSD_MMCCTL_PERMDR_BEND     (0x0001u)


#define CSL_MMCSD_MMCCTL_DATEG_MASK      (0x00C0u)
#define CSL_MMCSD_MMCCTL_DATEG_SHIFT     (0x0006u)
#define CSL_MMCSD_MMCCTL_DATEG_RESETVAL  (0x0000u)
/*----DATEG Tokens----*/
#define CSL_MMCSD_MMCCTL_DATEG_DISABLE   (0x0000u)
#define CSL_MMCSD_MMCCTL_DATEG_R_EDGE    (0x0001u)
#define CSL_MMCSD_MMCCTL_DATEG_F_EDGE    (0x0002u)
#define CSL_MMCSD_MMCCTL_DATEG_RF_EDGE   (0x0003u)


#define CSL_MMCSD_MMCCTL_WIDTH_MASK      (0x0004u)
#define CSL_MMCSD_MMCCTL_WIDTH_SHIFT     (0x0002u)
#define CSL_MMCSD_MMCCTL_WIDTH_RESETVAL  (0x0000u)
/*----WIDTH Tokens----*/
#define CSL_MMCSD_MMCCTL_WIDTH_BIT1      (0x0000u)
#define CSL_MMCSD_MMCCTL_WIDTH_BIT4      (0x0001u)

#define CSL_MMCSD_MMCCTL_CMDRST_MASK     (0x0002u)
#define CSL_MMCSD_MMCCTL_CMDRST_SHIFT    (0x0001u)
#define CSL_MMCSD_MMCCTL_CMDRST_RESETVAL (0x0000u)
/*----CMDRST Tokens----*/
#define CSL_MMCSD_MMCCTL_CMDRST_ENABLE   (0x0000u)
#define CSL_MMCSD_MMCCTL_CMDRST_DISABLE  (0x0001u)

#define CSL_MMCSD_MMCCTL_DATRST_MASK     (0x0001u)
#define CSL_MMCSD_MMCCTL_DATRST_SHIFT    (0x0000u)
#define CSL_MMCSD_MMCCTL_DATRST_RESETVAL (0x0000u)
/*----DATRST Tokens----*/
#define CSL_MMCSD_MMCCTL_DATRST_ENABLE   (0x0000u)
#define CSL_MMCSD_MMCCTL_DATRST_DISABLE  (0x0001u)

#define CSL_MMCSD_MMCCTL_RESETVAL        (0x0000u)

/* MMCCLK */


#define CSL_MMCSD_MMCCLK_CLKEN_MASK      (0x0100u)
#define CSL_MMCSD_MMCCLK_CLKEN_SHIFT     (0x0008u)
#define CSL_MMCSD_MMCCLK_CLKEN_RESETVAL  (0x0000u)
/*----CLKEN Tokens----*/
#define CSL_MMCSD_MMCCLK_CLKEN_DISABLE   (0x0000u)
#define CSL_MMCSD_MMCCLK_CLKEN_ENABLE    (0x0001u)

#define CSL_MMCSD_MMCCLK_CLKRT_MASK      (0x00FFu)
#define CSL_MMCSD_MMCCLK_CLKRT_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCCLK_CLKRT_RESETVAL  (0x00FFu)

#define CSL_MMCSD_MMCCLK_RESETVAL        (0x00FFu)

/* MMCST0 */


#define CSL_MMCSD_MMCST0_TRNDNE_MASK     (0x1000u)
#define CSL_MMCSD_MMCST0_TRNDNE_SHIFT    (0x000Cu)
#define CSL_MMCSD_MMCST0_TRNDNE_RESETVAL (0x0000u)
/*----TRNDNE Tokens----*/
#define CSL_MMCSD_MMCST0_TRNDNE_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST0_TRNDNE_SET      (0x0001u)

#define CSL_MMCSD_MMCST0_DATED_MASK      (0x0800u)
#define CSL_MMCSD_MMCST0_DATED_SHIFT     (0x000Bu)
#define CSL_MMCSD_MMCST0_DATED_RESETVAL  (0x0000u)
/*----DATED Tokens----*/
#define CSL_MMCSD_MMCST0_DATED_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST0_DATED_SET       (0x0001u)

#define CSL_MMCSD_MMCST0_DRRDY_MASK      (0x0400u)
#define CSL_MMCSD_MMCST0_DRRDY_SHIFT     (0x000Au)
#define CSL_MMCSD_MMCST0_DRRDY_RESETVAL  (0x0000u)
/*----DRRDY Tokens----*/
#define CSL_MMCSD_MMCST0_DRRDY_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST0_DRRDY_SET       (0x0001u)

#define CSL_MMCSD_MMCST0_DXRDY_MASK      (0x0200u)
#define CSL_MMCSD_MMCST0_DXRDY_SHIFT     (0x0009u)
#define CSL_MMCSD_MMCST0_DXRDY_RESETVAL  (0x0000u)
/*----DXRDY Tokens----*/
#define CSL_MMCSD_MMCST0_DXRDY_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST0_DXRDY_SET       (0x0001u)


#define CSL_MMCSD_MMCST0_CRCRS_MASK      (0x0080u)
#define CSL_MMCSD_MMCST0_CRCRS_SHIFT     (0x0007u)
#define CSL_MMCSD_MMCST0_CRCRS_RESETVAL  (0x0000u)
/*----CRCRS Tokens----*/
#define CSL_MMCSD_MMCST0_CRCRS_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST0_CRCRS_SET       (0x0001u)

#define CSL_MMCSD_MMCST0_CRCRD_MASK      (0x0040u)
#define CSL_MMCSD_MMCST0_CRCRD_SHIFT     (0x0006u)
#define CSL_MMCSD_MMCST0_CRCRD_RESETVAL  (0x0000u)
/*----CRCRD Tokens----*/
#define CSL_MMCSD_MMCST0_CRCRD_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST0_CRCRD_SET       (0x0001u)

#define CSL_MMCSD_MMCST0_CRCWR_MASK      (0x0020u)
#define CSL_MMCSD_MMCST0_CRCWR_SHIFT     (0x0005u)
#define CSL_MMCSD_MMCST0_CRCWR_RESETVAL  (0x0000u)
/*----CRCWR Tokens----*/
#define CSL_MMCSD_MMCST0_CRCWR_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST0_CRCWR_SET       (0x0001u)

#define CSL_MMCSD_MMCST0_TOUTRS_MASK     (0x0010u)
#define CSL_MMCSD_MMCST0_TOUTRS_SHIFT    (0x0004u)
#define CSL_MMCSD_MMCST0_TOUTRS_RESETVAL (0x0000u)
/*----TOUTRS Tokens----*/
#define CSL_MMCSD_MMCST0_TOUTRS_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST0_TOUTRS_SET      (0x0001u)

#define CSL_MMCSD_MMCST0_TOUTRD_MASK     (0x0008u)
#define CSL_MMCSD_MMCST0_TOUTRD_SHIFT    (0x0003u)
#define CSL_MMCSD_MMCST0_TOUTRD_RESETVAL (0x0000u)
/*----TOUTRD Tokens----*/
#define CSL_MMCSD_MMCST0_TOUTRD_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST0_TOUTRD_SET      (0x0001u)

#define CSL_MMCSD_MMCST0_RSPDNE_MASK     (0x0004u)
#define CSL_MMCSD_MMCST0_RSPDNE_SHIFT    (0x0002u)
#define CSL_MMCSD_MMCST0_RSPDNE_RESETVAL (0x0000u)
/*----RSPDNE Tokens----*/
#define CSL_MMCSD_MMCST0_RSPDNE_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST0_RSPDNE_SET      (0x0001u)

#define CSL_MMCSD_MMCST0_BSYDNE_MASK     (0x0002u)
#define CSL_MMCSD_MMCST0_BSYDNE_SHIFT    (0x0001u)
#define CSL_MMCSD_MMCST0_BSYDNE_RESETVAL (0x0000u)
/*----BSYDNE Tokens----*/
#define CSL_MMCSD_MMCST0_BSYDNE_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST0_BSYDNE_SET      (0x0001u)

#define CSL_MMCSD_MMCST0_DATDNE_MASK     (0x0001u)
#define CSL_MMCSD_MMCST0_DATDNE_SHIFT    (0x0000u)
#define CSL_MMCSD_MMCST0_DATDNE_RESETVAL (0x0000u)
/*----DATDNE Tokens----*/
#define CSL_MMCSD_MMCST0_DATDNE_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST0_DATDNE_SET      (0x0001u)

#define CSL_MMCSD_MMCST0_RESETVAL        (0x0200u)

/* MMCST1 */


#define CSL_MMCSD_MMCST1_FIFOFUL_MASK    (0x0040u)
#define CSL_MMCSD_MMCST1_FIFOFUL_SHIFT   (0x0006u)
#define CSL_MMCSD_MMCST1_FIFOFUL_RESETVAL (0x0000u)
/*----FIFOFUL Tokens----*/
#define CSL_MMCSD_MMCST1_FIFOFUL_CLEAR   (0x0000u)
#define CSL_MMCSD_MMCST1_FIFOFUL_SET     (0x0001u)

#define CSL_MMCSD_MMCST1_FIFOEMP_MASK    (0x0020u)
#define CSL_MMCSD_MMCST1_FIFOEMP_SHIFT   (0x0005u)
#define CSL_MMCSD_MMCST1_FIFOEMP_RESETVAL (0x0000u)
/*----FIFOEMP Tokens----*/
#define CSL_MMCSD_MMCST1_FIFOEMP_CLEAR   (0x0000u)
#define CSL_MMCSD_MMCST1_FIFOEMP_SET     (0x0001u)

#define CSL_MMCSD_MMCST1_DAT3ST_MASK     (0x0010u)
#define CSL_MMCSD_MMCST1_DAT3ST_SHIFT    (0x0004u)
#define CSL_MMCSD_MMCST1_DAT3ST_RESETVAL (0x0000u)
/*----DAT3ST Tokens----*/
#define CSL_MMCSD_MMCST1_DAT3ST_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST1_DAT3ST_SET      (0x0001u)

#define CSL_MMCSD_MMCST1_DRFUL_MASK      (0x0008u)
#define CSL_MMCSD_MMCST1_DRFUL_SHIFT     (0x0003u)
#define CSL_MMCSD_MMCST1_DRFUL_RESETVAL  (0x0000u)
/*----DRFUL Tokens----*/
#define CSL_MMCSD_MMCST1_DRFUL_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST1_DRFUL_SET       (0x0001u)

#define CSL_MMCSD_MMCST1_DXEMP_MASK      (0x0004u)
#define CSL_MMCSD_MMCST1_DXEMP_SHIFT     (0x0002u)
#define CSL_MMCSD_MMCST1_DXEMP_RESETVAL  (0x0000u)
/*----DXEMP Tokens----*/
#define CSL_MMCSD_MMCST1_DXEMP_CLEAR     (0x0000u)
#define CSL_MMCSD_MMCST1_DXEMP_SET       (0x0001u)

#define CSL_MMCSD_MMCST1_CLKSTP_MASK     (0x0002u)
#define CSL_MMCSD_MMCST1_CLKSTP_SHIFT    (0x0001u)
#define CSL_MMCSD_MMCST1_CLKSTP_RESETVAL (0x0001u)
/*----CLKSTP Tokens----*/
#define CSL_MMCSD_MMCST1_CLKSTP_CLEAR    (0x0000u)
#define CSL_MMCSD_MMCST1_CLKSTP_SET      (0x0001u)

#define CSL_MMCSD_MMCST1_BUSY_MASK       (0x0001u)
#define CSL_MMCSD_MMCST1_BUSY_SHIFT      (0x0000u)
#define CSL_MMCSD_MMCST1_BUSY_RESETVAL   (0x0000u)
/*----BUSY Tokens----*/
#define CSL_MMCSD_MMCST1_BUSY_CLEAR      (0x0000u)
#define CSL_MMCSD_MMCST1_BUSY_SET        (0x0001u)

#define CSL_MMCSD_MMCST1_RESETVAL        (0x0002u)

/* MMCIM */


#define CSL_MMCSD_MMCIM_ETRNDNE_MASK     (0x1000u)
#define CSL_MMCSD_MMCIM_ETRNDNE_SHIFT    (0x000Cu)
#define CSL_MMCSD_MMCIM_ETRNDNE_RESETVAL (0x0000u)
/*----ETRNDNE Tokens----*/
#define CSL_MMCSD_MMCIM_ETRNDNE_PROHIBIT (0x0000u)
#define CSL_MMCSD_MMCIM_ETRNDNE_PERMIT   (0x0001u)

#define CSL_MMCSD_MMCIM_EDATED_MASK      (0x0800u)
#define CSL_MMCSD_MMCIM_EDATED_SHIFT     (0x000Bu)
#define CSL_MMCSD_MMCIM_EDATED_RESETVAL  (0x0000u)
/*----EDATED Tokens----*/
#define CSL_MMCSD_MMCIM_EDATED_PROHIBIT  (0x0000u)
#define CSL_MMCSD_MMCIM_EDATED_PERMIT    (0x0001u)

#define CSL_MMCSD_MMCIM_EDRRDY_MASK      (0x0400u)
#define CSL_MMCSD_MMCIM_EDRRDY_SHIFT     (0x000Au)
#define CSL_MMCSD_MMCIM_EDRRDY_RESETVAL  (0x0000u)
/*----EDRRDY Tokens----*/
#define CSL_MMCSD_MMCIM_EDRRDY_PROHIBIT  (0x0000u)
#define CSL_MMCSD_MMCIM_EDRRDY_PERMIT    (0x0001u)

#define CSL_MMCSD_MMCIM_EDXRDY_MASK      (0x0200u)
#define CSL_MMCSD_MMCIM_EDXRDY_SHIFT     (0x0009u)
#define CSL_MMCSD_MMCIM_EDXRDY_RESETVAL  (0x0000u)
/*----EDXRDY Tokens----*/
#define CSL_MMCSD_MMCIM_EDXRDY_PROHIBIT  (0x0000u)
#define CSL_MMCSD_MMCIM_EDXRDY_PERMIT    (0x0001u)


#define CSL_MMCSD_MMCIM_ECRCRS_MASK      (0x0080u)
#define CSL_MMCSD_MMCIM_ECRCRS_SHIFT     (0x0007u)
#define CSL_MMCSD_MMCIM_ECRCRS_RESETVAL  (0x0000u)
/*----ECRCRS Tokens----*/
#define CSL_MMCSD_MMCIM_ECRCRS_PROHIBIT  (0x0000u)
#define CSL_MMCSD_MMCIM_ECRCRS_PERMIT    (0x0001u)

#define CSL_MMCSD_MMCIM_ECRCRD_MASK      (0x0040u)
#define CSL_MMCSD_MMCIM_ECRCRD_SHIFT     (0x0006u)
#define CSL_MMCSD_MMCIM_ECRCRD_RESETVAL  (0x0000u)
/*----ECRCRD Tokens----*/
#define CSL_MMCSD_MMCIM_ECRCRD_PROHIBIT  (0x0000u)
#define CSL_MMCSD_MMCIM_ECRCRD_PERMIT    (0x0001u)

#define CSL_MMCSD_MMCIM_ECRCWR_MASK      (0x0020u)
#define CSL_MMCSD_MMCIM_ECRCWR_SHIFT     (0x0005u)
#define CSL_MMCSD_MMCIM_ECRCWR_RESETVAL  (0x0000u)
/*----ECRCWR Tokens----*/
#define CSL_MMCSD_MMCIM_ECRCWR_PROHIBIT  (0x0000u)
#define CSL_MMCSD_MMCIM_ECRCWR_PERMIT    (0x0001u)

#define CSL_MMCSD_MMCIM_ETOUTRS_MASK     (0x0010u)
#define CSL_MMCSD_MMCIM_ETOUTRS_SHIFT    (0x0004u)
#define CSL_MMCSD_MMCIM_ETOUTRS_RESETVAL (0x0000u)
/*----ETOUTRS Tokens----*/
#define CSL_MMCSD_MMCIM_ETOUTRS_PROHIBIT (0x0000u)
#define CSL_MMCSD_MMCIM_ETOUTRS_PERMIT   (0x0001u)

#define CSL_MMCSD_MMCIM_ETOUTRD_MASK     (0x0008u)
#define CSL_MMCSD_MMCIM_ETOUTRD_SHIFT    (0x0003u)
#define CSL_MMCSD_MMCIM_ETOUTRD_RESETVAL (0x0000u)
/*----ETOUTRD Tokens----*/
#define CSL_MMCSD_MMCIM_ETOUTRD_PROHIBIT (0x0000u)
#define CSL_MMCSD_MMCIM_ETOUTRD_PERMIT   (0x0001u)

#define CSL_MMCSD_MMCIM_ERSPDNE_MASK     (0x0004u)
#define CSL_MMCSD_MMCIM_ERSPDNE_SHIFT    (0x0002u)
#define CSL_MMCSD_MMCIM_ERSPDNE_RESETVAL (0x0000u)
/*----ERSPDNE Tokens----*/
#define CSL_MMCSD_MMCIM_ERSPDNE_PROHIBIT (0x0000u)
#define CSL_MMCSD_MMCIM_ERSPDNE_PERMIT   (0x0001u)

#define CSL_MMCSD_MMCIM_EBSYDNE_MASK     (0x0002u)
#define CSL_MMCSD_MMCIM_EBSYDNE_SHIFT    (0x0001u)
#define CSL_MMCSD_MMCIM_EBSYDNE_RESETVAL (0x0000u)
/*----EBSYDNE Tokens----*/
#define CSL_MMCSD_MMCIM_EBSYDNE_PROHIBIT (0x0000u)
#define CSL_MMCSD_MMCIM_EBSYDNE_PERMIT   (0x0001u)

#define CSL_MMCSD_MMCIM_EDATDNE_MASK     (0x0001u)
#define CSL_MMCSD_MMCIM_EDATDNE_SHIFT    (0x0000u)
#define CSL_MMCSD_MMCIM_EDATDNE_RESETVAL (0x0000u)
/*----EDATDNE Tokens----*/
#define CSL_MMCSD_MMCIM_EDATDNE_PROHIBIT (0x0000u)
#define CSL_MMCSD_MMCIM_EDATDNE_PERMIT   (0x0001u)

#define CSL_MMCSD_MMCIM_RESETVAL         (0x0000u)

/* MMCTOR */

#define CSL_MMCSD_MMCTOR_TOD_23_16_MASK  (0xFF00u)
#define CSL_MMCSD_MMCTOR_TOD_23_16_SHIFT (0x0008u)
#define CSL_MMCSD_MMCTOR_TOD_23_16_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCTOR_TOR_MASK        (0x00FFu)
#define CSL_MMCSD_MMCTOR_TOR_SHIFT       (0x0000u)
#define CSL_MMCSD_MMCTOR_TOR_RESETVAL    (0x0000u)

#define CSL_MMCSD_MMCTOR_RESETVAL        (0x0000u)

/* MMCTOD */

#define CSL_MMCSD_MMCTOD_TOD_15_0_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCTOD_TOD_15_0_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCTOD_TOD_15_0_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCTOD_RESETVAL        (0x0000u)

/* MMCBLEN */


#define CSL_MMCSD_MMCBLEN_BLEN_MASK      (0x0FFFu)
#define CSL_MMCSD_MMCBLEN_BLEN_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCBLEN_BLEN_RESETVAL  (0x0200u)

#define CSL_MMCSD_MMCBLEN_RESETVAL       (0x0200u)

/* MMCNBLK */

#define CSL_MMCSD_MMCNBLK_NBLK_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCNBLK_NBLK_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCNBLK_NBLK_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCNBLK_RESETVAL       (0x0000u)

/* MMCNBLC */

#define CSL_MMCSD_MMCNBLC_NBLC_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCNBLC_NBLC_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCNBLC_NBLC_RESETVAL  (0xFFFFu)

#define CSL_MMCSD_MMCNBLC_RESETVAL       (0xFFFFu)

/* MMCDRR1 */

#define CSL_MMCSD_MMCDRR1_DRR1_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCDRR1_DRR1_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCDRR1_DRR1_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCDRR1_RESETVAL       (0x0000u)

/* MMCDRR2 */

#define CSL_MMCSD_MMCDRR2_DRR2_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCDRR2_DRR2_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCDRR2_DRR2_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCDRR2_RESETVAL       (0x0000u)

/* MMCDXR1 */

#define CSL_MMCSD_MMCDXR1_DXR1_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCDXR1_DXR1_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCDXR1_DXR1_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCDXR1_RESETVAL       (0x0000u)

/* MMCDXR2 */

#define CSL_MMCSD_MMCDXR2_DXR2_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCDXR2_DXR2_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCDXR2_DXR2_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCDXR2_RESETVAL       (0x0000u)

/* MMCCMD1 */

#define CSL_MMCSD_MMCCMD1_DCLR_MASK      (0x8000u)
#define CSL_MMCSD_MMCCMD1_DCLR_SHIFT     (0x000Fu)
#define CSL_MMCSD_MMCCMD1_DCLR_RESETVAL  (0x0000u)
/*----DCLR Tokens----*/
#define CSL_MMCSD_MMCCMD1_DCLR_NO        (0x0000u)
#define CSL_MMCSD_MMCCMD1_DCLR_CLEAR     (0x0001u)

#define CSL_MMCSD_MMCCMD1_INITCK_MASK    (0x4000u)
#define CSL_MMCSD_MMCCMD1_INITCK_SHIFT   (0x000Eu)
#define CSL_MMCSD_MMCCMD1_INITCK_RESETVAL (0x0000u)
/*----INITCK Tokens----*/
#define CSL_MMCSD_MMCCMD1_INITCK_NO      (0x0000u)
#define CSL_MMCSD_MMCCMD1_INITCK_INIT    (0x0001u)

#define CSL_MMCSD_MMCCMD1_WDATX_MASK     (0x2000u)
#define CSL_MMCSD_MMCCMD1_WDATX_SHIFT    (0x000Du)
#define CSL_MMCSD_MMCCMD1_WDATX_RESETVAL (0x0000u)
/*----WDATX Tokens----*/
#define CSL_MMCSD_MMCCMD1_WDATX_NO       (0x0000u)
#define CSL_MMCSD_MMCCMD1_WDATX_DATA     (0x0001u)

#define CSL_MMCSD_MMCCMD1_STRMTP_MASK    (0x1000u)
#define CSL_MMCSD_MMCCMD1_STRMTP_SHIFT   (0x000Cu)
#define CSL_MMCSD_MMCCMD1_STRMTP_RESETVAL (0x0000u)
/*----STRMTP Tokens----*/
#define CSL_MMCSD_MMCCMD1_STRMTP_BLOCK   (0x0000u)
#define CSL_MMCSD_MMCCMD1_STRMTP_STREAM  (0x0001u)
#define CSL_MMCSD_MMCCMD1_STRMTP_NO      (0x0000u)

#define CSL_MMCSD_MMCCMD1_DTRW_MASK      (0x0800u)
#define CSL_MMCSD_MMCCMD1_DTRW_SHIFT     (0x000Bu)
#define CSL_MMCSD_MMCCMD1_DTRW_RESETVAL  (0x0000u)
/*----DTRW Tokens----*/
#define CSL_MMCSD_MMCCMD1_DTRW_READ      (0x0000u)
#define CSL_MMCSD_MMCCMD1_DTRW_WRITE     (0x0001u)
#define CSL_MMCSD_MMCCMD1_DTRW_NO        (0x0000u)

#define CSL_MMCSD_MMCCMD1_RSPFMT_MASK    (0x0600u)
#define CSL_MMCSD_MMCCMD1_RSPFMT_SHIFT   (0x0009u)
#define CSL_MMCSD_MMCCMD1_RSPFMT_RESETVAL (0x0000u)
/*----RSPFMT Tokens----*/
#define CSL_MMCSD_MMCCMD1_RSPFMT_NORSP   (0x0000u)
#define CSL_MMCSD_MMCCMD1_RSPFMT_R1      (0x0001u)
#define CSL_MMCSD_MMCCMD1_RSPFMT_R2      (0x0002u)
#define CSL_MMCSD_MMCCMD1_RSPFMT_R3      (0x0003u)

#define CSL_MMCSD_MMCCMD1_BSYEXP_MASK    (0x0100u)
#define CSL_MMCSD_MMCCMD1_BSYEXP_SHIFT   (0x0008u)
#define CSL_MMCSD_MMCCMD1_BSYEXP_RESETVAL (0x0000u)
/*----BSYEXP Tokens----*/
#define CSL_MMCSD_MMCCMD1_BSYEXP_NO      (0x0000u)
#define CSL_MMCSD_MMCCMD1_BSYEXP_BUSY    (0x0001u)

#define CSL_MMCSD_MMCCMD1_PPLEN_MASK     (0x0080u)
#define CSL_MMCSD_MMCCMD1_PPLEN_SHIFT    (0x0007u)
#define CSL_MMCSD_MMCCMD1_PPLEN_RESETVAL (0x0000u)
/*----PPLEN Tokens----*/
#define CSL_MMCSD_MMCCMD1_PPLEN_OD       (0x0000u)
#define CSL_MMCSD_MMCCMD1_PPLEN_PP       (0x0001u)


#define CSL_MMCSD_MMCCMD1_CMD_MASK       (0x003Fu)
#define CSL_MMCSD_MMCCMD1_CMD_SHIFT      (0x0000u)
#define CSL_MMCSD_MMCCMD1_CMD_RESETVAL   (0x0000u)

#define CSL_MMCSD_MMCCMD1_RESETVAL       (0x0000u)

/* MMCCMD2 */


#define CSL_MMCSD_MMCCMD2_DMATRIG_MASK   (0x0001u)
#define CSL_MMCSD_MMCCMD2_DMATRIG_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCCMD2_DMATRIG_RESETVAL (0x0000u)
/*----DMATRIG Tokens----*/
#define CSL_MMCSD_MMCCMD2_DMATRIG_NO     (0x0000u)

#define CSL_MMCSD_MMCCMD2_RESETVAL       (0x0000u)

/* MMCARG1 */

#define CSL_MMCSD_MMCARG1_ARG1_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCARG1_ARG1_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCARG1_ARG1_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCARG1_RESETVAL       (0x0000u)

/* MMCARG2 */

#define CSL_MMCSD_MMCARG2_ARG2_MASK      (0xFFFFu)
#define CSL_MMCSD_MMCARG2_ARG2_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCARG2_ARG2_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCARG2_RESETVAL       (0x0000u)

/* MMCRSP0 */

#define CSL_MMCSD_MMCRSP0_MMCRSP0_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP0_MMCRSP0_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP0_MMCRSP0_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP0_RESETVAL       (0x0000u)

/* MMCRSP1 */

#define CSL_MMCSD_MMCRSP1_MMCRSP1_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP1_MMCRSP1_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP1_MMCRSP1_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP1_RESETVAL       (0x0000u)

/* MMCRSP2 */

#define CSL_MMCSD_MMCRSP2_MMCRSP2_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP2_MMCRSP2_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP2_MMCRSP2_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP2_RESETVAL       (0x0000u)

/* MMCRSP3 */

#define CSL_MMCSD_MMCRSP3_MMCRSP3_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP3_MMCRSP3_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP3_MMCRSP3_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP3_RESETVAL       (0x0000u)

/* MMCRSP4 */

#define CSL_MMCSD_MMCRSP4_MMCRSP4_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP4_MMCRSP4_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP4_MMCRSP4_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP4_RESETVAL       (0x0000u)

/* MMCRSP5 */

#define CSL_MMCSD_MMCRSP5_MMCRSP5_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP5_MMCRSP5_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP5_MMCRSP5_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP5_RESETVAL       (0x0000u)

/* MMCRSP6 */

#define CSL_MMCSD_MMCRSP6_MMCRSP6_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP6_MMCRSP6_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP6_MMCRSP6_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP6_RESETVAL       (0x0000u)

/* MMCRSP7 */

#define CSL_MMCSD_MMCRSP7_MMCRSP7_MASK   (0xFFFFu)
#define CSL_MMCSD_MMCRSP7_MMCRSP7_SHIFT  (0x0000u)
#define CSL_MMCSD_MMCRSP7_MMCRSP7_RESETVAL (0x0000u)

#define CSL_MMCSD_MMCRSP7_RESETVAL       (0x0000u)

/* MMCDRSP */


#define CSL_MMCSD_MMCDRSP_DRSP_MASK      (0x00FFu)
#define CSL_MMCSD_MMCDRSP_DRSP_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCDRSP_DRSP_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCDRSP_RESETVAL       (0x0000u)

/* MMCCIDX */


#define CSL_MMCSD_MMCCIDX_STRT_MASK      (0x0080u)
#define CSL_MMCSD_MMCCIDX_STRT_SHIFT     (0x0007u)
#define CSL_MMCSD_MMCCIDX_STRT_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCCIDX_XMIT_MASK      (0x0040u)
#define CSL_MMCSD_MMCCIDX_XMIT_SHIFT     (0x0006u)
#define CSL_MMCSD_MMCCIDX_XMIT_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCCIDX_CIDX_MASK      (0x003Fu)
#define CSL_MMCSD_MMCCIDX_CIDX_SHIFT     (0x0000u)
#define CSL_MMCSD_MMCCIDX_CIDX_RESETVAL  (0x0000u)

#define CSL_MMCSD_MMCCIDX_RESETVAL       (0x0000u)

/* SDIOCTL */


#define CSL_MMCSD_SDIOCTL_RDWTCR_MASK    (0x0002u)
#define CSL_MMCSD_SDIOCTL_RDWTCR_SHIFT   (0x0001u)
#define CSL_MMCSD_SDIOCTL_RDWTCR_RESETVAL (0x0000u)
/*----RDWTCR Tokens----*/
#define CSL_MMCSD_SDIOCTL_RDWTCR_DISABLE (0x0000u)
#define CSL_MMCSD_SDIOCTL_RDWTCR_ENABLE  (0x0001u)

#define CSL_MMCSD_SDIOCTL_RDWTRQ_MASK    (0x0001u)
#define CSL_MMCSD_SDIOCTL_RDWTRQ_SHIFT   (0x0000u)
#define CSL_MMCSD_SDIOCTL_RDWTRQ_RESETVAL (0x0000u)
/*----RDWTRQ Tokens----*/
#define CSL_MMCSD_SDIOCTL_RDWTRQ_DISABLE (0x0000u)
#define CSL_MMCSD_SDIOCTL_RDWTRQ_ENABLE  (0x0001u)

#define CSL_MMCSD_SDIOCTL_RESETVAL       (0x0000u)

/* SDIOST0 */


#define CSL_MMCSD_SDIOST0_RDWTST_MASK    (0x0004u)
#define CSL_MMCSD_SDIOST0_RDWTST_SHIFT   (0x0002u)
#define CSL_MMCSD_SDIOST0_RDWTST_RESETVAL (0x0000u)
/*----RDWTST Tokens----*/
#define CSL_MMCSD_SDIOST0_RDWTST_INACTIVE (0x0000u)
#define CSL_MMCSD_SDIOST0_RDWTST_ACTIVE  (0x0001u)

#define CSL_MMCSD_SDIOST0_INTPRD_MASK    (0x0002u)
#define CSL_MMCSD_SDIOST0_INTPRD_SHIFT   (0x0001u)
#define CSL_MMCSD_SDIOST0_INTPRD_RESETVAL (0x0000u)
/*----INTPRD Tokens----*/
#define CSL_MMCSD_SDIOST0_INTPRD_CLEAR   (0x0000u)
#define CSL_MMCSD_SDIOST0_INTPRD_INTERRUPT (0x0001u)

#define CSL_MMCSD_SDIOST0_DAT1_MASK      (0x0001u)
#define CSL_MMCSD_SDIOST0_DAT1_SHIFT     (0x0000u)
#define CSL_MMCSD_SDIOST0_DAT1_RESETVAL  (0x0001u)
/*----DAT1 Tokens----*/
#define CSL_MMCSD_SDIOST0_DAT1_LOW       (0x0000u)
#define CSL_MMCSD_SDIOST0_DAT1_HIGH      (0x0001u)

#define CSL_MMCSD_SDIOST0_RESETVAL       (0x0001u)

/* SDIOIEN */


#define CSL_MMCSD_SDIOIEN_RWSEN_MASK     (0x0002u)
#define CSL_MMCSD_SDIOIEN_RWSEN_SHIFT    (0x0001u)
#define CSL_MMCSD_SDIOIEN_RWSEN_RESETVAL (0x0000u)
/*----RWSEN Tokens----*/
#define CSL_MMCSD_SDIOIEN_RWSEN_DISABLE  (0x0000u)
#define CSL_MMCSD_SDIOIEN_RWSEN_ENABLE   (0x0001u)

#define CSL_MMCSD_SDIOIEN_IOINTEN_MASK   (0x0001u)
#define CSL_MMCSD_SDIOIEN_IOINTEN_SHIFT  (0x0000u)
#define CSL_MMCSD_SDIOIEN_IOINTEN_RESETVAL (0x0000u)
/*----IOINTEN Tokens----*/
#define CSL_MMCSD_SDIOIEN_IOINTEN_DISABLE (0x0000u)
#define CSL_MMCSD_SDIOIEN_IOINTEN_ENABLE (0x0001u)

#define CSL_MMCSD_SDIOIEN_RESETVAL       (0x0000u)

/* SDIOIST */


#define CSL_MMCSD_SDIOIST_RWS_MASK       (0x0002u)
#define CSL_MMCSD_SDIOIST_RWS_SHIFT      (0x0001u)
#define CSL_MMCSD_SDIOIST_RWS_RESETVAL   (0x0000u)
/*----RWS Tokens----*/
#define CSL_MMCSD_SDIOIST_RWS_CLEAR      (0x0000u)
#define CSL_MMCSD_SDIOIST_RWS_SET        (0x0001u)

#define CSL_MMCSD_SDIOIST_IOINT_MASK     (0x0001u)
#define CSL_MMCSD_SDIOIST_IOINT_SHIFT    (0x0000u)
#define CSL_MMCSD_SDIOIST_IOINT_RESETVAL (0x0000u)
/*----IOINT Tokens----*/
#define CSL_MMCSD_SDIOIST_IOINT_CLEAR    (0x0000u)
#define CSL_MMCSD_SDIOIST_IOINT_SET      (0x0001u)

#define CSL_MMCSD_SDIOIST_RESETVAL       (0x0000u)

/* MMCFIFOCTL */


#define CSL_MMCSD_MMCFIFOCTL_ACCWD_MASK  (0x0018u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_SHIFT (0x0003u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_RESETVAL (0x0000u)
/*----ACCWD Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_4BYTES (0x0000u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_3BYTES (0x0001u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_2BYTES (0x0002u)
#define CSL_MMCSD_MMCFIFOCTL_ACCWD_1BYTE (0x0003u)

#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_MASK (0x0004u)
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_SHIFT (0x0002u)
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_RESETVAL (0x0000u)
/*----FIFOLEV Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_128BIT (0x0000u)
#define CSL_MMCSD_MMCFIFOCTL_FIFOLEV_256BIT (0x0001u)

#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_MASK (0x0002u)
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_SHIFT (0x0001u)
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_RESETVAL (0x0000u)
/*----FIFODIR Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_READ (0x0000u)
#define CSL_MMCSD_MMCFIFOCTL_FIFODIR_WRITE (0x0001u)

#define CSL_MMCSD_MMCFIFOCTL_FIFORST_MASK (0x0001u)
#define CSL_MMCSD_MMCFIFOCTL_FIFORST_SHIFT (0x0000u)
#define CSL_MMCSD_MMCFIFOCTL_FIFORST_RESETVAL (0x0000u)
/*----FIFORST Tokens----*/
#define CSL_MMCSD_MMCFIFOCTL_FIFORST_RESET (0x0001u)

#define CSL_MMCSD_MMCFIFOCTL_RESETVAL    (0x0000u)

#endif
