#if 1
/*
*  Copyright (C) 2015-2017 Texas Instruments Incorporated - http://www.ti.com/
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/
/**
*  \file   mcspiLoopbackApp.c
*
*  \brief This file contains the application which demonstrates McSPI loopback
*         which transfers some data pattern from data I/O signal & receives
*         the data from same data I/O signal.
*
*/

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>

#include "stdint.h"
#include <stdio.h>
#include <ti/csl/example/utils/common/inc/app_utils.h>
#include <ti/csl/soc.h>
#include <ti/csl/hw_types.h>

#include <ti/board/board.h>

#include <ti/osal/osal.h>

/* UART Header files */
#include <ti/drv/uart/UART.h>

/* SPI Header files */
#include <ti/drv/spi/SPI.h>
#include <ti/csl/csl_mcspi.h>
#include <ti/drv/spi/soc/SPI_soc.h>
#ifdef SPI_DMA_ENABLE
#include <ti/osal/CacheP.h>
/* EDMA3 Header files */
#include <ti/sdo/edma3/drv/edma3_drv.h>
#include <ti/sdo/edma3/rm/edma3_rm.h>
#include <ti/sdo/edma3/rm/sample/bios6_edma3_rm_sample.h>

static EDMA3_RM_Handle SpiApp_edmaInit(void);

#endif

/* ========================================================================== */
/*                                 Macros                                     */
/* ========================================================================== */

#define McSPI_DATA_COUNT            5U // Data Count Transaction

#define UART_INSTANCE 0

#define MCSPI_INSTANCE 2

#define UART3   (0x48020000U)
/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
uint32_t           gRxBuffer[McSPI_DATA_COUNT];
uint32_t           gTxBuffer[McSPI_DATA_COUNT];
uint8_t           verifybuf[McSPI_DATA_COUNT] = {0,3,12,15,48};
//uint8_t           verifybuf[McSPI_DATA_COUNT] = {0,7,28,31,112};
UART_Handle gUartHandle;

SPI_Handle gSpiHandle;

/* UART parameters structure*/
const UART_Params gUserParams = {
   UART_MODE_BLOCKING,     /* readMode */
   UART_MODE_BLOCKING,     /* writeMode */
   SemaphoreP_WAIT_FOREVER,/* readTimeout */
   SemaphoreP_WAIT_FOREVER,/* writeTimeout */
   NULL,                  /* readCallback */
   NULL,                 /* writeCallback */
   UART_RETURN_NEWLINE,  /* readReturnMode */
   UART_DATA_TEXT,       /* readDataMode */
   UART_DATA_TEXT,       /* writeDataMode */
   UART_ECHO_ON,         /* readEcho */
   115200,               /* baudRate */
   UART_LEN_8,           /* dataLength */
   UART_STOP_ONE,        /* stopBits */
   UART_PAR_NONE         /* parityType */
};

/* SPI parameters structure Master mode*/
SPI_Params gSpiParams = {
   SPI_MODE_BLOCKING,  /* transferMode */
   SemaphoreP_WAIT_FOREVER,/* transferTimeout */
   NULL, /* transferCallbackFxn */
   SPI_MASTER,         /* mode */
   1000000,            /* bitRate */
   32,                  /* dataSize */
   SPI_POL0_PHA0,      /* frameFormat */
   NULL                /* custom */
};

/* ========================================================================== */
/*                          Function Declarations                             */
/* ========================================================================== */
static void McSPIInitializeBuffers(void);
void padConfig_prcmEnable();
void spi_test(UArg arg0, UArg arg1);
static int32_t McSPIVerifyData(void);

/* ========================================================================== */
/*                          Function Definitions                              */
/* ========================================================================== */
void padConfig_prcmEnable()
{
#if defined (SOC_DRA72x) || (SOC_DRA75x) || defined (SOC_DRA78x)
   Board_initCfg boardCfg;

   boardCfg = BOARD_INIT_PINMUX_CONFIG |
       BOARD_INIT_MODULE_CLOCK;

   Board_init(boardCfg);
#endif
#if defined (SOC_AM572x) || defined (SOC_AM571x)
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_UART3_RXD,0x00040000);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_UART3_TXD,0x00040000);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_SPI1_SCLK,0x000C0000);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_SPI1_D1,0x000C0000);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_SPI1_D0,0x000C0000);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_SPI1_CS0,0x00060000);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_GPMC_A8,0x000C0008);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_GPMC_A9,0x000C0008);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_GPMC_A10,0x000C0008);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_GPMC_A11,0x00060008);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR8,0x00060003);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR9,0x00060003);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR10,0x00060003);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR11,0x00060003);
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_MCASP1_AXR12,0x00060003);

#if defined (SOC_AM572x)
   HW_WR_REG32(CSL_MPU_CORE_PAD_IO_REGISTERS_REGS+CSL_CONTROL_CORE_PAD_IO_PAD_SPI1_CS1,0x00060000);
#endif
#endif
#if defined (SOC_TDA2XX) || defined (SOC_TDA2EX)
   /*Pad configurations */
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_UART1_RXD,0x00040000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_UART1_TXD,0x00040000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_SPI1_SCLK,0x000C0000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_SPI1_D1,0x000C0000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_SPI1_D0,0x000C0000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_SPI1_CS0,0x00060000);
#if defined (SOC_TDA2XX)
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_SPI1_CS1,0x00060000);
#endif
   /* IPU1 Crossbar */
   CSL_xbarIrqConfigure(CSL_XBAR_IRQ_CPU_ID_IPU1, CSL_XBAR_INST_IPU1_IRQ_44, CSL_XBAR_UART1_IRQ);
#endif
#if defined(SOC_TDA3XX)
   /*MCSPI1 prcm*/
   HW_WR_REG32(SOC_L4PER_CM_CORE_BASE + CM_L4PER_MCSPI1_CLKCTRL, 0x02);
   while (HW_RD_REG32(SOC_L4PER_CM_CORE_BASE + CM_L4PER_MCSPI1_CLKCTRL) !=
           0x02U)
       {
           ;
       }
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_IO_UART1_RXD,0x00040000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_IO_UART1_TXD,0x00000000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_IO_SPI1_CS0,0x00040000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_IO_SPI1_SCLK,0x00040000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_IO_SPI1_D0,0x00040000);
   HW_WR_REG32(SOC_CORE_PAD_IO_REGISTERS_BASE+CTRL_CORE_PAD_IO_SPI1_D1,0x00040000);

   /* IPU1 crossbar */
#if defined (__TI_ARM_V7M4__)
   CSL_xbarIrqConfigure(CSL_XBAR_IRQ_CPU_ID_IPU1, CSL_XBAR_INST_IPU1_IRQ_44, CSL_XBAR_UART1_IRQ);
#elif defined(_TMS320C6X)
   CSL_xbarIrqConfigure(CSL_XBAR_IRQ_CPU_ID_DSP1, CSL_XBAR_INST_DSP1_IRQ_44, CSL_XBAR_UART1_IRQ);
#endif
#endif
}

void spi_initConfig(void)
{
   SPI_v1_HWAttrs spi_cfg;

   /* Get the default UART init configurations */
   SPI_socGetInitCfg(MCSPI_INSTANCE, &spi_cfg);

#ifdef SPI_DMA_ENABLE
  // if (dmaMode == true)
  // {
      printf("\ninside dmaMode\n");
     spi_cfg.edmaHandle = SpiApp_edmaInit();
     spi_cfg.dmaMode = TRUE;
   //}
#endif
   /* Modify the default SPI configurations if necessary */
   spi_cfg.chnCfg[spi_cfg.chNum].dataLineCommMode = MCSPI_DATA_LINE_COMM_MODE_4;

   /* Set the default UART init configurations */
   SPI_socSetInitCfg(MCSPI_INSTANCE, &spi_cfg);
}

int main(void)
{
   Task_Handle task;
   Error_Block eb;

   Error_init(&eb);

   task = Task_create(spi_test, NULL, &eb);
   if (task == NULL) {
       System_printf("Task_create() failed!\n");
       BIOS_exit(0);
   }

   /* Start BIOS */
   BIOS_start();
   return (0);
}

void spi_test(UArg arg0, UArg arg1)
{
   UART_Params      params;
   int32_t retVal, ret;
   SPI_Transaction transaction;
   char echoPrompt[] = "\nMcSPI Internal Loopback test app started";
   char echoPrompt1[] = "\nThe Mode of transfer is Interrupt Mode";
   char echoPrompt2[] = "\nMcSPI Data Transmission is successful";
   char echoPrompt3[] = "\nMcSPI Data Transmission is Failed";

/*Pad configuration and PRCM enable*/
   padConfig_prcmEnable();

#if defined(SOC_TDA3XX)
   AppUtils_defaultInit();
#endif

//   /* Set the UART Parameters */
   UART_init();
   params = gUserParams;
   gUartHandle = UART_open(UART_INSTANCE, &params);
   if(gUartHandle == NULL)
   {
       printf("\nError opening UART driver\n");
   }

   printf("\nMcSPI Internal Loopback test app started\n");
 //   UART_write(gUartHandle,echoPrompt,sizeof(echoPrompt));
   //UART_write(gUartHandle,echoPrompt1,sizeof(echoPrompt1));

    /* Modify the default SPI configurations if necessary */
   spi_initConfig();

   /* Do the necessary set up configurations for McSPI.*/
   SPI_init();
while(1) {
   /* Open MCSPI instance 1 driver */
   gSpiHandle = SPI_open(MCSPI_INSTANCE, &gSpiParams);
   if(gSpiHandle == NULL)
   {
       printf("\nError opening MCSPI driver\n");
   }

   McSPIInitializeBuffers();

#ifdef SPI_DMA_ENABLE
   CacheP_wb((void *)gTxBuffer, (int32_t)McSPI_DATA_COUNT);
   CacheP_wb((void *)gRxBuffer, (int32_t)McSPI_DATA_COUNT);
#endif

   transaction.count = McSPI_DATA_COUNT;
   transaction.txBuf = gTxBuffer;
   transaction.rxBuf = gRxBuffer;

   ret = SPI_transfer(gSpiHandle, &transaction);

#ifdef SPI_DMA_ENABLE
   CacheP_Inv((void *)gRxBuffer, (int32_t)McSPI_DATA_COUNT);
#endif
   if(false == ret)
   {
       printf("\n Error occurred in spi transfer \n");
   }
   else
   {
       retVal = McSPIVerifyData();

     if(retVal != 0)
     {
       printf("\nMcSPI Data Transmission is Failed\n");
       UART_write(gUartHandle,echoPrompt3,sizeof(echoPrompt3));
     }
     else
     {
       printf("\nMcSPI Data Transmission is successful\n");
       UART_write(gUartHandle,echoPrompt2,sizeof(echoPrompt2));
     }
   }

Task_sleep(1000);
   SPI_close(gSpiHandle);
}
}

static void McSPIInitializeBuffers(void)
{
   uint32_t index = 0;

   for (index = 0; index < McSPI_DATA_COUNT; index++)
   {
       /* Initialize the gTxBuffer McSPI1 with a known pattern of data */
           gTxBuffer[index] = index;
       /* Initialize the gRxBuffer McSPI1 with 0 */
       gRxBuffer[index] = (uint32_t) 0;
   }
}

static int32_t McSPIVerifyData(void)
{
   uint32_t index = 0;
   int32_t retVal = 0;

   for (index = 0; index < McSPI_DATA_COUNT; index++)
   {
//      printf("Tx=%d Rx=%d\n",gTxBuffer[index], gRxBuffer[index]);
       if(gRxBuffer[index] !=  gTxBuffer[index])
//           if(gRxBuffer[index] !=   verifybuf[index])//verifybuf
       {
           retVal = -1;
           printf("FAILED Tx=%d Rx=%d\n",gTxBuffer[index], gRxBuffer[index]);
          // break;
       }
   }

   return retVal;
}




#ifdef SPI_DMA_ENABLE

EDMA3_RM_Handle gEdmaHandle = NULL;

/**
* \brief      Function to initialize the edma driver and get the handle to the
*             edma driver;
*
* \param      arg1  [IN]   unused
* \param      arg2  [IN]   unused
*
* \return     None
*/
static EDMA3_RM_Handle SpiApp_edmaInit(void)
{
   EDMA3_DRV_Result edmaResult = EDMA3_DRV_E_INVALID_PARAM;
   uint32_t edma3Id;

   if (gEdmaHandle != NULL)
   {
     return(gEdmaHandle);
   }


#if defined(SOC_AM572x)|| defined(SOC_AM571x) || defined (SOC_DRA72x)  || defined (SOC_DRA75x) || defined (SOC_DRA78x) || defined (SOC_AM335X) || defined (SOC_AM437X)
     edma3Id = 0;
#endif


   gEdmaHandle = (EDMA3_RM_Handle)edma3init(edma3Id, &edmaResult);
   if (edmaResult != EDMA3_DRV_SOK)
   {
          /* Report EDMA Error */
        System_printf("\nEDMA driver initialization FAIL\n");
   }
    else
   {
        System_printf("\nEDMA driver initialization PASS.\n");
   }

           CSL_xbarDmaConfigure(CSL_XBAR_DMA_CPU_ID_EDMA,70,/*CSL_XBAR_DMA_MCSPI1_DREQ_TX0*/69);
           CSL_xbarDmaConfigure(CSL_XBAR_DMA_CPU_ID_EDMA,71,/*CSL_XBAR_DMA_MCSPI1_DREQ_TX0*/70);
    return(gEdmaHandle);
}
#endif

/*****************************End Of File ******************************/

#endif
