/*
 * Copyright (c) 2015-2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== hello.c ========
 */

/* XDC Module Headers */
#include <xdc/std.h>
#include <xdc/runtime/System.h>

/* BIOS Module Headers */
#include <ti/sysbios/BIOS.h>

/* Example/Board Header files */
#include "Board.h"

#include <xdc/runtime/Error.h>

#include <ti/sysbios/family/arm/m3/Hwi.h>
#include <ti/sysbios/family/arm/msp432/Timer.h>

#include <stdbool.h>

void ISR_timer(UArg arg0)
{
    // Timer stuff
}

/*
 *  ======== main ========
 */
Int main()
{
    Timer_Handle timer_hndl = NULL;
    Timer_Params timer_params;
    Error_Block timer_eb;

    Error_init(&timer_eb);


    /* Call board init functions */
    Board_initGeneral();

    System_printf("hello world\n");

    Timer_Params_init(&timer_params);

    timer_params.instance->name  = "Test_Timer";

    timer_params.period          = 1;  // This is configured just before use, so put a dummy value here
                                                     // The period will be on the order of 1-2mSec

    timer_params.periodType      = ti_sysbios_interfaces_ITimer_PeriodType_MICROSECS;
    timer_params.runMode         = ti_sysbios_interfaces_ITimer_RunMode_ONESHOT;
    timer_params.startMode       = ti_sysbios_interfaces_ITimer_StartMode_USER;

    timer_params.clockSource     = ti_sysbios_family_arm_msp432_Timer_Source_SMCLK;
    timer_params.synchronous     = true;   // If true, reads of timer are done directly
                                                         // otherwise reads are done repeatedly until get two same in a row.

    //timer_params.extFreq       // Setup automatically when instance is created, doesn't need user config.

    // Set dividers such that
    //   * the desired period (per .period) can be reached in <= 65536 counts (TimerA's are 16 bit)
    //   * the desired period (per .period) is reached in a whole number of TimerA counts (for maximum accuracy)
    // I'm setting for uSec counts.
    timer_params.inputDivider    = ti_sysbios_family_arm_msp432_Timer_ID_4;
    timer_params.inputDividerExp = ti_sysbios_family_arm_msp432_Timer_IDEX_6;

    timer_params.nesting         = false;

    // Following is only used when Timer_Reconfig() is called otherwise control reg is set based on
    // .clockSouce and .inputDivider
    timer_params.controlRegInit  = timer_params.clockSource;

    // timer_params.prevThreshold   // Is only used by the clock module when it is in dynamic mode
                                                  // (i.e. ti_sysbios_interfaces_ITimer_RunMode_DYNAMIC)
                                                  // For to be used by use created Timer instances

    timer_hndl = Timer_create(1, ISR_timer, &timer_params, &timer_eb);
    if (timer_hndl == NULL)
    {
      // Handle error
    }

    // Timer_create() creates the HWI, here we set the priority
    Hwi_setPriority(timer_hndl->hwi->intNum, (~0));


    /*
     *  normal BIOS programs, would call BIOS_start() to enable interrupts
     *  and start the scheduler and kick BIOS into gear.  But, this program
     *  is a simple sanity test and calls BIOS_exit() instead.
     */
    BIOS_exit(0);  /* terminates program and dumps SysMin output */
    return(0);
}
