
#include <iostream>
#include <VX/vx.h>
#include <VX/vx_api.h>
#include <TI/tivx_img_proc_kernels.h>

#include <app_init.h>

#include "scaler_module.h"
#include "image_wrapper.h"

#define AVP_BUFFER_Q_DEPTH   (2)


void crop_image(vx_context context)
{
    const std::string name_file = "xaa";
    const std::string name_file_output = "xaa_crop";
    vx_status status = VX_SUCCESS;

    tivxHwaLoadKernels(context);
    tivxImgProcLoadKernels(context);
    tivxTIDLLoadKernels(context);

    ScalerObj scaler;
    scaler.input.width  = 1920;
    scaler.input.height = 1080;
    scaler.output_1.width = 512;
    scaler.output_1.height = 512;

    init_scaler(context, &scaler);

    vx_graph graph = vxCreateGraph(context);

    status = vxGetStatus((vx_reference)graph);
    vxSetReferenceName((vx_reference)graph, "avp_graph");

    if(VX_SUCCESS == status)
    {
        printf("graph was created\n");
        status = create_graph_scaler(context, graph, &scaler);
        if (VX_SUCCESS == status)
        {
            printf("scaler was created\n");

            status = verify_graph(&graph, &scaler);
            if (VX_SUCCESS == status)
            {
                printf("graph was verified\n");
                status = readScalerInput(name_file.data(), scaler.input.arr[0], 0);
                if (VX_SUCCESS == status)
                {
                    status = vxProcessGraph(graph);
                    if (VX_SUCCESS == status)
                    {
                        printf("Graph is done!\n");
                        status = writeScalerOutput(name_file_output.data(), scaler.output_1.arr[0]);
                        if (VX_SUCCESS == status)
                        {
                            printf("file was written\n");
                        }
                    }
                }
            }
        }

    }


    deinit_scaler(&scaler);
    delete_scaler(&scaler);

    printf("release Graph\n");
    vxReleaseGraph(&graph);

    tivxTIDLUnLoadKernels(context);
    tivxImgProcUnLoadKernels(context);
    tivxHwaUnLoadKernels(context);
}


int main (void)
{
    if ( VX_SUCCESS == appCommonInit())
    {
        tivxInit();
        tivxHostInit();

        vx_context context = vxCreateContext();
        crop_image(context);
        vxReleaseContext(&context);

        tivxHostDeInit();
        tivxDeInit();
        appCommonDeInit();
    }

    return 0;
}