//
// Created by log on 1/6/23.
//

#include <iostream>

#include "image_wrapper.h"

ImageWrapper::ImageWrapper(vx_image img):img_(img) {}

ImageWrapper::~ImageWrapper(void) {
    ReleaseImage();
}
bool ImageWrapper::ReleaseImage(void) {
    bool answer = true;
    if (img_)
        answer = VX_SUCCESS == vxReleaseImage(&img_);
    img_ = nullptr;
    return answer;
}

vx_image ImageWrapper::GetImage(void)
{
    return img_;
}

bool ImageWrapper::SaveToNV12File(FILE *fp) {
    vx_int32 j;
    vx_status status;
    vx_rectangle_t rect;
    vx_imagepatch_addressing_t image_addr;
    vx_map_id map_id;
    void * data_ptr;
    vx_uint32  img_width;
    vx_uint32  img_height;
    vx_uint32  num_bytes = 0;
    vx_image   out_img = img_;

    vxQueryImage(out_img, VX_IMAGE_WIDTH, &img_width, sizeof(vx_uint32));
    vxQueryImage(out_img, VX_IMAGE_HEIGHT, &img_height, sizeof(vx_uint32));

    rect.start_x = 0;
    rect.start_y = 0;
    rect.end_x = img_width;
    rect.end_y = img_height;
    status = vxMapImagePatch(out_img,
                             &rect,
                             0,
                             &map_id,
                             &image_addr,
                             &data_ptr,
                             VX_READ_ONLY,
                             VX_MEMORY_TYPE_HOST,
                             VX_NOGAP_X);

    if (VX_SUCCESS != status)
    {
        std::cout << "The fail mapping image for saving the Luma. Status:" << status << std::endl;
        return false;
    }
    /* Copy Luma */
    for (j = 0; j < img_height; j++)
    {
        // it from example, but out file bigger, then it mast be
        //num_bytes += fwrite(data_ptr, image_addr.stride_x, img_width, fp);
        num_bytes += fwrite(data_ptr, 1, img_width, fp);
        data_ptr = static_cast<void *>(static_cast<uint8_t*>(data_ptr) + image_addr.stride_y);
    }

    if(num_bytes != (img_width*img_height))
        std::cout <<"Luma bytes written = "<<num_bytes << ", expected = " << img_width*img_height << std::endl;

    vxUnmapImagePatch(out_img, map_id);

    rect.start_x = 0;
    rect.start_y = 0;
    rect.end_x = img_width;
    rect.end_y = img_height / 2;
    status = vxMapImagePatch(out_img,
                             &rect,
                             1,
                             &map_id,
                             &image_addr,
                             &data_ptr,
                             VX_READ_ONLY,
                             VX_MEMORY_TYPE_HOST,
                             VX_NOGAP_X);

    if (VX_SUCCESS != status) {
        std::cout << "The fail mapping image for saving the CbCr. Status:" << status << std::endl;
        return false;
    }

    /* Copy CbCr */
    num_bytes = 0;
    for (j = 0; j < img_height/2; j++)
    {
        // it from example, but out file bigger, then it mast be
        //num_bytes += fwrite(data_ptr, image_addr.stride_x, img_width, fp);
        num_bytes += fwrite(data_ptr, 1, img_width, fp);
        data_ptr = static_cast<void *>(static_cast<uint8_t*>(data_ptr) + image_addr.stride_y);
    }

    if(num_bytes != (img_width*img_height/2))
        std::cout <<"CbCr bytes written = "<<num_bytes << ", expected = " << img_width*img_height/2 << std::endl;

    vxUnmapImagePatch(out_img, map_id);
    return true;
}

bool ImageWrapper::LoadFromNV12File(FILE *fp) {
    vx_int32 j;
    vx_status status;
    vx_rectangle_t rect;
    vx_imagepatch_addressing_t image_addr;
    vx_map_id map_id;
    void * data_ptr;
    vx_uint32  img_width;
    vx_uint32  img_height;
    vx_uint32  num_bytes = 0;
    vx_image   in_img = img_;

    vxQueryImage(in_img, VX_IMAGE_WIDTH, &img_width, sizeof(vx_uint32));
    vxQueryImage(in_img, VX_IMAGE_HEIGHT, &img_height, sizeof(vx_uint32));

    rect.start_x = 0;
    rect.start_y = 0;
    rect.end_x = img_width;
    rect.end_y = img_height;
    status = vxMapImagePatch(in_img,
                             &rect,
                             0,
                             &map_id,
                             &image_addr,
                             &data_ptr,
                             VX_WRITE_ONLY,
                             VX_MEMORY_TYPE_HOST,
                             VX_NOGAP_X);

    if (VX_SUCCESS != status)
    {
        std::cout << "The fail mapping image for loading the Luma. Status:" << status << std::endl;
        return false;
    }

    /* Copy Luma */
    for (j = 0; j < img_height; j++)
    {
        num_bytes += fread(data_ptr, 1, img_width, fp);
        data_ptr = static_cast<void *>(static_cast<uint8_t*>(data_ptr) + image_addr.stride_y);
    }

    if(num_bytes != (img_width*img_height))
        std::cout << "Luma bytes read = " << num_bytes << ", expected = " << img_width*img_height << std::endl;

    vxUnmapImagePatch(in_img, map_id);

    rect.start_x = 0;
    rect.start_y = 0;
    rect.end_x = img_width;
    rect.end_y = img_height / 2;
    status = vxMapImagePatch(in_img,
                             &rect,
                             1,
                             &map_id,
                             &image_addr,
                             &data_ptr,
                             VX_WRITE_ONLY,
                             VX_MEMORY_TYPE_HOST,
                             VX_NOGAP_X);

    if (VX_SUCCESS != status) {
        std::cout << "The fail mapping image for loading the CbCr. Status:" << status << std::endl;
        return false;
    }

    /* Copy CbCr */
    num_bytes = 0;
    for (j = 0; j < img_height/2; j++)
    {
        num_bytes += fread(data_ptr, 1, img_width, fp);
        data_ptr = static_cast<void *>(static_cast<uint8_t*>(data_ptr) + image_addr.stride_y);
    }

    if(num_bytes != (img_width*img_height/2))
        std::cout << "CbCr bytes read = " << num_bytes << ", expected = " << img_width*img_height/2 << std::endl;

    vxUnmapImagePatch(in_img, map_id);

    return true;
}