
#include "pre_proc_module.h"

#include <tiadalg/common/tiadalg_common_data_struct.h>

static void createOutputTensors(vx_context context, /*vx_user_data_object config,*/ vx_tensor output_tensors[]);

#define NUM_BUFFER 1


vx_status init_pre_proc_od(vx_context context, PreProcObj *preProcObj)
{
    const char *objName = "psd_pre_proc_obj";
    vx_status status = VX_SUCCESS;

   vx_enum config_type = VX_TYPE_INVALID;
   config_type = vxRegisterUserStruct(context, sizeof(tivxImgPreProcParams));
   APP_ASSERT(config_type >= VX_TYPE_USER_STRUCT_START && config_type <= VX_TYPE_USER_STRUCT_END);

   preProcObj->config = vxCreateArray(context, config_type, 1);
   APP_ASSERT_VALID_REF(preProcObj->config);

   vx_char ref_name[APP_MAX_FILE_PATH];
   vxAddArrayItems(preProcObj->config, 1, &preProcObj->params, sizeof(tivxImgPreProcParams));
   snprintf(ref_name, APP_MAX_FILE_PATH, "%s_config", objName);
   vxSetReferenceName((vx_reference)preProcObj->config, ref_name);

   return status;
}

vx_status update_pre_proc_od(vx_context context, PreProcObj *preProcObj/*, vx_user_data_object config*/)
{
   vx_status status = VX_SUCCESS;
   vx_tensor output_tensors[APP_MAX_TENSORS];

   createOutputTensors(context, output_tensors);
   preProcObj->output_tensor_arr = vxCreateObjectArray(context, (vx_reference)output_tensors[0], NUM_CH);
   vxReleaseTensor(&output_tensors[0]);

   return status;
}

void deinit_pre_proc_od(PreProcObj *preProcObj)
{
   vxReleaseArray(&preProcObj->config);
   vxReleaseObjectArray(&preProcObj->output_tensor_arr);
}

void delete_pre_proc_od(PreProcObj *preProcObj)
{
   if(preProcObj->node != NULL)
   {
       vxReleaseNode(&preProcObj->node);
   }
}

vx_status create_graph_pre_proc_od(vx_graph graph, PreProcObj *preProcObj, vx_object_array input_im)
{
    vx_status status = VX_SUCCESS;

    vx_image  input   = (vx_image)vxGetObjectArrayItem((vx_object_array)input_im, 0);
    vx_tensor output  = (vx_tensor)vxGetObjectArrayItem((vx_object_array)preProcObj->output_tensor_arr, 0);

    preProcObj->node = tivxImgPreProcNode(graph,
                                         preProcObj->config,
                                         //input_im.GetImage(),
                                          input,
                                         output);

    APP_ASSERT_VALID_REF(preProcObj->node);

    status = vxSetNodeTarget(preProcObj->node, VX_TARGET_STRING, TIVX_TARGET_DSP1);
    vxSetReferenceName((vx_reference)preProcObj->node, "ODPreProcNode");

    vx_bool replicate[] = {vx_false_e, vx_true_e, vx_true_e};
    vxReplicateNode(graph, preProcObj->node, replicate, 3);

    vxReleaseImage(&input);
    vxReleaseTensor(&output);

    return(status);
}

vx_status writePreProcOutput(const char* file_name, vx_object_array output_arr)
{
   vx_status status = VX_SUCCESS;

   vx_tensor output;
   vx_size numCh;
   vx_int32 ch;

   vxQueryObjectArray((vx_object_array)output_arr, VX_OBJECT_ARRAY_NUMITEMS, &numCh, sizeof(vx_size));

   for(ch = 0; ch < numCh; ch++)
   {
       vx_size num_dims;
       void *data_ptr;
       vx_map_id map_id;

       vx_size    start[APP_MAX_TENSOR_DIMS];
       vx_size    tensor_strides[APP_MAX_TENSOR_DIMS];
       vx_size    tensor_sizes[APP_MAX_TENSOR_DIMS];

       output  = (vx_tensor)vxGetObjectArrayItem((vx_object_array)output_arr, ch);

       vxQueryTensor(output, VX_TENSOR_NUMBER_OF_DIMS, &num_dims, sizeof(vx_size));

       if(num_dims != 3)
       {
           printf("Number of dims are != 3! exiting.. \n");
           break;
       }

       vxQueryTensor(output, VX_TENSOR_DIMS, tensor_sizes, 3 * sizeof(vx_size));

       start[0] = start[1] = start[2] = 0;

       tensor_strides[0] = 1;
       tensor_strides[1] = tensor_strides[0];
       tensor_strides[2] = tensor_strides[1] * tensor_strides[1];

       status = tivxMapTensorPatch(output, num_dims, start, tensor_sizes, &map_id, tensor_strides, &data_ptr, VX_READ_ONLY, VX_MEMORY_TYPE_HOST);

       if(VX_SUCCESS == status)
       {
           vx_char new_name[APP_MAX_FILE_PATH];
           snprintf(new_name, APP_MAX_FILE_PATH, "%s_%dx%d_ch%d.rgb", file_name, (uint32_t)tensor_sizes[0], (uint32_t)tensor_sizes[1], ch);

           FILE *fp = fopen(new_name, "wb");
           if(NULL == fp)
           {
               printf("Unable to open file %s for writing!\n", new_name);
               break;
           }

           fwrite(data_ptr, 1, tensor_sizes[0] * tensor_sizes[1] * tensor_sizes[2], fp);
           fclose(fp);

           tivxUnmapTensorPatch(output, map_id);
       }

       vxReleaseTensor(&output);
   }

   return(status);
}

static void createOutputTensors(vx_context context, /*vx_user_data_object config,*/ vx_tensor output_tensors[])
{
   vx_size   input_sizes[APP_MAX_TENSOR_DIMS];

   for(vx_uint32 id = 0; id < NUM_BUFFER; id++)
   {
       input_sizes[0] = DISPLAY_WIDTH;
       input_sizes[1] = DISPLAY_HEIGHT;
       input_sizes[2] = 3;

       vx_enum data_type = get_vx_tensor_datatype(TIDL_UnsignedChar);
       output_tensors[id] = vxCreateTensor(context, 3, input_sizes, data_type, 0);
   }
}

void set_pre_proc_defaults_od(PreProcObj *preProcObj)
{
    for(vx_int32 i = 0; i< 3 ; i++)
    {
       preProcObj->params.scale_val[i] = 1.0;
       preProcObj->params.mean_pixel[i] = 0.0;
       preProcObj->params.pad_pixel[i] = 0;
    }

    preProcObj->params.skip_flag = 0;
    preProcObj->params.clear_count = 0;

    preProcObj->params.ip_rgb_or_yuv = 1;
    preProcObj->params.color_conv_flag = TIADALG_COLOR_CONV_YUV420_BGR;
    preProcObj->params.tidl_8bit_16bit_flag = 0;

    preProcObj->num_input_tensors = NUM_BUFFER;
    preProcObj->num_output_tensors = NUM_BUFFER;
}

