
#ifndef PRE_PROC_MODULE
#define PRE_PROC_MODULE

#include "common.h"
//#include "tiadalg_interface.h"
#include "itidl_ti.h"
#include "image_wrapper.h"

typedef struct {
    vx_node  node;

    vx_array config;
    tivxImgPreProcParams params;

    sTIDL_IOBufDesc_t ioBufDesc;

    vx_uint32 num_input_tensors;
    vx_uint32 num_output_tensors;

    vx_object_array  output_tensor_arr;

    vx_int32 graph_parameter_index;

    vx_char objName[APP_MAX_FILE_PATH];

} PreProcObj;


vx_status create_graph_pre_proc_od(vx_graph graph, PreProcObj *preProcObj, vx_object_array  input_im);

void set_pre_proc_defaults_od(PreProcObj *preProcObj);
vx_status init_pre_proc_od(vx_context context, PreProcObj *preProcObj);
void deinit_pre_proc_od(PreProcObj *obj);
void delete_pre_proc_od(PreProcObj *obj);

vx_status update_pre_proc_od(vx_context context, PreProcObj *preProcObj/*, vx_user_data_object config*/);

vx_status writePreProcOutput(const char* file_name, vx_object_array output_arr);

#endif
