
/* ============================================================================
 *
 *            TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *  Property of Texas Instruments
 *  For Unrestricted Internal Use Only
 *  Unauthorized reproduction and/or distribution is strictly prohibited.
 *  This product is protected under copyright law and trade secret law
 *  as an unpublished work.
 *  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
 *
 */

/**
 *  @Component:   CONTROL
 *
 *  @Filename:    ../../CredDataBase/CONTROL_cred.h
 *
 ============================================================================ */


#ifndef _HW_CONTROL_H_
#define _HW_CONTROL_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CONTROL_REVISION   (0x0)
#define CONTROL_HWINFO   (0x4)
#define CONTROL_SYSCONFIG   (0x10)
#define CONTROL_STATUS   (0x40)
#define CONTROL_BOOTSTAT   (0x44)
#define CONTROL_SEC_CTRL   (0x100)
#define CONTROL_SEC_SW   (0x104)
#define CONTROL_SEC_EMU   (0x108)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG   (0x110)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2   (0x114)
#define CONTROL_SW_CFG   (0x118)
#define CONTROL_SW_CCFG   (0x11c)
#define CONTROL_MPK(n)   (0x120 + (n * 4))
#define CONTROL_SWRV(n)   (0x140 + (n * 4))
#define CONTROL_SEC_TAP   (0x180)
#define CONTROL_SEC_TAP_CMDIN   (0x184)
#define CONTROL_SEC_TAP_CMDOUT   (0x188)
#define CONTROL_SEC_TAP_DATIN   (0x18c)
#define CONTROL_SEC_TAP_DATOUT   (0x190)
#define CONTROL_MREQDOMAIN_EXP1   (0x198)
#define CONTROL_MREQDOMAIN_EXP2   (0x19c)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0   (0x1a0)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1   (0x1a4)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF   (0x1a8)
#define CONTROL_SEC_LOAD_FW_EXP_VAL   (0x1ac)
#define CONTROL_SEC_CTRL_RO   (0x1b4)
#define CONTROL_EMIF_OBFUSCATION_KEY   (0x1b8)
#define CONTROL_SEC_CLK_CTRL   (0x1bc)
#define CONTROL_MREQDOMAIN_EXP3   (0x1d4)
#define CONTROL_CEK(n)   (0x200 + (n * 4))
#define CONTROL_CEK_BCH(n)   (0x210 + (n * 4))
#define CONTROL_MSV_0   (0x224)
#define CONTROL_MSV_BCH(n)   (0x228 + (n * 4))
#define CONTROL_SEC_STATUS   (0x240)
#define CONTROL_SECMEM_STATUS   (0x244)
#define CONTROL_SEC_ERR_STAT_FUNC(n)   (0x248 + (n * 4))
#define CONTROL_SEC_ERR_STAT_DBUG(n)   (0x250 + (n * 4))
#define CONTROL_KEK_SW(n)   (0x260 + (n * 4))
#define CONTROL_CMPK_BCH(n)   (0x280 + (n * 4))
#define CONTROL_CMPK(n)   (0x2b0 + (n * 4))
#define CONTROL_SSM_END_FAST_SECRAM   (0x300)
#define CONTROL_SSM_FIREWALL_CONTROLLER   (0x304)
#define CONTROL_SSM_START_SECURE_STACKED_RAM   (0x308)
#define CONTROL_SSM_END_SECURE_STACKED_RAM   (0x30c)
#define CONTROL_SSM_START_SPM_STACK   (0x310)
#define CONTROL_SSM_END_SPM_STACK   (0x314)
#define CONTROL_SSM_START_MONITOR_RAMCODE   (0x318)
#define CONTROL_SSM_END_MONITOR_RAMCODE   (0x31c)
#define CONTROL_SSM_END_MONITOR_RAMDATA   (0x320)
#define CONTROL_SSM_START_MONITOR_CODE   (0x324)
#define CONTROL_SSM_END_MONITOR_CODE   (0x328)
#define CONTROL_SSM_START_MONITOR_PERIPH   (0x32c)
#define CONTROL_SSM_END_MONITOR_PERIPH   (0x330)
#define CONTROL_SSM_START_MONITOR_STACK   (0x334)
#define CONTROL_SSM_END_MONITOR_STACK   (0x338)
#define CONTROL_SSM_START_MONITOR_RAMCODE_ETM   (0x33c)
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM   (0x340)
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM   (0x344)
#define CONTROL_SSM_START_MONITOR_CODE_ETM   (0x348)
#define CONTROL_SSM_END_MONITOR_CODE_ETM   (0x34c)
#define CONTROL_SSM_START_MONITOR_STACK_ETM   (0x350)
#define CONTROL_SSM_END_MONITOR_STACK_ETM   (0x354)
#define CONTROL_SSM_START_MONITOR_SHARED_ETM   (0x358)
#define CONTROL_SSM_END_MONITOR_SHARED_ETM   (0x35c)
#define CONTROL_SSM_START_MONITOR_PERIPH_ETM   (0x360)
#define CONTROL_SSM_END_MONITOR_PERIPH_ETM   (0x364)
#define CONTROL_SSM_CPSR_MODE_ENFC   (0x368)
#define CONTROL_SSM_END_L3_SECRAM   (0x36c)
#define CONTROL_CORTEX_VBBLDO_CTRL   (0x41c)
#define CONTROL_CORE_SLDO_CTRL   (0x428)
#define CONTROL_MPU_SLDO_CTRL   (0x42c)
#define CONTROL_REFCLK_LJCBLDO_CTRL   (0x440)
#define CONTROL_CLK32KDIVRATIO_CTRL   (0x444)
#define CONTROL_BANDGAP_CTRL   (0x448)
#define CONTROL_BANDGAP_TRIM   (0x44c)
#define CONTROL_PLL_CLKINPULOW_CTRL   (0x458)
#define CONTROL_MOSC_CTRL   (0x468)
#define CONTROL_RCOSC_CTRL   (0x46c)
#define CONTROL_DEEPSLEEP_CTRL   (0x470)
#define CONTROL_PE_SCRATCHPAD(n)   (0x500 + (n * 4))
#define CONTROL_DEVICE_ID   (0x600)
#define CONTROL_DEV_FEATURE   (0x604)
#define CONTROL_INIT_PRIORITY(n)   (0x608 + (n * 4))
#define CONTROL_MMU_CFG   (0x610)
#define CONTROL_TPTC_CFG   (0x614)
#define CONTROL_OCMC_CFG   (0x618)
#define CONTROL_USB_CTRL(n)   (0x620 + (n * 8))
#define CONTROL_USB_STS(n)   (0x624 + (n * 8))
#define CONTROL_MAC_ID_LO(n)   (0x630 + (n * 8))
#define CONTROL_MAC_ID_HI(n)   (0x634 + (n * 8))
#define CONTROL_DCAN_RAMINIT   (0x644)
#define CONTROL_USB_WKUP_CTRL   (0x648)
#define CONTROL_GMII_SEL   (0x650)
#define CONTROL_PWMSS_CTRL   (0x664)
#define CONTROL_MREQPRIO(n)   (0x670 + (n * 4))
#define CONTROL_HW_EVENT_SEL_GRP(n)   (0x690 + (n * 4))
#define CONTROL_SMRT_CTRL   (0x6a0)
#define CONTROL_SABTOOTH_HW_DEBUG_SEL   (0x6a4)
#define CONTROL_SABTOOTH_HW_DBG_INFO   (0x6a8)
#define CONTROL_MRGN_MODE(n)   (0x6c0 + (n * 4))
#define CONTROL_VDD_MPU_OPP(n)   (0x770 + (n * 4))
#define CONTROL_VDD_MPU_OPP_TURBO   (0x77c)
#define CONTROL_VDD_CORE_OPP(n)   (0x7b8 + (n * 4))
#define CONTROL_BB_SCALE   (0x7d0)
#define CONTROL_USB_VID_PID   (0x7f4)
#define CONTROL_EFUSE_SMA   (0x7fc)
#define CONTROL_CONF_GPMC_AD(n)   (0x800 + (n * 4))
#define CONTROL_CONF_GPMC_A(n)   (0x840 + (n * 4))
#define CONTROL_CONF_GPMC_WAIT0   (0x870)
#define CONTROL_CONF_GPMC_WPN   (0x874)
#define CONTROL_CONF_GPMC_BE1N   (0x878)
#define CONTROL_CONF_GPMC_CSN(n)   (0x87c + (n * 4))
#define CONTROL_CONF_GPMC_CLK   (0x88c)
#define CONTROL_CONF_GPMC_ADVN_ALE   (0x890)
#define CONTROL_CONF_GPMC_OEN_REN   (0x894)
#define CONTROL_CONF_GPMC_WEN   (0x898)
#define CONTROL_CONF_GPMC_BE0N_CLE   (0x89c)
#define CONTROL_CONF_LCD_DATA(n)   (0x8a0 + (n * 4))
#define CONTROL_CONF_LCD_VSYNC   (0x8e0)
#define CONTROL_CONF_LCD_HSYNC   (0x8e4)
#define CONTROL_CONF_LCD_PCLK   (0x8e8)
#define CONTROL_CONF_LCD_AC_BIAS_EN   (0x8ec)
#define CONTROL_CONF_MMC0_DAT3   (0x8f0)
#define CONTROL_CONF_MMC0_DAT2   (0x8f4)
#define CONTROL_CONF_MMC0_DAT1   (0x8f8)
#define CONTROL_CONF_MMC0_DAT0   (0x8fc)
#define CONTROL_CONF_MMC0_CLK   (0x900)
#define CONTROL_CONF_MMC0_CMD   (0x904)
#define CONTROL_CONF_MII1_COL   (0x908)
#define CONTROL_CONF_MII1_CRS   (0x90c)
#define CONTROL_CONF_MII1_RXERR   (0x910)
#define CONTROL_CONF_MII1_TXEN   (0x914)
#define CONTROL_CONF_MII1_RXDV   (0x918)
#define CONTROL_CONF_MII1_TXD3   (0x91c)
#define CONTROL_CONF_MII1_TXD2   (0x920)
#define CONTROL_CONF_MII1_TXD1   (0x924)
#define CONTROL_CONF_MII1_TXD0   (0x928)
#define CONTROL_CONF_MII1_TXCLK   (0x92c)
#define CONTROL_CONF_MII1_RXCLK   (0x930)
#define CONTROL_CONF_MII1_RXD3   (0x934)
#define CONTROL_CONF_MII1_RXD2   (0x938)
#define CONTROL_CONF_MII1_RXD1   (0x93c)
#define CONTROL_CONF_MII1_RXD0   (0x940)
#define CONTROL_CONF_RMII1_REFCLK   (0x944)
#define CONTROL_CONF_MDIO_DATA   (0x948)
#define CONTROL_CONF_MDIO_CLK   (0x94c)
#define CONTROL_CONF_SPI0_SCLK   (0x950)
#define CONTROL_CONF_SPI0_D0   (0x954)
#define CONTROL_CONF_SPI0_D1   (0x958)
#define CONTROL_CONF_SPI0_CS0   (0x95c)
#define CONTROL_CONF_SPI0_CS1   (0x960)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT   (0x964)
#define CONTROL_CONF_UART_CTSN(n)   (0x968 + ((n) * 0x10))
#define CONTROL_CONF_UART_RTSN(n)   (0x96c + ((n) * 0x10))
#define CONTROL_CONF_UART_RXD(n)   (0x970 + ((n) * 0x10))
#define CONTROL_CONF_UART_TXD(n)   (0x974 + ((n) * 0x10))
#define CONTROL_CONF_I2C0_SDA   (0x988)
#define CONTROL_CONF_I2C0_SCL   (0x98c)
#define CONTROL_CONF_MCASP0_ACLKX   (0x990)
#define CONTROL_CONF_MCASP0_FSX   (0x994)
#define CONTROL_CONF_MCASP0_AXR0   (0x998)
#define CONTROL_CONF_MCASP0_AHCLKR   (0x99c)
#define CONTROL_CONF_MCASP0_ACLKR   (0x9a0)
#define CONTROL_CONF_MCASP0_FSR   (0x9a4)
#define CONTROL_CONF_MCASP0_AXR1   (0x9a8)
#define CONTROL_CONF_MCASP0_AHCLKX   (0x9ac)
#define CONTROL_CONF_XDMA_EVENT_INTR(n)   (0x9b0 + (n * 4))
#define CONTROL_CONF_NRESETIN_OUT   (0x9b8)
#define CONTROL_CONF_PORZ   (0x9bc)
#define CONTROL_CONF_NNMI   (0x9c0)
#define CONTROL_CONF_OSC_IN(n)   (0x9c4 + (n * 0x24))
#define CONTROL_CONF_OSC_OUT(n)   (0x9c8 + (n * 0x24))
#define CONTROL_CONF_OSC_VSS(n)   (0x9cc + (n * 0x24))
#define CONTROL_CONF_TMS   (0x9d0)
#define CONTROL_CONF_TDI   (0x9d4)
#define CONTROL_CONF_TDO   (0x9d8)
#define CONTROL_CONF_TCK   (0x9dc)
#define CONTROL_CONF_NTRST   (0x9e0)
#define CONTROL_CONF_EMU(n)   (0x9e4 + (n * 4))
#define CONTROL_CONF_RTC_PORZ   (0x9f8)
#define CONTROL_CONF_PMIC_POWER_EN   (0x9fc)
#define CONTROL_CONF_EXT_WAKEUP   (0xa00)
#define CONTROL_CONF_ENZ_KALDO_1P8V   (0xa04)
#define CONTROL_CONF_USB_DM(n)   (0xa08 + ((n) * 0x18))
#define CONTROL_CONF_USB_DP(n)   (0xa0c + ((n) * 0x18))
#define CONTROL_CONF_USB_CE(n)   (0xa10 + ((n) * 0x18))
#define CONTROL_CONF_USB_ID(n)   (0xa14 + ((n) * 0x18))
#define CONTROL_CONF_USB_VBUS(n)   (0xa18 + ((n) * 0x18))
#define CONTROL_CONF_USB_DRVVBUS(n)   (0xa1c + ((n) * 0x18))
#define CONTROL_CONF_DDR_RESETN   (0xa38)
#define CONTROL_CONF_DDR_CSN0   (0xa3c)
#define CONTROL_CONF_DDR_CKE   (0xa40)
#define CONTROL_CONF_DDR_CK    (0xa44)
#define CONTROL_CONF_DDR_NCK   (0xa48)
#define CONTROL_CONF_DDR_CASN   (0xa4c)
#define CONTROL_CONF_DDR_RASN   (0xa50)
#define CONTROL_CONF_DDR_WEN   (0xa54)
#define CONTROL_CONF_DDR_BA(n)   (0xa58 + (n * 4))
#define CONTROL_CONF_DDR_A(n)   (0xa64 + (n * 4))
#define CONTROL_CONF_DDR_ODT   (0xaa4)
#define CONTROL_CONF_DDR_D(n)   (0xaa8 + (n * 4))
#define CONTROL_CONF_DDR_DQM(n)   (0xae8 + (n * 4))
#define CONTROL_CONF_DDR_DQS(n)   (0xaf0 + (n * 8))
#define CONTROL_CONF_DDR_DQSN(n)   (0xaf4 + (n * 8))
#define CONTROL_CONF_DDR_VREF   (0xb00)
#define CONTROL_CONF_DDR_VTP   (0xb04)
#define CONTROL_CONF_DDR_STRBEN(n)   (0xb08 + (n * 4))
#define CONTROL_CONF_AIN0    (0xb2c)
#define CONTROL_CONF_AIN1    (0xb28)
#define CONTROL_CONF_AIN2    (0xb24)
#define CONTROL_CONF_AIN3    (0xb20)
#define CONTROL_CONF_AIN4    (0xb1c)
#define CONTROL_CONF_AIN5    (0xb18)
#define CONTROL_CONF_AIN6    (0xb14)
#define CONTROL_CONF_AIN7    (0xb10)
#define CONTROL_CONF_VREFP   (0xb30)
#define CONTROL_CONF_VREFN   (0xb34)
#define CONTROL_CONF_AVDD   (0xb38)
#define CONTROL_CONF_AVSS   (0xb3c)
#define CONTROL_CONF_IFORCE   (0xb40)
#define CONTROL_CONF_VSENSE   (0xb44)
#define CONTROL_CONF_TESTOUT   (0xb48)
#define CONTROL_CQDETECT_STATUS   (0xe00)
#define CONTROL_DDR_IO_CTRL   (0xe04)
#define CONTROL_VTP_CTRL   (0xe0c)
#define CONTROL_VREF_CTRL   (0xe14)
#define CONTROL_SERDES_REFCLK_CTL   (0xe24)
#define CONTROL_TPCC_EVT_MUX_0_3   (0xf90)
#define CONTROL_TPCC_EVT_MUX_4_7   (0xf94)
#define CONTROL_TPCC_EVT_MUX_8_11   (0xf98)
#define CONTROL_TPCC_EVT_MUX_12_15   (0xf9c)
#define CONTROL_TPCC_EVT_MUX_16_19   (0xfa0)
#define CONTROL_TPCC_EVT_MUX_20_23   (0xfa4)
#define CONTROL_TPCC_EVT_MUX_24_27   (0xfa8)
#define CONTROL_TPCC_EVT_MUX_28_31   (0xfac)
#define CONTROL_TPCC_EVT_MUX_32_35   (0xfb0)
#define CONTROL_TPCC_EVT_MUX_36_39   (0xfb4)
#define CONTROL_TPCC_EVT_MUX_40_43   (0xfb8)
#define CONTROL_TPCC_EVT_MUX_44_47   (0xfbc)
#define CONTROL_TPCC_EVT_MUX_48_51   (0xfc0)
#define CONTROL_TPCC_EVT_MUX_52_55   (0xfc4)
#define CONTROL_TPCC_EVT_MUX_56_59   (0xfc8)
#define CONTROL_TPCC_EVT_MUX_60_63   (0xfcc)
#define CONTROL_TIMER_EVT_CAPT   (0xfd0)
#define CONTROL_ECAP_EVT_CAPT   (0xfd4)
#define CONTROL_ADC_EVT_CAPT   (0xfd8)
#define CONTROL_RESET_ISO   (0x1000)
#define CONTROL_SMA(n)   (0x1318 + (n * 8))
#define CONTROL_DDR_CKE_CTRL   (0x131c)
#define CONTROL_M3_TXEV_EOI   (0x1324)
#define CONTROL_IPC_MSG_REG(n)   (0x1328 + (n * 4))
#define CONTROL_DDR_CMD_IOCTRL(n)   (0x1404 + (n * 4))
#define CONTROL_DDR_DATA_IOCTRL(n)   (0x1440 + (n * 4))
#define CONTROL_DIE_ID2   (0x1824)
#define CONTROL_ID_UNLOCK1   (0x1828)
#define CONTROL_ID_UNLOCK2   (0x182c)
#define CONTROL_DIE_ID0   (0x183c)
#define CONTROL_ID_UNLOCK0   (0x1844)
#define CONTROL_DIE_ID1   (0x1848)
#define CONTROL_ID_UNLOCK3   (0x184c)
#define CONTROL_DIE_ID3   (0x1850)


#define CONTROL_CONF_PULLUDDISABLE     0x00000008 
#define CONTROL_CONF_PULLUPSEL         0x00000010
#define CONTROL_CONF_RXACTIVE          0x00000020 
#define CONTROL_CONF_SLOWSLEW          0x00000040
#define CONTROL_CONF_MUXMODE(n)        (n)


/**************************************************************************
 * Field Definition Macros
 **************************************************************************/

/* CONTROL_REVISION */
#define CONTROL_REVISION_IP_REV_CUSTOM   (0x000000C0u)
#define CONTROL_REVISION_IP_REV_CUSTOM_SHIFT   (0x00000006u)

#define CONTROL_REVISION_IP_REV_FUNC   (0x0FFF0000u)
#define CONTROL_REVISION_IP_REV_FUNC_SHIFT   (0x00000010u)

#define CONTROL_REVISION_IP_REV_MAJOR   (0x00000700u)
#define CONTROL_REVISION_IP_REV_MAJOR_SHIFT   (0x00000008u)

#define CONTROL_REVISION_IP_REV_MINOR   (0x0000003Fu)
#define CONTROL_REVISION_IP_REV_MINOR_SHIFT   (0x00000000u)

#define CONTROL_REVISION_IP_REV_RTL   (0x0000F800u)
#define CONTROL_REVISION_IP_REV_RTL_SHIFT   (0x0000000Bu)

#define CONTROL_REVISION_IP_REV_SCHEME   (0xC0000000u)
#define CONTROL_REVISION_IP_REV_SCHEME_SHIFT   (0x0000001Eu)


/* CONTROL_HWINFO */
#define CONTROL_HWINFO_IP_HWINFO   (0xFFFFFFFFu)
#define CONTROL_HWINFO_IP_HWINFO_SHIFT   (0x00000000u)


/* CONTROL_SYSCONFIG */
#define CONTROL_SYSCONFIG_FREEEMU   (0x00000002u)
#define CONTROL_SYSCONFIG_FREEEMU_SHIFT   (0x00000001u)

#define CONTROL_SYSCONFIG_IDLEMODE   (0x0000000Cu)
#define CONTROL_SYSCONFIG_IDLEMODE_SHIFT   (0x00000002u)

#define CONTROL_SYSCONFIG_RSVD2   (0xFFFFFFC0u)
#define CONTROL_SYSCONFIG_RSVD2_SHIFT   (0x00000006u)

#define CONTROL_SYSCONFIG_STANDBY   (0x00000030u)
#define CONTROL_SYSCONFIG_STANDBY_SHIFT   (0x00000004u)


/* CONTROL_STATUS */
#define CONTROL_STATUS_ADMUX   (0x000C0000u)
#define CONTROL_STATUS_ADMUX_SHIFT   (0x00000012u)

#define CONTROL_STATUS_BW   (0x00010000u)
#define CONTROL_STATUS_BW_SHIFT   (0x00000010u)

#define CONTROL_STATUS_DEVTYPE   (0x00000700u)
#define CONTROL_STATUS_DEVTYPE_SHIFT   (0x00000008u)

#define CONTROL_STATUS_RSVD2   (0xFF000000u)
#define CONTROL_STATUS_RSVD2_SHIFT   (0x00000018u)

#define CONTROL_STATUS_SYSBOOT0   (0x000000FFu)
#define CONTROL_STATUS_SYSBOOT0_SHIFT   (0x00000000u)

#define CONTROL_STATUS_SYSBOOT1   (0x00C00000u)
#define CONTROL_STATUS_SYSBOOT1_SHIFT   (0x00000016u)

#define CONTROL_STATUS_TESTMD   (0x00300000u)
#define CONTROL_STATUS_TESTMD_SHIFT   (0x00000014u)

#define CONTROL_STATUS_WAITEN   (0x00020000u)
#define CONTROL_STATUS_WAITEN_SHIFT   (0x00000011u)


/* BOOTSTAT */
#define CONTROL_BOOTSTAT_BC   (0x00000001u)
#define CONTROL_BOOTSTAT_BC_SHIFT   (0x00000000u)

#define CONTROL_BOOTSTAT_BOOTERR   (0x000F0000u)
#define CONTROL_BOOTSTAT_BOOTERR_SHIFT   (0x00000010u)

#define CONTROL_BOOTSTAT_RSVD2   (0xFFF00000u)
#define CONTROL_BOOTSTAT_RSVD2_SHIFT   (0x00000014u)


/* CONTROL_SEC_CTRL */
#define CONTROL_SEC_CTRL_BSCENABLE   (0x00000200u)
#define CONTROL_SEC_CTRL_BSCENABLE_SHIFT   (0x00000009u)

#define CONTROL_SEC_CTRL_CATSCANEN   (0x00000100u)
#define CONTROL_SEC_CTRL_CATSCANEN_SHIFT   (0x00000008u)

#define CONTROL_SEC_CTRL_CMPKEFUSENOTDEC   (0x00002000u)
#define CONTROL_SEC_CTRL_CMPKEFUSENOTDEC_SHIFT   (0x0000000Du)

#define CONTROL_SEC_CTRL_CPEFUSELDDONE   (0x00000400u)
#define CONTROL_SEC_CTRL_CPEFUSELDDONE_SHIFT   (0x0000000Au)

#define CONTROL_SEC_CTRL_CPEFUSENOTDEC   (0x00001000u)
#define CONTROL_SEC_CTRL_CPEFUSENOTDEC_SHIFT   (0x0000000Cu)

#define CONTROL_SEC_CTRL_CPEFUSEWRDIS   (0x00000800u)
#define CONTROL_SEC_CTRL_CPEFUSEWRDIS_SHIFT   (0x0000000Bu)

#define CONTROL_SEC_CTRL_DMLEDCOREEN   (0x00000080u)
#define CONTROL_SEC_CTRL_DMLEDCOREEN_SHIFT   (0x00000007u)

#define CONTROL_SEC_CTRL_FASTOCMSECSAVE   (0x30000000u)
#define CONTROL_SEC_CTRL_FASTOCMSECSAVE_SHIFT   (0x0000001Cu)

#define CONTROL_SEC_CTRL_KEKSWENABLE0   (0x00000004u)
#define CONTROL_SEC_CTRL_KEKSWENABLE0_SHIFT   (0x00000002u)

#define CONTROL_SEC_CTRL_KEKSWENABLE1   (0x00000010u)
#define CONTROL_SEC_CTRL_KEKSWENABLE1_SHIFT   (0x00000004u)

#define CONTROL_SEC_CTRL_L3OCMSECSAVE   (0x0C000000u)
#define CONTROL_SEC_CTRL_L3OCMSECSAVE_SHIFT   (0x0000001Au)

#define CONTROL_SEC_CTRL_RSVD2   (0x00000060u)
#define CONTROL_SEC_CTRL_RSVD2_SHIFT   (0x00000005u)

#define CONTROL_SEC_CTRL_SECCTRLWRDISABLE   (0x80000000u)
#define CONTROL_SEC_CTRL_SECCTRLWRDISABLE_SHIFT   (0x0000001Fu)

#define CONTROL_SEC_CTRL_SECUREMODEINITDONE   (0x40000000u)
#define CONTROL_SEC_CTRL_SECUREMODEINITDONE_SHIFT   (0x0000001Eu)

#define CONTROL_SEC_CTRL_WDOPDISABLE   (0x00000001u)
#define CONTROL_SEC_CTRL_WDOPDISABLE_SHIFT   (0x00000000u)

#define CONTROL_SEC_CTRL_WDREGENABLE   (0x00000002u)
#define CONTROL_SEC_CTRL_WDREGENABLE_SHIFT   (0x00000001u)


/* CONTROL_SEC_SW */
#define CONTROL_SEC_SW_SW_HW_PARAMETERS   (0xFFFFFFFFu)
#define CONTROL_SEC_SW_SW_HW_PARAMETERS_SHIFT   (0x00000000u)


/* CONTROL_SEC_EMU */
#define CONTROL_SEC_EMU_ETMSECPRIVDBGEN   (0x00001000u)
#define CONTROL_SEC_EMU_ETMSECPRIVDBGEN_SHIFT   (0x0000000Cu)

#define CONTROL_SEC_EMU_GENDBGEN   (0x00000FFFu)
#define CONTROL_SEC_EMU_GENDBGEN_SHIFT   (0x00000000u)

#define CONTROL_SEC_EMU_GENDBGEN_M3   (0x0000C000u)
#define CONTROL_SEC_EMU_GENDBGEN_M3_SHIFT   (0x0000000Eu)

#define CONTROL_SEC_EMU_ICESECPRIVDBGEN   (0x00002000u)
#define CONTROL_SEC_EMU_ICESECPRIVDBGEN_SHIFT   (0x0000000Du)

#define CONTROL_SEC_EMU_SECEMUWRDIS   (0x80000000u)
#define CONTROL_SEC_EMU_SECEMUWRDIS_SHIFT   (0x0000001Fu)


/* SECURE_EMIF_SDRAM_CONFIG */
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CL   (0x00003C00u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CL_SHIFT   (0x0000000Au)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CWL   (0x00030000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_CWL_SHIFT   (0x00000010u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DDR_TERM   (0x07000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DDR_TERM_SHIFT   (0x00000018u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DYN_ODT   (0x00600000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_DYN_ODT_SHIFT   (0x00000015u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_EBANK   (0x00000008u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_EBANK_SHIFT   (0x00000003u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK   (0x00000070u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK_SHIFT   (0x00000004u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK_POS   (0x18000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_IBANK_POS_SHIFT   (0x0000001Bu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_NARROW_MODE   (0x0000C000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_NARROW_MODE_SHIFT   (0x0000000Eu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_PAGESIZE   (0x00000007u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_PAGESIZE_SHIFT   (0x00000000u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_ROWSIZE   (0x00000380u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_ROWSIZE_SHIFT   (0x00000007u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_RSVD2   (0x00800000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_RSVD2_SHIFT   (0x00000017u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_DRIVE   (0x000C0000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_DRIVE_SHIFT   (0x00000012u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_TYPE   (0xE0000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_SDRAM_TYPE_SHIFT   (0x0000001Du)


/* SECURE_EMIF_SDRAM_CONFIG_2 */
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_CS1_NVMEN   (0x40000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_CS1_NVMEN_SHIFT   (0x0000001Eu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_EBANK_POS   (0x08000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_EBANK_POS_SHIFT   (0x0000001Bu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBNUM   (0x00000030u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBNUM_SHIFT   (0x00000004u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBSIZE   (0x00000007u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RDBSIZE_SHIFT   (0x00000000u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RSVD2   (0x07FFFFC0u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RSVD2_SHIFT   (0x00000006u)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RSVD3   (0x30000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RSVD3_SHIFT   (0x0000001Cu)

#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RSVD4   (0x80000000u)
#define CONTROL_SECURE_EMIF_SDRAM_CONFIG_2_RSVD4_SHIFT   (0x0000001Fu)


/* CONTROL_SW_CFG */
#define CONTROL_SW_CFG_SW_CFG   (0xFFFFFFFFu)
#define CONTROL_SW_CFG_SW_CFG_SHIFT   (0x00000000u)


/* CONTROL_SW_CCFG */
#define CONTROL_SW_CCFG_SW_CCFG   (0x0000FFFFu)
#define CONTROL_SW_CCFG_SW_CCFG_SHIFT   (0x00000000u)

#define CONTROL_SW_CCFG_SW_CCFG_RED   (0xFFFF0000u)
#define CONTROL_SW_CCFG_SW_CCFG_RED_SHIFT   (0x00000010u)


/* CONTROL_MPK_0 */
#define CONTROL_MPK_0_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_0_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_1 */
#define CONTROL_MPK_1_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_1_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_2 */
#define CONTROL_MPK_2_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_2_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_3 */
#define CONTROL_MPK_3_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_3_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_4 */
#define CONTROL_MPK_4_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_4_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_5 */
#define CONTROL_MPK_5_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_5_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_6 */
#define CONTROL_MPK_6_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_6_MPK_SHIFT   (0x00000000u)


/* CONTROL_MPK_7 */
#define CONTROL_MPK_7_MPK   (0xFFFFFFFFu)
#define CONTROL_MPK_7_MPK_SHIFT   (0x00000000u)


/* CONTROL_SWRV_0 */
#define CONTROL_SWRV_0_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_0_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_0_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_0_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SWRV_1 */
#define CONTROL_SWRV_1_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_1_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_1_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_1_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SWRV_2 */
#define CONTROL_SWRV_2_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_2_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_2_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_2_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SWRV_3 */
#define CONTROL_SWRV_3_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_3_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_3_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_3_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SWRV_4 */
#define CONTROL_SWRV_4_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_4_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_4_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_4_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SWRV_5 */
#define CONTROL_SWRV_5_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_5_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_5_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_5_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SWRV_6 */
#define CONTROL_SWRV_6_SWRV   (0x0000FFFFu)
#define CONTROL_SWRV_6_SWRV_SHIFT   (0x00000000u)

#define CONTROL_SWRV_6_SWRV_RED   (0xFFFF0000u)
#define CONTROL_SWRV_6_SWRV_RED_SHIFT   (0x00000010u)


/* CONTROL_SEC_TAP */
#define CONTROL_SEC_TAP_1500EN   (0x00000008u)
#define CONTROL_SEC_TAP_1500EN_SHIFT   (0x00000003u)

#define CONTROL_SEC_TAP_DAPTAPEN   (0x00000001u)
#define CONTROL_SEC_TAP_DAPTAPEN_SHIFT   (0x00000000u)

#define CONTROL_SEC_TAP_PART1500DIS   (0x00000010u)
#define CONTROL_SEC_TAP_PART1500DIS_SHIFT   (0x00000004u)

#define CONTROL_SEC_TAP_RSVD2   (0x000001E0u)
#define CONTROL_SEC_TAP_RSVD2_SHIFT   (0x00000005u)

#define CONTROL_SEC_TAP_RSVD3   (0x7FFFFC00u)
#define CONTROL_SEC_TAP_RSVD3_SHIFT   (0x0000000Au)

#define CONTROL_SEC_TAP_SABERMPUTAPEN   (0x00000200u)
#define CONTROL_SEC_TAP_SABERMPUTAPEN_SHIFT   (0x00000009u)

#define CONTROL_SEC_TAP_SECTAPWRDISABLE   (0x80000000u)
#define CONTROL_SEC_TAP_SECTAPWRDISABLE_SHIFT   (0x0000001Fu)

#define CONTROL_SEC_TAP_WAKEUPTAPEN   (0x00000004u)
#define CONTROL_SEC_TAP_WAKEUPTAPEN_SHIFT   (0x00000002u)


/* CONTROL_SEC_TAP_CMDIN */
#define CONTROL_SEC_TAP_CMDIN_CMDIN   (0x000000FFu)
#define CONTROL_SEC_TAP_CMDIN_CMDIN_SHIFT   (0x00000000u)


/* CONTROL_SEC_TAP_CMDOUT */
#define CONTROL_SEC_TAP_CMDOUT_CMDOUT   (0x000000FFu)
#define CONTROL_SEC_TAP_CMDOUT_CMDOUT_SHIFT   (0x00000000u)


/* CONTROL_SEC_TAP_DATIN */
#define CONTROL_SEC_TAP_DATIN_DATAIN   (0x000000FFu)
#define CONTROL_SEC_TAP_DATIN_DATAIN_SHIFT   (0x00000000u)


/* CONTROL_SEC_TAP_DATOUT */
#define CONTROL_SEC_TAP_DATOUT_DATAOUT   (0x000000FFu)
#define CONTROL_SEC_TAP_DATOUT_DATAOUT_SHIFT   (0x00000000u)


/* CONTROL_MREQDOMAIN_EXP1 */
#define CONTROL_MREQDOMAIN_EXP1_2DBITBLT_DOM   (0x001C0000u)
#define CONTROL_MREQDOMAIN_EXP1_2DBITBLT_DOM_SHIFT   (0x00000012u)

#define CONTROL_MREQDOMAIN_EXP1_L3_EXP_DOM   (0x00000007u)
#define CONTROL_MREQDOMAIN_EXP1_L3_EXP_DOM_SHIFT   (0x00000000u)

#define CONTROL_MREQDOMAIN_EXP1_LCD_CTRL_DOM   (0x00038000u)
#define CONTROL_MREQDOMAIN_EXP1_LCD_CTRL_DOM_SHIFT   (0x0000000Fu)

#define CONTROL_MREQDOMAIN_EXP1_LCK   (0x80000000u)
#define CONTROL_MREQDOMAIN_EXP1_LCK_SHIFT   (0x0000001Fu)

#define CONTROL_MREQDOMAIN_EXP1_MLB_DOM   (0x00007000u)
#define CONTROL_MREQDOMAIN_EXP1_MLB_DOM_SHIFT   (0x0000000Cu)

#define CONTROL_MREQDOMAIN_EXP1_RSVD2   (0x78000000u)
#define CONTROL_MREQDOMAIN_EXP1_RSVD2_SHIFT   (0x0000001Bu)

#define CONTROL_MREQDOMAIN_EXP1_SGX_DOM   (0x07000000u)
#define CONTROL_MREQDOMAIN_EXP1_SGX_DOM_SHIFT   (0x00000018u)

#define CONTROL_MREQDOMAIN_EXP1_WAKE_DOM   (0x00E00000u)
#define CONTROL_MREQDOMAIN_EXP1_WAKE_DOM_SHIFT   (0x00000015u)


/* CONTROL_MREQDOMAIN_EXP2 */
#define CONTROL_MREQDOMAIN_EXP2_GEMAC_DOM   (0x001C0000u)
#define CONTROL_MREQDOMAIN_EXP2_GEMAC_DOM_SHIFT   (0x00000012u)

#define CONTROL_MREQDOMAIN_EXP2_LCK   (0x80000000u)
#define CONTROL_MREQDOMAIN_EXP2_LCK_SHIFT   (0x0000001Fu)

#define CONTROL_MREQDOMAIN_EXP2_P1500_DOM   (0x00038000u)
#define CONTROL_MREQDOMAIN_EXP2_P1500_DOM_SHIFT   (0x0000000Fu)

#define CONTROL_MREQDOMAIN_EXP2_RSVD2   (0x7FE00000u)
#define CONTROL_MREQDOMAIN_EXP2_RSVD2_SHIFT   (0x00000015u)

#define CONTROL_MREQDOMAIN_EXP2_USB0_DOM   (0x00000E00u)
#define CONTROL_MREQDOMAIN_EXP2_USB0_DOM_SHIFT   (0x00000009u)

#define CONTROL_MREQDOMAIN_EXP2_USB1_DOM   (0x00007000u)
#define CONTROL_MREQDOMAIN_EXP2_USB1_DOM_SHIFT   (0x0000000Cu)


/* L3_HW_FW_EXP_VAL_CONF0 */
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECDBG_EN   (0x00040000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECDBG_EN_SHIFT   (0x00000012u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECLOCK_EN   (0x00000004u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3EXP_SECLOCK_EN_SHIFT   (0x00000002u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECDBG_EN   (0x01000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECDBG_EN_SHIFT   (0x00000018u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECLOCK_EN   (0x00000100u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_L3RAM_SECLOCK_EN_SHIFT   (0x00000008u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD2   (0x00000020u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD2_SHIFT   (0x00000005u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD3   (0x00000200u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD3_SHIFT   (0x00000009u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD4   (0x0003F800u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD4_SHIFT   (0x0000000Bu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD5   (0x00200000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD5_SHIFT   (0x00000015u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD6   (0x02000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD6_SHIFT   (0x00000019u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD7   (0xF8000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_RSVD7_SHIFT   (0x0000001Bu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECDBG_EN   (0x00800000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECDBG_EN_SHIFT   (0x00000017u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECLOCK_EN   (0x00000080u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_SGX_SECLOCK_EN_SHIFT   (0x00000007u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECDBG_EN   (0x00100000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECDBG_EN_SHIFT   (0x00000014u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECLOCK_EN   (0x00000010u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPCC_SECLOCK_EN_SHIFT   (0x00000004u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECDBG_EN   (0x00080000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECDBG_EN_SHIFT   (0x00000013u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECLOCK_EN   (0x00000008u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_TPTC_SECLOCK_EN_SHIFT   (0x00000003u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECDBG_EN   (0x04000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECDBG_EN_SHIFT   (0x0000001Au)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECLOCK_EN   (0x00000400u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF0_USB_SECLOCK_EN_SHIFT   (0x0000000Au)


/* L3_HW_FW_EXP_VAL_CONF1 */
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECDBG_EN   (0x08000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECDBG_EN_SHIFT   (0x0000001Bu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECLOCK_EN   (0x00000800u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_ADCTSC_SECLOCK_EN_SHIFT   (0x0000000Bu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECDBG_EN   (0x10000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECDBG_EN_SHIFT   (0x0000001Cu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECLOCK_EN   (0x00001000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_AES0_SECLOCK_EN_SHIFT   (0x0000000Cu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECDBG_EN   (0x02000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECDBG_EN_SHIFT   (0x00000019u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECLOCK_EN   (0x00000200u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_DEBUG_SECLOCK_EN_SHIFT   (0x00000009u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECDBG_EN   (0x01000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECDBG_EN_SHIFT   (0x00000018u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECLOCK_EN   (0x00000100u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_EMIF_SECLOCK_EN_SHIFT   (0x00000008u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECDBG_EN   (0x00080000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECDBG_EN_SHIFT   (0x00000013u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECLOCK_EN   (0x00000008u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_GPMC_SECLOCK_EN_SHIFT   (0x00000003u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECDBG_EN   (0x00100000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECDBG_EN_SHIFT   (0x00000014u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECLOCK_EN   (0x00000010u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP0_SECLOCK_EN_SHIFT   (0x00000004u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECDBG_EN   (0x00200000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECDBG_EN_SHIFT   (0x00000015u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECLOCK_EN   (0x00000020u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MCASP1_SECLOCK_EN_SHIFT   (0x00000005u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECDBG_EN   (0x04000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECDBG_EN_SHIFT   (0x0000001Au)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECLOCK_EN   (0x00000400u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_MMCHS2_SECLOCK_EN_SHIFT   (0x0000000Au)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD2   (0x00000080u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD2_SHIFT   (0x00000007u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD3   (0x00078000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD3_SHIFT   (0x0000000Fu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD4   (0x00800000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD4_SHIFT   (0x00000017u)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD5   (0x80000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_RSVD5_SHIFT   (0x0000001Fu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECDBG_EN   (0x40000000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECDBG_EN_SHIFT   (0x0000001Eu)

#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECLOCK_EN   (0x00004000u)
#define CONTROL_L3_HW_FW_EXP_VAL_CONF1_SHA_SECLOCK_EN_SHIFT   (0x0000000Eu)


/* L4_HW_FW_EXP_VAL_CONF */
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECDBG_EN   (0x01000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECDBG_EN_SHIFT   (0x00000018u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECLOCK_EN   (0x00000100u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FAST_AP_SECLOCK_EN_SHIFT   (0x00000008u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECDBG_EN   (0x00100000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECDBG_EN_SHIFT   (0x00000014u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECLOCK_EN   (0x00000010u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_AP_SECLOCK_EN_SHIFT   (0x00000004u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECDBG_EN   (0x00200000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECDBG_EN_SHIFT   (0x00000015u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECLOCK_EN   (0x00000020u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4FW_SEC_SECLOCK_EN_SHIFT   (0x00000005u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECDBG_EN   (0x00010000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECDBG_EN_SHIFT   (0x00000010u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECLOCK_EN   (0x00000001u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_AP_SECLOCK_EN_SHIFT   (0x00000000u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECDBG_EN   (0x00020000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECDBG_EN_SHIFT   (0x00000011u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECLOCK_EN   (0x00000002u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4PER_CRYPTO_SECLOCK_EN_SHIFT   (0x00000001u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECDBG_EN   (0x10000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECDBG_EN_SHIFT   (0x0000001Cu)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECLOCK_EN   (0x00001000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_AP_SECLOCK_EN_SHIFT   (0x0000000Cu)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECDBG_EN   (0x20000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECDBG_EN_SHIFT   (0x0000001Du)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECLOCK_EN   (0x00002000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_L4WKUP_SEC_SECLOCK_EN_SHIFT   (0x0000000Du)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD2   (0x000000C0u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD2_SHIFT   (0x00000006u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD3   (0x00000E00u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD3_SHIFT   (0x00000009u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD4   (0x0000C000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD4_SHIFT   (0x0000000Eu)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD5   (0x000C0000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD5_SHIFT   (0x00000012u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD6   (0x00C00000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD6_SHIFT   (0x00000016u)

#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD7   (0x0E000000u)
#define CONTROL_L4_HW_FW_EXP_VAL_CONF_RSVD7_SHIFT   (0x00000019u)


/* CONTROL_SEC_LOAD_FW_EXP_VAL */
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FAST_LD_EXPVAL_REQN   (0x00000010u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FAST_LD_EXPVAL_REQN_SHIFT   (0x00000004u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FW_LD_EXPVAL_REQN   (0x00000004u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4FW_LD_EXPVAL_REQN_SHIFT   (0x00000002u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4PER_LD_EXPVAL_REQN   (0x00000008u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4PER_LD_EXPVAL_REQN_SHIFT   (0x00000003u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4WKUP_LD_EXPVAL_REQN   (0x00000020u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_L4WKUP_LD_EXPVAL_REQN_SHIFT   (0x00000005u)

#define CONTROL_SEC_LOAD_FW_EXP_VAL_RSVD2   (0xFFFFFFC0u)
#define CONTROL_SEC_LOAD_FW_EXP_VAL_RSVD2_SHIFT   (0x00000006u)


/* CONTROL_SEC_CTRL_RO */
#define CONTROL_SEC_CTRL_RO_CUSTMPK   (0x00000010u)
#define CONTROL_SEC_CTRL_RO_CUSTMPK_SHIFT   (0x00000004u)

#define CONTROL_SEC_CTRL_RO_EMIF_CFG_RO_EN   (0x00000002u)
#define CONTROL_SEC_CTRL_RO_EMIF_CFG_RO_EN_SHIFT   (0x00000001u)

#define CONTROL_SEC_CTRL_RO_EMIF_OBFS_EN   (0x00000004u)
#define CONTROL_SEC_CTRL_RO_EMIF_OBFS_EN_SHIFT   (0x00000002u)

#define CONTROL_SEC_CTRL_RO_RSVD2   (0xFFFFFFE0u)
#define CONTROL_SEC_CTRL_RO_RSVD2_SHIFT   (0x00000005u)

#define CONTROL_SEC_CTRL_RO_SECKEYACCEN   (0x00000008u)
#define CONTROL_SEC_CTRL_RO_SECKEYACCEN_SHIFT   (0x00000003u)


/* EMIF_OBFUSCATION_KEY */
#define CONTROL_EMIF_OBFUSCATION_KEY_OBFUSCATIONKEY   (0x0000FFFFu)
#define CONTROL_EMIF_OBFUSCATION_KEY_OBFUSCATIONKEY_SHIFT   (0x00000000u)


/* SEC_CLK_CTRL */
#define CONTROL_SEC_CLK_CTRL_RSVD2   (0x7FFFFFC0u)
#define CONTROL_SEC_CLK_CTRL_RSVD2_SHIFT   (0x00000006u)

#define CONTROL_SEC_CLK_CTRL_SECCLKLCK   (0x80000000u)
#define CONTROL_SEC_CLK_CTRL_SECCLKLCK_SHIFT   (0x0000001Fu)

#define CONTROL_SEC_CLK_CTRL_SECTIMERCLKSEL   (0x00000030u)
#define CONTROL_SEC_CLK_CTRL_SECTIMERCLKSEL_SHIFT   (0x00000004u)

#define CONTROL_SEC_CLK_CTRL_SECWDCLKSEL   (0x00000001u)
#define CONTROL_SEC_CLK_CTRL_SECWDCLKSEL_SHIFT   (0x00000000u)


/* CONTROL_MREQDOMAIN_EXP3 */
#define CONTROL_MREQDOMAIN_EXP3_LCK   (0x80000000u)
#define CONTROL_MREQDOMAIN_EXP3_LCK_SHIFT   (0x0000001Fu)

#define CONTROL_MREQDOMAIN_EXP3_PRU0_DOM   (0x00000007u)
#define CONTROL_MREQDOMAIN_EXP3_PRU0_DOM_SHIFT   (0x00000000u)

#define CONTROL_MREQDOMAIN_EXP3_PRU1_DOM   (0x00000038u)
#define CONTROL_MREQDOMAIN_EXP3_PRU1_DOM_SHIFT   (0x00000003u)

#define CONTROL_MREQDOMAIN_EXP3_PRU2_DOM   (0x000001C0u)
#define CONTROL_MREQDOMAIN_EXP3_PRU2_DOM_SHIFT   (0x00000006u)

#define CONTROL_MREQDOMAIN_EXP3_PRU3_DOM   (0x00000E00u)
#define CONTROL_MREQDOMAIN_EXP3_PRU3_DOM_SHIFT   (0x00000009u)


/* CONTROL_CEK_0 */
#define CONTROL_CEK_0_CEK   (0xFFFFFFFFu)
#define CONTROL_CEK_0_CEK_SHIFT   (0x00000000u)


/* CONTROL_CEK_1 */
#define CONTROL_CEK_1_CEK   (0xFFFFFFFFu)
#define CONTROL_CEK_1_CEK_SHIFT   (0x00000000u)


/* CONTROL_CEK_2 */
#define CONTROL_CEK_2_CEK   (0xFFFFFFFFu)
#define CONTROL_CEK_2_CEK_SHIFT   (0x00000000u)


/* CONTROL_CEK_3 */
#define CONTROL_CEK_3_CEK   (0xFFFFFFFFu)
#define CONTROL_CEK_3_CEK_SHIFT   (0x00000000u)


/* CONTROL_CEK_BCH_0 */
#define CONTROL_CEK_BCH_0_CEK_BCH   (0xFFFFFFFFu)
#define CONTROL_CEK_BCH_0_CEK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CEK_BCH_1 */
#define CONTROL_CEK_BCH_1_CEK_BCH   (0xFFFFFFFFu)
#define CONTROL_CEK_BCH_1_CEK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CEK_BCH_2 */
#define CONTROL_CEK_BCH_2_CEK_BCH   (0xFFFFFFFFu)
#define CONTROL_CEK_BCH_2_CEK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CEK_BCH_3 */
#define CONTROL_CEK_BCH_3_CEK_BCH   (0xFFFFFFFFu)
#define CONTROL_CEK_BCH_3_CEK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CEK_BCH_4 */
#define CONTROL_CEK_BCH_4_CEK_BCH   (0x0000FFFFu)
#define CONTROL_CEK_BCH_4_CEK_BCH_SHIFT   (0x00000000u)


/* CONTROL_MSV_0 */
#define CONTROL_MSV_0_MSV   (0xFFFFFFFFu)
#define CONTROL_MSV_0_MSV_SHIFT   (0x00000000u)


/* CONTROL_MSV_BCH_0 */
#define CONTROL_MSV_BCH_0_MSV_BCH   (0xFFFFFFFFu)
#define CONTROL_MSV_BCH_0_MSV_BCH_SHIFT   (0x00000000u)


/* CONTROL_MSV_BCH_1 */
#define CONTROL_MSV_BCH_1_MSV_BCH   (0xFFFFFFFFu)
#define CONTROL_MSV_BCH_1_MSV_BCH_SHIFT   (0x00000000u)


/* CONTROL_SEC_STATUS */
#define CONTROL_SEC_STATUS_EMURST   (0x00000020u)
#define CONTROL_SEC_STATUS_EMURST_SHIFT   (0x00000005u)

#define CONTROL_SEC_STATUS_GFXDOMAINRST   (0x00000200u)
#define CONTROL_SEC_STATUS_GFXDOMAINRST_SHIFT   (0x00000009u)

#define CONTROL_SEC_STATUS_GLOBALCOLDRST   (0x00000001u)
#define CONTROL_SEC_STATUS_GLOBALCOLDRST_SHIFT   (0x00000000u)

#define CONTROL_SEC_STATUS_GLOBALWARMRST   (0x00000002u)
#define CONTROL_SEC_STATUS_GLOBALWARMRST_SHIFT   (0x00000001u)

#define CONTROL_SEC_STATUS_ICSS0RST   (0x00040000u)
#define CONTROL_SEC_STATUS_ICSS0RST_SHIFT   (0x00000012u)

#define CONTROL_SEC_STATUS_ICSS1RST   (0x00080000u)
#define CONTROL_SEC_STATUS_ICSS1RST_SHIFT   (0x00000013u)

#define CONTROL_SEC_STATUS_MPUDOMAINRST   (0x00000040u)
#define CONTROL_SEC_STATUS_MPUDOMAINRST_SHIFT   (0x00000006u)

#define CONTROL_SEC_STATUS_MPURST   (0x00020000u)
#define CONTROL_SEC_STATUS_MPURST_SHIFT   (0x00000011u)

#define CONTROL_SEC_STATUS_PERDOMAINRST   (0x00000080u)
#define CONTROL_SEC_STATUS_PERDOMAINRST_SHIFT   (0x00000007u)

#define CONTROL_SEC_STATUS_PUBWDRST   (0x00000004u)
#define CONTROL_SEC_STATUS_PUBWDRST_SHIFT   (0x00000002u)

#define CONTROL_SEC_STATUS_RSVD2   (0xFFF00000u)
#define CONTROL_SEC_STATUS_RSVD2_SHIFT   (0x00000014u)

#define CONTROL_SEC_STATUS_SECWDRST   (0x00000008u)
#define CONTROL_SEC_STATUS_SECWDRST_SHIFT   (0x00000003u)

#define CONTROL_SEC_STATUS_SSMVIOLATIONRST   (0x00000010u)
#define CONTROL_SEC_STATUS_SSMVIOLATIONRST_SHIFT   (0x00000004u)

#define CONTROL_SEC_STATUS_WKUPDOMAINRST   (0x00000100u)
#define CONTROL_SEC_STATUS_WKUPDOMAINRST_SHIFT   (0x00000008u)


/* CONTROL_SECMEM_STATUS */
#define CONTROL_SECMEM_STATUS_A8L1DEST   (0x00000001u)
#define CONTROL_SECMEM_STATUS_A8L1DEST_SHIFT   (0x00000000u)

#define CONTROL_SECMEM_STATUS_A8L1NOTACC   (0x00010000u)
#define CONTROL_SECMEM_STATUS_A8L1NOTACC_SHIFT   (0x00000010u)

#define CONTROL_SECMEM_STATUS_A8L2DEST   (0x00000002u)
#define CONTROL_SECMEM_STATUS_A8L2DEST_SHIFT   (0x00000001u)

#define CONTROL_SECMEM_STATUS_A8L2NOTACC   (0x00020000u)
#define CONTROL_SECMEM_STATUS_A8L2NOTACC_SHIFT   (0x00000011u)

#define CONTROL_SECMEM_STATUS_FASTSECRAMDEST   (0x00000004u)
#define CONTROL_SECMEM_STATUS_FASTSECRAMDEST_SHIFT   (0x00000002u)

#define CONTROL_SECMEM_STATUS_FASTSECRAMNOTACC   (0x00040000u)
#define CONTROL_SECMEM_STATUS_FASTSECRAMNOTACC_SHIFT   (0x00000012u)

#define CONTROL_SECMEM_STATUS_L3SECRAMDEST   (0x00000008u)
#define CONTROL_SECMEM_STATUS_L3SECRAMDEST_SHIFT   (0x00000003u)

#define CONTROL_SECMEM_STATUS_L3SECRAMNOTACC   (0x00080000u)
#define CONTROL_SECMEM_STATUS_L3SECRAMNOTACC_SHIFT   (0x00000013u)

#define CONTROL_SECMEM_STATUS_RSVD2   (0xFFF00000u)
#define CONTROL_SECMEM_STATUS_RSVD2_SHIFT   (0x00000014u)


/* CONTROL_SEC_ERR_STAT_FUNC0 */
#define CONTROL_SEC_ERR_STAT_FUNC0_EMIFFWERR   (0x00000010u)
#define CONTROL_SEC_ERR_STAT_FUNC0_EMIFFWERR_SHIFT   (0x00000004u)

#define CONTROL_SEC_ERR_STAT_FUNC0_GPMCFWERR   (0x00000004u)
#define CONTROL_SEC_ERR_STAT_FUNC0_GPMCFWERR_SHIFT   (0x00000002u)

#define CONTROL_SEC_ERR_STAT_FUNC0_L3RAMFWERR   (0x00000001u)
#define CONTROL_SEC_ERR_STAT_FUNC0_L3RAMFWERR_SHIFT   (0x00000000u)

#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD2   (0x00000008u)
#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD2_SHIFT   (0x00000003u)

#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD3   (0x0001FFE0u)
#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD3_SHIFT   (0x00000005u)

#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD4   (0x007C0000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD4_SHIFT   (0x00000012u)

#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD5   (0xF8000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_RSVD5_SHIFT   (0x0000001Bu)

#define CONTROL_SEC_ERR_STAT_FUNC0_SGXFWERR   (0x00020000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_SGXFWERR_SHIFT   (0x00000011u)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC0FWERR   (0x01000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC0FWERR_SHIFT   (0x00000018u)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC1FWERR   (0x02000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC1FWERR_SHIFT   (0x00000019u)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC2FWERR   (0x04000000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTC2FWERR_SHIFT   (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_FUNC0_TPTCCFWERR   (0x00800000u)
#define CONTROL_SEC_ERR_STAT_FUNC0_TPTCCFWERR_SHIFT   (0x00000017u)


/* CONTROL_SEC_ERR_STAT_FUNC1 */
#define CONTROL_SEC_ERR_STAT_FUNC1_ADCFWERR   (0x00000200u)
#define CONTROL_SEC_ERR_STAT_FUNC1_ADCFWERR_SHIFT   (0x00000009u)

#define CONTROL_SEC_ERR_STAT_FUNC1_AES0FWERR   (0x00100000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_AES0FWERR_SHIFT   (0x00000014u)

#define CONTROL_SEC_ERR_STAT_FUNC1_CRYPTODMAFWERR   (0x00080000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_CRYPTODMAFWERR_SHIFT   (0x00000013u)

#define CONTROL_SEC_ERR_STAT_FUNC1_DBGPORTFWERR   (0x00020000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_DBGPORTFWERR_SHIFT   (0x00000011u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L3EXPFWERR   (0x00010000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L3EXPFWERR_SHIFT   (0x00000010u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4FASTFWERR   (0x02000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4FASTFWERR_SHIFT   (0x00000019u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4FWFWERR   (0x08000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4FWFWERR_SHIFT   (0x0000001Bu)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4PERFWERR   (0x01000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4PERFWERR_SHIFT   (0x00000018u)

#define CONTROL_SEC_ERR_STAT_FUNC1_L4WKUPFWERR   (0x04000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_L4WKUPFWERR_SHIFT   (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP0FWERR   (0x00000001u)
#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP0FWERR_SHIFT   (0x00000000u)

#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP1FWERR   (0x00000002u)
#define CONTROL_SEC_ERR_STAT_FUNC1_MCASP1FWERR_SHIFT   (0x00000001u)

#define CONTROL_SEC_ERR_STAT_FUNC1_MMCHS2FWERR   (0x00008000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_MMCHS2FWERR_SHIFT   (0x0000000Fu)

#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD2   (0x00000400u)
#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD2_SHIFT   (0x0000000Au)

#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD3   (0x00006000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD3_SHIFT   (0x0000000Du)

#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD4   (0x00800000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD4_SHIFT   (0x00000017u)

#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD5   (0xF0000000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_RSVD5_SHIFT   (0x0000001Cu)

#define CONTROL_SEC_ERR_STAT_FUNC1_SECMODFWERR   (0x00040000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_SECMODFWERR_SHIFT   (0x00000012u)

#define CONTROL_SEC_ERR_STAT_FUNC1_SHAFWERR   (0x00400000u)
#define CONTROL_SEC_ERR_STAT_FUNC1_SHAFWERR_SHIFT   (0x00000016u)

#define CONTROL_SEC_ERR_STAT_FUNC1_USBFWERR   (0x00000800u)
#define CONTROL_SEC_ERR_STAT_FUNC1_USBFWERR_SHIFT   (0x0000000Bu)


/* CONTROL_SEC_ERR_STAT_DBUG0 */
#define CONTROL_SEC_ERR_STAT_DBUG0_EMIFDBGFWERR   (0x00000010u)
#define CONTROL_SEC_ERR_STAT_DBUG0_EMIFDBGFWERR_SHIFT   (0x00000004u)

#define CONTROL_SEC_ERR_STAT_DBUG0_GPMCDBGFWERR   (0x00000004u)
#define CONTROL_SEC_ERR_STAT_DBUG0_GPMCDBGFWERR_SHIFT   (0x00000002u)

#define CONTROL_SEC_ERR_STAT_DBUG0_L3RAMDBGFWERR   (0x00000001u)
#define CONTROL_SEC_ERR_STAT_DBUG0_L3RAMDBGFWERR_SHIFT   (0x00000000u)

#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD2   (0x00000008u)
#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD2_SHIFT   (0x00000003u)

#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD3   (0x0001FFE0u)
#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD3_SHIFT   (0x00000005u)

#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD4   (0x007C0000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD4_SHIFT   (0x00000012u)

#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD5   (0xF8000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_RSVD5_SHIFT   (0x0000001Bu)

#define CONTROL_SEC_ERR_STAT_DBUG0_SGXDBGFWERR   (0x00020000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_SGXDBGFWERR_SHIFT   (0x00000011u)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC0DBGFWERR   (0x01000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC0DBGFWERR_SHIFT   (0x00000018u)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC1DBGFWERR   (0x02000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC1DBGFWERR_SHIFT   (0x00000019u)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC2DBGFWERR   (0x04000000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTC2DBGFWERR_SHIFT   (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_DBUG0_TPTCCDBGFWERR   (0x00800000u)
#define CONTROL_SEC_ERR_STAT_DBUG0_TPTCCDBGFWERR_SHIFT   (0x00000017u)


/* CONTROL_SEC_ERR_STAT_DBUG1 */
#define CONTROL_SEC_ERR_STAT_DBUG1_ADCDBGFWERR   (0x00000200u)
#define CONTROL_SEC_ERR_STAT_DBUG1_ADCDBGFWERR_SHIFT   (0x00000009u)

#define CONTROL_SEC_ERR_STAT_DBUG1_AES0DBGFWERR   (0x00100000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_AES0DBGFWERR_SHIFT   (0x00000014u)

#define CONTROL_SEC_ERR_STAT_DBUG1_CRYPTODMADBGFWERR   (0x00080000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_CRYPTODMADBGFWERR_SHIFT   (0x00000013u)

#define CONTROL_SEC_ERR_STAT_DBUG1_DBGPORTDBGFWERR   (0x00020000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_DBGPORTDBGFWERR_SHIFT   (0x00000011u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L3EXPDBGFWERR   (0x00010000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L3EXPDBGFWERR_SHIFT   (0x00000010u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4FASTDBGFWERR   (0x02000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4FASTDBGFWERR_SHIFT   (0x00000019u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4FWDBGFWERR   (0x08000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4FWDBGFWERR_SHIFT   (0x0000001Bu)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4PERDBGFWERR   (0x01000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4PERDBGFWERR_SHIFT   (0x00000018u)

#define CONTROL_SEC_ERR_STAT_DBUG1_L4WKUPDBGFWERR   (0x04000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_L4WKUPDBGFWERR_SHIFT   (0x0000001Au)

#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP0DBGFWERR   (0x00000001u)
#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP0DBGFWERR_SHIFT   (0x00000000u)

#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP1DBGFWERR   (0x00000002u)
#define CONTROL_SEC_ERR_STAT_DBUG1_MCASP1DBGFWERR_SHIFT   (0x00000001u)

#define CONTROL_SEC_ERR_STAT_DBUG1_MMCHS2DBGFWERR   (0x00008000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_MMCHS2DBGFWERR_SHIFT   (0x0000000Fu)

#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD2   (0x00000400u)
#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD2_SHIFT   (0x0000000Au)

#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD3   (0x00006000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD3_SHIFT   (0x0000000Du)

#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD4   (0x00040000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD4_SHIFT   (0x00000012u)

#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD5   (0x00800000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD5_SHIFT   (0x00000017u)

#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD6   (0xF0000000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_RSVD6_SHIFT   (0x0000001Cu)

#define CONTROL_SEC_ERR_STAT_DBUG1_SHADBGFWERR   (0x00400000u)
#define CONTROL_SEC_ERR_STAT_DBUG1_SHADBGFWERR_SHIFT   (0x00000016u)

#define CONTROL_SEC_ERR_STAT_DBUG1_USBDBGFWERR   (0x00000800u)
#define CONTROL_SEC_ERR_STAT_DBUG1_USBDBGFWERR_SHIFT   (0x0000000Bu)


/* CONTROL_KEK_SW_0 */
#define CONTROL_KEK_SW_0_KEK_SW   (0xFFFFFFFFu)
#define CONTROL_KEK_SW_0_KEK_SW_SHIFT   (0x00000000u)


/* CONTROL_KEK_SW_1 */
#define CONTROL_KEK_SW_1_KEK_SW   (0xFFFFFFFFu)
#define CONTROL_KEK_SW_1_KEK_SW_SHIFT   (0x00000000u)


/* CONTROL_KEK_SW_2 */
#define CONTROL_KEK_SW_2_KEK_SW   (0xFFFFFFFFu)
#define CONTROL_KEK_SW_2_KEK_SW_SHIFT   (0x00000000u)


/* CONTROL_KEK_SW_3 */
#define CONTROL_KEK_SW_3_KEK_SW   (0xFFFFFFFFu)
#define CONTROL_KEK_SW_3_KEK_SW_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_0 */
#define CONTROL_CMPK_BCH_0_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_0_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_1 */
#define CONTROL_CMPK_BCH_1_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_1_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_2 */
#define CONTROL_CMPK_BCH_2_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_2_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_3 */
#define CONTROL_CMPK_BCH_3_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_3_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_4 */
#define CONTROL_CMPK_BCH_4_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_4_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_5 */
#define CONTROL_CMPK_BCH_5_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_5_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_6 */
#define CONTROL_CMPK_BCH_6_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_6_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_7 */
#define CONTROL_CMPK_BCH_7_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_7_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_BCH_8 */
#define CONTROL_CMPK_BCH_8_CMPK_BCH   (0xFFFFFFFFu)
#define CONTROL_CMPK_BCH_8_CMPK_BCH_SHIFT   (0x00000000u)


/* CONTROL_CMPK_0 */
#define CONTROL_CMPK_0_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_0_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_1 */
#define CONTROL_CMPK_1_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_1_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_2 */
#define CONTROL_CMPK_2_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_2_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_3 */
#define CONTROL_CMPK_3_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_3_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_4 */
#define CONTROL_CMPK_4_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_4_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_5 */
#define CONTROL_CMPK_5_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_5_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_6 */
#define CONTROL_CMPK_6_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_6_CMPK_SHIFT   (0x00000000u)


/* CONTROL_CMPK_7 */
#define CONTROL_CMPK_7_CMPK   (0xFFFFFFFFu)
#define CONTROL_CMPK_7_CMPK_SHIFT   (0x00000000u)


/* SSM_END_FAST_SECRAM */
#define CONTROL_SSM_END_FAST_SECRAM_END_FAST_SECRAM   (0x0000FC00u)
#define CONTROL_SSM_END_FAST_SECRAM_END_FAST_SECRAM_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_FAST_SECRAM_RSVD2   (0xFFFF0000u)
#define CONTROL_SSM_END_FAST_SECRAM_RSVD2_SHIFT   (0x00000010u)


/* SSM_FIREWALL_CONTROLLER */
#define CONTROL_SSM_FIREWALL_CONTROLLER_CPSR_ENFC_EN   (0x00001000u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_CPSR_ENFC_EN_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_FIREWALL_CONTROLLER_DC_ENFC_EN   (0x00000800u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_DC_ENFC_EN_SHIFT   (0x0000000Bu)

#define CONTROL_SSM_FIREWALL_CONTROLLER_IC_ENFC_EN   (0x00000400u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_IC_ENFC_EN_SHIFT   (0x0000000Au)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MMU_ENFC_EN   (0x00000200u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MMU_ENFC_EN_SHIFT   (0x00000009u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MONITOR_EN   (0x00000001u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MONITOR_EN_SHIFT   (0x00000000u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DATA_TRASH_EN   (0x00000080u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DATA_TRASH_EN_SHIFT   (0x00000007u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DETM_EN   (0x00000020u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_DETM_EN_SHIFT   (0x00000005u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_IETM_EN   (0x00000010u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_IETM_EN_SHIFT   (0x00000004u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_RAMCODE_EN   (0x00000100u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_RAMCODE_EN_SHIFT   (0x00000008u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_STACK_EN   (0x00000040u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_MON_STACK_EN_SHIFT   (0x00000006u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_SECRAM_EN   (0x00000002u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_SECRAM_EN_SHIFT   (0x00000001u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_SPM_STACK_EN   (0x00000008u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_SPM_STACK_EN_SHIFT   (0x00000003u)

#define CONTROL_SSM_FIREWALL_CONTROLLER_SSM_FC_REG_LOCK   (0x00002000u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_SSM_FC_REG_LOCK_SHIFT   (0x0000000Du)

#define CONTROL_SSM_FIREWALL_CONTROLLER_STACKEDRAM_EN   (0x00000004u)
#define CONTROL_SSM_FIREWALL_CONTROLLER_STACKEDRAM_EN_SHIFT   (0x00000002u)


/* SSM_START_SECURE_STACKED_RAM */
#define CONTROL_SSM_START_SECURE_STACKED_RAM_START_STACKEDRAM   (0xFFFF0000u)
#define CONTROL_SSM_START_SECURE_STACKED_RAM_START_STACKEDRAM_SHIFT   (0x00000010u)


/* SSM_END_SECURE_STACKED_RAM */
#define CONTROL_SSM_END_SECURE_STACKED_RAM_END_STACKEDRAM   (0xFFFF0000u)
#define CONTROL_SSM_END_SECURE_STACKED_RAM_END_STACKEDRAM_SHIFT   (0x00000010u)


/* SSM_START_SPM_STACK */
#define CONTROL_SSM_START_SPM_STACK_START_SPM_STACK   (0xFFFFFC00u)
#define CONTROL_SSM_START_SPM_STACK_START_SPM_STACK_SHIFT   (0x0000000Au)


/* SSM_END_SPM_STACK */
#define CONTROL_SSM_END_SPM_STACK_END_SPM_STACK   (0x0000FC00u)
#define CONTROL_SSM_END_SPM_STACK_END_SPM_STACK_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_SPM_STACK_START_SPM_STACK   (0xFFFF0000u)
#define CONTROL_SSM_END_SPM_STACK_START_SPM_STACK_SHIFT   (0x00000010u)


/* SSM_START_MONITOR_RAMCODE */
#define CONTROL_SSM_START_MONITOR_RAMCODE_START_MON_RAMCODE   (0xFFFFFC00u)
#define CONTROL_SSM_START_MONITOR_RAMCODE_START_MON_RAMCODE_SHIFT   (0x0000000Au)


/* SSM_END_MONITOR_RAMCODE */
#define CONTROL_SSM_END_MONITOR_RAMCODE_END_MON_RAMCODE   (0x0000FC00u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_END_MON_RAMCODE_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_RAMCODE_START_MON_RAMCODE   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_START_MON_RAMCODE_SHIFT   (0x00000010u)


/* SSM_END_MONITOR_RAMDATA */
#define CONTROL_SSM_END_MONITOR_RAMDATA_END_MON_RAMDATA   (0x0000FC00u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_END_MON_RAMDATA_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_RAMDATA_START_MON_RAMCODE   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_START_MON_RAMCODE_SHIFT   (0x00000010u)


/* SSM_START_MONITOR_CODE */
#define CONTROL_SSM_START_MONITOR_CODE_START_MON_CODE   (0xFFFFFC00u)
#define CONTROL_SSM_START_MONITOR_CODE_START_MON_CODE_SHIFT   (0x0000000Au)


/* SSM_END_MONITOR_CODE */
#define CONTROL_SSM_END_MONITOR_CODE_END_MON_CODE   (0x0001FC00u)
#define CONTROL_SSM_END_MONITOR_CODE_END_MON_CODE_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_CODE_START_MON_CODE   (0xFFFE0000u)
#define CONTROL_SSM_END_MONITOR_CODE_START_MON_CODE_SHIFT   (0x00000011u)


/* SSM_START_MONITOR_PERIPH */
#define CONTROL_SSM_START_MONITOR_PERIPH_START_MON_PERIPH   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_PERIPH_START_MON_PERIPH_SHIFT   (0x0000000Cu)


/* SSM_END_MONITOR_PERIPH */
#define CONTROL_SSM_END_MONITOR_PERIPH_END_MON_PERIPH   (0x0FFFF000u)
#define CONTROL_SSM_END_MONITOR_PERIPH_END_MON_PERIPH_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_PERIPH_START_MON_PERIPH   (0xF0000000u)
#define CONTROL_SSM_END_MONITOR_PERIPH_START_MON_PERIPH_SHIFT   (0x0000001Cu)


/* SSM_START_MONITOR_STACK */
#define CONTROL_SSM_START_MONITOR_STACK_START_MON_STACK   (0xFFFFFC00u)
#define CONTROL_SSM_START_MONITOR_STACK_START_MON_STACK_SHIFT   (0x0000000Au)


/* SSM_END_MONITOR_STACK */
#define CONTROL_SSM_END_MONITOR_STACK_END_MON_STACK   (0x00007C00u)
#define CONTROL_SSM_END_MONITOR_STACK_END_MON_STACK_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_MONITOR_STACK_START_MON_STACK   (0xFFFF8000u)
#define CONTROL_SSM_END_MONITOR_STACK_START_MON_STACK_SHIFT   (0x0000000Fu)


/* SSM_START_MONITOR_RAMCODE_ETM */
#define CONTROL_SSM_START_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM_SHIFT   (0x0000000Cu)


/* SSM_END_MONITOR_RAMCODE_ETM */
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_END_MON_RAMCODE_ETM   (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_END_MON_RAMCODE_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMCODE_ETM_START_MON_RAMCODE_ETM_SHIFT   (0x00000010u)


/* SSM_END_MONITOR_RAMDATA_ETM */
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_END_MON_RAMDATA_ETM   (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_END_MON_RAMDATA_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_START_MON_RAMCODE_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_RAMDATA_ETM_START_MON_RAMCODE_ETM_SHIFT   (0x00000010u)


/* SSM_START_MONITOR_CODE_ETM */
#define CONTROL_SSM_START_MONITOR_CODE_ETM_START_MON_CODE_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_CODE_ETM_START_MON_CODE_ETM_SHIFT   (0x0000000Cu)


/* SSM_END_MONITOR_CODE_ETM */
#define CONTROL_SSM_END_MONITOR_CODE_ETM_END_MON_CODE_ETM   (0x0001F000u)
#define CONTROL_SSM_END_MONITOR_CODE_ETM_END_MON_CODE_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_CODE_ETM_START_MON_CODE_ETM   (0xFFFE0000u)
#define CONTROL_SSM_END_MONITOR_CODE_ETM_START_MON_CODE_ETM_SHIFT   (0x00000011u)


/* SSM_START_MONITOR_STACK_ETM */
#define CONTROL_SSM_START_MONITOR_STACK_ETM_START_MON_STACK_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_STACK_ETM_START_MON_STACK_ETM_SHIFT   (0x0000000Cu)


/* SSM_END_MONITOR_STACK_ETM */
#define CONTROL_SSM_END_MONITOR_STACK_ETM_END_MON_STACK_ETM   (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_STACK_ETM_END_MON_STACK_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_STACK_ETM_START_MON_STACK_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_STACK_ETM_START_MON_STACK_ETM_SHIFT   (0x00000010u)


/* SSM_START_MONITOR_SHARED_ETM */
#define CONTROL_SSM_START_MONITOR_SHARED_ETM_START_MON_SHARED_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_SHARED_ETM_START_MON_SHARED_ETM_SHIFT   (0x0000000Cu)


/* SSM_END_MONITOR_SHARED_ETM */
#define CONTROL_SSM_END_MONITOR_SHARED_ETM_END_MON_SHARED_ETM   (0x0000F000u)
#define CONTROL_SSM_END_MONITOR_SHARED_ETM_END_MON_SHARED_ETM_SHIFT   (0x0000000Cu)

#define CONTROL_SSM_END_MONITOR_SHARED_ETM_START_MON_SHARED_ETM   (0xFFFF0000u)
#define CONTROL_SSM_END_MONITOR_SHARED_ETM_START_MON_SHARED_ETM_SHIFT   (0x00000010u)


/* SSM_START_MONITOR_PERIPH_ETM */
#define CONTROL_SSM_START_MONITOR_PERIPH_ETM_START_MON_PERIPH_ETM   (0xFFFFF000u)
#define CONTROL_SSM_START_MONITOR_PERIPH_ETM_START_MON_PERIPH_ETM_SHIFT   (0x0000000Cu)


/* SSM_END_MONITOR_PERIPH_ETM */
#define CONTROL_SSM_END_MONITOR_PERIPH_ETM_END_MON_PERIPH_ETM   (0xFFFFF000u)
#define CONTROL_SSM_END_MONITOR_PERIPH_ETM_END_MON_PERIPH_ETM_SHIFT   (0x0000000Cu)


/* SSM_CPSR_MODE_ENFC */
#define CONTROL_SSM_CPSR_MODE_ENFC_EA_TRAPPED_IN_MON   (0x00000100u)
#define CONTROL_SSM_CPSR_MODE_ENFC_EA_TRAPPED_IN_MON_SHIFT   (0x00000008u)

#define CONTROL_SSM_CPSR_MODE_ENFC_FIQ_TRAPPED_IN_MON   (0x00000080u)
#define CONTROL_SSM_CPSR_MODE_ENFC_FIQ_TRAPPED_IN_MON_SHIFT   (0x00000007u)

#define CONTROL_SSM_CPSR_MODE_ENFC_IRQ_TRAPPED_IN_MON   (0x00000040u)
#define CONTROL_SSM_CPSR_MODE_ENFC_IRQ_TRAPPED_IN_MON_SHIFT   (0x00000006u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_ABORT_ENFC   (0x00000004u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_ABORT_ENFC_SHIFT   (0x00000002u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_SYS_ENFC   (0x00000010u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_SYS_ENFC_SHIFT   (0x00000004u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_UNDEF_ENFC   (0x00000008u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_UNDEF_ENFC_SHIFT   (0x00000003u)

#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_USER_ENFC   (0x00000002u)
#define CONTROL_SSM_CPSR_MODE_ENFC_MON_VS_USER_ENFC_SHIFT   (0x00000001u)

#define CONTROL_SSM_CPSR_MODE_ENFC_SYS_VS_USER_ENFC   (0x00000020u)
#define CONTROL_SSM_CPSR_MODE_ENFC_SYS_VS_USER_ENFC_SHIFT   (0x00000005u)

#define CONTROL_SSM_CPSR_MODE_ENFC_TZ_NS_BIT_ENFC   (0x00000001u)
#define CONTROL_SSM_CPSR_MODE_ENFC_TZ_NS_BIT_ENFC_SHIFT   (0x00000000u)


/* SSM_END_L3_SECRAM */
#define CONTROL_SSM_END_L3_SECRAM_END_L3_SECRAM   (0x0000FC00u)
#define CONTROL_SSM_END_L3_SECRAM_END_L3_SECRAM_SHIFT   (0x0000000Au)

#define CONTROL_SSM_END_L3_SECRAM_RSVD2   (0xFFFF0000u)
#define CONTROL_SSM_END_L3_SECRAM_RSVD2_SHIFT   (0x00000010u)


/* CORTEX_VBBLDO_CTRL */
#define CONTROL_CORTEX_VBBLDO_CTRL_BBSEL   (0x00000004u)
#define CONTROL_CORTEX_VBBLDO_CTRL_BBSEL_SHIFT   (0x00000002u)

#define CONTROL_CORTEX_VBBLDO_CTRL_HZ   (0x00000008u)
#define CONTROL_CORTEX_VBBLDO_CTRL_HZ_SHIFT   (0x00000003u)

#define CONTROL_CORTEX_VBBLDO_CTRL_LDOBYPASSZ   (0x00000020u)
#define CONTROL_CORTEX_VBBLDO_CTRL_LDOBYPASSZ_SHIFT   (0x00000005u)

#define CONTROL_CORTEX_VBBLDO_CTRL_LOWPWR   (0x00000010u)
#define CONTROL_CORTEX_VBBLDO_CTRL_LOWPWR_SHIFT   (0x00000004u)

#define CONTROL_CORTEX_VBBLDO_CTRL_NOCAP   (0x00000002u)
#define CONTROL_CORTEX_VBBLDO_CTRL_NOCAP_SHIFT   (0x00000001u)

#define CONTROL_CORTEX_VBBLDO_CTRL_NOVBGBYR   (0x00000001u)
#define CONTROL_CORTEX_VBBLDO_CTRL_NOVBGBYR_SHIFT   (0x00000000u)

#define CONTROL_CORTEX_VBBLDO_CTRL_RSVD2   (0xFC000000u)
#define CONTROL_CORTEX_VBBLDO_CTRL_RSVD2_SHIFT   (0x0000001Au)

#define CONTROL_CORTEX_VBBLDO_CTRL_VSETFBB   (0x03E00000u)
#define CONTROL_CORTEX_VBBLDO_CTRL_VSETFBB_SHIFT   (0x00000015u)

#define CONTROL_CORTEX_VBBLDO_CTRL_VSETRBB   (0x001F0000u)
#define CONTROL_CORTEX_VBBLDO_CTRL_VSETRBB_SHIFT   (0x00000010u)


/* CORE_SLDO_CTRL */
#define CONTROL_CORE_SLDO_CTRL_RSVD2   (0xFC000000u)
#define CONTROL_CORE_SLDO_CTRL_RSVD2_SHIFT   (0x0000001Au)

#define CONTROL_CORE_SLDO_CTRL_VSET   (0x03FF0000u)
#define CONTROL_CORE_SLDO_CTRL_VSET_SHIFT   (0x00000010u)


/* MPU_SLDO_CTRL */
#define CONTROL_MPU_SLDO_CTRL_RSVD2   (0xFC000000u)
#define CONTROL_MPU_SLDO_CTRL_RSVD2_SHIFT   (0x0000001Au)

#define CONTROL_MPU_SLDO_CTRL_VSET   (0x03FF0000u)
#define CONTROL_MPU_SLDO_CTRL_VSET_SHIFT   (0x00000010u)


/* REFCLK_LJCBLDO_CTRL */
#define CONTROL_REFCLK_LJCBLDO_CTRL_ABBOFF   (0x00000040u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ABBOFF_SHIFT   (0x00000006u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_AIPOFF   (0x00000080u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_AIPOFF_SHIFT   (0x00000007u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC1   (0x00000001u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC1_SHIFT   (0x00000000u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC2   (0x00000002u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC2_SHIFT   (0x00000001u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC3   (0x00000004u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC3_SHIFT   (0x00000002u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC4   (0x00000008u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC4_SHIFT   (0x00000003u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC5   (0x00000010u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_ENFUNC5_SHIFT   (0x00000004u)

#define CONTROL_REFCLK_LJCBLDO_CTRL_RSVD2   (0xFC000000u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_RSVD2_SHIFT   (0x0000001Au)

#define CONTROL_REFCLK_LJCBLDO_CTRL_VSET   (0x03FF0000u)
#define CONTROL_REFCLK_LJCBLDO_CTRL_VSET_SHIFT   (0x00000010u)


/* CLK32KDIVRATIO_CTRL */
#define CONTROL_CLK32KDIVRATIO_CTRL_CLKDIVOPP50_EN   (0x00000001u)
#define CONTROL_CLK32KDIVRATIO_CTRL_CLKDIVOPP50_EN_SHIFT   (0x00000000u)


/* BANDGAP_CTRL */
#define CONTROL_BANDGAP_CTRL_BGROFF   (0x00000040u)
#define CONTROL_BANDGAP_CTRL_BGROFF_SHIFT   (0x00000006u)

#define CONTROL_BANDGAP_CTRL_CBIASSEL   (0x00000080u)
#define CONTROL_BANDGAP_CTRL_CBIASSEL_SHIFT   (0x00000007u)

#define CONTROL_BANDGAP_CTRL_CLRZ   (0x00000008u)
#define CONTROL_BANDGAP_CTRL_CLRZ_SHIFT   (0x00000003u)

#define CONTROL_BANDGAP_CTRL_CONTCONV   (0x00000004u)
#define CONTROL_BANDGAP_CTRL_CONTCONV_SHIFT   (0x00000002u)

#define CONTROL_BANDGAP_CTRL_DTEMP   (0x0000FF00u)
#define CONTROL_BANDGAP_CTRL_DTEMP_SHIFT   (0x00000008u)

#define CONTROL_BANDGAP_CTRL_ECOZ   (0x00000002u)
#define CONTROL_BANDGAP_CTRL_ECOZ_SHIFT   (0x00000001u)

#define CONTROL_BANDGAP_CTRL_SOC   (0x00000010u)
#define CONTROL_BANDGAP_CTRL_SOC_SHIFT   (0x00000004u)

#define CONTROL_BANDGAP_CTRL_TMPSOFF   (0x00000020u)
#define CONTROL_BANDGAP_CTRL_TMPSOFF_SHIFT   (0x00000005u)

#define CONTROL_BANDGAP_CTRL_TSHUT   (0x00000001u)
#define CONTROL_BANDGAP_CTRL_TSHUT_SHIFT   (0x00000000u)


/* BANDGAP_TRIM */
#define CONTROL_BANDGAP_TRIM_DTRBGAPC   (0xFF000000u)
#define CONTROL_BANDGAP_TRIM_DTRBGAPC_SHIFT   (0x00000018u)

#define CONTROL_BANDGAP_TRIM_DTRBGAPV   (0x00FF0000u)
#define CONTROL_BANDGAP_TRIM_DTRBGAPV_SHIFT   (0x00000010u)

#define CONTROL_BANDGAP_TRIM_DTRTEMPS   (0x0000FF00u)
#define CONTROL_BANDGAP_TRIM_DTRTEMPS_SHIFT   (0x00000008u)

#define CONTROL_BANDGAP_TRIM_DTRTEMPSC   (0x000000FFu)
#define CONTROL_BANDGAP_TRIM_DTRTEMPSC_SHIFT   (0x00000000u)


/* PLL_CLKINPULOW_CTRL */
#define CONTROL_PLL_CLKINPULOW_CTRL_DDR_PLL_CLKINPULOW_SEL   (0x00000004u)
#define CONTROL_PLL_CLKINPULOW_CTRL_DDR_PLL_CLKINPULOW_SEL_SHIFT   (0x00000002u)

#define CONTROL_PLL_CLKINPULOW_CTRL_DISP_PLL_CLKINPULOW_SEL   (0x00000002u)
#define CONTROL_PLL_CLKINPULOW_CTRL_DISP_PLL_CLKINPULOW_SEL_SHIFT   (0x00000001u)

#define CONTROL_PLL_CLKINPULOW_CTRL_MPU_DPLL_CLKINPULOW_SEL   (0x00000001u)
#define CONTROL_PLL_CLKINPULOW_CTRL_MPU_DPLL_CLKINPULOW_SEL_SHIFT   (0x00000000u)


/* MOSC_CTRL */
#define CONTROL_MOSC_CTRL_RESSELECT   (0x00000001u)
#define CONTROL_MOSC_CTRL_RESSELECT_SHIFT   (0x00000000u)


/* RCOSC_CTRL */
#define CONTROL_RCOSC_CTRL_STOPOSC   (0x00000001u)
#define CONTROL_RCOSC_CTRL_STOPOSC_SHIFT   (0x00000000u)


/* DEEPSLEEP_CTRL */
#define CONTROL_DEEPSLEEP_CTRL_DSCOUNT   (0x0000FFFFu)
#define CONTROL_DEEPSLEEP_CTRL_DSCOUNT_SHIFT   (0x00000000u)

#define CONTROL_DEEPSLEEP_CTRL_DSENABLE   (0x00020000u)
#define CONTROL_DEEPSLEEP_CTRL_DSENABLE_SHIFT   (0x00000011u)

#define CONTROL_DEEPSLEEP_CTRL_RSVD2   (0xFFFC0000u)
#define CONTROL_DEEPSLEEP_CTRL_RSVD2_SHIFT   (0x00000012u)


/* PE_SCRATCHPAD_0 */
#define CONTROL_PE_SCRATCHPAD_0_PE_SCRATCHPAD_0   (0xFFFFFFFFu)
#define CONTROL_PE_SCRATCHPAD_0_PE_SCRATCHPAD_0_SHIFT   (0x00000000u)


/* PE_SCRATCHPAD_1 */
#define CONTROL_PE_SCRATCHPAD_1_PE_SCRATCHPAD_1   (0xFFFFFFFFu)
#define CONTROL_PE_SCRATCHPAD_1_PE_SCRATCHPAD_1_SHIFT   (0x00000000u)


/* PE_SCRATCHPAD_2 */
#define CONTROL_PE_SCRATCHPAD_2_PE_SCRATCHPAD_2   (0xFFFFFFFFu)
#define CONTROL_PE_SCRATCHPAD_2_PE_SCRATCHPAD_2_SHIFT   (0x00000000u)


/* PE_SCRATCHPAD_3 */
#define CONTROL_PE_SCRATCHPAD_3_PE_SCRATCHPAD_3   (0xFFFFFFFFu)
#define CONTROL_PE_SCRATCHPAD_3_PE_SCRATCHPAD_3_SHIFT   (0x00000000u)


/* DEVICE_ID */
#define CONTROL_DEVICE_ID_DEVREV   (0xF0000000u)
#define CONTROL_DEVICE_ID_DEVREV_SHIFT   (0x0000001Cu)

#define CONTROL_DEVICE_ID_MFGR   (0x00000FFEu)
#define CONTROL_DEVICE_ID_MFGR_SHIFT   (0x00000001u)

#define CONTROL_DEVICE_ID_PARTNUM   (0x0FFFF000u)
#define CONTROL_DEVICE_ID_PARTNUM_SHIFT   (0x0000000Cu)


/* DEV_FEATURE */
#define CONTROL_DEV_FEATURE_CPSW   (0x00000002u)
#define CONTROL_DEV_FEATURE_CPSW_SHIFT   (0x00000001u)

#define CONTROL_DEV_FEATURE_DCAN   (0x00000080u)
#define CONTROL_DEV_FEATURE_DCAN_SHIFT   (0x00000007u)

#define CONTROL_DEV_FEATURE_ICSS   (0x00000001u)
#define CONTROL_DEV_FEATURE_ICSS_SHIFT   (0x00000000u)

#define CONTROL_DEV_FEATURE_ICSS_FEA   (0x00FF0000u)
#define CONTROL_DEV_FEATURE_ICSS_FEA_SHIFT   (0x00000010u)

#define CONTROL_DEV_FEATURE_RSVD2   (0x0000FC00u)
#define CONTROL_DEV_FEATURE_RSVD2_SHIFT   (0x0000000Au)

#define CONTROL_DEV_FEATURE_RSVD3   (0x1F000000u)
#define CONTROL_DEV_FEATURE_RSVD3_SHIFT   (0x00000018u)

#define CONTROL_DEV_FEATURE_RSVD4   (0xC0000000u)
#define CONTROL_DEV_FEATURE_RSVD4_SHIFT   (0x0000001Eu)

#define CONTROL_DEV_FEATURE_SEC_PKA_RNG_SHA   (0x00000200u)
#define CONTROL_DEV_FEATURE_SEC_PKA_RNG_SHA_SHIFT   (0x00000009u)

#define CONTROL_DEV_FEATURE_SGX   (0x20000000u)
#define CONTROL_DEV_FEATURE_SGX_SHIFT   (0x0000001Du)


/* INIT_PRIORITY_0 */
#define CONTROL_INIT_PRIORITY_0_HOST_ARM   (0x00000003u)
#define CONTROL_INIT_PRIORITY_0_HOST_ARM_SHIFT   (0x00000000u)

#define CONTROL_INIT_PRIORITY_0_MMU   (0x000000C0u)
#define CONTROL_INIT_PRIORITY_0_MMU_SHIFT   (0x00000006u)

#define CONTROL_INIT_PRIORITY_0_P1500   (0x0000C000u)
#define CONTROL_INIT_PRIORITY_0_P1500_SHIFT   (0x0000000Eu)

#define CONTROL_INIT_PRIORITY_0_PRUSS0   (0x0000000Cu)
#define CONTROL_INIT_PRIORITY_0_PRUSS0_SHIFT   (0x00000002u)

#define CONTROL_INIT_PRIORITY_0_PRUSS1   (0x00000030u)
#define CONTROL_INIT_PRIORITY_0_PRUSS1_SHIFT   (0x00000004u)

#define CONTROL_INIT_PRIORITY_0_RSVD2   (0xF0000000u)
#define CONTROL_INIT_PRIORITY_0_RSVD2_SHIFT   (0x0000001Cu)

#define CONTROL_INIT_PRIORITY_0_TCRD0   (0x00030000u)
#define CONTROL_INIT_PRIORITY_0_TCRD0_SHIFT   (0x00000010u)

#define CONTROL_INIT_PRIORITY_0_TCRD1   (0x00300000u)
#define CONTROL_INIT_PRIORITY_0_TCRD1_SHIFT   (0x00000014u)

#define CONTROL_INIT_PRIORITY_0_TCRD2   (0x03000000u)
#define CONTROL_INIT_PRIORITY_0_TCRD2_SHIFT   (0x00000018u)

#define CONTROL_INIT_PRIORITY_0_TCWR0   (0x000C0000u)
#define CONTROL_INIT_PRIORITY_0_TCWR0_SHIFT   (0x00000012u)

#define CONTROL_INIT_PRIORITY_0_TCWR1   (0x00C00000u)
#define CONTROL_INIT_PRIORITY_0_TCWR1_SHIFT   (0x00000016u)

#define CONTROL_INIT_PRIORITY_0_TCWR2   (0x0C000000u)
#define CONTROL_INIT_PRIORITY_0_TCWR2_SHIFT   (0x0000001Au)


/* INIT_PRIORITY_1 */
#define CONTROL_INIT_PRIORITY_1_CPSW   (0x00000003u)
#define CONTROL_INIT_PRIORITY_1_CPSW_SHIFT   (0x00000000u)

#define CONTROL_INIT_PRIORITY_1_DEBUG   (0x03000000u)
#define CONTROL_INIT_PRIORITY_1_DEBUG_SHIFT   (0x00000018u)

#define CONTROL_INIT_PRIORITY_1_LCD   (0x00C00000u)
#define CONTROL_INIT_PRIORITY_1_LCD_SHIFT   (0x00000016u)

#define CONTROL_INIT_PRIORITY_1_RSVD2   (0x0000FF00u)
#define CONTROL_INIT_PRIORITY_1_RSVD2_SHIFT   (0x00000008u)

#define CONTROL_INIT_PRIORITY_1_RSVD3   (0x000C0000u)
#define CONTROL_INIT_PRIORITY_1_RSVD3_SHIFT   (0x00000012u)

#define CONTROL_INIT_PRIORITY_1_RSVD4   (0xFC000000u)
#define CONTROL_INIT_PRIORITY_1_RSVD4_SHIFT   (0x0000001Au)

#define CONTROL_INIT_PRIORITY_1_SGX   (0x00300000u)
#define CONTROL_INIT_PRIORITY_1_SGX_SHIFT   (0x00000014u)

#define CONTROL_INIT_PRIORITY_1_USB_DMA   (0x00000030u)
#define CONTROL_INIT_PRIORITY_1_USB_DMA_SHIFT   (0x00000004u)

#define CONTROL_INIT_PRIORITY_1_USB_QMGR   (0x000000C0u)
#define CONTROL_INIT_PRIORITY_1_USB_QMGR_SHIFT   (0x00000006u)


/* MMU_CFG */
#define CONTROL_MMU_CFG_MMU_ABORT   (0x00008000u)
#define CONTROL_MMU_CFG_MMU_ABORT_SHIFT   (0x0000000Fu)

#define CONTROL_MMU_CFG_MMU_DISABLE   (0x00000080u)
#define CONTROL_MMU_CFG_MMU_DISABLE_SHIFT   (0x00000007u)

#define CONTROL_MMU_CFG_RSVD2   (0x00007F00u)
#define CONTROL_MMU_CFG_RSVD2_SHIFT   (0x00000008u)

#define CONTROL_MMU_CFG_RSVD3   (0xFFFF0000u)
#define CONTROL_MMU_CFG_RSVD3_SHIFT   (0x00000010u)


/* TPTC_CFG */
#define CONTROL_TPTC_CFG_TC0DBS   (0x00000003u)
#define CONTROL_TPTC_CFG_TC0DBS_SHIFT   (0x00000000u)

#define CONTROL_TPTC_CFG_TC1DBS   (0x0000000Cu)
#define CONTROL_TPTC_CFG_TC1DBS_SHIFT   (0x00000002u)

#define CONTROL_TPTC_CFG_TC2DBS   (0x00000030u)
#define CONTROL_TPTC_CFG_TC2DBS_SHIFT   (0x00000004u)


/* OCMC_CFG */
#define CONTROL_OCMC_CFG_PAR_EN   (0x00000001u)
#define CONTROL_OCMC_CFG_PAR_EN_SHIFT   (0x00000000u)

#define CONTROL_OCMC_CFG_PAR_INT_CLR   (0x00000010u)
#define CONTROL_OCMC_CFG_PAR_INT_CLR_SHIFT   (0x00000004u)

#define CONTROL_OCMC_CFG_PAR_RESP_EN   (0x00000002u)
#define CONTROL_OCMC_CFG_PAR_RESP_EN_SHIFT   (0x00000001u)

#define CONTROL_OCMC_CFG_RSVD2   (0xFFFFFFE0u)
#define CONTROL_OCMC_CFG_RSVD2_SHIFT   (0x00000005u)


/* USB_CTRL0 */
#define CONTROL_USB_CTRL0_CDET_EXTCTL   (0x00000400u)
#define CONTROL_USB_CTRL0_CDET_EXTCTL_SHIFT   (0x0000000Au)

#define CONTROL_USB_CTRL0_CHGDET_DIS   (0x00000004u)
#define CONTROL_USB_CTRL0_CHGDET_DIS_SHIFT   (0x00000002u)

#define CONTROL_USB_CTRL0_CHGDET_RSTRT   (0x00000008u)
#define CONTROL_USB_CTRL0_CHGDET_RSTRT_SHIFT   (0x00000003u)

#define CONTROL_USB_CTRL0_CHGISINK_EN   (0x00000040u)
#define CONTROL_USB_CTRL0_CHGISINK_EN_SHIFT   (0x00000006u)

#define CONTROL_USB_CTRL0_CHGVSRC_EN   (0x00000080u)
#define CONTROL_USB_CTRL0_CHGVSRC_EN_SHIFT   (0x00000007u)

#define CONTROL_USB_CTRL0_CM_PWRDN   (0x00000001u)
#define CONTROL_USB_CTRL0_CM_PWRDN_SHIFT   (0x00000000u)

#define CONTROL_USB_CTRL0_DATAPOLARITY_INV   (0x00800000u)
#define CONTROL_USB_CTRL0_DATAPOLARITY_INV_SHIFT   (0x00000017u)

#define CONTROL_USB_CTRL0_DMGPIO_PD   (0x00040000u)
#define CONTROL_USB_CTRL0_DMGPIO_PD_SHIFT   (0x00000012u)

#define CONTROL_USB_CTRL0_DMPULLUP   (0x00000100u)
#define CONTROL_USB_CTRL0_DMPULLUP_SHIFT   (0x00000008u)

#define CONTROL_USB_CTRL0_DPGPIO_PD   (0x00020000u)
#define CONTROL_USB_CTRL0_DPGPIO_PD_SHIFT   (0x00000011u)

#define CONTROL_USB_CTRL0_DPPULLUP   (0x00000200u)
#define CONTROL_USB_CTRL0_DPPULLUP_SHIFT   (0x00000009u)

#define CONTROL_USB_CTRL0_GPIOMODE   (0x00001000u)
#define CONTROL_USB_CTRL0_GPIOMODE_SHIFT   (0x0000000Cu)

#define CONTROL_USB_CTRL0_GPIO_SIG_CROSS   (0x00004000u)
#define CONTROL_USB_CTRL0_GPIO_SIG_CROSS_SHIFT   (0x0000000Eu)

#define CONTROL_USB_CTRL0_GPIO_SIG_INV   (0x00002000u)
#define CONTROL_USB_CTRL0_GPIO_SIG_INV_SHIFT   (0x0000000Du)

#define CONTROL_USB_CTRL0_OTGSESSENDEN   (0x00100000u)
#define CONTROL_USB_CTRL0_OTGSESSENDEN_SHIFT   (0x00000014u)

#define CONTROL_USB_CTRL0_OTGVDET_EN   (0x00080000u)
#define CONTROL_USB_CTRL0_OTGVDET_EN_SHIFT   (0x00000013u)

#define CONTROL_USB_CTRL0_OTG_PWRDN   (0x00000002u)
#define CONTROL_USB_CTRL0_OTG_PWRDN_SHIFT   (0x00000001u)

#define CONTROL_USB_CTRL0_RSVD2   (0x00008000u)
#define CONTROL_USB_CTRL0_RSVD2_SHIFT   (0x0000000Fu)

#define CONTROL_USB_CTRL0_RSVD3   (0x00010000u)
#define CONTROL_USB_CTRL0_RSVD3_SHIFT   (0x00000010u)

#define CONTROL_USB_CTRL0_SINKONDP   (0x00000020u)
#define CONTROL_USB_CTRL0_SINKONDP_SHIFT   (0x00000005u)

#define CONTROL_USB_CTRL0_SPAREIN   (0xFF000000u)
#define CONTROL_USB_CTRL0_SPAREIN_SHIFT   (0x00000018u)

#define CONTROL_USB_CTRL0_SRCONDM   (0x00000010u)
#define CONTROL_USB_CTRL0_SRCONDM_SHIFT   (0x00000004u)

#define CONTROL_USB_CTRL0_USB_PHY_SMA1   (0x00200000u)
#define CONTROL_USB_CTRL0_USB_PHY_SMA1_SHIFT   (0x00000015u)

#define CONTROL_USB_CTRL0_USB_PHY_SMA2   (0x00400000u)
#define CONTROL_USB_CTRL0_USB_PHY_SMA2_SHIFT   (0x00000016u)


/* USB_STS0 */
#define CONTROL_USB_STS0_CDET_DATADET   (0x00000004u)
#define CONTROL_USB_STS0_CDET_DATADET_SHIFT   (0x00000002u)

#define CONTROL_USB_STS0_CDET_DMDET   (0x00000010u)
#define CONTROL_USB_STS0_CDET_DMDET_SHIFT   (0x00000004u)

#define CONTROL_USB_STS0_CDET_DPDET   (0x00000008u)
#define CONTROL_USB_STS0_CDET_DPDET_SHIFT   (0x00000003u)

#define CONTROL_USB_STS0_CHGDETDONE   (0x00000001u)
#define CONTROL_USB_STS0_CHGDETDONE_SHIFT   (0x00000000u)

#define CONTROL_USB_STS0_CHGDETECT   (0x00000002u)
#define CONTROL_USB_STS0_CHGDETECT_SHIFT   (0x00000001u)

#define CONTROL_USB_STS0_CHGDETSTS   (0x000000E0u)
#define CONTROL_USB_STS0_CHGDETSTS_SHIFT   (0x00000005u)


/* USB_CTRL1 */
#define CONTROL_USB_CTRL1_CDET_EXTCTL   (0x00000400u)
#define CONTROL_USB_CTRL1_CDET_EXTCTL_SHIFT   (0x0000000Au)

#define CONTROL_USB_CTRL1_CHGDET_DIS   (0x00000004u)
#define CONTROL_USB_CTRL1_CHGDET_DIS_SHIFT   (0x00000002u)

#define CONTROL_USB_CTRL1_CHGDET_RSTRT   (0x00000008u)
#define CONTROL_USB_CTRL1_CHGDET_RSTRT_SHIFT   (0x00000003u)

#define CONTROL_USB_CTRL1_CHGISINK_EN   (0x00000040u)
#define CONTROL_USB_CTRL1_CHGISINK_EN_SHIFT   (0x00000006u)

#define CONTROL_USB_CTRL1_CHGVSRC_EN   (0x00000080u)
#define CONTROL_USB_CTRL1_CHGVSRC_EN_SHIFT   (0x00000007u)

#define CONTROL_USB_CTRL1_CM_PWRDN   (0x00000001u)
#define CONTROL_USB_CTRL1_CM_PWRDN_SHIFT   (0x00000000u)

#define CONTROL_USB_CTRL1_DATAPOLARITY_INV   (0x00800000u)
#define CONTROL_USB_CTRL1_DATAPOLARITY_INV_SHIFT   (0x00000017u)

#define CONTROL_USB_CTRL1_DMGPIO_PD   (0x00040000u)
#define CONTROL_USB_CTRL1_DMGPIO_PD_SHIFT   (0x00000012u)

#define CONTROL_USB_CTRL1_DMPULLUP   (0x00000100u)
#define CONTROL_USB_CTRL1_DMPULLUP_SHIFT   (0x00000008u)

#define CONTROL_USB_CTRL1_DPGPIO_PD   (0x00020000u)
#define CONTROL_USB_CTRL1_DPGPIO_PD_SHIFT   (0x00000011u)

#define CONTROL_USB_CTRL1_DPPULLUP   (0x00000200u)
#define CONTROL_USB_CTRL1_DPPULLUP_SHIFT   (0x00000009u)

#define CONTROL_USB_CTRL1_GPIOMODE   (0x00001000u)
#define CONTROL_USB_CTRL1_GPIOMODE_SHIFT   (0x0000000Cu)

#define CONTROL_USB_CTRL1_GPIO_SIG_CROSS   (0x00004000u)
#define CONTROL_USB_CTRL1_GPIO_SIG_CROSS_SHIFT   (0x0000000Eu)

#define CONTROL_USB_CTRL1_GPIO_SIG_INV   (0x00002000u)
#define CONTROL_USB_CTRL1_GPIO_SIG_INV_SHIFT   (0x0000000Du)

#define CONTROL_USB_CTRL1_OTGSESSENDEN   (0x00100000u)
#define CONTROL_USB_CTRL1_OTGSESSENDEN_SHIFT   (0x00000014u)

#define CONTROL_USB_CTRL1_OTGVDET_EN   (0x00080000u)
#define CONTROL_USB_CTRL1_OTGVDET_EN_SHIFT   (0x00000013u)

#define CONTROL_USB_CTRL1_OTG_PWRDN   (0x00000002u)
#define CONTROL_USB_CTRL1_OTG_PWRDN_SHIFT   (0x00000001u)

#define CONTROL_USB_CTRL1_RSVD2   (0x00008000u)
#define CONTROL_USB_CTRL1_RSVD2_SHIFT   (0x0000000Fu)

#define CONTROL_USB_CTRL1_RSVD3   (0x00010000u)
#define CONTROL_USB_CTRL1_RSVD3_SHIFT   (0x00000010u)

#define CONTROL_USB_CTRL1_SINKONDP   (0x00000020u)
#define CONTROL_USB_CTRL1_SINKONDP_SHIFT   (0x00000005u)

#define CONTROL_USB_CTRL1_SPAREIN   (0xFF000000u)
#define CONTROL_USB_CTRL1_SPAREIN_SHIFT   (0x00000018u)

#define CONTROL_USB_CTRL1_SRCONDM   (0x00000010u)
#define CONTROL_USB_CTRL1_SRCONDM_SHIFT   (0x00000004u)

#define CONTROL_USB_CTRL1_USB_PHY_SMA1   (0x00200000u)
#define CONTROL_USB_CTRL1_USB_PHY_SMA1_SHIFT   (0x00000015u)

#define CONTROL_USB_CTRL1_USB_PHY_SMA2   (0x00400000u)
#define CONTROL_USB_CTRL1_USB_PHY_SMA2_SHIFT   (0x00000016u)


/* USB_STS1 */
#define CONTROL_USB_STS1_CDET_DATADET   (0x00000004u)
#define CONTROL_USB_STS1_CDET_DATADET_SHIFT   (0x00000002u)

#define CONTROL_USB_STS1_CDET_DMDET   (0x00000010u)
#define CONTROL_USB_STS1_CDET_DMDET_SHIFT   (0x00000004u)

#define CONTROL_USB_STS1_CDET_DPDET   (0x00000008u)
#define CONTROL_USB_STS1_CDET_DPDET_SHIFT   (0x00000003u)

#define CONTROL_USB_STS1_CHGDETDONE   (0x00000001u)
#define CONTROL_USB_STS1_CHGDETDONE_SHIFT   (0x00000000u)

#define CONTROL_USB_STS1_CHGDETECT   (0x00000002u)
#define CONTROL_USB_STS1_CHGDETECT_SHIFT   (0x00000001u)

#define CONTROL_USB_STS1_CHGDETSTS   (0x000000E0u)
#define CONTROL_USB_STS1_CHGDETSTS_SHIFT   (0x00000005u)


/* MAC_ID0_LO */
#define CONTROL_MAC_ID0_LO_MACADDR_15_8   (0x000000FFu)
#define CONTROL_MAC_ID0_LO_MACADDR_15_8_SHIFT   (0x00000000u)

#define CONTROL_MAC_ID0_LO_MACADDR_7_0   (0x0000FF00u)
#define CONTROL_MAC_ID0_LO_MACADDR_7_0_SHIFT   (0x00000008u)


/* MAC_ID0_HI */
#define CONTROL_MAC_ID0_HI_MACADDR_23_16   (0xFF000000u)
#define CONTROL_MAC_ID0_HI_MACADDR_23_16_SHIFT   (0x00000018u)

#define CONTROL_MAC_ID0_HI_MACADDR_31_24   (0x00FF0000u)
#define CONTROL_MAC_ID0_HI_MACADDR_31_24_SHIFT   (0x00000010u)

#define CONTROL_MAC_ID0_HI_MACADDR_39_32   (0x0000FF00u)
#define CONTROL_MAC_ID0_HI_MACADDR_39_32_SHIFT   (0x00000008u)

#define CONTROL_MAC_ID0_HI_MACADDR_47_40   (0x000000FFu)
#define CONTROL_MAC_ID0_HI_MACADDR_47_40_SHIFT   (0x00000000u)


/* MAC_ID1_LO */
#define CONTROL_MAC_ID1_LO_MACADDR_15_8   (0x000000FFu)
#define CONTROL_MAC_ID1_LO_MACADDR_15_8_SHIFT   (0x00000000u)

#define CONTROL_MAC_ID1_LO_MACADDR_7_0   (0x0000FF00u)
#define CONTROL_MAC_ID1_LO_MACADDR_7_0_SHIFT   (0x00000008u)


/* MAC_ID1_HI */
#define CONTROL_MAC_ID1_HI_MACADDR_23_16   (0xFF000000u)
#define CONTROL_MAC_ID1_HI_MACADDR_23_16_SHIFT   (0x00000018u)

#define CONTROL_MAC_ID1_HI_MACADDR_31_24   (0x00FF0000u)
#define CONTROL_MAC_ID1_HI_MACADDR_31_24_SHIFT   (0x00000010u)

#define CONTROL_MAC_ID1_HI_MACADDR_39_32   (0x0000FF00u)
#define CONTROL_MAC_ID1_HI_MACADDR_39_32_SHIFT   (0x00000008u)

#define CONTROL_MAC_ID1_HI_MACADDR_47_40   (0x000000FFu)
#define CONTROL_MAC_ID1_HI_MACADDR_47_40_SHIFT   (0x00000000u)


/* DCAN_RAMINIT */
#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_DONE   (0x00000100u)
#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_DONE_SHIFT   (0x00000008u)

#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_START   (0x00000001u)
#define CONTROL_DCAN_RAMINIT_DCAN0_RAMINIT_START_SHIFT   (0x00000000u)

#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_DONE   (0x00000200u)
#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_DONE_SHIFT   (0x00000009u)

#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_START   (0x00000002u)
#define CONTROL_DCAN_RAMINIT_DCAN1_RAMINIT_START_SHIFT   (0x00000001u)

#define CONTROL_DCAN_RAMINIT_RSVD2   (0xFFFFFC00u)
#define CONTROL_DCAN_RAMINIT_RSVD2_SHIFT   (0x0000000Au)


/* USB_WKUP_CTRL */
#define CONTROL_USB_WKUP_CTRL_PHY0_WUEN   (0x00000001u)
#define CONTROL_USB_WKUP_CTRL_PHY0_WUEN_SHIFT   (0x00000000u)

#define CONTROL_USB_WKUP_CTRL_PHY1_WUEN   (0x00000100u)
#define CONTROL_USB_WKUP_CTRL_PHY1_WUEN_SHIFT   (0x00000008u)

#define CONTROL_USB_WKUP_CTRL_RSVD2   (0xFFFFFE00u)
#define CONTROL_USB_WKUP_CTRL_RSVD2_SHIFT   (0x00000009u)


/* GMII_SEL */
#define CONTROL_GMII_SEL_GMII1_SEL   (0x00000003u)
#define CONTROL_GMII_SEL_GMII1_SEL_SHIFT   (0x00000000u)

#define CONTROL_GMII_SEL_GMII2_SEL   (0x0000000Cu)
#define CONTROL_GMII_SEL_GMII2_SEL_SHIFT   (0x00000002u)

#define CONTROL_GMII_SEL_RGMII1_IDMODE   (0x00000010u)
#define CONTROL_GMII_SEL_RGMII1_IDMODE_SHIFT   (0x00000004u)

#define CONTROL_GMII_SEL_RGMII2_IDMOE   (0x00000020u)
#define CONTROL_GMII_SEL_RGMII2_IDMOE_SHIFT   (0x00000005u)

#define CONTROL_GMII_SEL_RMII1_IO_CLK_EN   (0x00000040u)
#define CONTROL_GMII_SEL_RMII1_IO_CLK_EN_SHIFT   (0x00000006u)

#define CONTROL_GMII_SEL_RMII2_IO_CLK_EN   (0x00000080u)
#define CONTROL_GMII_SEL_RMII2_IO_CLK_EN_SHIFT   (0x00000007u)


/* PWMSS_CTRL */
#define CONTROL_PWMSS_CTRL_PWMMS1_TBCLKEN   (0x00000002u)
#define CONTROL_PWMSS_CTRL_PWMMS1_TBCLKEN_SHIFT   (0x00000001u)

#define CONTROL_PWMSS_CTRL_PWMSS0_TBCLKEN   (0x00000001u)
#define CONTROL_PWMSS_CTRL_PWMSS0_TBCLKEN_SHIFT   (0x00000000u)

#define CONTROL_PWMSS_CTRL_PWMSS2_TBCLKEN   (0x00000004u)
#define CONTROL_PWMSS_CTRL_PWMSS2_TBCLKEN_SHIFT   (0x00000002u)


/* MREQPRIO_0 */
#define CONTROL_MREQPRIO_0_CPSW   (0x00070000u)
#define CONTROL_MREQPRIO_0_CPSW_SHIFT   (0x00000010u)

#define CONTROL_MREQPRIO_0_PRUSS1_PRU0   (0x00000700u)
#define CONTROL_MREQPRIO_0_PRUSS1_PRU0_SHIFT   (0x00000008u)

#define CONTROL_MREQPRIO_0_PRUSS1_PRU1   (0x00007000u)
#define CONTROL_MREQPRIO_0_PRUSS1_PRU1_SHIFT   (0x0000000Cu)

#define CONTROL_MREQPRIO_0_RSVD2   (0x00000080u)
#define CONTROL_MREQPRIO_0_RSVD2_SHIFT   (0x00000007u)

#define CONTROL_MREQPRIO_0_RSVD3   (0x00000800u)
#define CONTROL_MREQPRIO_0_RSVD3_SHIFT   (0x0000000Bu)

#define CONTROL_MREQPRIO_0_RSVD4   (0x00008000u)
#define CONTROL_MREQPRIO_0_RSVD4_SHIFT   (0x0000000Fu)

#define CONTROL_MREQPRIO_0_RSVD5   (0x00080000u)
#define CONTROL_MREQPRIO_0_RSVD5_SHIFT   (0x00000013u)

#define CONTROL_MREQPRIO_0_RSVD6   (0x00800000u)
#define CONTROL_MREQPRIO_0_RSVD6_SHIFT   (0x00000017u)

#define CONTROL_MREQPRIO_0_RSVD7   (0x08000000u)
#define CONTROL_MREQPRIO_0_RSVD7_SHIFT   (0x0000001Bu)

#define CONTROL_MREQPRIO_0_RSVD8   (0x80000000u)
#define CONTROL_MREQPRIO_0_RSVD8_SHIFT   (0x0000001Fu)

#define CONTROL_MREQPRIO_0_SAB_INIT0   (0x00000007u)
#define CONTROL_MREQPRIO_0_SAB_INIT0_SHIFT   (0x00000000u)

#define CONTROL_MREQPRIO_0_SAB_INIT1   (0x00000070u)
#define CONTROL_MREQPRIO_0_SAB_INIT1_SHIFT   (0x00000004u)

#define CONTROL_MREQPRIO_0_SGX   (0x70000000u)
#define CONTROL_MREQPRIO_0_SGX_SHIFT   (0x0000001Cu)

#define CONTROL_MREQPRIO_0_USB0   (0x00700000u)
#define CONTROL_MREQPRIO_0_USB0_SHIFT   (0x00000014u)

#define CONTROL_MREQPRIO_0_USB1   (0x07000000u)
#define CONTROL_MREQPRIO_0_USB1_SHIFT   (0x00000018u)


/* MREQPRIO_1 */
#define CONTROL_MREQPRIO_1_EXP   (0x00000007u)
#define CONTROL_MREQPRIO_1_EXP_SHIFT   (0x00000000u)


/* HW_EVENT_SEL_GRP1 */
#define CONTROL_HW_EVENT_SEL_GRP1_EVENT1   (0x000000FFu)
#define CONTROL_HW_EVENT_SEL_GRP1_EVENT1_SHIFT   (0x00000000u)

#define CONTROL_HW_EVENT_SEL_GRP1_EVENT2   (0x0000FF00u)
#define CONTROL_HW_EVENT_SEL_GRP1_EVENT2_SHIFT   (0x00000008u)

#define CONTROL_HW_EVENT_SEL_GRP1_EVENT3   (0x00FF0000u)
#define CONTROL_HW_EVENT_SEL_GRP1_EVENT3_SHIFT   (0x00000010u)

#define CONTROL_HW_EVENT_SEL_GRP1_EVENT4   (0xFF000000u)
#define CONTROL_HW_EVENT_SEL_GRP1_EVENT4_SHIFT   (0x00000018u)


/* HW_EVENT_SEL_GRP2 */
#define CONTROL_HW_EVENT_SEL_GRP2_EVENT5   (0x000000FFu)
#define CONTROL_HW_EVENT_SEL_GRP2_EVENT5_SHIFT   (0x00000000u)

#define CONTROL_HW_EVENT_SEL_GRP2_EVENT6   (0x0000FF00u)
#define CONTROL_HW_EVENT_SEL_GRP2_EVENT6_SHIFT   (0x00000008u)

#define CONTROL_HW_EVENT_SEL_GRP2_EVENT7   (0x00FF0000u)
#define CONTROL_HW_EVENT_SEL_GRP2_EVENT7_SHIFT   (0x00000010u)

#define CONTROL_HW_EVENT_SEL_GRP2_EVENT8   (0xFF000000u)
#define CONTROL_HW_EVENT_SEL_GRP2_EVENT8_SHIFT   (0x00000018u)


/* HW_EVENT_SEL_GRP3 */
#define CONTROL_HW_EVENT_SEL_GRP3_EVENT10   (0x0000FF00u)
#define CONTROL_HW_EVENT_SEL_GRP3_EVENT10_SHIFT   (0x00000008u)

#define CONTROL_HW_EVENT_SEL_GRP3_EVENT11   (0x00FF0000u)
#define CONTROL_HW_EVENT_SEL_GRP3_EVENT11_SHIFT   (0x00000010u)

#define CONTROL_HW_EVENT_SEL_GRP3_EVENT12   (0xFF000000u)
#define CONTROL_HW_EVENT_SEL_GRP3_EVENT12_SHIFT   (0x00000018u)

#define CONTROL_HW_EVENT_SEL_GRP3_EVENT9   (0x000000FFu)
#define CONTROL_HW_EVENT_SEL_GRP3_EVENT9_SHIFT   (0x00000000u)


/* HW_EVENT_SEL_GRP4 */
#define CONTROL_HW_EVENT_SEL_GRP4_EVENT13   (0x000000FFu)
#define CONTROL_HW_EVENT_SEL_GRP4_EVENT13_SHIFT   (0x00000000u)

#define CONTROL_HW_EVENT_SEL_GRP4_EVENT14   (0x0000FF00u)
#define CONTROL_HW_EVENT_SEL_GRP4_EVENT14_SHIFT   (0x00000008u)

#define CONTROL_HW_EVENT_SEL_GRP4_EVENT15   (0x00FF0000u)
#define CONTROL_HW_EVENT_SEL_GRP4_EVENT15_SHIFT   (0x00000010u)

#define CONTROL_HW_EVENT_SEL_GRP4_EVENT16   (0xFF000000u)
#define CONTROL_HW_EVENT_SEL_GRP4_EVENT16_SHIFT   (0x00000018u)


/* SMRT_CTRL */
#define CONTROL_SMRT_CTRL_SR0_SLEEP   (0x00000001u)
#define CONTROL_SMRT_CTRL_SR0_SLEEP_SHIFT   (0x00000000u)

#define CONTROL_SMRT_CTRL_SR1_SLEEP   (0x00000002u)
#define CONTROL_SMRT_CTRL_SR1_SLEEP_SHIFT   (0x00000001u)


/* SABTOOTH_HW_DEBUG_SEL */
#define CONTROL_SABTOOTH_HW_DEBUG_SEL_HW_DBG_GATE_EN   (0x00000200u)
#define CONTROL_SABTOOTH_HW_DEBUG_SEL_HW_DBG_GATE_EN_SHIFT   (0x00000009u)

#define CONTROL_SABTOOTH_HW_DEBUG_SEL_HW_DBG_SEL   (0x0000000Fu)
#define CONTROL_SABTOOTH_HW_DEBUG_SEL_HW_DBG_SEL_SHIFT   (0x00000000u)

#define CONTROL_SABTOOTH_HW_DEBUG_SEL_RSVD3   (0xFFFFFC00u)
#define CONTROL_SABTOOTH_HW_DEBUG_SEL_RSVD3_SHIFT   (0x0000000Au)


/* SABTOOTH_HW_DBG_INFO */
#define CONTROL_SABTOOTH_HW_DBG_INFO_HW_DBG_INFO   (0xFFFFFFFFu)
#define CONTROL_SABTOOTH_HW_DBG_INFO_HW_DBG_INFO_SHIFT   (0x00000000u)


/* MRGN_MODE0 */
#define CONTROL_MRGN_MODE0_MMODE0   (0x00000003u)
#define CONTROL_MRGN_MODE0_MMODE0_SHIFT   (0x00000000u)

#define CONTROL_MRGN_MODE0_MMODE1   (0x0000000Cu)
#define CONTROL_MRGN_MODE0_MMODE1_SHIFT   (0x00000002u)

#define CONTROL_MRGN_MODE0_MMODE10   (0x00300000u)
#define CONTROL_MRGN_MODE0_MMODE10_SHIFT   (0x00000014u)

#define CONTROL_MRGN_MODE0_MMODE11   (0x00C00000u)
#define CONTROL_MRGN_MODE0_MMODE11_SHIFT   (0x00000016u)

#define CONTROL_MRGN_MODE0_MMODE12   (0x03000000u)
#define CONTROL_MRGN_MODE0_MMODE12_SHIFT   (0x00000018u)

#define CONTROL_MRGN_MODE0_MMODE13   (0x0C000000u)
#define CONTROL_MRGN_MODE0_MMODE13_SHIFT   (0x0000001Au)

#define CONTROL_MRGN_MODE0_MMODE14   (0x30000000u)
#define CONTROL_MRGN_MODE0_MMODE14_SHIFT   (0x0000001Cu)

#define CONTROL_MRGN_MODE0_MMODE15   (0xC0000000u)
#define CONTROL_MRGN_MODE0_MMODE15_SHIFT   (0x0000001Eu)

#define CONTROL_MRGN_MODE0_MMODE2   (0x00000030u)
#define CONTROL_MRGN_MODE0_MMODE2_SHIFT   (0x00000004u)

#define CONTROL_MRGN_MODE0_MMODE3   (0x000000C0u)
#define CONTROL_MRGN_MODE0_MMODE3_SHIFT   (0x00000006u)

#define CONTROL_MRGN_MODE0_MMODE4   (0x00000300u)
#define CONTROL_MRGN_MODE0_MMODE4_SHIFT   (0x00000008u)

#define CONTROL_MRGN_MODE0_MMODE5   (0x00000C00u)
#define CONTROL_MRGN_MODE0_MMODE5_SHIFT   (0x0000000Au)

#define CONTROL_MRGN_MODE0_MMODE6   (0x00003000u)
#define CONTROL_MRGN_MODE0_MMODE6_SHIFT   (0x0000000Cu)

#define CONTROL_MRGN_MODE0_MMODE7   (0x0000C000u)
#define CONTROL_MRGN_MODE0_MMODE7_SHIFT   (0x0000000Eu)

#define CONTROL_MRGN_MODE0_MMODE8   (0x00030000u)
#define CONTROL_MRGN_MODE0_MMODE8_SHIFT   (0x00000010u)

#define CONTROL_MRGN_MODE0_MMODE9   (0x000C0000u)
#define CONTROL_MRGN_MODE0_MMODE9_SHIFT   (0x00000012u)


/* MRGN_MODE1 */
#define CONTROL_MRGN_MODE1_MMODE16   (0x00000003u)
#define CONTROL_MRGN_MODE1_MMODE16_SHIFT   (0x00000000u)

#define CONTROL_MRGN_MODE1_MMODE17   (0x0000000Cu)
#define CONTROL_MRGN_MODE1_MMODE17_SHIFT   (0x00000002u)

#define CONTROL_MRGN_MODE1_MMODE18   (0x00000030u)
#define CONTROL_MRGN_MODE1_MMODE18_SHIFT   (0x00000004u)

#define CONTROL_MRGN_MODE1_MMODE19   (0x000000C0u)
#define CONTROL_MRGN_MODE1_MMODE19_SHIFT   (0x00000006u)


/* VDD_MPU_OPP_050 */
#define CONTROL_VDD_MPU_OPP_050_NTARGET   (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_050_NTARGET_SHIFT   (0x00000000u)


/* VDD_MPU_OPP_100 */
#define CONTROL_VDD_MPU_OPP_100_NTARGET   (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_100_NTARGET_SHIFT   (0x00000000u)


/* VDD_MPU_OPP_119 */
#define CONTROL_VDD_MPU_OPP_119_NTARGET   (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_119_NTARGET_SHIFT   (0x00000000u)


/* VDD_MPU_OPP_TURBO */
#define CONTROL_VDD_MPU_OPP_TURBO_NTARGET   (0x00FFFFFFu)
#define CONTROL_VDD_MPU_OPP_TURBO_NTARGET_SHIFT   (0x00000000u)


/* VDD_CORE_OPP_050 */
#define CONTROL_VDD_CORE_OPP_050_NTARGET   (0x00FFFFFFu)
#define CONTROL_VDD_CORE_OPP_050_NTARGET_SHIFT   (0x00000000u)


/* VDD_CORE_OPP_100 */
#define CONTROL_VDD_CORE_OPP_100_NTARGET   (0x00FFFFFFu)
#define CONTROL_VDD_CORE_OPP_100_NTARGET_SHIFT   (0x00000000u)


/* BB_SCALE */
#define CONTROL_BB_SCALE_BBIAS   (0x00000003u)
#define CONTROL_BB_SCALE_BBIAS_SHIFT   (0x00000000u)

#define CONTROL_BB_SCALE_RSVD2   (0xFFFFF000u)
#define CONTROL_BB_SCALE_RSVD2_SHIFT   (0x0000000Cu)

#define CONTROL_BB_SCALE_SCALE   (0x00000F00u)
#define CONTROL_BB_SCALE_SCALE_SHIFT   (0x00000008u)


/* USB_VID_PID */
#define CONTROL_USB_VID_PID_USB_PID   (0x0000FFFFu)
#define CONTROL_USB_VID_PID_USB_PID_SHIFT   (0x00000000u)

#define CONTROL_USB_VID_PID_USB_VID   (0xFFFF0000u)
#define CONTROL_USB_VID_PID_USB_VID_SHIFT   (0x00000010u)


/* EFUSE_SMA */
#define CONTROL_EFUSE_SMA_EFUSE_SMA   (0xFFFFFFFFu)
#define CONTROL_EFUSE_SMA_EFUSE_SMA_SHIFT   (0x00000000u)


/* CONF_GPMC_ADx */
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD_CONF_GPMC_AD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD0 */
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD0_CONF_GPMC_AD0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD1 */
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD1_CONF_GPMC_AD1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD2 */
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD2_CONF_GPMC_AD2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD3 */
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD3_CONF_GPMC_AD3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD4 */
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD4_CONF_GPMC_AD4_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD5 */
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD5_CONF_GPMC_AD5_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD6 */
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD6_CONF_GPMC_AD6_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD7 */
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD7_CONF_GPMC_AD7_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD8 */
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD8_CONF_GPMC_AD8_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD9 */
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD9_CONF_GPMC_AD9_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD10 */
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD10_CONF_GPMC_AD10_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD11 */
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD11_CONF_GPMC_AD11_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD12 */
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD12_CONF_GPMC_AD12_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD13 */
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD13_CONF_GPMC_AD13_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD14 */
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD14_CONF_GPMC_AD14_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_AD15 */
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_AD15_CONF_GPMC_AD15_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A0 */
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A0_CONF_GPMC_A0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A1 */
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A1_CONF_GPMC_A1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A2 */
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A2_CONF_GPMC_A2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A3 */
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A3_CONF_GPMC_A3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A4 */
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A4_CONF_GPMC_A4_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A5 */
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A5_CONF_GPMC_A5_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A6 */
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A6_CONF_GPMC_A6_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A7 */
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A7_CONF_GPMC_A7_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A8 */
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A8_CONF_GPMC_A8_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A9 */
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A9_CONF_GPMC_A9_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A10 */
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A10_CONF_GPMC_A10_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_A11 */
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_A11_CONF_GPMC_A11_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_WAIT0 */
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_WAIT0_CONF_GPMC_WAIT0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_WPN */
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_WPN_CONF_GPMC_WPN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_BE1N */
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_BE1N_CONF_GPMC_BE1N_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_CSN0 */
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_CSN0_CONF_GPMC_CSN0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_CSN1 */
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_CSN1_CONF_GPMC_CSN1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_CSN2 */
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_CSN2_CONF_GPMC_CSN2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_CSN3 */
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_CSN3_CONF_GPMC_CSN3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_CLK */
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_CLK_CONF_GPMC_CLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_ADVN_ALE */
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_ADVN_ALE_CONF_GPMC_ADVN_ALE_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_OEN_REN */
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_OEN_REN_CONF_GPMC_OEN_REN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_WEN */
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_WEN_CONF_GPMC_WEN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_GPMC_BE0N_CLE */
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_MMODE   (0x00000007u)
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_PUDEN   (0x00000008u)
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_RSVD   (0x000FFF80u)
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_GPMC_BE0N_CLE_CONF_GPMC_BE0N_CLE_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA0 */
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA0_CONF_LCD_DATA0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA1 */
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA1_CONF_LCD_DATA1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA2 */
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA2_CONF_LCD_DATA2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA3 */
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA3_CONF_LCD_DATA3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA4 */
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA4_CONF_LCD_DATA4_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA5 */
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA5_CONF_LCD_DATA5_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA6 */
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA6_CONF_LCD_DATA6_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA7 */
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA7_CONF_LCD_DATA7_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA8 */
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA8_CONF_LCD_DATA8_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA9 */
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA9_CONF_LCD_DATA9_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA10 */
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA10_CONF_LCD_DATA10_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA11 */
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA11_CONF_LCD_DATA11_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA12 */
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA12_CONF_LCD_DATA12_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA13 */
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA13_CONF_LCD_DATA13_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA14 */
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA14_CONF_LCD_DATA14_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA15 */
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA15_CONF_LCD_DATA15_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA16 */
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA16_CONF_LCD_DATA16_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA17 */
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA17_CONF_LCD_DATA17_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA18 */
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA18_CONF_LCD_DATA18_SLEWCTRL_SHIFT   (0x00000006u)

/* CONF_LCD_DATA19 */
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA19_CONF_LCD_DATA19_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA20 */
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA20_CONF_LCD_DATA20_SLEWCTRL_SHIFT   (0x00000006u)

/* CONF_LCD_DATA21 */
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA21_CONF_LCD_DATA21_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_DATA22 */
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA22_CONF_LCD_DATA22_SLEWCTRL_SHIFT   (0x00000006u)

/* CONF_LCD_DATA20 */
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_DATA23_CONF_LCD_DATA23_SLEWCTRL_SHIFT   (0x00000006u)









/* CONF_LCD_VSYNC */
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_VSYNC_CONF_LCD_VSYNC_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_HSYNC */
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_HSYNC_CONF_LCD_HSYNC_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_PCLK */
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_PCLK_CONF_LCD_PCLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_LCD_AC_BIAS_EN */
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_MMODE   (0x00000007u)
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_PUDEN   (0x00000008u)
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_LCD_AC_BIAS_EN_CONF_LCD_AC_BIAS_EN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MMC0_DAT3 */
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_MMODE   (0x00000007u)
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_PUDEN   (0x00000008u)
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MMC0_DAT3_CONF_MMC0_DAT3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MMC0_DAT2 */
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_MMODE   (0x00000007u)
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_PUDEN   (0x00000008u)
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MMC0_DAT2_CONF_MMC0_DAT2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MMC0_DAT1 */
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_MMODE   (0x00000007u)
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_PUDEN   (0x00000008u)
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MMC0_DAT1_CONF_MMC0_DAT1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MMC0_DAT0 */
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_MMODE   (0x00000007u)
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_PUDEN   (0x00000008u)
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MMC0_DAT0_CONF_MMC0_DAT0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MMC0_CLK */
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_MMODE   (0x00000007u)
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MMC0_CLK_CONF_MMC0_CLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MMC0_CMD */
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_MMODE   (0x00000007u)
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_PUDEN   (0x00000008u)
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MMC0_CMD_CONF_MMC0_CMD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_COL */
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_COL_CONF_MII1_COL_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_CRS */
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_CRS_CONF_MII1_CRS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXERR */
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXERR_CONF_MII1_RXERR_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_TXEN */
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_TXEN_CONF_MII1_TXEN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXDV */
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXDV_CONF_MII1_RXDV_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_TXD3 */
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_TXD3_CONF_MII1_TXD3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_TXD2 */
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_TXD2_CONF_MII1_TXD2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_TXD1 */
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_TXD1_CONF_MII1_TXD1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_TXD0 */
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_TXD0_CONF_MII1_TXD0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_TXCLK */
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_TXCLK_CONF_MII1_TXCLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXCLK */
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXCLK_CONF_MII1_RXCLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXD3 */
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXD3_CONF_MII1_RXD3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXD2 */
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXD2_CONF_MII1_RXD2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXD1 */
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXD1_CONF_MII1_RXD1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MII1_RXD0 */
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_MMODE   (0x00000007u)
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_PUDEN   (0x00000008u)
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MII1_RXD0_CONF_MII1_RXD0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_RMII1_REFCLK */
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_MMODE   (0x00000007u)
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_RMII1_REFCLK_CONF_RMII1_REFCLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MDIO_DATA */
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_MMODE   (0x00000007u)
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_PUDEN   (0x00000008u)
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MDIO_DATA_CONF_MDIO_DATA_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MDIO_CLK */
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_MMODE   (0x00000007u)
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MDIO_CLK_CONF_MDIO_CLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_SPI0_SCLK */
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_MMODE   (0x00000007u)
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_PUDEN   (0x00000008u)
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_SPI0_SCLK_CONF_SPI0_SCLK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_SPI0_D0 */
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_MMODE   (0x00000007u)
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_PUDEN   (0x00000008u)
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_SPI0_D0_CONF_SPI0_D0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_SPI0_D1 */
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_MMODE   (0x00000007u)
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_PUDEN   (0x00000008u)
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_SPI0_D1_CONF_SPI0_D1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_SPI0_CS0 */
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_MMODE   (0x00000007u)
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_PUDEN   (0x00000008u)
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_SPI0_CS0_CONF_SPI0_CS0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_SPI0_CS1 */
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_MMODE   (0x00000007u)
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_PUDEN   (0x00000008u)
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_SPI0_CS1_CONF_SPI0_CS1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_ECAP0_IN_PWM0_OUT */
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_MMODE   (0x00000007u)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_PUDEN   (0x00000008u)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_RSVD   (0x000FFF80u)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_ECAP0_IN_PWM0_OUT_CONF_ECAP0_IN_PWM0_OUT_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART0_CTSN */
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_MMODE   (0x00000007u)
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART0_CTSN_CONF_UART0_CTSN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART0_RTSN */
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_MMODE   (0x00000007u)
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART0_RTSN_CONF_UART0_RTSN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART0_RXD */
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_MMODE   (0x00000007u)
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART0_RXD_CONF_UART0_RXD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART0_TXD */
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_MMODE   (0x00000007u)
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART0_TXD_CONF_UART0_TXD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART1_CTSN */
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_MMODE   (0x00000007u)
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART1_CTSN_CONF_UART1_CTSN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART1_RTSN */
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_MMODE   (0x00000007u)
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART1_RTSN_CONF_UART1_RTSN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART1_RXD */
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_MMODE   (0x00000007u)
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART1_RXD_CONF_UART1_RXD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_UART1_TXD */
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_MMODE   (0x00000007u)
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_PUDEN   (0x00000008u)
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_UART1_TXD_CONF_UART1_TXD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_I2C0_SDA */
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_MMODE   (0x00000007u)
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_PUDEN   (0x00000008u)
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_RSVD   (0x000FFF80u)
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_I2C0_SDA_CONF_I2C0_SDA_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_I2C0_SCL */
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_MMODE   (0x00000007u)
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_PUDEN   (0x00000008u)
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_RSVD   (0x000FFF80u)
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_I2C0_SCL_CONF_I2C0_SCL_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_I2C0_SDA */
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_MMODE   (0x00000007u)
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_PUDEN   (0x00000008u)
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_RSVD   (0x000FFF80u)
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_I2C1_SDA_CONF_I2C1_SDA_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_I2C0_SCL */
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_MMODE   (0x00000007u)
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_PUDEN   (0x00000008u)
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_RSVD   (0x000FFF80u)
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_I2C1_SCL_CONF_I2C1_SCL_SLEWCTRL_SHIFT   (0x00000006u)



/* CONF_MCASP0_ACLKX */
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_ACLKX_CONF_MCASP0_ACLKX_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_FSX */
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_FSX_CONF_MCASP0_FSX_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_AXR0 */
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_AXR0_CONF_MCASP0_AXR0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_AHCLKR */
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_AHCLKR_CONF_MCASP0_AHCLKR_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_ACLKR */
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_ACLKR_CONF_MCASP0_ACLKR_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_FSR */
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_FSR_CONF_MCASP0_FSR_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_AXR1 */
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_AXR1_CONF_MCASP0_AXR1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_MCASP0_AHCLKX */
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_MMODE   (0x00000007u)
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_PUDEN   (0x00000008u)
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_RSVD   (0x000FFF80u)
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_MCASP0_AHCLKX_CONF_MCASP0_AHCLKX_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_XDMA_EVENT_INTR0 */
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_MMODE   (0x00000007u)
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_PUDEN   (0x00000008u)
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_XDMA_EVENT_INTR0_CONF_XDMA_EVENT_INTR0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_XDMA_EVENT_INTR1 */
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_MMODE   (0x00000007u)
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_PUDEN   (0x00000008u)
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_XDMA_EVENT_INTR1_CONF_XDMA_EVENT_INTR1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_NRESETIN_OUT */
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_MMODE   (0x00000007u)
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_PUDEN   (0x00000008u)
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_RSVD   (0x000FFF80u)
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_NRESETIN_OUT_CONF_NRESETIN_OUT_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_PORZ */
#define CONTROL_CONF_PORZ_CONF_PORZ_MMODE   (0x00000007u)
#define CONTROL_CONF_PORZ_CONF_PORZ_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_PORZ_CONF_PORZ_PUDEN   (0x00000008u)
#define CONTROL_CONF_PORZ_CONF_PORZ_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_PORZ_CONF_PORZ_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_PORZ_CONF_PORZ_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_PORZ_CONF_PORZ_RSVD   (0x000FFF80u)
#define CONTROL_CONF_PORZ_CONF_PORZ_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_PORZ_CONF_PORZ_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_PORZ_CONF_PORZ_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_PORZ_CONF_PORZ_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_PORZ_CONF_PORZ_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_NNMI */
#define CONTROL_CONF_NNMI_CONF_NNMI_MMODE   (0x00000007u)
#define CONTROL_CONF_NNMI_CONF_NNMI_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_NNMI_CONF_NNMI_PUDEN   (0x00000008u)
#define CONTROL_CONF_NNMI_CONF_NNMI_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_NNMI_CONF_NNMI_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_NNMI_CONF_NNMI_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_NNMI_CONF_NNMI_RSVD   (0x000FFF80u)
#define CONTROL_CONF_NNMI_CONF_NNMI_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_NNMI_CONF_NNMI_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_NNMI_CONF_NNMI_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_NNMI_CONF_NNMI_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_NNMI_CONF_NNMI_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_OSC0_IN */
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_MMODE   (0x00000007u)
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_PUDEN   (0x00000008u)
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_OSC0_IN_CONF_OSC0_IN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_OSC0_OUT */
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_MMODE   (0x00000007u)
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_PUDEN   (0x00000008u)
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_RSVD   (0x000FFF80u)
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_OSC0_OUT_CONF_OSC0_OUT_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_OSC0_VSS */
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_MMODE   (0x00000007u)
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_PUDEN   (0x00000008u)
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_OSC0_VSS_CONF_OSC0_VSS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_TMS */
#define CONTROL_CONF_TMS_CONF_TMS_MMODE   (0x00000007u)
#define CONTROL_CONF_TMS_CONF_TMS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_TMS_CONF_TMS_PUDEN   (0x00000008u)
#define CONTROL_CONF_TMS_CONF_TMS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_TMS_CONF_TMS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_TMS_CONF_TMS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_TMS_CONF_TMS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_TMS_CONF_TMS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_TMS_CONF_TMS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_TMS_CONF_TMS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_TMS_CONF_TMS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_TMS_CONF_TMS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_TDI */
#define CONTROL_CONF_TDI_CONF_TDI_MMODE   (0x00000007u)
#define CONTROL_CONF_TDI_CONF_TDI_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_TDI_CONF_TDI_PUDEN   (0x00000008u)
#define CONTROL_CONF_TDI_CONF_TDI_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_TDI_CONF_TDI_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_TDI_CONF_TDI_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_TDI_CONF_TDI_RSVD   (0x000FFF80u)
#define CONTROL_CONF_TDI_CONF_TDI_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_TDI_CONF_TDI_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_TDI_CONF_TDI_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_TDI_CONF_TDI_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_TDI_CONF_TDI_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_TDO */
#define CONTROL_CONF_TDO_CONF_TDO_MMODE   (0x00000007u)
#define CONTROL_CONF_TDO_CONF_TDO_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_TDO_CONF_TDO_PUDEN   (0x00000008u)
#define CONTROL_CONF_TDO_CONF_TDO_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_TDO_CONF_TDO_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_TDO_CONF_TDO_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_TDO_CONF_TDO_RSVD   (0x000FFF80u)
#define CONTROL_CONF_TDO_CONF_TDO_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_TDO_CONF_TDO_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_TDO_CONF_TDO_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_TDO_CONF_TDO_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_TDO_CONF_TDO_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_TCK */
#define CONTROL_CONF_TCK_CONF_TCK_MMODE   (0x00000007u)
#define CONTROL_CONF_TCK_CONF_TCK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_TCK_CONF_TCK_PUDEN   (0x00000008u)
#define CONTROL_CONF_TCK_CONF_TCK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_TCK_CONF_TCK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_TCK_CONF_TCK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_TCK_CONF_TCK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_TCK_CONF_TCK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_TCK_CONF_TCK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_TCK_CONF_TCK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_TCK_CONF_TCK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_TCK_CONF_TCK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_NTRST */
#define CONTROL_CONF_NTRST_CONF_NTRST_MMODE   (0x00000007u)
#define CONTROL_CONF_NTRST_CONF_NTRST_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_NTRST_CONF_NTRST_PUDEN   (0x00000008u)
#define CONTROL_CONF_NTRST_CONF_NTRST_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_NTRST_CONF_NTRST_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_NTRST_CONF_NTRST_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_NTRST_CONF_NTRST_RSVD   (0x000FFF80u)
#define CONTROL_CONF_NTRST_CONF_NTRST_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_NTRST_CONF_NTRST_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_NTRST_CONF_NTRST_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_NTRST_CONF_NTRST_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_NTRST_CONF_NTRST_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_EMU0 */
#define CONTROL_CONF_EMU0_CONF_EMU0_MMODE   (0x00000007u)
#define CONTROL_CONF_EMU0_CONF_EMU0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_EMU0_CONF_EMU0_PUDEN   (0x00000008u)
#define CONTROL_CONF_EMU0_CONF_EMU0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_EMU0_CONF_EMU0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_EMU0_CONF_EMU0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_EMU0_CONF_EMU0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_EMU0_CONF_EMU0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_EMU0_CONF_EMU0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_EMU0_CONF_EMU0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_EMU0_CONF_EMU0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_EMU0_CONF_EMU0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_EMU1 */
#define CONTROL_CONF_EMU1_CONF_EMU1_MMODE   (0x00000007u)
#define CONTROL_CONF_EMU1_CONF_EMU1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_EMU1_CONF_EMU1_PUDEN   (0x00000008u)
#define CONTROL_CONF_EMU1_CONF_EMU1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_EMU1_CONF_EMU1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_EMU1_CONF_EMU1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_EMU1_CONF_EMU1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_EMU1_CONF_EMU1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_EMU1_CONF_EMU1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_EMU1_CONF_EMU1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_EMU1_CONF_EMU1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_EMU1_CONF_EMU1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_OSC1_IN */
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_MMODE   (0x00000007u)
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_PUDEN   (0x00000008u)
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_OSC1_IN_CONF_OSC1_IN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_OSC1_OUT */
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_MMODE   (0x00000007u)
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_PUDEN   (0x00000008u)
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_RSVD   (0x000FFF80u)
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_OSC1_OUT_CONF_OSC1_OUT_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_OSC1_VSS */
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_MMODE   (0x00000007u)
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_PUDEN   (0x00000008u)
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_OSC1_VSS_CONF_OSC1_VSS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_RTC_PORZ */
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_MMODE   (0x00000007u)
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_PUDEN   (0x00000008u)
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_RSVD   (0x000FFF80u)
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_RTC_PORZ_CONF_RTC_PORZ_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_PMIC_POWER_EN */
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_MMODE   (0x00000007u)
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_PUDEN   (0x00000008u)
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_PMIC_POWER_EN_CONF_PMIC_POWER_EN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_EXT_WAKEUP */
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_MMODE   (0x00000007u)
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_PUDEN   (0x00000008u)
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_RSVD   (0x000FFF80u)
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_EXT_WAKEUP_CONF_EXT_WAKEUP_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_ENZ_KALDO_1P8V */
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_MMODE   (0x00000007u)
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_PUDEN   (0x00000008u)
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_RSVD   (0x000FFF80u)
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_ENZ_KALDO_1P8V_CONF_ENZ_KALDO_1P8V_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB0_DM */
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_MMODE   (0x00000007u)
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB0_DM_CONF_USB0_DM_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB0_DP */
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_MMODE   (0x00000007u)
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB0_DP_CONF_USB0_DP_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB0_CE */
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_MMODE   (0x00000007u)
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB0_CE_CONF_USB0_CE_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB0_ID */
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_MMODE   (0x00000007u)
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB0_ID_CONF_USB0_ID_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB0_VBUS */
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_MMODE   (0x00000007u)
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB0_VBUS_CONF_USB0_VBUS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB0_DRVVBUS */
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_MMODE   (0x00000007u)
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB0_DRVVBUS_CONF_USB0_DRVVBUS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB1_DM */
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_MMODE   (0x00000007u)
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB1_DM_CONF_USB1_DM_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB1_DP */
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_MMODE   (0x00000007u)
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB1_DP_CONF_USB1_DP_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB1_CE */
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_MMODE   (0x00000007u)
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB1_CE_CONF_USB1_CE_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB1_ID */
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_MMODE   (0x00000007u)
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB1_ID_CONF_USB1_ID_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB1_VBUS */
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_MMODE   (0x00000007u)
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB1_VBUS_CONF_USB1_VBUS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_USB1_DRVVBUS */
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_MMODE   (0x00000007u)
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_PUDEN   (0x00000008u)
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_USB1_DRVVBUS_CONF_USB1_DRVVBUS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_RESETN */
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_RESETN_CONF_DDR_RESETN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_CSN0 */
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_CSN0_CONF_DDR_CSN0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_CKE */
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_RSVD2   (0x000FFF80u)
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_RSVD2_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_CKE_CONF_DDR_CK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_NCK */
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_NCK_CONF_DDR_NCK_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_CASN */
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_CASN_CONF_DDR_CASN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_RASN */
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_RASN_CONF_DDR_RASN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_WEN */
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_WEN_CONF_DDR_WEN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_BA0 */
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_BA0_CONF_DDR_BA0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_BA1 */
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_BA1_CONF_DDR_BA1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_BA2 */
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_BA2_CONF_DDR_BA2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A0 */
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A0_CONF_DDR_A0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A1 */
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A1_CONF_DDR_A1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A2 */
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A2_CONF_DDR_A2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A3 */
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A3_CONF_DDR_A3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A4 */
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A4_CONF_DDR_A4_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A5 */
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A5_CONF_DDR_A5_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A6 */
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A6_CONF_DDR_A6_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A7 */
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A7_CONF_DDR_A7_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A8 */
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A8_CONF_DDR_A8_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A9 */
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A9_CONF_DDR_A9_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A10 */
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A10_CONF_DDR_A10_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A11 */
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A11_CONF_DDR_A11_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A12 */
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A12_CONF_DDR_A12_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A13 */
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A13_CONF_DDR_A13_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A14 */
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A14_CONF_DDR_A14_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_A15 */
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_A15_CONF_DDR_A15_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_ODT */
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_ODT_CONF_DDR_ODT_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D0 */
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D0_CONF_DDR_D0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D1 */
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D1_CONF_DDR_D1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D2 */
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D2_CONF_DDR_D2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D3 */
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D3_CONF_DDR_D3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D4 */
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D4_CONF_DDR_D4_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D5 */
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D5_CONF_DDR_D5_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D6 */
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D6_CONF_DDR_D6_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D7 */
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D7_CONF_DDR_D7_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D8 */
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D8_CONF_DDR_D8_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D9 */
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D9_CONF_DDR_D9_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D10 */
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D10_CONF_DDR_D10_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D11 */
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D11_CONF_DDR_D11_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D12 */
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D12_CONF_DDR_D12_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D13 */
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D13_CONF_DDR_D13_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D14 */
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D14_CONF_DDR_D14_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_D15 */
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_D15_CONF_DDR_D15_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_DQM0 */
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_DQM0_CONF_DDR_DQM0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_DQM1 */
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_DQM1_CONF_DDR_DQM1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_DQS0 */
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_DQS0_CONF_DDR_DQS0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_DQSN0 */
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_DQSN0_CONF_DDR_DQSN0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_DQS1 */
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_DQS1_CONF_DDR_DQS1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_DQSN1 */
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_DQSN1_CONF_DDR_DQSN1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_VREF */
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_VREF_CONF_DDR_VREF_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_VTP */
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_VTP_CONF_DDR_VTP_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_STRBEN0 */
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_STRBEN0_CONF_DDR_STRBEN0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_DDR_STRBEN1 */
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_MMODE   (0x00000007u)
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_PUDEN   (0x00000008u)
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_DDR_STRBEN1_CONF_DDR_STRBEN1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN7 */
#define CONTROL_CONF_AIN7_CONF_AIN7_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN7_CONF_AIN7_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN7_CONF_AIN7_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN7_CONF_AIN7_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN7_CONF_AIN7_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN7_CONF_AIN7_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN7_CONF_AIN7_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN7_CONF_AIN7_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN7_CONF_AIN7_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN7_CONF_AIN7_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN7_CONF_AIN7_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN7_CONF_AIN7_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN6 */
#define CONTROL_CONF_AIN6_CONF_AIN6_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN6_CONF_AIN6_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN6_CONF_AIN6_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN6_CONF_AIN6_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN6_CONF_AIN6_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN6_CONF_AIN6_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN6_CONF_AIN6_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN6_CONF_AIN6_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN6_CONF_AIN6_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN6_CONF_AIN6_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN6_CONF_AIN6_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN6_CONF_AIN6_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN5 */
#define CONTROL_CONF_AIN5_CONF_AIN5_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN5_CONF_AIN5_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN5_CONF_AIN5_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN5_CONF_AIN5_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN5_CONF_AIN5_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN5_CONF_AIN5_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN5_CONF_AIN5_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN5_CONF_AIN5_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN5_CONF_AIN5_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN5_CONF_AIN5_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN5_CONF_AIN5_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN5_CONF_AIN5_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN4 */
#define CONTROL_CONF_AIN4_CONF_AIN4_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN4_CONF_AIN4_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN4_CONF_AIN4_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN4_CONF_AIN4_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN4_CONF_AIN4_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN4_CONF_AIN4_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN4_CONF_AIN4_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN4_CONF_AIN4_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN4_CONF_AIN4_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN4_CONF_AIN4_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN4_CONF_AIN4_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN4_CONF_AIN4_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN3 */
#define CONTROL_CONF_AIN3_CONF_AIN3_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN3_CONF_AIN3_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN3_CONF_AIN3_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN3_CONF_AIN3_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN3_CONF_AIN3_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN3_CONF_AIN3_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN3_CONF_AIN3_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN3_CONF_AIN3_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN3_CONF_AIN3_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN3_CONF_AIN3_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN3_CONF_AIN3_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN3_CONF_AIN3_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN2 */
#define CONTROL_CONF_AIN2_CONF_AIN2_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN2_CONF_AIN2_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN2_CONF_AIN2_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN2_CONF_AIN2_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN2_CONF_AIN2_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN2_CONF_AIN2_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN2_CONF_AIN2_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN2_CONF_AIN2_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN2_CONF_AIN2_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN2_CONF_AIN2_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN2_CONF_AIN2_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN2_CONF_AIN2_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN1 */
#define CONTROL_CONF_AIN1_CONF_AIN1_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN1_CONF_AIN1_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN1_CONF_AIN1_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN1_CONF_AIN1_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN1_CONF_AIN1_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN1_CONF_AIN1_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN1_CONF_AIN1_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN1_CONF_AIN1_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN1_CONF_AIN1_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN1_CONF_AIN1_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN1_CONF_AIN1_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN1_CONF_AIN1_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AIN0 */
#define CONTROL_CONF_AIN0_CONF_AIN0_MMODE   (0x00000007u)
#define CONTROL_CONF_AIN0_CONF_AIN0_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AIN0_CONF_AIN0_PUDEN   (0x00000008u)
#define CONTROL_CONF_AIN0_CONF_AIN0_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AIN0_CONF_AIN0_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AIN0_CONF_AIN0_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AIN0_CONF_AIN0_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AIN0_CONF_AIN0_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AIN0_CONF_AIN0_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AIN0_CONF_AIN0_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AIN0_CONF_AIN0_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AIN0_CONF_AIN0_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_VREFP */
#define CONTROL_CONF_VREFP_CONF_VREFP_MMODE   (0x00000007u)
#define CONTROL_CONF_VREFP_CONF_VREFP_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_VREFP_CONF_VREFP_PUDEN   (0x00000008u)
#define CONTROL_CONF_VREFP_CONF_VREFP_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_VREFP_CONF_VREFP_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_VREFP_CONF_VREFP_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_VREFP_CONF_VREFP_RSVD   (0x000FFF80u)
#define CONTROL_CONF_VREFP_CONF_VREFP_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_VREFP_CONF_VREFP_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_VREFP_CONF_VREFP_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_VREFP_CONF_VREFP_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_VREFP_CONF_VREFP_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_VREFN */
#define CONTROL_CONF_VREFN_CONF_VREFN_MMODE   (0x00000007u)
#define CONTROL_CONF_VREFN_CONF_VREFN_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_VREFN_CONF_VREFN_PUDEN   (0x00000008u)
#define CONTROL_CONF_VREFN_CONF_VREFN_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_VREFN_CONF_VREFN_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_VREFN_CONF_VREFN_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_VREFN_CONF_VREFN_RSVD   (0x000FFF80u)
#define CONTROL_CONF_VREFN_CONF_VREFN_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_VREFN_CONF_VREFN_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_VREFN_CONF_VREFN_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_VREFN_CONF_VREFN_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_VREFN_CONF_VREFN_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AVDD */
#define CONTROL_CONF_AVDD_CONF_AVDD_MMODE   (0x00000007u)
#define CONTROL_CONF_AVDD_CONF_AVDD_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AVDD_CONF_AVDD_PUDEN   (0x00000008u)
#define CONTROL_CONF_AVDD_CONF_AVDD_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AVDD_CONF_AVDD_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AVDD_CONF_AVDD_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AVDD_CONF_AVDD_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AVDD_CONF_AVDD_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AVDD_CONF_AVDD_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AVDD_CONF_AVDD_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AVDD_CONF_AVDD_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AVDD_CONF_AVDD_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_AVSS */
#define CONTROL_CONF_AVSS_CONF_AVSS_MMODE   (0x00000007u)
#define CONTROL_CONF_AVSS_CONF_AVSS_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_AVSS_CONF_AVSS_PUDEN   (0x00000008u)
#define CONTROL_CONF_AVSS_CONF_AVSS_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_AVSS_CONF_AVSS_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_AVSS_CONF_AVSS_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_AVSS_CONF_AVSS_RSVD   (0x000FFF80u)
#define CONTROL_CONF_AVSS_CONF_AVSS_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_AVSS_CONF_AVSS_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_AVSS_CONF_AVSS_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_AVSS_CONF_AVSS_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_AVSS_CONF_AVSS_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_IFORCE */
#define CONTROL_CONF_IFORCE_CONF_IFORCE_MMODE   (0x00000007u)
#define CONTROL_CONF_IFORCE_CONF_IFORCE_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_IFORCE_CONF_IFORCE_PUDEN   (0x00000008u)
#define CONTROL_CONF_IFORCE_CONF_IFORCE_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_IFORCE_CONF_IFORCE_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_IFORCE_CONF_IFORCE_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_IFORCE_CONF_IFORCE_RSVD   (0x000FFF80u)
#define CONTROL_CONF_IFORCE_CONF_IFORCE_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_IFORCE_CONF_IFORCE_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_IFORCE_CONF_IFORCE_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_IFORCE_CONF_IFORCE_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_IFORCE_CONF_IFORCE_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_VSENSE */
#define CONTROL_CONF_VSENSE_CONF_VSENSE_MMODE   (0x00000007u)
#define CONTROL_CONF_VSENSE_CONF_VSENSE_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_VSENSE_CONF_VSENSE_PUDEN   (0x00000008u)
#define CONTROL_CONF_VSENSE_CONF_VSENSE_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_VSENSE_CONF_VSENSE_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_VSENSE_CONF_VSENSE_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_VSENSE_CONF_VSENSE_RSVD   (0x000FFF80u)
#define CONTROL_CONF_VSENSE_CONF_VSENSE_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_VSENSE_CONF_VSENSE_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_VSENSE_CONF_VSENSE_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_VSENSE_CONF_VSENSE_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_VSENSE_CONF_VSENSE_SLEWCTRL_SHIFT   (0x00000006u)


/* CONF_TESTOUT */
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_MMODE   (0x00000007u)
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_MMODE_SHIFT   (0x00000000u)

#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_PUDEN   (0x00000008u)
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_PUDEN_SHIFT   (0x00000003u)

#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_PUTYPESEL   (0x00000010u)
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_PUTYPESEL_SHIFT   (0x00000004u)

#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_RSVD   (0x000FFF80u)
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_RSVD_SHIFT   (0x00000007u)

#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_RXACTIVE   (0x00000020u)
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_RXACTIVE_SHIFT   (0x00000005u)

#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_SLEWCTRL   (0x00000040u)
#define CONTROL_CONF_TESTOUT_CONF_TESTOUT_SLEWCTRL_SHIFT   (0x00000006u)


/* CQDETECT_STATUS */
#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_A   (0x00000800u)
#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_A_SHIFT   (0x0000000Bu)

#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_B   (0x00001000u)
#define CONTROL_CQDETECT_STATUS_CQERR_GEMAC_B_SHIFT   (0x0000000Cu)

#define CONTROL_CQDETECT_STATUS_CQERR_GENERAL   (0x00002000u)
#define CONTROL_CQDETECT_STATUS_CQERR_GENERAL_SHIFT   (0x0000000Du)

#define CONTROL_CQDETECT_STATUS_CQERR_GPMC   (0x00000100u)
#define CONTROL_CQDETECT_STATUS_CQERR_GPMC_SHIFT   (0x00000008u)

#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_A   (0x00000200u)
#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_A_SHIFT   (0x00000009u)

#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_B   (0x00000400u)
#define CONTROL_CQDETECT_STATUS_CQERR_MMCSD_B_SHIFT   (0x0000000Au)

#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_A   (0x00080000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_A_SHIFT   (0x00000013u)

#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_B   (0x00100000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GEMAC_B_SHIFT   (0x00000014u)

#define CONTROL_CQDETECT_STATUS_CQMODE_GENERAL   (0x00200000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GENERAL_SHIFT   (0x00000015u)

#define CONTROL_CQDETECT_STATUS_CQMODE_GPMC   (0x00010000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_GPMC_SHIFT   (0x00000010u)

#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_A   (0x00020000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_A_SHIFT   (0x00000011u)

#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_B   (0x00040000u)
#define CONTROL_CQDETECT_STATUS_CQMODE_MMCSD_B_SHIFT   (0x00000012u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_A   (0x00000008u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_A_SHIFT   (0x00000003u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_B   (0x00000010u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GEMAC_B_SHIFT   (0x00000004u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GENERAL   (0x00000020u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GENERAL_SHIFT   (0x00000005u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_GPMC   (0x00000001u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_GPMC_SHIFT   (0x00000000u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_A   (0x00000002u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_A_SHIFT   (0x00000001u)

#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_B   (0x00000004u)
#define CONTROL_CQDETECT_STATUS_CQSTAT_MMCSD_B_SHIFT   (0x00000002u)

#define CONTROL_CQDETECT_STATUS_RSVD2   (0x0000C000u)
#define CONTROL_CQDETECT_STATUS_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_CQDETECT_STATUS_RSVD3   (0xFFC00000u)
#define CONTROL_CQDETECT_STATUS_RSVD3_SHIFT   (0x00000016u)


/* DDR_IO_CTRL */
#define CONTROL_DDR_IO_CTRL_DDR3_RST_DEF_VAL   (0x80000000u)
#define CONTROL_DDR_IO_CTRL_DDR3_RST_DEF_VAL_SHIFT   (0x0000001Fu)

#define CONTROL_DDR_IO_CTRL_DDR_WUCLK_DISABLE   (0x40000000u)
#define CONTROL_DDR_IO_CTRL_DDR_WUCLK_DISABLE_SHIFT   (0x0000001Eu)

#define CONTROL_DDR_IO_CTRL_MDDR_SEL   (0x10000000u)
#define CONTROL_DDR_IO_CTRL_MDDR_SEL_SHIFT   (0x0000001Cu)

#define CONTROL_DDR_IO_CTRL_RSVD2   (0x20000000u)
#define CONTROL_DDR_IO_CTRL_RSVD2_SHIFT   (0x0000001Du)


/* VTP_CTRL */
#define CONTROL_VTP_CTRL_CLRZ   (0x00000001u)
#define CONTROL_VTP_CTRL_CLRZ_SHIFT   (0x00000000u)

#define CONTROL_VTP_CTRL_ENABLE   (0x00000040u)
#define CONTROL_VTP_CTRL_ENABLE_SHIFT   (0x00000006u)

#define CONTROL_VTP_CTRL_FILTER   (0x0000000Eu)
#define CONTROL_VTP_CTRL_FILTER_SHIFT   (0x00000001u)

#define CONTROL_VTP_CTRL_LOCK   (0x00000010u)
#define CONTROL_VTP_CTRL_LOCK_SHIFT   (0x00000004u)

#define CONTROL_VTP_CTRL_NCIN   (0x00007F00u)
#define CONTROL_VTP_CTRL_NCIN_SHIFT   (0x00000008u)

#define CONTROL_VTP_CTRL_PCIN   (0x007F0000u)
#define CONTROL_VTP_CTRL_PCIN_SHIFT   (0x00000010u)

#define CONTROL_VTP_CTRL_READY   (0x00000020u)
#define CONTROL_VTP_CTRL_READY_SHIFT   (0x00000005u)

#define CONTROL_VTP_CTRL_RSVD2   (0x00008000u)
#define CONTROL_VTP_CTRL_RSVD2_SHIFT   (0x0000000Fu)

#define CONTROL_VTP_CTRL_RSVD3   (0xFF800000u)
#define CONTROL_VTP_CTRL_RSVD3_SHIFT   (0x00000017u)


/* VREF_CTRL */
#define CONTROL_VREF_CTRL_DDR_VREF_CCAP   (0x00000018u)
#define CONTROL_VREF_CTRL_DDR_VREF_CCAP_SHIFT   (0x00000003u)

#define CONTROL_VREF_CTRL_DDR_VREF_EN   (0x00000001u)
#define CONTROL_VREF_CTRL_DDR_VREF_EN_SHIFT   (0x00000000u)

#define CONTROL_VREF_CTRL_DDR_VREF_TAP   (0x00000006u)
#define CONTROL_VREF_CTRL_DDR_VREF_TAP_SHIFT   (0x00000001u)


/* SERDES_REFCLK_CTL */
#define CONTROL_SERDES_REFCLK_CTL_PWRDN   (0x00000001u)
#define CONTROL_SERDES_REFCLK_CTL_PWRDN_SHIFT   (0x00000000u)

#define CONTROL_SERDES_REFCLK_CTL_PWRDN_SE   (0x00000002u)
#define CONTROL_SERDES_REFCLK_CTL_PWRDN_SE_SHIFT   (0x00000001u)


/* TPCC_EVT_MUX_0_3 */
#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_0   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_0_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_1   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_1_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_2   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_2_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_3   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_0_3_EVT_MUX_3_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_0_3_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_0_3_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_0_3_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_0_3_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_0_3_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_0_3_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_4_7 */
#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_4   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_4_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_5   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_5_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_6   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_6_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_7   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_4_7_EVT_MUX_7_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_4_7_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_4_7_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_4_7_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_4_7_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_4_7_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_4_7_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_8_11 */
#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_10   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_10_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_11   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_11_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_8   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_8_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_9   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_8_11_EVT_MUX_9_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_8_11_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_8_11_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_8_11_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_8_11_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_8_11_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_8_11_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_12_15 */
#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_12   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_12_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_13   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_13_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_14   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_14_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_15   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_12_15_EVT_MUX_15_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_12_15_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_12_15_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_12_15_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_12_15_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_12_15_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_12_15_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_16_19 */
#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_16   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_16_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_17   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_17_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_18   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_18_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_19   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_16_19_EVT_MUX_19_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_16_19_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_16_19_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_16_19_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_16_19_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_16_19_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_16_19_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_20_23 */
#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_20   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_20_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_21   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_21_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_22   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_22_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_23   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_20_23_EVT_MUX_23_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_20_23_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_20_23_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_20_23_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_20_23_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_20_23_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_20_23_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_24_27 */
#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_24   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_24_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_25   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_25_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_26   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_26_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_27   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_24_27_EVT_MUX_27_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_24_27_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_24_27_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_24_27_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_24_27_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_24_27_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_24_27_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_28_31 */
#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_28   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_28_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_29   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_29_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_30   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_30_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_31   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_28_31_EVT_MUX_31_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_28_31_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_28_31_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_28_31_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_28_31_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_28_31_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_28_31_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_32_35 */
#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_32   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_32_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_33   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_33_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_34   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_34_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_35   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_32_35_EVT_MUX_35_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_32_35_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_32_35_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_32_35_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_32_35_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_32_35_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_32_35_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_36_39 */
#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_36   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_36_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_37   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_37_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_38   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_38_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_39   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_36_39_EVT_MUX_39_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_36_39_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_36_39_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_36_39_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_36_39_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_36_39_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_36_39_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_40_43 */
#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_40   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_40_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_41   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_41_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_42   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_42_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_43   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_40_43_EVT_MUX_43_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_40_43_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_40_43_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_40_43_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_40_43_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_40_43_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_40_43_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_44_47 */
#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_44   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_44_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_45   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_45_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_46   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_46_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_47   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_44_47_EVT_MUX_47_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_44_47_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_44_47_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_44_47_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_44_47_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_44_47_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_44_47_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_48_51 */
#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_48   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_48_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_49   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_49_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_50   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_50_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_51   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_48_51_EVT_MUX_51_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_48_51_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_48_51_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_48_51_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_48_51_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_48_51_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_48_51_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_52_55 */
#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_52   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_52_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_53   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_53_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_54   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_54_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_55   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_52_55_EVT_MUX_55_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_52_55_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_52_55_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_52_55_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_52_55_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_52_55_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_52_55_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_56_59 */
#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_56   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_56_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_57   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_57_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_58   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_58_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_59   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_56_59_EVT_MUX_59_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_56_59_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_56_59_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_56_59_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_56_59_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_56_59_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_56_59_RSVD4_SHIFT   (0x0000001Eu)


/* TPCC_EVT_MUX_60_63 */
#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_60   (0x3F000000u)
#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_60_SHIFT   (0x00000018u)

#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_61   (0x003F0000u)
#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_61_SHIFT   (0x00000010u)

#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_62   (0x00003F00u)
#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_62_SHIFT   (0x00000008u)

#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_63   (0x0000003Fu)
#define CONTROL_TPCC_EVT_MUX_60_63_EVT_MUX_63_SHIFT   (0x00000000u)

#define CONTROL_TPCC_EVT_MUX_60_63_RSVD2   (0x0000C000u)
#define CONTROL_TPCC_EVT_MUX_60_63_RSVD2_SHIFT   (0x0000000Eu)

#define CONTROL_TPCC_EVT_MUX_60_63_RSVD3   (0x00C00000u)
#define CONTROL_TPCC_EVT_MUX_60_63_RSVD3_SHIFT   (0x00000016u)

#define CONTROL_TPCC_EVT_MUX_60_63_RSVD4   (0xC0000000u)
#define CONTROL_TPCC_EVT_MUX_60_63_RSVD4_SHIFT   (0x0000001Eu)


/* TIMER_EVT_CAPT */
#define CONTROL_TIMER_EVT_CAPT_RSVD2   (0x0000E000u)
#define CONTROL_TIMER_EVT_CAPT_RSVD2_SHIFT   (0x0000000Du)

#define CONTROL_TIMER_EVT_CAPT_RSVD3   (0xFFE00000u)
#define CONTROL_TIMER_EVT_CAPT_RSVD3_SHIFT   (0x00000015u)

#define CONTROL_TIMER_EVT_CAPT_TIMER5_EVTCAPT   (0x0000001Fu)
#define CONTROL_TIMER_EVT_CAPT_TIMER5_EVTCAPT_SHIFT   (0x00000000u)

#define CONTROL_TIMER_EVT_CAPT_TIMER6_EVTCAPT   (0x00001F00u)
#define CONTROL_TIMER_EVT_CAPT_TIMER6_EVTCAPT_SHIFT   (0x00000008u)

#define CONTROL_TIMER_EVT_CAPT_TIMER7_EVTCAPT   (0x001F0000u)
#define CONTROL_TIMER_EVT_CAPT_TIMER7_EVTCAPT_SHIFT   (0x00000010u)


/* ECAP_EVT_CAPT */
#define CONTROL_ECAP_EVT_CAPT_ECAP0_EVTCAPT   (0x0000001Fu)
#define CONTROL_ECAP_EVT_CAPT_ECAP0_EVTCAPT_SHIFT   (0x00000000u)

#define CONTROL_ECAP_EVT_CAPT_ECAP1_EVTCAPT   (0x00001F00u)
#define CONTROL_ECAP_EVT_CAPT_ECAP1_EVTCAPT_SHIFT   (0x00000008u)

#define CONTROL_ECAP_EVT_CAPT_ECAP2_EVTCAPT   (0x001F0000u)
#define CONTROL_ECAP_EVT_CAPT_ECAP2_EVTCAPT_SHIFT   (0x00000010u)

#define CONTROL_ECAP_EVT_CAPT_RSVD2   (0x0000E000u)
#define CONTROL_ECAP_EVT_CAPT_RSVD2_SHIFT   (0x0000000Du)

#define CONTROL_ECAP_EVT_CAPT_RSVD3   (0xFFE00000u)
#define CONTROL_ECAP_EVT_CAPT_RSVD3_SHIFT   (0x00000015u)


/* ADC_EVT_CAPT */
#define CONTROL_ADC_EVT_CAPT_ADC_EVTCAPT   (0x0000000Fu)
#define CONTROL_ADC_EVT_CAPT_ADC_EVTCAPT_SHIFT   (0x00000000u)


/* RESET_ISO */
#define CONTROL_RESET_ISO_ISO_CONTROL   (0x00000001u)
#define CONTROL_RESET_ISO_ISO_CONTROL_SHIFT   (0x00000000u)


/* SMA0 */
#define CONTROL_SMA0_SMA0   (0xFFFFFFFFu)
#define CONTROL_SMA0_SMA0_SHIFT   (0x00000000u)


/* DDR_CKE_CTRL */
#define CONTROL_DDR_CKE_CTRL_DDR_CKE_CTRL   (0x00000001u)
#define CONTROL_DDR_CKE_CTRL_DDR_CKE_CTRL_SHIFT   (0x00000000u)

#define CONTROL_DDR_CKE_CTRL_SMA1   (0xFFFFFFFEu)
#define CONTROL_DDR_CKE_CTRL_SMA1_SHIFT   (0x00000001u)


/* SMA2 */
#define CONTROL_SMA2_SMA2   (0xFFFFFFFFu)
#define CONTROL_SMA2_SMA2_SHIFT   (0x00000000u)


/* M3_TXEV_EOI */
#define CONTROL_M3_TXEV_EOI_M3_TXEV_EOI   (0x00000001u)
#define CONTROL_M3_TXEV_EOI_M3_TXEV_EOI_SHIFT   (0x00000000u)

#define CONTROL_M3_TXEV_EOI_SMA3   (0xFFFFFFFEu)
#define CONTROL_M3_TXEV_EOI_SMA3_SHIFT   (0x00000001u)


/* IPC_MSG_REG0 */
#define CONTROL_IPC_MSG_REG0_IPC_MSG_REG0   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG0_IPC_MSG_REG0_SHIFT   (0x00000000u)


/* IPC_MSG_REG1 */
#define CONTROL_IPC_MSG_REG1_IPC_MSG_REG1   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG1_IPC_MSG_REG1_SHIFT   (0x00000000u)


/* IPC_MSG_REG2 */
#define CONTROL_IPC_MSG_REG2_IPC_MSG_REG2   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG2_IPC_MSG_REG2_SHIFT   (0x00000000u)


/* IPC_MSG_REG3 */
#define CONTROL_IPC_MSG_REG3_IPC_MSG_REG3   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG3_IPC_MSG_REG3_SHIFT   (0x00000000u)


/* IPC_MSG_REG4 */
#define CONTROL_IPC_MSG_REG4_IPC_MSG_REG4   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG4_IPC_MSG_REG4_SHIFT   (0x00000000u)


/* IPC_MSG_REG5 */
#define CONTROL_IPC_MSG_REG5_IPC_MSG_REG5   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG5_IPC_MSG_REG5_SHIFT   (0x00000000u)


/* IPC_MSG_REG6 */
#define CONTROL_IPC_MSG_REG6_IPC_MSG_REG6   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG6_IPC_MSG_REG6_SHIFT   (0x00000000u)


/* IPC_MSG_REG7 */
#define CONTROL_IPC_MSG_REG7_IPC_MSG_REG7   (0xFFFFFFFFu)
#define CONTROL_IPC_MSG_REG7_IPC_MSG_REG7_SHIFT   (0x00000000u)


/* DDR_CMD0_IOCTRL */
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_GP_WD0   (0x001FFC00u)
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_GP_WD0_SHIFT   (0x0000000Au)

#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_GP_WD1   (0xFFE00000u)
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_GP_WD1_SHIFT   (0x00000015u)

#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_CMD0_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)


/* DDR_CMD1_IOCTRL */
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_GP_WD0   (0x001FFC00u)
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_GP_WD0_SHIFT   (0x0000000Au)

#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_GP_WD1   (0xFFE00000u)
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_GP_WD1_SHIFT   (0x00000015u)

#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_CMD1_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)


/* DDR_CMD2_IOCTRL */
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_GP_WD0   (0x001FFC00u)
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_GP_WD0_SHIFT   (0x0000000Au)

#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_GP_WD1   (0xFFE00000u)
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_GP_WD1_SHIFT   (0x00000015u)

#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_CMD2_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)


/* DDR_DATA0_IOCTRL */
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD0_DM   (0x00040000u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD0_DM_SHIFT   (0x00000012u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD0_DQ   (0x0003FC00u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD0_DQ_SHIFT   (0x0000000Au)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD0_DQS   (0x00080000u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD0_DQS_SHIFT   (0x00000013u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD1_DM   (0x10000000u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD1_DM_SHIFT   (0x0000001Cu)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD1_DQ   (0x0FF00000u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD1_DQ_SHIFT   (0x00000014u)

#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD1_DQS   (0x20000000u)
#define CONTROL_DDR_DATA0_IOCTRL_IO_CONFIG_WD1_DQS_SHIFT   (0x0000001Du)


/* DDR_DATA1_IOCTRL */
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD0_DM   (0x00040000u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD0_DM_SHIFT   (0x00000012u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD0_DQ   (0x0003FC00u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD0_DQ_SHIFT   (0x0000000Au)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD0_DQS   (0x00080000u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD0_DQS_SHIFT   (0x00000013u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD1_DM   (0x10000000u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD1_DM_SHIFT   (0x0000001Cu)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD1_DQ   (0x0FF00000u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD1_DQ_SHIFT   (0x00000014u)

#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD1_DQS   (0x20000000u)
#define CONTROL_DDR_DATA1_IOCTRL_IO_CONFIG_WD1_DQS_SHIFT   (0x0000001Du)


/* DDR_DATA2_IOCTRL */
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD0_DM   (0x00040000u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD0_DM_SHIFT   (0x00000012u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD0_DQ   (0x0003FC00u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD0_DQ_SHIFT   (0x0000000Au)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD0_DQS   (0x00080000u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD0_DQS_SHIFT   (0x00000013u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD1_DM   (0x10000000u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD1_DM_SHIFT   (0x0000001Cu)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD1_DQ   (0x0FF00000u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD1_DQ_SHIFT   (0x00000014u)

#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD1_DQS   (0x20000000u)
#define CONTROL_DDR_DATA2_IOCTRL_IO_CONFIG_WD1_DQS_SHIFT   (0x0000001Du)


/* DDR_DATA3_IOCTRL */
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD0_DM   (0x00040000u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD0_DM_SHIFT   (0x00000012u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD0_DQ   (0x0003FC00u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD0_DQ_SHIFT   (0x0000000Au)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD0_DQS   (0x00080000u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD0_DQS_SHIFT   (0x00000013u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD1_DM   (0x10000000u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD1_DM_SHIFT   (0x0000001Cu)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD1_DQ   (0x0FF00000u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD1_DQ_SHIFT   (0x00000014u)

#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD1_DQS   (0x20000000u)
#define CONTROL_DDR_DATA3_IOCTRL_IO_CONFIG_WD1_DQS_SHIFT   (0x0000001Du)


/* DDR_DATA4_IOCTRL */
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_I   (0x00000007u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_I_SHIFT   (0x00000000u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_I_CLK   (0x000000E0u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_I_CLK_SHIFT   (0x00000005u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_SR   (0x00000018u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_SR_SHIFT   (0x00000003u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_SR_CLK   (0x00000300u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_SR_CLK_SHIFT   (0x00000008u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD0_DM   (0x00040000u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD0_DM_SHIFT   (0x00000012u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD0_DQ   (0x0003FC00u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD0_DQ_SHIFT   (0x0000000Au)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD0_DQS   (0x00080000u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD0_DQS_SHIFT   (0x00000013u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD1_DM   (0x10000000u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD1_DM_SHIFT   (0x0000001Cu)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD1_DQ   (0x0FF00000u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD1_DQ_SHIFT   (0x00000014u)

#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD1_DQS   (0x20000000u)
#define CONTROL_DDR_DATA4_IOCTRL_IO_CONFIG_WD1_DQS_SHIFT   (0x0000001Du)


/* DIE_ID2 */
#define CONTROL_DIE_ID2_DIE_ID   (0xFFFFFFFFu)
#define CONTROL_DIE_ID2_DIE_ID_SHIFT   (0x00000000u)


/* ID_UNLOCK1 */
#define CONTROL_ID_UNLOCK1_ID_UNLOCK1   (0xFFFFFFFFu)
#define CONTROL_ID_UNLOCK1_ID_UNLOCK1_SHIFT   (0x00000000u)


/* ID_UNLOCK2 */
#define CONTROL_ID_UNLOCK2_ID_UNLOCK2   (0xFFFFFFFFu)
#define CONTROL_ID_UNLOCK2_ID_UNLOCK2_SHIFT   (0x00000000u)


/* DIE_ID0 */
#define CONTROL_DIE_ID0_DIE_ID   (0xFFFFFFFFu)
#define CONTROL_DIE_ID0_DIE_ID_SHIFT   (0x00000000u)


/* ID_UNLOCK0 */
#define CONTROL_ID_UNLOCK0_ID_UNLOCK0   (0xFFFFFFFFu)
#define CONTROL_ID_UNLOCK0_ID_UNLOCK0_SHIFT   (0x00000000u)


/* DIE_ID1 */
#define CONTROL_DIE_ID1_DIE_ID   (0xFFFFFFFFu)
#define CONTROL_DIE_ID1_DIE_ID_SHIFT   (0x00000000u)


/* ID_UNLOCK3 */
#define CONTROL_ID_UNLOCK3_ID_UNLOCK3   (0xFFFFFFFFu)
#define CONTROL_ID_UNLOCK3_ID_UNLOCK3_SHIFT   (0x00000000u)


/* DIE_ID3 */
#define CONTROL_DIE_ID3_DIE_ID   (0xFFFFFFFFu)
#define CONTROL_DIE_ID3_DIE_ID_SHIFT   (0x00000000u)



#ifdef __cplusplus
}
#endif

#endif
