

/**
 *  @Component:   CPSW
 *
 *  @Filename:    cpsw_ale_cred.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_CPSW_ALE_H_
#define _HW_CPSW_ALE_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CPSW_ALE_IDVER   (0x0)
#define CPSW_ALE_CONTROL   (0x8)
#define CPSW_ALE_PRESCALE   (0x10)
#define CPSW_ALE_UNKNOWN_VLAN   (0x18)
#define CPSW_ALE_TBLCTL   (0x20)
#define CPSW_ALE_TBLW(n)   (0x34 + ((2- (n)) * 4))
#define CPSW_ALE_PORTCTL(n)   (0x40 + (n * 4))

/**************************************************************************\
 * Field Definition Macros
\**************************************************************************/

/* ALE_IDVER */
#define CPSW_ALE_IDVER_ALE_IDENT   (0xFFFF0000u)
#define CPSW_ALE_IDVER_ALE_IDENT_SHIFT   (0x00000010u)

#define CPSW_ALE_IDVER_ALE_MAJ_VER   (0x0000FF00u)
#define CPSW_ALE_IDVER_ALE_MAJ_VER_SHIFT   (0x00000008u)

#define CPSW_ALE_IDVER_ALE_MINOR_VER   (0x000000FFu)
#define CPSW_ALE_IDVER_ALE_MINOR_VER_SHIFT   (0x00000000u)


/* ALE_CONTROL */
#define CPSW_ALE_CONTROL_AGE_OUT_NOW   (0x20000000u)
#define CPSW_ALE_CONTROL_AGE_OUT_NOW_SHIFT   (0x0000001Du)

#define CPSW_ALE_CONTROL_ALE_BYPASS   (0x00000010u)
#define CPSW_ALE_CONTROL_ALE_BYPASS_SHIFT   (0x00000004u)

#define CPSW_ALE_CONTROL_ALE_VLAN_AWARE   (0x00000004u)
#define CPSW_ALE_CONTROL_ALE_VLAN_AWARE_SHIFT   (0x00000002u)

#define CPSW_ALE_CONTROL_CLEAR_TABLE   (0x40000000u)
#define CPSW_ALE_CONTROL_CLEAR_TABLE_SHIFT   (0x0000001Eu)

#define CPSW_ALE_CONTROL_ENABLE_ALE   (0x80000000u)
#define CPSW_ALE_CONTROL_ENABLE_ALE_SHIFT   (0x0000001Fu)

#define CPSW_ALE_CONTROL_ENABLE_AUTH_MODE   (0x00000002u)
#define CPSW_ALE_CONTROL_ENABLE_AUTH_MODE_SHIFT   (0x00000001u)

#define CPSW_ALE_CONTROL_ENABLE_OUI_DENY   (0x00000020u)
#define CPSW_ALE_CONTROL_ENABLE_OUI_DENY_SHIFT   (0x00000005u)

#define CPSW_ALE_CONTROL_ENABLE_RATE_LIMIT   (0x00000001u)
#define CPSW_ALE_CONTROL_ENABLE_RATE_LIMIT_SHIFT   (0x00000000u)

#define CPSW_ALE_CONTROL_EN_P0_UNI_FLOOD   (0x00000100u)
#define CPSW_ALE_CONTROL_EN_P0_UNI_FLOOD_SHIFT   (0x00000008u)

#define CPSW_ALE_CONTROL_EN_VID0_MODE   (0x00000040u)
#define CPSW_ALE_CONTROL_EN_VID0_MODE_SHIFT   (0x00000006u)

#define CPSW_ALE_CONTROL_LEARN_NO_VID   (0x00000080u)
#define CPSW_ALE_CONTROL_LEARN_NO_VID_SHIFT   (0x00000007u)

#define CPSW_ALE_CONTROL_RATE_LIMIT_TX   (0x00000008u)
#define CPSW_ALE_CONTROL_RATE_LIMIT_TX_SHIFT   (0x00000003u)


/* ALE_PRESCALE */
#define CPSW_ALE_PRESCALE_ALE_PRESCALE   (0x000FFFFFu)
#define CPSW_ALE_PRESCALE_ALE_PRESCALE_SHIFT   (0x00000000u)


/* ALE_UNKNOWN_VLAN */
#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_FORCE_UNTA   (0x3F000000u)
#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_FORCE_UNTA_SHIFT   (0x00000018u)

#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_MCAST_FLO   (0x00003F00u)
#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_MCAST_FLO_SHIFT   (0x00000008u)

#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_REG_MCAST   (0x003F0000u)
#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_REG_MCAST_SHIFT   (0x00000010u)

#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_VLAN_MEM   (0x0000003Fu)
#define CPSW_ALE_UNKNOWN_VLAN_UNKNOWN_VLAN_MEM_SHIFT   (0x00000000u)


/* ALE_TBLCTL */
#define CPSW_ALE_TBLCTL_ENTRY_POINTER   (0x000003FFu)
#define CPSW_ALE_TBLCTL_ENTRY_POINTER_SHIFT   (0x00000000u)

#define CPSW_ALE_TBLCTL_WRITE_RDZ   (0x80000000u)
#define CPSW_ALE_TBLCTL_WRITE_RDZ_SHIFT   (0x0000001Fu)


/* ALE_PORTCTL0 */
#define CPSW_ALE_PORTCTL0_BCAST_LIMIT   (0xFF000000u)
#define CPSW_ALE_PORTCTL0_BCAST_LIMIT_SHIFT   (0x00000018u)

#define CPSW_ALE_PORTCTL0_DROP_UNTAGGED   (0x00000004u)
#define CPSW_ALE_PORTCTL0_DROP_UNTAGGED_SHIFT   (0x00000002u)

#define CPSW_ALE_PORTCTL0_MCAST_LIMIT   (0x00FF0000u)
#define CPSW_ALE_PORTCTL0_MCAST_LIMIT_SHIFT   (0x00000010u)

#define CPSW_ALE_PORTCTL0_NO_LEARN   (0x00000010u)
#define CPSW_ALE_PORTCTL0_NO_LEARN_SHIFT   (0x00000004u)

#define CPSW_ALE_PORTCTL0_NO_SA_UPDATE   (0x00000020u)
#define CPSW_ALE_PORTCTL0_NO_SA_UPDATE_SHIFT   (0x00000005u)

#define CPSW_ALE_PORTCTL0_PORT_STATE   (0x00000003u)
#define CPSW_ALE_PORTCTL0_PORT_STATE_SHIFT   (0x00000000u)

#define CPSW_ALE_PORTCTL0_VID_INGRESS_CHECK   (0x00000008u)
#define CPSW_ALE_PORTCTL0_VID_INGRESS_CHECK_SHIFT   (0x00000003u)


/* ALE_PORTCTL1 */
#define CPSW_ALE_PORTCTL1_BCAST_LIMIT   (0xFF000000u)
#define CPSW_ALE_PORTCTL1_BCAST_LIMIT_SHIFT   (0x00000018u)

#define CPSW_ALE_PORTCTL1_DROP_UNTAGGED   (0x00000004u)
#define CPSW_ALE_PORTCTL1_DROP_UNTAGGED_SHIFT   (0x00000002u)

#define CPSW_ALE_PORTCTL1_MCAST_LIMIT   (0x00FF0000u)
#define CPSW_ALE_PORTCTL1_MCAST_LIMIT_SHIFT   (0x00000010u)

#define CPSW_ALE_PORTCTL1_NO_LEARN   (0x00000010u)
#define CPSW_ALE_PORTCTL1_NO_LEARN_SHIFT   (0x00000004u)

#define CPSW_ALE_PORTCTL1_NO_SA_UPDATE   (0x00000020u)
#define CPSW_ALE_PORTCTL1_NO_SA_UPDATE_SHIFT   (0x00000005u)

#define CPSW_ALE_PORTCTL1_PORT_STATE   (0x00000003u)
#define CPSW_ALE_PORTCTL1_PORT_STATE_SHIFT   (0x00000000u)

#define CPSW_ALE_PORTCTL1_VID_INGRESS_CHECK   (0x00000008u)
#define CPSW_ALE_PORTCTL1_VID_INGRESS_CHECK_SHIFT   (0x00000003u)


/* ALE_PORTCTL2 */
#define CPSW_ALE_PORTCTL2_BCAST_LIMIT   (0xFF000000u)
#define CPSW_ALE_PORTCTL2_BCAST_LIMIT_SHIFT   (0x00000018u)

#define CPSW_ALE_PORTCTL2_DROP_UNTAGGED   (0x00000004u)
#define CPSW_ALE_PORTCTL2_DROP_UNTAGGED_SHIFT   (0x00000002u)

#define CPSW_ALE_PORTCTL2_MCAST_LIMIT   (0x00FF0000u)
#define CPSW_ALE_PORTCTL2_MCAST_LIMIT_SHIFT   (0x00000010u)

#define CPSW_ALE_PORTCTL2_NO_LEARN   (0x00000010u)
#define CPSW_ALE_PORTCTL2_NO_LEARN_SHIFT   (0x00000004u)

#define CPSW_ALE_PORTCTL2_NO_SA_UPDATE   (0x00000020u)
#define CPSW_ALE_PORTCTL2_NO_SA_UPDATE_SHIFT   (0x00000005u)

#define CPSW_ALE_PORTCTL2_PORT_STATE   (0x00000003u)
#define CPSW_ALE_PORTCTL2_PORT_STATE_SHIFT   (0x00000000u)

#define CPSW_ALE_PORTCTL2_VID_INGRESS_CHECK   (0x00000008u)
#define CPSW_ALE_PORTCTL2_VID_INGRESS_CHECK_SHIFT   (0x00000003u)


/* ALE_PORTCTL3 */
#define CPSW_ALE_PORTCTL3_BCAST_LIMIT   (0xFF000000u)
#define CPSW_ALE_PORTCTL3_BCAST_LIMIT_SHIFT   (0x00000018u)

#define CPSW_ALE_PORTCTL3_DROP_UNTAGGED   (0x00000004u)
#define CPSW_ALE_PORTCTL3_DROP_UNTAGGED_SHIFT   (0x00000002u)

#define CPSW_ALE_PORTCTL3_MCAST_LIMIT   (0x00FF0000u)
#define CPSW_ALE_PORTCTL3_MCAST_LIMIT_SHIFT   (0x00000010u)

#define CPSW_ALE_PORTCTL3_NO_LEARN   (0x00000010u)
#define CPSW_ALE_PORTCTL3_NO_LEARN_SHIFT   (0x00000004u)

#define CPSW_ALE_PORTCTL3_NO_SA_UPDATE   (0x00000020u)
#define CPSW_ALE_PORTCTL3_NO_SA_UPDATE_SHIFT   (0x00000005u)

#define CPSW_ALE_PORTCTL3_PORT_STATE   (0x00000003u)
#define CPSW_ALE_PORTCTL3_PORT_STATE_SHIFT   (0x00000000u)

#define CPSW_ALE_PORTCTL3_VID_INGRESS_CHECK   (0x00000008u)
#define CPSW_ALE_PORTCTL3_VID_INGRESS_CHECK_SHIFT   (0x00000003u)


/* ALE_PORTCTL4 */
#define CPSW_ALE_PORTCTL4_BCAST_LIMIT   (0xFF000000u)
#define CPSW_ALE_PORTCTL4_BCAST_LIMIT_SHIFT   (0x00000018u)

#define CPSW_ALE_PORTCTL4_DROP_UNTAGGED   (0x00000004u)
#define CPSW_ALE_PORTCTL4_DROP_UNTAGGED_SHIFT   (0x00000002u)

#define CPSW_ALE_PORTCTL4_MCAST_LIMIT   (0x00FF0000u)
#define CPSW_ALE_PORTCTL4_MCAST_LIMIT_SHIFT   (0x00000010u)

#define CPSW_ALE_PORTCTL4_NO_LEARN   (0x00000010u)
#define CPSW_ALE_PORTCTL4_NO_LEARN_SHIFT   (0x00000004u)

#define CPSW_ALE_PORTCTL4_NO_SA_UPDATE   (0x00000020u)
#define CPSW_ALE_PORTCTL4_NO_SA_UPDATE_SHIFT   (0x00000005u)

#define CPSW_ALE_PORTCTL4_PORT_STATE   (0x00000003u)
#define CPSW_ALE_PORTCTL4_PORT_STATE_SHIFT   (0x00000000u)

#define CPSW_ALE_PORTCTL4_VID_INGRESS_CHECK   (0x00000008u)
#define CPSW_ALE_PORTCTL4_VID_INGRESS_CHECK_SHIFT   (0x00000003u)


/* ALE_PORTCTL5 */
#define CPSW_ALE_PORTCTL5_BCAST_LIMIT   (0xFF000000u)
#define CPSW_ALE_PORTCTL5_BCAST_LIMIT_SHIFT   (0x00000018u)

#define CPSW_ALE_PORTCTL5_DROP_UNTAGGED   (0x00000004u)
#define CPSW_ALE_PORTCTL5_DROP_UNTAGGED_SHIFT   (0x00000002u)

#define CPSW_ALE_PORTCTL5_MCAST_LIMIT   (0x00FF0000u)
#define CPSW_ALE_PORTCTL5_MCAST_LIMIT_SHIFT   (0x00000010u)

#define CPSW_ALE_PORTCTL5_NO_LEARN   (0x00000010u)
#define CPSW_ALE_PORTCTL5_NO_LEARN_SHIFT   (0x00000004u)

#define CPSW_ALE_PORTCTL5_NO_SA_UPDATE   (0x00000020u)
#define CPSW_ALE_PORTCTL5_NO_SA_UPDATE_SHIFT   (0x00000005u)

#define CPSW_ALE_PORTCTL5_PORT_STATE   (0x00000003u)
#define CPSW_ALE_PORTCTL5_PORT_STATE_SHIFT   (0x00000000u)

#define CPSW_ALE_PORTCTL5_VID_INGRESS_CHECK   (0x00000008u)
#define CPSW_ALE_PORTCTL5_VID_INGRESS_CHECK_SHIFT   (0x00000003u)



#ifdef __cplusplus
}
#endif

#endif
