
/* ============================================================================
 *
 *            TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *  Property of Texas Instruments
 *  For Unrestricted Internal Use Only
 *  Unauthorized reproduction and/or distribution is strictly prohibited.
 *  This product is protected under copyright law and trade secret law
 *  as an unpublished work.
 *  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
 *
 */

/**
 *  @Component:   ELM
 *
 *  @Filename:    hw_elm.h
 *
 ============================================================================ */


#ifndef _HW_ELM_H_
#define _HW_ELM_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/

#define ELM_SYNDROMES (0x400u)
#define ELM_SYNDROMES_ELSIZE (0x40u)
#define ELM_SYNDROMES_NELEMS  8
#define ELM_ERROR_LOCATIONS (0x800u)
#define ELM_ERROR_LOCATIONS_ELSIZE (0x100u)
#define ELM_ERROR_LOCATIONS_NELEMS  8

/***********************************************************************\
 * Bundles Definition
\***********************************************************************/

#define ELM_SYNDROME_FRAGMENT_0_OFFSET (0x0u)
#define ELM_SYNDROME_FRAGMENT_1_OFFSET (0x4u)
#define ELM_SYNDROME_FRAGMENT_2_OFFSET (0x8u)
#define ELM_SYNDROME_FRAGMENT_3_OFFSET (0xCu)
#define ELM_SYNDROME_FRAGMENT_4_OFFSET (0x10u)
#define ELM_SYNDROME_FRAGMENT_5_OFFSET (0x14u)
#define ELM_SYNDROME_FRAGMENT_6_OFFSET (0x18u)
#define ELM_LOCATION_STATUS_OFFSET (0x0u)
#define ELM_ERROR_LOCATION_0_OFFSET (0x80u)
#define ELM_ERROR_LOCATION_1_OFFSET (0x84u)
#define ELM_ERROR_LOCATION_2_OFFSET (0x88u)
#define ELM_ERROR_LOCATION_3_OFFSET (0x8Cu)
#define ELM_ERROR_LOCATION_4_OFFSET (0x90u)
#define ELM_ERROR_LOCATION_5_OFFSET (0x94u)
#define ELM_ERROR_LOCATION_6_OFFSET (0x98u)
#define ELM_ERROR_LOCATION_7_OFFSET (0x9Cu)
#define ELM_ERROR_LOCATION_8_OFFSET (0xA0u)
#define ELM_ERROR_LOCATION_9_OFFSET (0xA4u)
#define ELM_ERROR_LOCATION_10_OFFSET (0xA8u)
#define ELM_ERROR_LOCATION_11_OFFSET (0xACu)
#define ELM_ERROR_LOCATION_12_OFFSET (0xB0u)
#define ELM_ERROR_LOCATION_13_OFFSET (0xB4u)
#define ELM_ERROR_LOCATION_14_OFFSET (0xB8u)
#define ELM_ERROR_LOCATION_15_OFFSET (0xBCu)


/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define ELM_REVISION   (0x0)
#define ELM_SYSCONFIG   (0x10)
#define ELM_SYSSTATUS   (0x14)
#define ELM_IRQSTATUS   (0x18)
#define ELM_IRQENABLE   (0x1C)
#define ELM_LOCATION_CONFIG   (0x20)
#define ELM_PAGE_CTRL   (0x80)
#define ELM_SYNDROME_FRAGMENT(n)   (0x400 + (n * 4))
#define ELM_LOCATION_STATUS   (0x800)
#define ELM_ERROR_LOCATION(n)   (0x880 + (n * 4))

/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/* REVISION */
#define ELM_REVISION_REVISION   (0xFFFFFFFFu)
#define ELM_REVISION_REVISION_SHIFT   (0x00000000u)

#define ELM_REVISION_REV_NUMBER   (0x000000FFu)
#define ELM_REVISION_REV_NUMBER_SHIFT   (0x00000000u)


/* SYSCONFIG */
#define ELM_SYSCONFIG_AUTOGATING   (0x00000001u)
#define ELM_SYSCONFIG_AUTOGATING_SHIFT   (0x00000000u)
#define ELM_SYSCONFIG_AUTOGATING_OCP_FREE   (0x0u)
#define ELM_SYSCONFIG_AUTOGATING_OCP_GATING   (0x1u)

#define ELM_SYSCONFIG_CLOCKACTIVITYOCP   (0x00000100u)
#define ELM_SYSCONFIG_CLOCKACTIVITYOCP_SHIFT   (0x00000008u)
#define ELM_SYSCONFIG_CLOCKACTIVITYOCP_OCP_OFF   (0x0u)
#define ELM_SYSCONFIG_CLOCKACTIVITYOCP_OCP_ON   (0x1u)

#define ELM_SYSCONFIG_SIDLEMODE   (0x00000018u)
#define ELM_SYSCONFIG_SIDLEMODE_SHIFT   (0x00000003u)
#define ELM_SYSCONFIG_SIDLEMODE_FORCE_IDLE   (0x0u)
#define ELM_SYSCONFIG_SIDLEMODE_NO_IDLE   (0x1u)
#define ELM_SYSCONFIG_SIDLEMODE_RESERVED   (0x3u)
#define ELM_SYSCONFIG_SIDLEMODE_SMART_IDLE   (0x2u)

#define ELM_SYSCONFIG_SOFTRESET   (0x00000002u)
#define ELM_SYSCONFIG_SOFTRESET_SHIFT   (0x00000001u)
#define ELM_SYSCONFIG_SOFTRESET_NORMAL   (0x0u)
#define ELM_SYSCONFIG_SOFTRESET_RESET   (0x1u)


/* SYSSTATUS */
#define ELM_SYSSTATUS_RESETDONE   (0x00000001u)
#define ELM_SYSSTATUS_RESETDONE_SHIFT   (0x00000000u)
#define ELM_SYSSTATUS_RESETDONE_RST_DONE   (0x1u)
#define ELM_SYSSTATUS_RESETDONE_RST_ONGOING   (0x0u)


/* IRQSTATUS */
#define ELM_IRQSTATUS_LOC_VALID_0   (0x00000001u)
#define ELM_IRQSTATUS_LOC_VALID_0_SHIFT   (0x00000000u)

#define ELM_IRQSTATUS_LOC_VALID_1   (0x00000002u)
#define ELM_IRQSTATUS_LOC_VALID_1_SHIFT   (0x00000001u)

#define ELM_IRQSTATUS_LOC_VALID_2   (0x00000004u)
#define ELM_IRQSTATUS_LOC_VALID_2_SHIFT   (0x00000002u)

#define ELM_IRQSTATUS_LOC_VALID_3   (0x00000008u)
#define ELM_IRQSTATUS_LOC_VALID_3_SHIFT   (0x00000003u)

#define ELM_IRQSTATUS_LOC_VALID_4   (0x00000010u)
#define ELM_IRQSTATUS_LOC_VALID_4_SHIFT   (0x00000004u)

#define ELM_IRQSTATUS_LOC_VALID_5   (0x00000020u)
#define ELM_IRQSTATUS_LOC_VALID_5_SHIFT   (0x00000005u)

#define ELM_IRQSTATUS_LOC_VALID_6   (0x00000040u)
#define ELM_IRQSTATUS_LOC_VALID_6_SHIFT   (0x00000006u)

#define ELM_IRQSTATUS_LOC_VALID_7   (0x00000080u)
#define ELM_IRQSTATUS_LOC_VALID_7_SHIFT   (0x00000007u)
#define ELM_IRQSTATUS_LOC_VALID_7_CLEAR   (0x1u)
#define ELM_IRQSTATUS_LOC_VALID_7_COMPLETED   (0x1u)
#define ELM_IRQSTATUS_LOC_VALID_7_NO   (0x0u)

#define ELM_IRQSTATUS_PAGE_VALID   (0x00000100u)
#define ELM_IRQSTATUS_PAGE_VALID_SHIFT   (0x00000008u)
#define ELM_IRQSTATUS_PAGE_VALID_CLEAR   (0x1u)
#define ELM_IRQSTATUS_PAGE_VALID_INVALID   (0x0u)
#define ELM_IRQSTATUS_PAGE_VALID_VALID   (0x1u)


/* IRQENABLE */
#define ELM_IRQENABLE_LOCATION_MASK_0   (0x00000001u)
#define ELM_IRQENABLE_LOCATION_MASK_0_SHIFT   (0x00000000u)
#define ELM_IRQENABLE_LOCATION_MASK_0_DISABLE   (0x0u)
#define ELM_IRQENABLE_LOCATION_MASK_0_ENABLE   (0x1u)

#define ELM_IRQENABLE_LOCATION_MASK_1   (0x00000002u)
#define ELM_IRQENABLE_LOCATION_MASK_1_SHIFT   (0x00000001u)

#define ELM_IRQENABLE_LOCATION_MASK_2   (0x00000004u)
#define ELM_IRQENABLE_LOCATION_MASK_2_SHIFT   (0x00000002u)

#define ELM_IRQENABLE_LOCATION_MASK_3   (0x00000008u)
#define ELM_IRQENABLE_LOCATION_MASK_3_SHIFT   (0x00000003u)

#define ELM_IRQENABLE_LOCATION_MASK_4   (0x00000010u)
#define ELM_IRQENABLE_LOCATION_MASK_4_SHIFT   (0x00000004u)

#define ELM_IRQENABLE_LOCATION_MASK_5   (0x00000020u)
#define ELM_IRQENABLE_LOCATION_MASK_5_SHIFT   (0x00000005u)

#define ELM_IRQENABLE_LOCATION_MASK_6   (0x00000040u)
#define ELM_IRQENABLE_LOCATION_MASK_6_SHIFT   (0x00000006u)

#define ELM_IRQENABLE_LOCATION_MASK_7   (0x00000080u)
#define ELM_IRQENABLE_LOCATION_MASK_7_SHIFT   (0x00000007u)

#define ELM_IRQENABLE_PAGE_MASK   (0x00000100u)
#define ELM_IRQENABLE_PAGE_MASK_SHIFT   (0x00000008u)
#define ELM_IRQENABLE_PAGE_MASK_DISABLE   (0x0u)
#define ELM_IRQENABLE_PAGE_MASK_ENABLE   (0x1u)


/* LOCATION_CONFIG */
#define ELM_LOCATION_CONFIG_ECC_BCH_LEVEL   (0x00000003u)
#define ELM_LOCATION_CONFIG_ECC_BCH_LEVEL_SHIFT   (0x00000000u)
#define ELM_LOCATION_CONFIG_ECC_BCH_LEVEL_16BITS   (0x2u)
#define ELM_LOCATION_CONFIG_ECC_BCH_LEVEL_4BITS   (0x0u)
#define ELM_LOCATION_CONFIG_ECC_BCH_LEVEL_8BITS   (0x1u)

#define ELM_LOCATION_CONFIG_ECC_SIZE   (0x07FF0000u)
#define ELM_LOCATION_CONFIG_ECC_SIZE_SHIFT   (0x00000010u)


/* PAGE_CTRL */
#define ELM_PAGE_CTRL_SECTOR_0   (0x00000001u)
#define ELM_PAGE_CTRL_SECTOR_0_SHIFT   (0x00000000u)

#define ELM_PAGE_CTRL_SECTOR_1   (0x00000002u)
#define ELM_PAGE_CTRL_SECTOR_1_SHIFT   (0x00000001u)

#define ELM_PAGE_CTRL_SECTOR_2   (0x00000004u)
#define ELM_PAGE_CTRL_SECTOR_2_SHIFT   (0x00000002u)

#define ELM_PAGE_CTRL_SECTOR_3   (0x00000008u)
#define ELM_PAGE_CTRL_SECTOR_3_SHIFT   (0x00000003u)

#define ELM_PAGE_CTRL_SECTOR_4   (0x00000010u)
#define ELM_PAGE_CTRL_SECTOR_4_SHIFT   (0x00000004u)

#define ELM_PAGE_CTRL_SECTOR_5   (0x00000020u)
#define ELM_PAGE_CTRL_SECTOR_5_SHIFT   (0x00000005u)

#define ELM_PAGE_CTRL_SECTOR_6   (0x00000040u)
#define ELM_PAGE_CTRL_SECTOR_6_SHIFT   (0x00000006u)

#define ELM_PAGE_CTRL_SECTOR_7   (0x00000080u)
#define ELM_PAGE_CTRL_SECTOR_7_SHIFT   (0x00000007u)


/* SYNDROME_FRAGMENT_0 */
#define ELM_SYNDROME_FRAGMENT_0_SYNDROME_0   (0xFFFFFFFFu)
#define ELM_SYNDROME_FRAGMENT_0_SYNDROME_0_SHIFT   (0x00000000u)


/* SYNDROME_FRAGMENT_1 */
#define ELM_SYNDROME_FRAGMENT_1_SYNDROME_1   (0xFFFFFFFFu)
#define ELM_SYNDROME_FRAGMENT_1_SYNDROME_1_SHIFT   (0x00000000u)


/* SYNDROME_FRAGMENT_2 */
#define ELM_SYNDROME_FRAGMENT_2_SYNDROME_2   (0xFFFFFFFFu)
#define ELM_SYNDROME_FRAGMENT_2_SYNDROME_2_SHIFT   (0x00000000u)


/* SYNDROME_FRAGMENT_3 */
#define ELM_SYNDROME_FRAGMENT_3_SYNDROME_3   (0xFFFFFFFFu)
#define ELM_SYNDROME_FRAGMENT_3_SYNDROME_3_SHIFT   (0x00000000u)


/* SYNDROME_FRAGMENT_4 */
#define ELM_SYNDROME_FRAGMENT_4_SYNDROME_4   (0xFFFFFFFFu)
#define ELM_SYNDROME_FRAGMENT_4_SYNDROME_4_SHIFT   (0x00000000u)


/* SYNDROME_FRAGMENT_5 */
#define ELM_SYNDROME_FRAGMENT_5_SYNDROME_5   (0xFFFFFFFFu)
#define ELM_SYNDROME_FRAGMENT_5_SYNDROME_5_SHIFT   (0x00000000u)


/* SYNDROME_FRAGMENT_6 */
#define ELM_SYNDROME_FRAGMENT_6_SYNDROME_6   (0x0000FFFFu)
#define ELM_SYNDROME_FRAGMENT_6_SYNDROME_6_SHIFT   (0x00000000u)

#define ELM_SYNDROME_FRAGMENT_6_SYNDROME_VALID   (0x00010000u)
#define ELM_SYNDROME_FRAGMENT_6_SYNDROME_VALID_SHIFT   (0x00000010u)


/* LOCATION_STATUS */
#define ELM_LOCATION_STATUS_ECC_CORRECTABLE   (0x00000100u)
#define ELM_LOCATION_STATUS_ECC_CORRECTABLE_SHIFT   (0x00000008u)
#define ELM_LOCATION_STATUS_ECC_CORRECTABLE_FAIL   (0x0u)
#define ELM_LOCATION_STATUS_ECC_CORRECTABLE_SUCCESS   (0x1u)

#define ELM_LOCATION_STATUS_ECC_NB_ERRORS   (0x0000001Fu)
#define ELM_LOCATION_STATUS_ECC_NB_ERRORS_SHIFT   (0x00000000u)


/* ERROR_LOCATION_0 */
#define ELM_ERROR_LOCATION_0_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_0_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_1 */
#define ELM_ERROR_LOCATION_1_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_1_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_2 */
#define ELM_ERROR_LOCATION_2_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_2_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_3 */
#define ELM_ERROR_LOCATION_3_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_3_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_4 */
#define ELM_ERROR_LOCATION_4_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_4_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_5 */
#define ELM_ERROR_LOCATION_5_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_5_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_6 */
#define ELM_ERROR_LOCATION_6_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_6_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_7 */
#define ELM_ERROR_LOCATION_7_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_7_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_8 */
#define ELM_ERROR_LOCATION_8_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_8_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_9 */
#define ELM_ERROR_LOCATION_9_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_9_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_10 */
#define ELM_ERROR_LOCATION_10_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_10_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_11 */
#define ELM_ERROR_LOCATION_11_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_11_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_12 */
#define ELM_ERROR_LOCATION_12_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_12_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_13 */
#define ELM_ERROR_LOCATION_13_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_13_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_14 */
#define ELM_ERROR_LOCATION_14_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_14_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)


/* ERROR_LOCATION_15 */
#define ELM_ERROR_LOCATION_15_ECC_ERROR_LOCATION   (0x00001FFFu)
#define ELM_ERROR_LOCATION_15_ECC_ERROR_LOCATION_SHIFT   (0x00000000u)



#ifdef __cplusplus
}
#endif

#endif

