/*
 * hw_emac1.h
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */

#ifndef _HW_EMAC_H_
#define _HW_EMAC_H_

#define EMAC_TXREVID		(0x0)
#define EMAC_TXCONTROL		(0x4)
#define EMAC_TXTEARDOWN		(0x8)
#define EMAC_RXREVID		(0x10)
#define EMAC_RXCONTROL		(0x14)
#define EMAC_RXTEARDOWN		(0x18)
#define EMAC_TXINTSTATRAW	(0x80)
#define EMAC_TXINTSTATMASKED	(0x84)
#define EMAC_TXINTMASKSET	(0x88)
#define EMAC_TXINTMASKCLEAR	(0x8C)
#define EMAC_MACINVECTOR	(0x90)
#define EMAC_MACEOIVECTOR	(0x94)
#define EMAC_RXINTSTATRAW	(0xA0)
#define EMAC_RXINTSTATMASKED	(0xA4)
#define EMAC_RXINTMASKSET	(0xA8)
#define EMAC_RXINTMASKCLEAR	(0xAC)
#define EMAC_MACINTSTATRAW	(0xB0)
#define EMAC_MACINTSTATMASKED	(0xB4)
#define EMAC_MACINTMASKSET	(0xB8)
#define EMAC_MACINTMASKCLEAR	(0xBC)
#define EMAC_RXMBPENABLE	(0x100)
#define EMAC_RXUNICASTSET	(0x104)
#define EMAC_RXUNICASTCLEAR	(0x108)
#define EMAC_RXMAXLEN		(0x10C)
#define EMAC_RXBUFFEROFFSET	(0x110)
#define EMAC_RXFILTERLOWTHRESH	(0x114)
#define EMAC_RXFLOWTHRESH(n)	(0x120 + (n * 4))
#define EMAC_RXFREEBUFFER(n)	(0x140 + (n * 4))
#define EMAC_MACCONTROL		(0x160)
#define EMAC_MACSTATUS		(0x164)
#define EMAC_EMCONTROL		(0x168)
#define EMAC_FIFOCONTROL	(0x16C)
#define EMAC_MACCONFIG		(0x170)
#define EMAC_SOFTRESET		(0x174)
#define EMAC_MACSRCADDRLO	(0x1D0)
#define EMAC_MACSRCADDRHI	(0x1D4)
#define EMAC_MACHASH1		(0x1D8)
#define EMAC_MACHASH2		(0x1DC)
#define EMAC_BOFFTEST		(0x1E0)
#define EMAC_TPACETEST		(0x1E4)
#define EMAC_RXPAUSE		(0x1E8)
#define EMAC_TXPAUSE		(0x1EC)
#define EMAC_RXGOODFRAMES	(0x200)
#define EMAC_RXBCASTFRAMES	(0x204)
#define EMAC_RXMCASTFRAMES	(0x208)
#define EMAC_RXPAUSEFRAMES	(0x20C)
#define EMAC_RXCRCERRORS	(0x210)
#define EMAC_RXALIGNCODEERRORS	(0x214)
#define EMAC_RXOVERSIZED	(0x218)
#define EMAC_RXJABBER		(0x21C)
#define EMAC_RXUNDERSIZED	(0x220)
#define EMAC_RXFRAGMENTS	(0x224)
#define EMAC_RXFILTERED		(0x228)
#define EMAC_RXQOSFILTERED	(0x22C)
#define EMAC_RXOCTETS		(0x230)
#define EMAC_TXGOODFRAMES	(0x234)
#define EMAC_TXBCASTFRAMES	(0x238)
#define EMAC_TXMCASTFRAMES	(0x23C)
#define EMAC_TXPAUSEFRAMES	(0x240)
#define EMAC_TXDEFERRED		(0x244)
#define EMAC_TXCOLLISION	(0x248)
#define EMAC_TXSINGLECOLL	(0x24C)
#define EMAC_TXMULTICOLL	(0x250)
#define EMAC_TXEXCESSIVECOLL	(0x254)
#define EMAC_TXLATECOLL		(0x258)
#define EMAC_TXUNDERRUN		(0x25C)
#define EMAC_TXCARRIERSENSE	(0x260)
#define EMAC_TXOCTETS		(0x264)
#define EMAC_FRAME64		(0x268)
#define EMAC_FRAME65T127	(0x26C)
#define EMAC_FRAME128T255	(0x270)
#define EMAC_FRAME256T511	(0x274)
#define EMAC_FRAME512T1023	(0x278)
#define EMAC_FRAME1024TUP	(0x27C)
#define EMAC_NETOCTETS		(0x208)
#define EMAC_RXSOFOVERRUNS	(0x284)
#define EMAC_RXMOFOVERRUNS	(0x288)
#define EMAC_RXDMAOVERRUNS	(0x28C)
#define EMAC_MACADDRLO          (0x500)
#define EMAC_MACADDRHI          (0x504)
#define EMAC_MACINDEX           (0x508)
#define EMAC_TXHDP(n)		(0x600 + (n * 4))
#define EMAC_RXHDP(n)		(0x620 + (n * 4))
#define EMAC_TXCP(n)		(0x640 + (n * 4))
#define EMAC_RXCP(n)		(0x660 + (n * 4))

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TXREVID */

#define EMAC_TXREVID_TXREV      (0xFFFFFFFFu)
#define EMAC_TXREVID_TXREV_SHIFT     (0x00000000u)


/* TXCONTROL */


#define EMAC_TXCONTROL_TXEN     (0x00000001u)
#define EMAC_TXCONTROL_TXEN_SHIFT    (0x00000000u)


/* TXTEARDOWN */

#define EMAC_TXTEARDOWN_TXTDNCH (0x00000007u)
#define EMAC_TXTEARDOWN_TXTDNCH_SHIFT (0x00000000u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA0 (0x00000000u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA1 (0x00000001u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA2 (0x00000002u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA3 (0x00000003u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA4 (0x00000004u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA5 (0x00000005u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA6 (0x00000006u)
#define EMAC_TXTEARDOWN_TXTDNCH_CHA7 (0x00000007u)


/* RXREVID */

#define EMAC_RXREVID_RXREV      (0xFFFFFFFFu)
#define EMAC_RXREVID_RXREV_SHIFT     (0x00000000u)


/* RXCONTROL */


#define EMAC_RXCONTROL_RXEN     (0x00000001u)
#define EMAC_RXCONTROL_RXEN_SHIFT    (0x00000000u)

/* RXTEARDOWN */



#define EMAC_RXTEARDOWN_RXTDNCH (0x00000007u)
#define EMAC_RXTEARDOWN_RXTDNCH_SHIFT (0x00000000u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA0 (0x00000000u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA1 (0x00000001u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA2 (0x00000002u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA3 (0x00000003u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA4 (0x00000004u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA5 (0x00000005u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA6 (0x00000006u)
#define EMAC_RXTEARDOWN_RXTDNCH_CHA7 (0x00000007u)


/* TXINTSTATRAW */


#define EMAC_TXINTSTATRAW_TX7PEND (0x00000080u)
#define EMAC_TXINTSTATRAW_TX7PEND_SHIFT (0x00000007u)

#define EMAC_TXINTSTATRAW_TX6PEND (0x00000040u)
#define EMAC_TXINTSTATRAW_TX6PEND_SHIFT (0x00000006u)

#define EMAC_TXINTSTATRAW_TX5PEND (0x00000020u)
#define EMAC_TXINTSTATRAW_TX5PEND_SHIFT (0x00000005u)

#define EMAC_TXINTSTATRAW_TX4PEND (0x00000010u)
#define EMAC_TXINTSTATRAW_TX4PEND_SHIFT (0x00000004u)

#define EMAC_TXINTSTATRAW_TX3PEND (0x00000008u)
#define EMAC_TXINTSTATRAW_TX3PEND_SHIFT (0x00000003u)

#define EMAC_TXINTSTATRAW_TX2PEND (0x00000004u)
#define EMAC_TXINTSTATRAW_TX2PEND_SHIFT (0x00000002u)

#define EMAC_TXINTSTATRAW_TX1PEND (0x00000002u)
#define EMAC_TXINTSTATRAW_TX1PEND_SHIFT (0x00000001u)

#define EMAC_TXINTSTATRAW_TX0PEND (0x00000001u)
#define EMAC_TXINTSTATRAW_TX0PEND_SHIFT (0x00000000u)


/* TXINTSTATMASKED */


#define EMAC_TXINTSTATMASKED_TX7PEND (0x00000080u)
#define EMAC_TXINTSTATMASKED_TX7PEND_SHIFT (0x00000007u)

#define EMAC_TXINTSTATMASKED_TX6PEND (0x00000040u)
#define EMAC_TXINTSTATMASKED_TX6PEND_SHIFT (0x00000006u)

#define EMAC_TXINTSTATMASKED_TX5PEND (0x00000020u)
#define EMAC_TXINTSTATMASKED_TX5PEND_SHIFT (0x00000005u)

#define EMAC_TXINTSTATMASKED_TX4PEND (0x00000010u)
#define EMAC_TXINTSTATMASKED_TX4PEND_SHIFT (0x00000004u)

#define EMAC_TXINTSTATMASKED_TX3PEND (0x00000008u)
#define EMAC_TXINTSTATMASKED_TX3PEND_SHIFT (0x00000003u)

#define EMAC_TXINTSTATMASKED_TX2PEND (0x00000004u)
#define EMAC_TXINTSTATMASKED_TX2PEND_SHIFT (0x00000002u)

#define EMAC_TXINTSTATMASKED_TX1PEND (0x00000002u)
#define EMAC_TXINTSTATMASKED_TX1PEND_SHIFT (0x00000001u)

#define EMAC_TXINTSTATMASKED_TX0PEND (0x00000001u)
#define EMAC_TXINTSTATMASKED_TX0PEND_SHIFT (0x00000000u)


/* TXINTMASKSET */


#define EMAC_TXINTMASKSET_TX7MASK (0x00000080u)
#define EMAC_TXINTMASKSET_TX7MASK_SHIFT (0x00000007u)

#define EMAC_TXINTMASKSET_TX6MASK (0x00000040u)
#define EMAC_TXINTMASKSET_TX6MASK_SHIFT (0x00000006u)

#define EMAC_TXINTMASKSET_TX5MASK (0x00000020u)
#define EMAC_TXINTMASKSET_TX5MASK_SHIFT (0x00000005u)

#define EMAC_TXINTMASKSET_TX4MASK (0x00000010u)
#define EMAC_TXINTMASKSET_TX4MASK_SHIFT (0x00000004u)

#define EMAC_TXINTMASKSET_TX3MASK (0x00000008u)
#define EMAC_TXINTMASKSET_TX3MASK_SHIFT (0x00000003u)

#define EMAC_TXINTMASKSET_TX2MASK (0x00000004u)
#define EMAC_TXINTMASKSET_TX2MASK_SHIFT (0x00000002u)

#define EMAC_TXINTMASKSET_TX1MASK (0x00000002u)
#define EMAC_TXINTMASKSET_TX1MASK_SHIFT (0x00000001u)

#define EMAC_TXINTMASKSET_TX0MASK (0x00000001u)
#define EMAC_TXINTMASKSET_TX0MASK_SHIFT (0x00000000u)


/* TXINTMASKCLEAR */


#define EMAC_TXINTMASKCLEAR_TX7MASK (0x00000080u)
#define EMAC_TXINTMASKCLEAR_TX7MASK_SHIFT (0x00000007u)

#define EMAC_TXINTMASKCLEAR_TX6MASK (0x00000040u)
#define EMAC_TXINTMASKCLEAR_TX6MASK_SHIFT (0x00000006u)

#define EMAC_TXINTMASKCLEAR_TX5MASK (0x00000020u)
#define EMAC_TXINTMASKCLEAR_TX5MASK_SHIFT (0x00000005u)

#define EMAC_TXINTMASKCLEAR_TX4MASK (0x00000010u)
#define EMAC_TXINTMASKCLEAR_TX4MASK_SHIFT (0x00000004u)

#define EMAC_TXINTMASKCLEAR_TX3MASK (0x00000008u)
#define EMAC_TXINTMASKCLEAR_TX3MASK_SHIFT (0x00000003u)

#define EMAC_TXINTMASKCLEAR_TX2MASK (0x00000004u)
#define EMAC_TXINTMASKCLEAR_TX2MASK_SHIFT (0x00000002u)

#define EMAC_TXINTMASKCLEAR_TX1MASK (0x00000002u)
#define EMAC_TXINTMASKCLEAR_TX1MASK_SHIFT (0x00000001u)

#define EMAC_TXINTMASKCLEAR_TX0MASK (0x00000001u)
#define EMAC_TXINTMASKCLEAR_TX0MASK_SHIFT (0x00000000u)


/* MACINVECTOR */


#define EMAC_MACINVECTOR_STATPEND (0x08000000u)
#define EMAC_MACINVECTOR_STATPEND_SHIFT (0x0000001Bu)

#define EMAC_MACINVECTOR_HOSTPEND (0x04000000u)
#define EMAC_MACINVECTOR_HOSTPEND_SHIFT (0x0000001Au)

#define EMAC_MACINVECTOR_LINKINT0 (0x02000000u)
#define EMAC_MACINVECTOR_LINKINT0_SHIFT (0x00000019u)

#define EMAC_MACINVECTOR_USERINT0 (0x01000000u)
#define EMAC_MACINVECTOR_USERINT0_SHIFT (0x00000018u)

#define EMAC_MACINVECTOR_TXPEND (0x00FF0000u)
#define EMAC_MACINVECTOR_TXPEND_SHIFT (0x00000010u)

#define EMAC_MACINVECTOR_RXTHRESHPEND (0x0000FF00u)
#define EMAC_MACINVECTOR_RXTHRESHPEND_SHIFT (0x00000008u)

#define EMAC_MACINVECTOR_RXPEND (0x000000FFu)
#define EMAC_MACINVECTOR_RXPEND_SHIFT (0x00000000u)


/* MACEOIVECTOR */


#define EMAC_MACEOIVECTOR_INTVECT (0x0000001Fu)
#define EMAC_MACEOIVECTOR_INTVECT_SHIFT (0x00000000u)
/*----INTVECT Tokens----*/
#define EMAC_MACEOIVECTOR_INTVECT_C0RXTHRESH (0x00000000u)
#define EMAC_MACEOIVECTOR_INTVECT_C0RX (0x00000001u)
#define EMAC_MACEOIVECTOR_INTVECT_C0TX (0x00000002u)
#define EMAC_MACEOIVECTOR_INTVECT_C0MISC (0x00000003u)
#define EMAC_MACEOIVECTOR_INTVECT_C1RXTHRESH (0x00000004u)
#define EMAC_MACEOIVECTOR_INTVECT_C1RX (0x00000005u)
#define EMAC_MACEOIVECTOR_INTVECT_C1TX (0x00000006u)
#define EMAC_MACEOIVECTOR_INTVECT_C1MISC (0x00000007u)


/* RXINTSTATRAW */


#define EMAC_RXINTSTATRAW_RX7THRESHPEND (0x00008000u)
#define EMAC_RXINTSTATRAW_RX7THRESHPEND_SHIFT (0x0000000Fu)

#define EMAC_RXINTSTATRAW_RX6THRESHPEND (0x00004000u)
#define EMAC_RXINTSTATRAW_RX6THRESHPEND_SHIFT (0x0000000Eu)

#define EMAC_RXINTSTATRAW_RX5THRESHPEND (0x00002000u)
#define EMAC_RXINTSTATRAW_RX5THRESHPEND_SHIFT (0x0000000Du)

#define EMAC_RXINTSTATRAW_RX4THRESHPEND (0x00001000u)
#define EMAC_RXINTSTATRAW_RX4THRESHPEND_SHIFT (0x0000000Cu)

#define EMAC_RXINTSTATRAW_RX3THRESHPEND (0x00000800u)
#define EMAC_RXINTSTATRAW_RX3THRESHPEND_SHIFT (0x0000000Bu)

#define EMAC_RXINTSTATRAW_RX2THRESHPEND (0x00000400u)
#define EMAC_RXINTSTATRAW_RX2THRESHPEND_SHIFT (0x0000000Au)

#define EMAC_RXINTSTATRAW_RX1THRESHPEND (0x00000200u)
#define EMAC_RXINTSTATRAW_RX1THRESHPEND_SHIFT (0x00000009u)

#define EMAC_RXINTSTATRAW_RX0THRESHPEND (0x00000100u)
#define EMAC_RXINTSTATRAW_RX0THRESHPEND_SHIFT (0x00000008u)

#define EMAC_RXINTSTATRAW_RX7PEND (0x00000080u)
#define EMAC_RXINTSTATRAW_RX7PEND_SHIFT (0x00000007u)

#define EMAC_RXINTSTATRAW_RX6PEND (0x00000040u)
#define EMAC_RXINTSTATRAW_RX6PEND_SHIFT (0x00000006u)

#define EMAC_RXINTSTATRAW_RX5PEND (0x00000020u)
#define EMAC_RXINTSTATRAW_RX5PEND_SHIFT (0x00000005u)

#define EMAC_RXINTSTATRAW_RX4PEND (0x00000010u)
#define EMAC_RXINTSTATRAW_RX4PEND_SHIFT (0x00000004u)

#define EMAC_RXINTSTATRAW_RX3PEND (0x00000008u)
#define EMAC_RXINTSTATRAW_RX3PEND_SHIFT (0x00000003u)

#define EMAC_RXINTSTATRAW_RX2PEND (0x00000004u)
#define EMAC_RXINTSTATRAW_RX2PEND_SHIFT (0x00000002u)

#define EMAC_RXINTSTATRAW_RX1PEND (0x00000002u)
#define EMAC_RXINTSTATRAW_RX1PEND_SHIFT (0x00000001u)

#define EMAC_RXINTSTATRAW_RX0PEND (0x00000001u)
#define EMAC_RXINTSTATRAW_RX0PEND_SHIFT (0x00000000u)


/* RXINTSTATMASKED */


#define EMAC_RXINTSTATMASKED_RX7THRESHPEND (0x00008000u)
#define EMAC_RXINTSTATMASKED_RX7THRESHPEND_SHIFT (0x0000000Fu)

#define EMAC_RXINTSTATMASKED_RX6THRESHPEND (0x00004000u)
#define EMAC_RXINTSTATMASKED_RX6THRESHPEND_SHIFT (0x0000000Eu)

#define EMAC_RXINTSTATMASKED_RX5THRESHPEND (0x00002000u)
#define EMAC_RXINTSTATMASKED_RX5THRESHPEND_SHIFT (0x0000000Du)

#define EMAC_RXINTSTATMASKED_RX4THRESHPEND (0x00001000u)
#define EMAC_RXINTSTATMASKED_RX4THRESHPEND_SHIFT (0x0000000Cu)

#define EMAC_RXINTSTATMASKED_RX3THRESHPEND (0x00000800u)
#define EMAC_RXINTSTATMASKED_RX3THRESHPEND_SHIFT (0x0000000Bu)

#define EMAC_RXINTSTATMASKED_RX2THRESHPEND (0x00000400u)
#define EMAC_RXINTSTATMASKED_RX2THRESHPEND_SHIFT (0x0000000Au)

#define EMAC_RXINTSTATMASKED_RX1THRESHPEND (0x00000200u)
#define EMAC_RXINTSTATMASKED_RX1THRESHPEND_SHIFT (0x00000009u)

#define EMAC_RXINTSTATMASKED_RX0THRESHPEND (0x00000100u)
#define EMAC_RXINTSTATMASKED_RX0THRESHPEND_SHIFT (0x00000008u)

#define EMAC_RXINTSTATMASKED_RX7PEND (0x00000080u)
#define EMAC_RXINTSTATMASKED_RX7PEND_SHIFT (0x00000007u)

#define EMAC_RXINTSTATMASKED_RX6PEND (0x00000040u)
#define EMAC_RXINTSTATMASKED_RX6PEND_SHIFT (0x00000006u)

#define EMAC_RXINTSTATMASKED_RX5PEND (0x00000020u)
#define EMAC_RXINTSTATMASKED_RX5PEND_SHIFT (0x00000005u)

#define EMAC_RXINTSTATMASKED_RX4PEND (0x00000010u)
#define EMAC_RXINTSTATMASKED_RX4PEND_SHIFT (0x00000004u)

#define EMAC_RXINTSTATMASKED_RX3PEND (0x00000008u)
#define EMAC_RXINTSTATMASKED_RX3PEND_SHIFT (0x00000003u)

#define EMAC_RXINTSTATMASKED_RX2PEND (0x00000004u)
#define EMAC_RXINTSTATMASKED_RX2PEND_SHIFT (0x00000002u)

#define EMAC_RXINTSTATMASKED_RX1PEND (0x00000002u)
#define EMAC_RXINTSTATMASKED_RX1PEND_SHIFT (0x00000001u)

#define EMAC_RXINTSTATMASKED_RX0PEND (0x00000001u)
#define EMAC_RXINTSTATMASKED_RX0PEND_SHIFT (0x00000000u)


/* RXINTMASKSET */


#define EMAC_RXINTMASKSET_RX7THRESHMASK (0x00008000u)
#define EMAC_RXINTMASKSET_RX7THRESHMASK_SHIFT (0x0000000Fu)

#define EMAC_RXINTMASKSET_RX6THRESHMASK (0x00004000u)
#define EMAC_RXINTMASKSET_RX6THRESHMASK_SHIFT (0x0000000Eu)

#define EMAC_RXINTMASKSET_RX5THRESHMASK (0x00002000u)
#define EMAC_RXINTMASKSET_RX5THRESHMASK_SHIFT (0x0000000Du)

#define EMAC_RXINTMASKSET_RX4THRESHMASK (0x00001000u)
#define EMAC_RXINTMASKSET_RX4THRESHMASK_SHIFT (0x0000000Cu)

#define EMAC_RXINTMASKSET_RX3THRESHMASK (0x00000800u)
#define EMAC_RXINTMASKSET_RX3THRESHMASK_SHIFT (0x0000000Bu)

#define EMAC_RXINTMASKSET_RX2THRESHMASK (0x00000400u)
#define EMAC_RXINTMASKSET_RX2THRESHMASK_SHIFT (0x0000000Au)

#define EMAC_RXINTMASKSET_RX1THRESHMASK (0x00000200u)
#define EMAC_RXINTMASKSET_RX1THRESHMASK_SHIFT (0x00000009u)

#define EMAC_RXINTMASKSET_RX0THRESHMASK (0x00000100u)
#define EMAC_RXINTMASKSET_RX0THRESHMASK_SHIFT (0x00000008u)

#define EMAC_RXINTMASKSET_RX7MASK (0x00000080u)
#define EMAC_RXINTMASKSET_RX7MASK_SHIFT (0x00000007u)

#define EMAC_RXINTMASKSET_RX6MASK (0x00000040u)
#define EMAC_RXINTMASKSET_RX6MASK_SHIFT (0x00000006u)

#define EMAC_RXINTMASKSET_RX5MASK (0x00000020u)
#define EMAC_RXINTMASKSET_RX5MASK_SHIFT (0x00000005u)

#define EMAC_RXINTMASKSET_RX4MASK (0x00000010u)
#define EMAC_RXINTMASKSET_RX4MASK_SHIFT (0x00000004u)

#define EMAC_RXINTMASKSET_RX3MASK (0x00000008u)
#define EMAC_RXINTMASKSET_RX3MASK_SHIFT (0x00000003u)

#define EMAC_RXINTMASKSET_RX2MASK (0x00000004u)
#define EMAC_RXINTMASKSET_RX2MASK_SHIFT (0x00000002u)

#define EMAC_RXINTMASKSET_RX1MASK (0x00000002u)
#define EMAC_RXINTMASKSET_RX1MASK_SHIFT (0x00000001u)

#define EMAC_RXINTMASKSET_RX0MASK (0x00000001u)
#define EMAC_RXINTMASKSET_RX0MASK_SHIFT (0x00000000u)


/* RXINTMASKCLEAR */


#define EMAC_RXINTMASKCLEAR_RX7THRESHMASK (0x00008000u)
#define EMAC_RXINTMASKCLEAR_RX7THRESHMASK_SHIFT (0x0000000Fu)

#define EMAC_RXINTMASKCLEAR_RX6THRESHMASK (0x00004000u)
#define EMAC_RXINTMASKCLEAR_RX6THRESHMASK_SHIFT (0x0000000Eu)

#define EMAC_RXINTMASKCLEAR_RX5THRESHMASK (0x00002000u)
#define EMAC_RXINTMASKCLEAR_RX5THRESHMASK_SHIFT (0x0000000Du)

#define EMAC_RXINTMASKCLEAR_RX4THRESHMASK (0x00001000u)
#define EMAC_RXINTMASKCLEAR_RX4THRESHMASK_SHIFT (0x0000000Cu)

#define EMAC_RXINTMASKCLEAR_RX3THRESHMASK (0x00000800u)
#define EMAC_RXINTMASKCLEAR_RX3THRESHMASK_SHIFT (0x0000000Bu)

#define EMAC_RXINTMASKCLEAR_RX2THRESHMASK (0x00000400u)
#define EMAC_RXINTMASKCLEAR_RX2THRESHMASK_SHIFT (0x0000000Au)

#define EMAC_RXINTMASKCLEAR_RX1THRESHMASK (0x00000200u)
#define EMAC_RXINTMASKCLEAR_RX1THRESHMASK_SHIFT (0x00000009u)

#define EMAC_RXINTMASKCLEAR_RX0THRESHMASK (0x00000100u)
#define EMAC_RXINTMASKCLEAR_RX0THRESHMASK_SHIFT (0x00000008u)

#define EMAC_RXINTMASKCLEAR_RX7MASK (0x00000080u)
#define EMAC_RXINTMASKCLEAR_RX7MASK_SHIFT (0x00000007u)

#define EMAC_RXINTMASKCLEAR_RX6MASK (0x00000040u)
#define EMAC_RXINTMASKCLEAR_RX6MASK_SHIFT (0x00000006u)

#define EMAC_RXINTMASKCLEAR_RX5MASK (0x00000020u)
#define EMAC_RXINTMASKCLEAR_RX5MASK_SHIFT (0x00000005u)

#define EMAC_RXINTMASKCLEAR_RX4MASK (0x00000010u)
#define EMAC_RXINTMASKCLEAR_RX4MASK_SHIFT (0x00000004u)

#define EMAC_RXINTMASKCLEAR_RX3MASK (0x00000008u)
#define EMAC_RXINTMASKCLEAR_RX3MASK_SHIFT (0x00000003u)

#define EMAC_RXINTMASKCLEAR_RX2MASK (0x00000004u)
#define EMAC_RXINTMASKCLEAR_RX2MASK_SHIFT (0x00000002u)

#define EMAC_RXINTMASKCLEAR_RX1MASK (0x00000002u)
#define EMAC_RXINTMASKCLEAR_RX1MASK_SHIFT (0x00000001u)

#define EMAC_RXINTMASKCLEAR_RX0MASK (0x00000001u)
#define EMAC_RXINTMASKCLEAR_RX0MASK_SHIFT (0x00000000u)


/* MACINTSTATRAW */


#define EMAC_MACINTSTATRAW_HOSTPEND (0x00000002u)
#define EMAC_MACINTSTATRAW_HOSTPEND_SHIFT (0x00000001u)

#define EMAC_MACINTSTATRAW_STATPEND (0x00000001u)
#define EMAC_MACINTSTATRAW_STATPEND_SHIFT (0x00000000u)


/* MACINTSTATMASKED */


#define EMAC_MACINTSTATMASKED_HOSTPEND (0x00000002u)
#define EMAC_MACINTSTATMASKED_HOSTPEND_SHIFT (0x00000001u)

#define EMAC_MACINTSTATMASKED_STATPEND (0x00000001u)
#define EMAC_MACINTSTATMASKED_STATPEND_SHIFT (0x00000000u)


/* MACINTMASKSET */


#define EMAC_MACINTMASKSET_HOSTMASK (0x00000002u)
#define EMAC_MACINTMASKSET_HOSTMASK_SHIFT (0x00000001u)

#define EMAC_MACINTMASKSET_STATMASK (0x00000001u)
#define EMAC_MACINTMASKSET_STATMASK_SHIFT (0x00000000u)


/* MACINTMASKCLEAR */


#define EMAC_MACINTMASKCLEAR_HOSTMASK (0x00000002u)
#define EMAC_MACINTMASKCLEAR_HOSTMASK_SHIFT (0x00000001u)

#define EMAC_MACINTMASKCLEAR_STATMASK (0x00000001u)
#define EMAC_MACINTMASKCLEAR_STATMASK_SHIFT (0x00000000u)


/* RXMBPENABLE */


#define EMAC_RXMBPENABLE_RXPASSCRC (0x40000000u)
#define EMAC_RXMBPENABLE_RXPASSCRC_SHIFT (0x0000001Eu)
#define EMAC_RXMBPENABLE_RXQOSEN (0x20000000u)
#define EMAC_RXMBPENABLE_RXQOSEN_SHIFT (0x0000001Du)
#define EMAC_RXMBPENABLE_RXNOCHAIN (0x10000000u)
#define EMAC_RXMBPENABLE_RXNOCHAIN_SHIFT (0x0000001Cu)
#define EMAC_RXMBPENABLE_RXCMFEN (0x01000000u)
#define EMAC_RXMBPENABLE_RXCMFEN_SHIFT (0x00000018u)
#define EMAC_RXMBPENABLE_RXCSFEN (0x00800000u)
#define EMAC_RXMBPENABLE_RXCSFEN_SHIFT (0x00000017u)
#define EMAC_RXMBPENABLE_RXCEFEN (0x00400000u)
#define EMAC_RXMBPENABLE_RXCEFEN_SHIFT (0x00000016u)
#define EMAC_RXMBPENABLE_RXCAFEN (0x00200000u)
#define EMAC_RXMBPENABLE_RXCAFEN_SHIFT (0x00000015u)
/*----RXCAFEN Tokens----*/
#define EMAC_RXMBPENABLE_RXPROMCH (0x00070000u)
#define EMAC_RXMBPENABLE_RXPROMCH_SHIFT (0x00000010u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA0 (0x00000000u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA1 (0x00000001u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA2 (0x00000002u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA3 (0x00000003u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA4 (0x00000004u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA5 (0x00000005u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA6 (0x00000006u)
#define EMAC_RXMBPENABLE_RXPROMCH_CHA7 (0x00000007u)


#define EMAC_RXMBPENABLE_RXBROADEN (0x00002000u)
#define EMAC_RXMBPENABLE_RXBROADEN_SHIFT (0x0000000Du)
#define EMAC_RXMBPENABLE_RXBROADCH (0x00000700u)
#define EMAC_RXMBPENABLE_RXBROADCH_SHIFT (0x00000008u)
/*----RXBROADCH Tokens----*/
#define EMAC_RXMBPENABLE_RXBROADCH_CHA0 (0x00000000u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA1 (0x00000001u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA2 (0x00000002u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA3 (0x00000003u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA4 (0x00000004u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA5 (0x00000005u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA6 (0x00000006u)
#define EMAC_RXMBPENABLE_RXBROADCH_CHA7 (0x00000007u)


#define EMAC_RXMBPENABLE_RXMULTEN (0x00000020u)
#define EMAC_RXMBPENABLE_RXMULTEN_SHIFT (0x00000005u)
#define EMAC_RXMBPENABLE_RXMULTCH (0x00000007u)
#define EMAC_RXMBPENABLE_RXMULTCH_SHIFT (0x00000000u)
/*----RXMULTCH Tokens----*/
#define EMAC_RXMBPENABLE_RXMULTCH_CHA0 (0x00000000u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA1 (0x00000001u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA2 (0x00000002u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA3 (0x00000003u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA4 (0x00000004u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA5 (0x00000005u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA6 (0x00000006u)
#define EMAC_RXMBPENABLE_RXMULTCH_CHA7 (0x00000007u)


/* RXUNICASTSET */


#define EMAC_RXUNICASTSET_RXCH7EN (0x00000080u)
#define EMAC_RXUNICASTSET_RXCH7EN_SHIFT (0x00000007u)
#define EMAC_RXUNICASTSET_RXCH6EN (0x00000040u)
#define EMAC_RXUNICASTSET_RXCH6EN_SHIFT (0x00000006u)
#define EMAC_RXUNICASTSET_RXCH5EN (0x00000020u)
#define EMAC_RXUNICASTSET_RXCH5EN_SHIFT (0x00000005u)
#define EMAC_RXUNICASTSET_RXCH4EN (0x00000010u)
#define EMAC_RXUNICASTSET_RXCH4EN_SHIFT (0x00000004u)
#define EMAC_RXUNICASTSET_RXCH3EN (0x00000008u)
#define EMAC_RXUNICASTSET_RXCH3EN_SHIFT (0x00000003u)
#define EMAC_RXUNICASTSET_RXCH2EN (0x00000004u)
#define EMAC_RXUNICASTSET_RXCH2EN_SHIFT (0x00000002u)
#define EMAC_RXUNICASTSET_RXCH1EN (0x00000002u)
#define EMAC_RXUNICASTSET_RXCH1EN_SHIFT (0x00000001u)
#define EMAC_RXUNICASTSET_RXCH0EN (0x00000001u)
#define EMAC_RXUNICASTSET_RXCH0EN_SHIFT (0x00000000u)

/* RXUNICASTCLEAR */


#define EMAC_RXUNICASTCLEAR_RXCH7EN (0x00000080u)
#define EMAC_RXUNICASTCLEAR_RXCH7EN_SHIFT (0x00000007u)
#define EMAC_RXUNICASTCLEAR_RXCH6EN (0x00000040u)
#define EMAC_RXUNICASTCLEAR_RXCH6EN_SHIFT (0x00000006u)
#define EMAC_RXUNICASTCLEAR_RXCH5EN (0x00000020u)
#define EMAC_RXUNICASTCLEAR_RXCH5EN_SHIFT (0x00000005u)
#define EMAC_RXUNICASTCLEAR_RXCH4EN (0x00000010u)
#define EMAC_RXUNICASTCLEAR_RXCH4EN_SHIFT (0x00000004u)
#define EMAC_RXUNICASTCLEAR_RXCH3EN (0x00000008u)
#define EMAC_RXUNICASTCLEAR_RXCH3EN_SHIFT (0x00000003u)
#define EMAC_RXUNICASTCLEAR_RXCH2EN (0x00000004u)
#define EMAC_RXUNICASTCLEAR_RXCH2EN_SHIFT (0x00000002u)
#define EMAC_RXUNICASTCLEAR_RXCH1EN (0x00000002u)
#define EMAC_RXUNICASTCLEAR_RXCH1EN_SHIFT (0x00000001u)
#define EMAC_RXUNICASTCLEAR_RXCH0EN (0x00000001u)
#define EMAC_RXUNICASTCLEAR_RXCH0EN_SHIFT (0x00000000u)

/* RXMAXLEN */


#define EMAC_RXMAXLEN_RXMAXLEN  (0x0000FFFFu)
#define EMAC_RXMAXLEN_RXMAXLEN_SHIFT (0x00000000u)


/* RXBUFFEROFFSET */


#define EMAC_RXBUFFEROFFSET_RXBUFFEROFFSET (0x0000FFFFu)
#define EMAC_RXBUFFEROFFSET_RXBUFFEROFFSET_SHIFT (0x00000000u)


/* RXFILTERLOWTHRESH */


#define EMAC_RXFILTERLOWTHRESH_RXFILTERTHRESH (0x000000FFu)
#define EMAC_RXFILTERLOWTHRESH_RXFILTERTHRESH_SHIFT (0x00000000u)


/* RX0FLOWTHRESH */


#define EMAC_RX0FLOWTHRESH_RX0FLOWTHRESH (0x000000FFu)
#define EMAC_RX0FLOWTHRESH_RX0FLOWTHRESH_SHIFT (0x00000000u)


/* RX1FLOWTHRESH */


#define EMAC_RX1FLOWTHRESH_RX1FLOWTHRESH (0x000000FFu)
#define EMAC_RX1FLOWTHRESH_RX1FLOWTHRESH_SHIFT (0x00000000u)


/* RX2FLOWTHRESH */


#define EMAC_RX2FLOWTHRESH_RX2FLOWTHRESH (0x000000FFu)
#define EMAC_RX2FLOWTHRESH_RX2FLOWTHRESH_SHIFT (0x00000000u)


/* RX3FLOWTHRESH */


#define EMAC_RX3FLOWTHRESH_RX3FLOWTHRESH (0x000000FFu)
#define EMAC_RX3FLOWTHRESH_RX3FLOWTHRESH_SHIFT (0x00000000u)


/* RX4FLOWTHRESH */


#define EMAC_RX4FLOWTHRESH_RX4FLOWTHRESH (0x000000FFu)
#define EMAC_RX4FLOWTHRESH_RX4FLOWTHRESH_SHIFT (0x00000000u)


/* RX5FLOWTHRESH */


#define EMAC_RX5FLOWTHRESH_RX5FLOWTHRESH (0x000000FFu)
#define EMAC_RX5FLOWTHRESH_RX5FLOWTHRESH_SHIFT (0x00000000u)


/* RX6FLOWTHRESH */


#define EMAC_RX6FLOWTHRESH_RX6FLOWTHRESH (0x000000FFu)
#define EMAC_RX6FLOWTHRESH_RX6FLOWTHRESH_SHIFT (0x00000000u)


/* RX7FLOWTHRESH */


#define EMAC_RX7FLOWTHRESH_RX7FLOWTHRESH (0x000000FFu)
#define EMAC_RX7FLOWTHRESH_RX7FLOWTHRESH_SHIFT (0x00000000u)


/* RX0FREEBUFFER */


#define EMAC_RX0FREEBUFFER_RX0FREEBUF (0x0000FFFFu)
#define EMAC_RX0FREEBUFFER_RX0FREEBUF_SHIFT (0x00000000u)


/* RX1FREEBUFFER */


#define EMAC_RX1FREEBUFFER_RX1FREEBUF (0x0000FFFFu)
#define EMAC_RX1FREEBUFFER_RX1FREEBUF_SHIFT (0x00000000u)


/* RX2FREEBUFFER */


#define EMAC_RX2FREEBUFFER_RX2FREEBUF (0x0000FFFFu)
#define EMAC_RX2FREEBUFFER_RX2FREEBUF_SHIFT (0x00000000u)


/* RX3FREEBUFFER */


#define EMAC_RX3FREEBUFFER_RX3FREEBUF (0x0000FFFFu)
#define EMAC_RX3FREEBUFFER_RX3FREEBUF_SHIFT (0x00000000u)


/* RX4FREEBUFFER */


#define EMAC_RX4FREEBUFFER_RX4FREEBUF (0x0000FFFFu)
#define EMAC_RX4FREEBUFFER_RX4FREEBUF_SHIFT (0x00000000u)


/* RX5FREEBUFFER */


#define EMAC_RX5FREEBUFFER_RX5FREEBUF (0x0000FFFFu)
#define EMAC_RX5FREEBUFFER_RX5FREEBUF_SHIFT (0x00000000u)


/* RX6FREEBUFFER */


#define EMAC_RX6FREEBUFFER_RX6FREEBUF (0x0000FFFFu)
#define EMAC_RX6FREEBUFFER_RX6FREEBUF_SHIFT (0x00000000u)


/* RX7FREEBUFFER */


#define EMAC_RX7FREEBUFFER_RX7FREEBUF (0x0000FFFFu)
#define EMAC_RX7FREEBUFFER_RX7FREEBUF_SHIFT (0x00000000u)


/* MACCONTROL */





#define EMAC_MACCONTROL_RMIISPEED (0x00008000u)
#define EMAC_MACCONTROL_RMIISPEED_SHIFT (0x0000000Fu)
#define EMAC_MACCONTROL_RXOFFLENBLOCK (0x00004000u)
#define EMAC_MACCONTROL_RXOFFLENBLOCK_SHIFT (0x0000000Eu)
#define EMAC_MACCONTROL_RXOWNERSHIP (0x00002000u)
#define EMAC_MACCONTROL_RXOWNERSHIP_SHIFT (0x0000000Du)
#define EMAC_MACCONTROL_CMDIDLE (0x00000800u)
#define EMAC_MACCONTROL_CMDIDLE_SHIFT (0x0000000Bu)
#define EMAC_MACCONTROL_TXSHORTGAPEN (0x00000400u)
#define EMAC_MACCONTROL_TXSHORTGAPEN_SHIFT (0x0000000Au)
#define EMAC_MACCONTROL_TXPTYPE (0x00000200u)
#define EMAC_MACCONTROL_TXPTYPE_SHIFT (0x00000009u)
#define EMAC_MACCONTROL_TXPACE  (0x00000040u)
#define EMAC_MACCONTROL_TXPACE_SHIFT (0x00000006u)
#define EMAC_MACCONTROL_GMIIEN  (0x00000020u)
#define EMAC_MACCONTROL_GMIIEN_SHIFT (0x00000005u)
#define EMAC_MACCONTROL_TXFLOWEN (0x00000010u)
#define EMAC_MACCONTROL_TXFLOWEN_SHIFT (0x00000004u)
#define EMAC_MACCONTROL_RXBUFFERFLOWEN (0x00000008u)
#define EMAC_MACCONTROL_RXBUFFERFLOWEN_SHIFT (0x00000003u)
#define EMAC_MACCONTROL_LOOPBACK (0x00000002u)
#define EMAC_MACCONTROL_LOOPBACK_SHIFT (0x00000001u)
#define EMAC_MACCONTROL_FULLDUPLEX (0x00000001u)
#define EMAC_MACCONTROL_FULLDUPLEX_SHIFT (0x00000000u)


/* MACSTATUS */

#define EMAC_MACSTATUS_IDLE     (0x80000000u)
#define EMAC_MACSTATUS_IDLE_SHIFT    (0x0000001Fu)
#define EMAC_MACSTATUS_TXERRCODE (0x00F00000u)
#define EMAC_MACSTATUS_TXERRCODE_SHIFT (0x00000014u)
/*----TXERRCODE Tokens----*/
#define EMAC_MACSTATUS_TXERRCODE_NOERROR (0x00000000u)
#define EMAC_MACSTATUS_TXERRCODE_SOPERROR (0x00000001u)
#define EMAC_MACSTATUS_TXERRCODE_OWNERSHIP (0x00000002u)
#define EMAC_MACSTATUS_TXERRCODE_NOEOP (0x00000003u)
#define EMAC_MACSTATUS_TXERRCODE_NULLPTR (0x00000004u)
#define EMAC_MACSTATUS_TXERRCODE_NULLEN (0x00000005u)
#define EMAC_MACSTATUS_TXERRCODE_LENERROR (0x00000006u)


#define EMAC_MACSTATUS_TXERRCH  (0x00070000u)
#define EMAC_MACSTATUS_TXERRCH_SHIFT (0x00000010u)
/*----TXERRCH Tokens----*/
#define EMAC_MACSTATUS_TXERRCH_CHA0  (0x00000000u)
#define EMAC_MACSTATUS_TXERRCH_CHA1  (0x00000001u)
#define EMAC_MACSTATUS_TXERRCH_CHA2  (0x00000002u)
#define EMAC_MACSTATUS_TXERRCH_CHA3  (0x00000003u)
#define EMAC_MACSTATUS_TXERRCH_CHA4  (0x00000004u)
#define EMAC_MACSTATUS_TXERRCH_CHA5  (0x00000005u)
#define EMAC_MACSTATUS_TXERRCH_CHA6  (0x00000006u)
#define EMAC_MACSTATUS_TXERRCH_CHA7  (0x00000007u)

#define EMAC_MACSTATUS_RXERRCODE (0x0000F000u)
#define EMAC_MACSTATUS_RXERRCODE_SHIFT (0x0000000Cu)
/*----RXERRCODE Tokens----*/
#define EMAC_MACSTATUS_RXERRCODE_NOERROR (0x00000000u)
#define EMAC_MACSTATUS_RXERRCODE_OWNERSHIP (0x00000002u)
#define EMAC_MACSTATUS_RXERRCODE_NULLPTR (0x00000004u)


#define EMAC_MACSTATUS_RXERRCH  (0x00000700u)
#define EMAC_MACSTATUS_RXERRCH_SHIFT (0x00000008u)
/*----RXERRCH Tokens----*/
#define EMAC_MACSTATUS_RXERRCH_CHA0  (0x00000000u)
#define EMAC_MACSTATUS_RXERRCH_CHA1  (0x00000001u)
#define EMAC_MACSTATUS_RXERRCH_CHA2  (0x00000002u)
#define EMAC_MACSTATUS_RXERRCH_CHA3  (0x00000003u)
#define EMAC_MACSTATUS_RXERRCH_CHA4  (0x00000004u)
#define EMAC_MACSTATUS_RXERRCH_CHA5  (0x00000005u)
#define EMAC_MACSTATUS_RXERRCH_CHA6  (0x00000006u)
#define EMAC_MACSTATUS_RXERRCH_CHA7  (0x00000007u)




#define EMAC_MACSTATUS_RXQOSACT (0x00000004u)
#define EMAC_MACSTATUS_RXQOSACT_SHIFT (0x00000002u)
#define EMAC_MACSTATUS_RXFLOWACT (0x00000002u)
#define EMAC_MACSTATUS_RXFLOWACT_SHIFT (0x00000001u)
#define EMAC_MACSTATUS_TXFLOWACT (0x00000001u)
#define EMAC_MACSTATUS_TXFLOWACT_SHIFT (0x00000000u)

/* EMCONTROL */


#define EMAC_EMCONTROL_SOFT     (0x00000002u)
#define EMAC_EMCONTROL_SOFT_SHIFT    (0x00000001u)

#define EMAC_EMCONTROL_FREE     (0x00000001u)
#define EMAC_EMCONTROL_FREE_SHIFT    (0x00000000u)


/* FIFOCONTROL */


#define EMAC_FIFOCONTROL_TXCELLTHRESH (0x00000003u)
#define EMAC_FIFOCONTROL_TXCELLTHRESH_SHIFT (0x00000000u)


/* MACCONFIG */

#define EMAC_MACCONFIG_TXCELLDEPTH (0xFF000000u)
#define EMAC_MACCONFIG_TXCELLDEPTH_SHIFT (0x00000018u)

#define EMAC_MACCONFIG_RXCELLDEPTH (0x00FF0000u)
#define EMAC_MACCONFIG_RXCELLDEPTH_SHIFT (0x00000010u)

#define EMAC_MACCONFIG_ADDRESSTYPE (0x0000FF00u)
#define EMAC_MACCONFIG_ADDRESSTYPE_SHIFT (0x00000008u)

#define EMAC_MACCONFIG_MACCFIG  (0x000000FFu)
#define EMAC_MACCONFIG_MACCFIG_SHIFT (0x00000000u)


/* SOFTRESET */


#define EMAC_SOFTRESET_SOFTRESET (0x00000001u)
#define EMAC_SOFTRESET_SOFTRESET_SHIFT (0x00000000u)

/* MACSRCADDRLO */


#define EMAC_MACSRCADDRLO_MACSRCADDR0 (0x0000FF00u)
#define EMAC_MACSRCADDRLO_MACSRCADDR0_SHIFT (0x00000008u)
#define EMAC_MACSRCADDRLO_MACSRCADDR1 (0x000000FFu)
#define EMAC_MACSRCADDRLO_MACSRCADDR1_SHIFT (0x00000000u)


/* MACSRCADDRHI */

#define EMAC_MACSRCADDRHI_MACSRCADDR2 (0xFF000000u)
#define EMAC_MACSRCADDRHI_MACSRCADDR2_SHIFT (0x00000018u)

#define EMAC_MACSRCADDRHI_MACSRCADDR3 (0x00FF0000u)
#define EMAC_MACSRCADDRHI_MACSRCADDR3_SHIFT (0x00000010u)

#define EMAC_MACSRCADDRHI_MACSRCADDR4 (0x0000FF00u)
#define EMAC_MACSRCADDRHI_MACSRCADDR4_SHIFT (0x00000008u)

#define EMAC_MACSRCADDRHI_MACSRCADDR5 (0x000000FFu)
#define EMAC_MACSRCADDRHI_MACSRCADDR5_SHIFT (0x00000000u)


/* MACHASH1 */

#define EMAC_MACHASH1_MACHASH1  (0xFFFFFFFFu)
#define EMAC_MACHASH1_MACHASH1_SHIFT (0x00000000u)


/* MACHASH2 */

#define EMAC_MACHASH2_MACHASH2  (0xFFFFFFFFu)
#define EMAC_MACHASH2_MACHASH2_SHIFT (0x00000000u)


/* BOFFTEST */


#define EMAC_BOFFTEST_RNDNUM    (0x03FF0000u)
#define EMAC_BOFFTEST_RNDNUM_SHIFT   (0x00000010u)

#define EMAC_BOFFTEST_COLLCOUNT (0x0000F000u)
#define EMAC_BOFFTEST_COLLCOUNT_SHIFT (0x0000000Cu)


#define EMAC_BOFFTEST_TXBACKOFF (0x000003FFu)
#define EMAC_BOFFTEST_TXBACKOFF_SHIFT (0x00000000u)


/* TPACETEST */


#define EMAC_TPACETEST_PACEVAL  (0x0000001Fu)
#define EMAC_TPACETEST_PACEVAL_SHIFT (0x00000000u)


/* RXPAUSE */


#define EMAC_RXPAUSE_PAUSETIMER (0x0000FFFFu)
#define EMAC_RXPAUSE_PAUSETIMER_SHIFT (0x00000000u)


/* TXPAUSE */


#define EMAC_TXPAUSE_PAUSETIMER (0x0000FFFFu)
#define EMAC_TXPAUSE_PAUSETIMER_SHIFT (0x00000000u)


/* RXGOODFRAMES */

#define EMAC_RXGOODFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_RXGOODFRAMES_COUNT_SHIFT (0x00000000u)


/* RXBCASTFRAMES */

#define EMAC_RXBCASTFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_RXBCASTFRAMES_COUNT_SHIFT (0x00000000u)


/* RXMCASTFRAMES */

#define EMAC_RXMCASTFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_RXMCASTFRAMES_COUNT_SHIFT (0x00000000u)


/* RXPAUSEFRAMES */

#define EMAC_RXPAUSEFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_RXPAUSEFRAMES_COUNT_SHIFT (0x00000000u)


/* RXCRCERRORS */

#define EMAC_RXCRCERRORS_COUNT  (0xFFFFFFFFu)
#define EMAC_RXCRCERRORS_COUNT_SHIFT (0x00000000u)


/* RXALIGNCODEERRORS */

#define EMAC_RXALIGNCODEERRORS_COUNT (0xFFFFFFFFu)
#define EMAC_RXALIGNCODEERRORS_COUNT_SHIFT (0x00000000u)


/* RXOVERSIZED */

#define EMAC_RXOVERSIZED_COUNT  (0xFFFFFFFFu)
#define EMAC_RXOVERSIZED_COUNT_SHIFT (0x00000000u)


/* RXJABBER */

#define EMAC_RXJABBER_COUNT     (0xFFFFFFFFu)
#define EMAC_RXJABBER_COUNT_SHIFT    (0x00000000u)


/* RXUNDERSIZED */

#define EMAC_RXUNDERSIZED_COUNT (0xFFFFFFFFu)
#define EMAC_RXUNDERSIZED_COUNT_SHIFT (0x00000000u)


/* RXFRAGMENTS */

#define EMAC_RXFRAGMENTS_COUNT  (0xFFFFFFFFu)
#define EMAC_RXFRAGMENTS_COUNT_SHIFT (0x00000000u)


/* RXFILTERED */

#define EMAC_RXFILTERED_COUNT   (0xFFFFFFFFu)
#define EMAC_RXFILTERED_COUNT_SHIFT  (0x00000000u)


/* RXQOSFILTERED */

#define EMAC_RXQOSFILTERED_COUNT (0xFFFFFFFFu)
#define EMAC_RXQOSFILTERED_COUNT_SHIFT (0x00000000u)


/* RXOCTETS */

#define EMAC_RXOCTETS_COUNT     (0xFFFFFFFFu)
#define EMAC_RXOCTETS_COUNT_SHIFT    (0x00000000u)


/* TXGOODFRAMES */

#define EMAC_TXGOODFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_TXGOODFRAMES_COUNT_SHIFT (0x00000000u)


/* TXBCASTFRAMES */

#define EMAC_TXBCASTFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_TXBCASTFRAMES_COUNT_SHIFT (0x00000000u)


/* TXMCASTFRAMES */

#define EMAC_TXMCASTFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_TXMCASTFRAMES_COUNT_SHIFT (0x00000000u)


/* TXPAUSEFRAMES */

#define EMAC_TXPAUSEFRAMES_COUNT (0xFFFFFFFFu)
#define EMAC_TXPAUSEFRAMES_COUNT_SHIFT (0x00000000u)


/* TXDEFERRED */

#define EMAC_TXDEFERRED_COUNT   (0xFFFFFFFFu)
#define EMAC_TXDEFERRED_COUNT_SHIFT  (0x00000000u)


/* TXCOLLISION */

#define EMAC_TXCOLLISION_COUNT  (0xFFFFFFFFu)
#define EMAC_TXCOLLISION_COUNT_SHIFT (0x00000000u)


/* TXSINGLECOLL */

#define EMAC_TXSINGLECOLL_COUNT (0xFFFFFFFFu)
#define EMAC_TXSINGLECOLL_COUNT_SHIFT (0x00000000u)


/* TXMULTICOLL */

#define EMAC_TXMULTICOLL_COUNT  (0xFFFFFFFFu)
#define EMAC_TXMULTICOLL_COUNT_SHIFT (0x00000000u)


/* TXEXCESSIVECOLL */

#define EMAC_TXEXCESSIVECOLL_COUNT (0xFFFFFFFFu)
#define EMAC_TXEXCESSIVECOLL_COUNT_SHIFT (0x00000000u)


/* TXLATECOLL */

#define EMAC_TXLATECOLL_COUNT   (0xFFFFFFFFu)
#define EMAC_TXLATECOLL_COUNT_SHIFT  (0x00000000u)


/* TXUNDERRUN */

#define EMAC_TXUNDERRUN_COUNT   (0xFFFFFFFFu)
#define EMAC_TXUNDERRUN_COUNT_SHIFT  (0x00000000u)


/* TXCARRIERSENSE */

#define EMAC_TXCARRIERSENSE_COUNT (0xFFFFFFFFu)
#define EMAC_TXCARRIERSENSE_COUNT_SHIFT (0x00000000u)


/* TXOCTETS */

#define EMAC_TXOCTETS_COUNT     (0xFFFFFFFFu)
#define EMAC_TXOCTETS_COUNT_SHIFT    (0x00000000u)


/* FRAME64 */

#define EMAC_FRAME64_COUNT      (0xFFFFFFFFu)
#define EMAC_FRAME64_COUNT_SHIFT     (0x00000000u)


/* FRAME65T127 */

#define EMAC_FRAME65T127_COUNT  (0xFFFFFFFFu)
#define EMAC_FRAME65T127_COUNT_SHIFT (0x00000000u)


/* FRAME128T255 */

#define EMAC_FRAME128T255_COUNT (0xFFFFFFFFu)
#define EMAC_FRAME128T255_COUNT_SHIFT (0x00000000u)


/* FRAME256T511 */

#define EMAC_FRAME256T511_COUNT (0xFFFFFFFFu)
#define EMAC_FRAME256T511_COUNT_SHIFT (0x00000000u)


/* FRAME512T1023 */

#define EMAC_FRAME512T1023_COUNT (0xFFFFFFFFu)
#define EMAC_FRAME512T1023_COUNT_SHIFT (0x00000000u)


/* FRAME1024TUP */

#define EMAC_FRAME1024TUP_COUNT (0xFFFFFFFFu)
#define EMAC_FRAME1024TUP_COUNT_SHIFT (0x00000000u)


/* NETOCTETS */

#define EMAC_NETOCTETS_COUNT    (0xFFFFFFFFu)
#define EMAC_NETOCTETS_COUNT_SHIFT   (0x00000000u)


/* RXSOFOVERRUNS */

#define EMAC_RXSOFOVERRUNS_COUNT (0xFFFFFFFFu)
#define EMAC_RXSOFOVERRUNS_COUNT_SHIFT (0x00000000u)


/* RXMOFOVERRUNS */

#define EMAC_RXMOFOVERRUNS_COUNT (0xFFFFFFFFu)
#define EMAC_RXMOFOVERRUNS_COUNT_SHIFT (0x00000000u)


/* RXDMAOVERRUNS */

#define EMAC_RXDMAOVERRUNS_COUNT (0xFFFFFFFFu)
#define EMAC_RXDMAOVERRUNS_COUNT_SHIFT (0x00000000u)


/* MACADDRLO */


#define EMAC_MACADDRLO_VALID    (0x00100000u)
#define EMAC_MACADDRLO_VALID_SHIFT   (0x00000014u)
#define EMAC_MACADDRLO_MATCHFILT (0x00080000u)
#define EMAC_MACADDRLO_MATCHFILT_SHIFT (0x00000013u)
#define EMAC_MACADDRLO_CHANNEL  (0x00070000u)
#define EMAC_MACADDRLO_CHANNEL_SHIFT (0x00000010u)
#define EMAC_MACADDRLO_MACADDR0 (0x0000FF00u)
#define EMAC_MACADDRLO_MACADDR0_SHIFT (0x00000008u)
#define EMAC_MACADDRLO_MACADDR1 (0x000000FFu)
#define EMAC_MACADDRLO_MACADDR1_SHIFT (0x00000000u)


/* MACADDRHI */

#define EMAC_MACADDRHI_MACADDR2 (0xFF000000u)
#define EMAC_MACADDRHI_MACADDR2_SHIFT (0x00000018u)

#define EMAC_MACADDRHI_MACADDR3 (0x00FF0000u)
#define EMAC_MACADDRHI_MACADDR3_SHIFT (0x00000010u)

#define EMAC_MACADDRHI_MACADDR4 (0x0000FF00u)
#define EMAC_MACADDRHI_MACADDR4_SHIFT (0x00000008u)

#define EMAC_MACADDRHI_MACADDR5 (0x000000FFu)
#define EMAC_MACADDRHI_MACADDR5_SHIFT (0x00000000u)


/* MACINDEX */


#define EMAC_MACINDEX_MACINDEX  (0x0000001Fu)
#define EMAC_MACINDEX_MACINDEX_SHIFT (0x00000000u)


/* TX0HDP */

#define EMAC_TX0HDP_TX0HDP      (0xFFFFFFFFu)
#define EMAC_TX0HDP_TX0HDP_SHIFT     (0x00000000u)


/* TX1HDP */

#define EMAC_TX1HDP_TX1HDP      (0xFFFFFFFFu)
#define EMAC_TX1HDP_TX1HDP_SHIFT     (0x00000000u)


/* TX2HDP */

#define EMAC_TX2HDP_TX2HDP      (0xFFFFFFFFu)
#define EMAC_TX2HDP_TX2HDP_SHIFT     (0x00000000u)


/* TX3HDP */

#define EMAC_TX3HDP_TX3HDP      (0xFFFFFFFFu)
#define EMAC_TX3HDP_TX3HDP_SHIFT     (0x00000000u)


/* TX4HDP */

#define EMAC_TX4HDP_TX4HDP      (0xFFFFFFFFu)
#define EMAC_TX4HDP_TX4HDP_SHIFT     (0x00000000u)


/* TX5HDP */

#define EMAC_TX5HDP_TX5HDP      (0xFFFFFFFFu)
#define EMAC_TX5HDP_TX5HDP_SHIFT     (0x00000000u)


/* TX6HDP */

#define EMAC_TX6HDP_TX6HDP      (0xFFFFFFFFu)
#define EMAC_TX6HDP_TX6HDP_SHIFT     (0x00000000u)


/* TX7HDP */

#define EMAC_TX7HDP_TX7HDP      (0xFFFFFFFFu)
#define EMAC_TX7HDP_TX7HDP_SHIFT     (0x00000000u)


/* RX0HDP */

#define EMAC_RX0HDP_RX0HDP      (0xFFFFFFFFu)
#define EMAC_RX0HDP_RX0HDP_SHIFT     (0x00000000u)


/* RX1HDP */

#define EMAC_RX1HDP_RX1HDP      (0xFFFFFFFFu)
#define EMAC_RX1HDP_RX1HDP_SHIFT     (0x00000000u)


/* RX2HDP */

#define EMAC_RX2HDP_RX2HDP      (0xFFFFFFFFu)
#define EMAC_RX2HDP_RX2HDP_SHIFT     (0x00000000u)


/* RX3HDP */

#define EMAC_RX3HDP_RX3HDP      (0xFFFFFFFFu)
#define EMAC_RX3HDP_RX3HDP_SHIFT     (0x00000000u)


/* RX4HDP */

#define EMAC_RX4HDP_RX4HDP      (0xFFFFFFFFu)
#define EMAC_RX4HDP_RX4HDP_SHIFT     (0x00000000u)


/* RX5HDP */

#define EMAC_RX5HDP_RX5HDP      (0xFFFFFFFFu)
#define EMAC_RX5HDP_RX5HDP_SHIFT     (0x00000000u)


/* RX6HDP */

#define EMAC_RX6HDP_RX6HDP      (0xFFFFFFFFu)
#define EMAC_RX6HDP_RX6HDP_SHIFT     (0x00000000u)


/* RX7HDP */

#define EMAC_RX7HDP_RX7HDP      (0xFFFFFFFFu)
#define EMAC_RX7HDP_RX7HDP_SHIFT     (0x00000000u)


/* TX0CP */

#define EMAC_TX0CP_TX0CP        (0xFFFFFFFFu)
#define EMAC_TX0CP_TX0CP_SHIFT       (0x00000000u)


/* TX1CP */

#define EMAC_TX1CP_TX1CP        (0xFFFFFFFFu)
#define EMAC_TX1CP_TX1CP_SHIFT       (0x00000000u)


/* TX2CP */

#define EMAC_TX2CP_TX2CP        (0xFFFFFFFFu)
#define EMAC_TX2CP_TX2CP_SHIFT       (0x00000000u)


/* TX3CP */

#define EMAC_TX3CP_TX3CP        (0xFFFFFFFFu)
#define EMAC_TX3CP_TX3CP_SHIFT       (0x00000000u)


/* TX4CP */

#define EMAC_TX4CP_TX4CP        (0xFFFFFFFFu)
#define EMAC_TX4CP_TX4CP_SHIFT       (0x00000000u)


/* TX5CP */

#define EMAC_TX5CP_TX5CP        (0xFFFFFFFFu)
#define EMAC_TX5CP_TX5CP_SHIFT       (0x00000000u)


/* TX6CP */

#define EMAC_TX6CP_TX6CP        (0xFFFFFFFFu)
#define EMAC_TX6CP_TX6CP_SHIFT       (0x00000000u)


/* TX7CP */

#define EMAC_TX7CP_TX7CP        (0xFFFFFFFFu)
#define EMAC_TX7CP_TX7CP_SHIFT       (0x00000000u)


/* RX0CP */

#define EMAC_RX0CP_RX0CP        (0xFFFFFFFFu)
#define EMAC_RX0CP_RX0CP_SHIFT       (0x00000000u)


/* RX1CP */

#define EMAC_RX1CP_RX1CP        (0xFFFFFFFFu)
#define EMAC_RX1CP_RX1CP_SHIFT       (0x00000000u)


/* RX2CP */

#define EMAC_RX2CP_RX2CP        (0xFFFFFFFFu)
#define EMAC_RX2CP_RX2CP_SHIFT       (0x00000000u)


/* RX3CP */

#define EMAC_RX3CP_RX3CP        (0xFFFFFFFFu)
#define EMAC_RX3CP_RX3CP_SHIFT       (0x00000000u)


/* RX4CP */

#define EMAC_RX4CP_RX4CP        (0xFFFFFFFFu)
#define EMAC_RX4CP_RX4CP_SHIFT       (0x00000000u)


/* RX5CP */

#define EMAC_RX5CP_RX5CP        (0xFFFFFFFFu)
#define EMAC_RX5CP_RX5CP_SHIFT       (0x00000000u)


/* RX6CP */

#define EMAC_RX6CP_RX6CP        (0xFFFFFFFFu)
#define EMAC_RX6CP_RX6CP_SHIFT       (0x00000000u)


/* RX7CP */

#define EMAC_RX7CP_RX7CP        (0xFFFFFFFFu)
#define EMAC_RX7CP_RX7CP_SHIFT       (0x00000000u)


#endif
