/*
 * hw_gpio.h
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */


#ifndef _HW_GPIO_H_
#define _HW_GPIO_H_

#ifdef __cplusplus
extern "C" {
#endif


#define GPIO_REVID		(0x0)
#define GPIO_BINTEN		(0x8)
#define GPIO_DIR(n)		(0x10 + (0x28 * n))
#define GPIO_OUT_DATA(n)	(0x14 + (0x28 * n))
#define GPIO_SET_DATA(n)	(0x18 + (0x28 * n))
#define GPIO_CLR_DATA(n)	(0x1C + (0x28 * n))
#define GPIO_IN_DATA(n)		(0x20 + (0x28 * n))
#define GPIO_SET_RIS_TRIG(n)	(0x24 + (0x28 * n))
#define GPIO_CLR_RIS_TRIG(n)	(0x28 + (0x28 * n))
#define GPIO_SET_FAL_TRIG(n)	(0x2C + (0x28 * n))
#define GPIO_CLR_FAL_TRIG(n)	(0x30 + (0x28 * n))
#define GPIO_INTSTAT(n)		(0x34 + (0x28 * n))


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define GPIO_REVID_REV          (0xFFFFFFFFu)
#define GPIO_REVID_REV_SHIFT         (0x00000000u)


/* BINTEN */

#define GPIO_BINTEN_EN7         (0x00000080u)
#define GPIO_BINTEN_EN7_SHIFT        (0x00000007u)

#define GPIO_BINTEN_EN6         (0x00000040u)
#define GPIO_BINTEN_EN6_SHIFT        (0x00000006u)

#define GPIO_BINTEN_EN5         (0x00000020u)
#define GPIO_BINTEN_EN5_SHIFT        (0x00000005u)

#define GPIO_BINTEN_EN4         (0x00000010u)
#define GPIO_BINTEN_EN4_SHIFT        (0x00000004u)

#define GPIO_BINTEN_EN3         (0x00000008u)
#define GPIO_BINTEN_EN3_SHIFT        (0x00000003u)

#define GPIO_BINTEN_EN2         (0x00000004u)
#define GPIO_BINTEN_EN2_SHIFT        (0x00000002u)

#define GPIO_BINTEN_EN1         (0x00000002u)
#define GPIO_BINTEN_EN1_SHIFT        (0x00000001u)

#define GPIO_BINTEN_EN0         (0x00000001u)
#define GPIO_BINTEN_EN0_SHIFT        (0x00000000u)


/* DIR */

#define GPIO_DIR_DIR31          (0x80000000u)
#define GPIO_DIR_DIR31_SHIFT         (0x0000001Fu)

#define GPIO_DIR_DIR30          (0x40000000u)
#define GPIO_DIR_DIR30_SHIFT         (0x0000001Eu)

#define GPIO_DIR_DIR29          (0x20000000u)
#define GPIO_DIR_DIR29_SHIFT         (0x0000001Du)

#define GPIO_DIR_DIR28          (0x10000000u)
#define GPIO_DIR_DIR28_SHIFT         (0x0000001Cu)

#define GPIO_DIR_DIR27          (0x08000000u)
#define GPIO_DIR_DIR27_SHIFT         (0x0000001Bu)

#define GPIO_DIR_DIR26          (0x04000000u)
#define GPIO_DIR_DIR26_SHIFT         (0x0000001Au)

#define GPIO_DIR_DIR25          (0x02000000u)
#define GPIO_DIR_DIR25_SHIFT         (0x00000019u)

#define GPIO_DIR_DIR24          (0x01000000u)
#define GPIO_DIR_DIR24_SHIFT         (0x00000018u)

#define GPIO_DIR_DIR23          (0x00800000u)
#define GPIO_DIR_DIR23_SHIFT         (0x00000017u)

#define GPIO_DIR_DIR22          (0x00400000u)
#define GPIO_DIR_DIR22_SHIFT         (0x00000016u)

#define GPIO_DIR_DIR21          (0x00200000u)
#define GPIO_DIR_DIR21_SHIFT         (0x00000015u)

#define GPIO_DIR_DIR20          (0x00100000u)
#define GPIO_DIR_DIR20_SHIFT         (0x00000014u)

#define GPIO_DIR_DIR19          (0x00080000u)
#define GPIO_DIR_DIR19_SHIFT         (0x00000013u)

#define GPIO_DIR_DIR18          (0x00040000u)
#define GPIO_DIR_DIR18_SHIFT         (0x00000012u)

#define GPIO_DIR_DIR17          (0x00020000u)
#define GPIO_DIR_DIR17_SHIFT         (0x00000011u)

#define GPIO_DIR_DIR16          (0x00010000u)
#define GPIO_DIR_DIR16_SHIFT         (0x00000010u)

#define GPIO_DIR_DIR15          (0x00008000u)
#define GPIO_DIR_DIR15_SHIFT         (0x0000000Fu)

#define GPIO_DIR_DIR14          (0x00004000u)
#define GPIO_DIR_DIR14_SHIFT         (0x0000000Eu)

#define GPIO_DIR_DIR13          (0x00002000u)
#define GPIO_DIR_DIR13_SHIFT         (0x0000000Du)

#define GPIO_DIR_DIR12          (0x00001000u)
#define GPIO_DIR_DIR12_SHIFT         (0x0000000Cu)

#define GPIO_DIR_DIR11          (0x00000800u)
#define GPIO_DIR_DIR11_SHIFT         (0x0000000Bu)

#define GPIO_DIR_DIR10          (0x00000400u)
#define GPIO_DIR_DIR10_SHIFT         (0x0000000Au)

#define GPIO_DIR_DIR9           (0x00000200u)
#define GPIO_DIR_DIR9_SHIFT          (0x00000009u)

#define GPIO_DIR_DIR8           (0x00000100u)
#define GPIO_DIR_DIR8_SHIFT          (0x00000008u)

#define GPIO_DIR_DIR7           (0x00000080u)
#define GPIO_DIR_DIR7_SHIFT          (0x00000007u)

#define GPIO_DIR_DIR6           (0x00000040u)
#define GPIO_DIR_DIR6_SHIFT          (0x00000006u)

#define GPIO_DIR_DIR5           (0x00000020u)
#define GPIO_DIR_DIR5_SHIFT          (0x00000005u)

#define GPIO_DIR_DIR4           (0x00000010u)
#define GPIO_DIR_DIR4_SHIFT          (0x00000004u)

#define GPIO_DIR_DIR3           (0x00000008u)
#define GPIO_DIR_DIR3_SHIFT          (0x00000003u)

#define GPIO_DIR_DIR2           (0x00000004u)
#define GPIO_DIR_DIR2_SHIFT          (0x00000002u)

#define GPIO_DIR_DIR1           (0x00000002u)
#define GPIO_DIR_DIR1_SHIFT          (0x00000001u)

#define GPIO_DIR_DIR0           (0x00000001u)
#define GPIO_DIR_DIR0_SHIFT          (0x00000000u)

/* OUT_DATA */

#define GPIO_OUT_DATA_OUT31     (0x80000000u)
#define GPIO_OUT_DATA_OUT31_SHIFT    (0x0000001Fu)

#define GPIO_OUT_DATA_OUT30     (0x40000000u)
#define GPIO_OUT_DATA_OUT30_SHIFT    (0x0000001Eu)

#define GPIO_OUT_DATA_OUT29     (0x20000000u)
#define GPIO_OUT_DATA_OUT29_SHIFT    (0x0000001Du)

#define GPIO_OUT_DATA_OUT28     (0x10000000u)
#define GPIO_OUT_DATA_OUT28_SHIFT    (0x0000001Cu)

#define GPIO_OUT_DATA_OUT27     (0x08000000u)
#define GPIO_OUT_DATA_OUT27_SHIFT    (0x0000001Bu)

#define GPIO_OUT_DATA_OUT26     (0x04000000u)
#define GPIO_OUT_DATA_OUT26_SHIFT    (0x0000001Au)

#define GPIO_OUT_DATA_OUT25     (0x02000000u)
#define GPIO_OUT_DATA_OUT25_SHIFT    (0x00000019u)

#define GPIO_OUT_DATA_OUT24     (0x01000000u)
#define GPIO_OUT_DATA_OUT24_SHIFT    (0x00000018u)

#define GPIO_OUT_DATA_OUT23     (0x00800000u)
#define GPIO_OUT_DATA_OUT23_SHIFT    (0x00000017u)

#define GPIO_OUT_DATA_OUT22     (0x00400000u)
#define GPIO_OUT_DATA_OUT22_SHIFT    (0x00000016u)

#define GPIO_OUT_DATA_OUT21     (0x00200000u)
#define GPIO_OUT_DATA_OUT21_SHIFT    (0x00000015u)

#define GPIO_OUT_DATA_OUT20     (0x00100000u)
#define GPIO_OUT_DATA_OUT20_SHIFT    (0x00000014u)

#define GPIO_OUT_DATA_OUT19     (0x00080000u)
#define GPIO_OUT_DATA_OUT19_SHIFT    (0x00000013u)

#define GPIO_OUT_DATA_OUT18     (0x00040000u)
#define GPIO_OUT_DATA_OUT18_SHIFT    (0x00000012u)

#define GPIO_OUT_DATA_OUT17     (0x00020000u)
#define GPIO_OUT_DATA_OUT17_SHIFT    (0x00000011u)

#define GPIO_OUT_DATA_OUT16     (0x00010000u)
#define GPIO_OUT_DATA_OUT16_SHIFT    (0x00000010u)

#define GPIO_OUT_DATA_OUT15     (0x00008000u)
#define GPIO_OUT_DATA_OUT15_SHIFT    (0x0000000Fu)

#define GPIO_OUT_DATA_OUT14     (0x00004000u)
#define GPIO_OUT_DATA_OUT14_SHIFT    (0x0000000Eu)

#define GPIO_OUT_DATA_OUT13     (0x00002000u)
#define GPIO_OUT_DATA_OUT13_SHIFT    (0x0000000Du)

#define GPIO_OUT_DATA_OUT12     (0x00001000u)
#define GPIO_OUT_DATA_OUT12_SHIFT    (0x0000000Cu)

#define GPIO_OUT_DATA_OUT11     (0x00000800u)
#define GPIO_OUT_DATA_OUT11_SHIFT    (0x0000000Bu)

#define GPIO_OUT_DATA_OUT10     (0x00000400u)
#define GPIO_OUT_DATA_OUT10_SHIFT    (0x0000000Au)

#define GPIO_OUT_DATA_OUT9      (0x00000200u)
#define GPIO_OUT_DATA_OUT9_SHIFT     (0x00000009u)

#define GPIO_OUT_DATA_OUT8      (0x00000100u)
#define GPIO_OUT_DATA_OUT8_SHIFT     (0x00000008u)

#define GPIO_OUT_DATA_OUT7      (0x00000080u)
#define GPIO_OUT_DATA_OUT7_SHIFT     (0x00000007u)

#define GPIO_OUT_DATA_OUT6      (0x00000040u)
#define GPIO_OUT_DATA_OUT6_SHIFT     (0x00000006u)

#define GPIO_OUT_DATA_OUT5      (0x00000020u)
#define GPIO_OUT_DATA_OUT5_SHIFT     (0x00000005u)

#define GPIO_OUT_DATA_OUT4      (0x00000010u)
#define GPIO_OUT_DATA_OUT4_SHIFT     (0x00000004u)

#define GPIO_OUT_DATA_OUT3      (0x00000008u)
#define GPIO_OUT_DATA_OUT3_SHIFT     (0x00000003u)

#define GPIO_OUT_DATA_OUT2      (0x00000004u)
#define GPIO_OUT_DATA_OUT2_SHIFT     (0x00000002u)

#define GPIO_OUT_DATA_OUT1      (0x00000002u)
#define GPIO_OUT_DATA_OUT1_SHIFT     (0x00000001u)

#define GPIO_OUT_DATA_OUT0      (0x00000001u)
#define GPIO_OUT_DATA_OUT0_SHIFT     (0x00000000u)


/* SET_DATA */

#define GPIO_SET_DATA_SET31     (0x80000000u)
#define GPIO_SET_DATA_SET31_SHIFT    (0x0000001Fu)

#define GPIO_SET_DATA_SET30     (0x40000000u)
#define GPIO_SET_DATA_SET30_SHIFT    (0x0000001Eu)

#define GPIO_SET_DATA_SET29     (0x20000000u)
#define GPIO_SET_DATA_SET29_SHIFT    (0x0000001Du)

#define GPIO_SET_DATA_SET28     (0x10000000u)
#define GPIO_SET_DATA_SET28_SHIFT    (0x0000001Cu)

#define GPIO_SET_DATA_SET27     (0x08000000u)
#define GPIO_SET_DATA_SET27_SHIFT    (0x0000001Bu)

#define GPIO_SET_DATA_SET26     (0x04000000u)
#define GPIO_SET_DATA_SET26_SHIFT    (0x0000001Au)

#define GPIO_SET_DATA_SET25     (0x02000000u)
#define GPIO_SET_DATA_SET25_SHIFT    (0x00000019u)

#define GPIO_SET_DATA_SET24     (0x01000000u)
#define GPIO_SET_DATA_SET24_SHIFT    (0x00000018u)

#define GPIO_SET_DATA_SET23     (0x00800000u)
#define GPIO_SET_DATA_SET23_SHIFT    (0x00000017u)

#define GPIO_SET_DATA_SET22     (0x00400000u)
#define GPIO_SET_DATA_SET22_SHIFT    (0x00000016u)

#define GPIO_SET_DATA_SET21     (0x00200000u)
#define GPIO_SET_DATA_SET21_SHIFT    (0x00000015u)

#define GPIO_SET_DATA_SET20     (0x00100000u)
#define GPIO_SET_DATA_SET20_SHIFT    (0x00000014u)

#define GPIO_SET_DATA_SET19     (0x00080000u)
#define GPIO_SET_DATA_SET19_SHIFT    (0x00000013u)

#define GPIO_SET_DATA_SET18     (0x00040000u)
#define GPIO_SET_DATA_SET18_SHIFT    (0x00000012u)

#define GPIO_SET_DATA_SET17     (0x00020000u)
#define GPIO_SET_DATA_SET17_SHIFT    (0x00000011u)

#define GPIO_SET_DATA_SET16     (0x00010000u)
#define GPIO_SET_DATA_SET16_SHIFT    (0x00000010u)

#define GPIO_SET_DATA_SET15     (0x00008000u)
#define GPIO_SET_DATA_SET15_SHIFT    (0x0000000Fu)

#define GPIO_SET_DATA_SET14     (0x00004000u)
#define GPIO_SET_DATA_SET14_SHIFT    (0x0000000Eu)

#define GPIO_SET_DATA_SET13     (0x00002000u)
#define GPIO_SET_DATA_SET13_SHIFT    (0x0000000Du)

#define GPIO_SET_DATA_SET12     (0x00001000u)
#define GPIO_SET_DATA_SET12_SHIFT    (0x0000000Cu)

#define GPIO_SET_DATA_SET11     (0x00000800u)
#define GPIO_SET_DATA_SET11_SHIFT    (0x0000000Bu)

#define GPIO_SET_DATA_SET10     (0x00000400u)
#define GPIO_SET_DATA_SET10_SHIFT    (0x0000000Au)

#define GPIO_SET_DATA_SET9      (0x00000200u)
#define GPIO_SET_DATA_SET9_SHIFT     (0x00000009u)

#define GPIO_SET_DATA_SET8      (0x00000100u)
#define GPIO_SET_DATA_SET8_SHIFT     (0x00000008u)

#define GPIO_SET_DATA_SET7      (0x00000080u)
#define GPIO_SET_DATA_SET7_SHIFT     (0x00000007u)

#define GPIO_SET_DATA_SET6      (0x00000040u)
#define GPIO_SET_DATA_SET6_SHIFT     (0x00000006u)

#define GPIO_SET_DATA_SET5      (0x00000020u)
#define GPIO_SET_DATA_SET5_SHIFT     (0x00000005u)

#define GPIO_SET_DATA_SET4      (0x00000010u)
#define GPIO_SET_DATA_SET4_SHIFT     (0x00000004u)

#define GPIO_SET_DATA_SET3      (0x00000008u)
#define GPIO_SET_DATA_SET3_SHIFT     (0x00000003u)

#define GPIO_SET_DATA_SET2      (0x00000004u)
#define GPIO_SET_DATA_SET2_SHIFT     (0x00000002u)

#define GPIO_SET_DATA_SET1      (0x00000002u)
#define GPIO_SET_DATA_SET1_SHIFT     (0x00000001u)

#define GPIO_SET_DATA_SET0      (0x00000001u)
#define GPIO_SET_DATA_SET0_SHIFT     (0x00000000u)

/* CLR_DATA */

#define GPIO_CLR_DATA_CLR31     (0x80000000u)
#define GPIO_CLR_DATA_CLR31_SHIFT    (0x0000001Fu)

#define GPIO_CLR_DATA_CLR30     (0x40000000u)
#define GPIO_CLR_DATA_CLR30_SHIFT    (0x0000001Eu)

#define GPIO_CLR_DATA_CLR29     (0x20000000u)
#define GPIO_CLR_DATA_CLR29_SHIFT    (0x0000001Du)

#define GPIO_CLR_DATA_CLR28     (0x10000000u)
#define GPIO_CLR_DATA_CLR28_SHIFT    (0x0000001Cu)

#define GPIO_CLR_DATA_CLR27     (0x08000000u)
#define GPIO_CLR_DATA_CLR27_SHIFT    (0x0000001Bu)

#define GPIO_CLR_DATA_CLR26     (0x04000000u)
#define GPIO_CLR_DATA_CLR26_SHIFT    (0x0000001Au)

#define GPIO_CLR_DATA_CLR25     (0x02000000u)
#define GPIO_CLR_DATA_CLR25_SHIFT    (0x00000019u)

#define GPIO_CLR_DATA_CLR24     (0x01000000u)
#define GPIO_CLR_DATA_CLR24_SHIFT    (0x00000018u)

#define GPIO_CLR_DATA_CLR23     (0x00800000u)
#define GPIO_CLR_DATA_CLR23_SHIFT    (0x00000017u)

#define GPIO_CLR_DATA_CLR22     (0x00400000u)
#define GPIO_CLR_DATA_CLR22_SHIFT    (0x00000016u)

#define GPIO_CLR_DATA_CLR21     (0x00200000u)
#define GPIO_CLR_DATA_CLR21_SHIFT    (0x00000015u)

#define GPIO_CLR_DATA_CLR20     (0x00100000u)
#define GPIO_CLR_DATA_CLR20_SHIFT    (0x00000014u)

#define GPIO_CLR_DATA_CLR19     (0x00080000u)
#define GPIO_CLR_DATA_CLR19_SHIFT    (0x00000013u)

#define GPIO_CLR_DATA_CLR18     (0x00040000u)
#define GPIO_CLR_DATA_CLR18_SHIFT    (0x00000012u)

#define GPIO_CLR_DATA_CLR17     (0x00020000u)
#define GPIO_CLR_DATA_CLR17_SHIFT    (0x00000011u)

#define GPIO_CLR_DATA_CLR16     (0x00010000u)
#define GPIO_CLR_DATA_CLR16_SHIFT    (0x00000010u)

#define GPIO_CLR_DATA_CLR15     (0x00008000u)
#define GPIO_CLR_DATA_CLR15_SHIFT    (0x0000000Fu)

#define GPIO_CLR_DATA_CLR14     (0x00004000u)
#define GPIO_CLR_DATA_CLR14_SHIFT    (0x0000000Eu)

#define GPIO_CLR_DATA_CLR13     (0x00002000u)
#define GPIO_CLR_DATA_CLR13_SHIFT    (0x0000000Du)

#define GPIO_CLR_DATA_CLR12     (0x00001000u)
#define GPIO_CLR_DATA_CLR12_SHIFT    (0x0000000Cu)

#define GPIO_CLR_DATA_CLR11     (0x00000800u)
#define GPIO_CLR_DATA_CLR11_SHIFT    (0x0000000Bu)

#define GPIO_CLR_DATA_CLR10     (0x00000400u)
#define GPIO_CLR_DATA_CLR10_SHIFT    (0x0000000Au)

#define GPIO_CLR_DATA_CLR9      (0x00000200u)
#define GPIO_CLR_DATA_CLR9_SHIFT     (0x00000009u)

#define GPIO_CLR_DATA_CLR8      (0x00000100u)
#define GPIO_CLR_DATA_CLR8_SHIFT     (0x00000008u)

#define GPIO_CLR_DATA_CLR7      (0x00000080u)
#define GPIO_CLR_DATA_CLR7_SHIFT     (0x00000007u)

#define GPIO_CLR_DATA_CLR6      (0x00000040u)
#define GPIO_CLR_DATA_CLR6_SHIFT     (0x00000006u)

#define GPIO_CLR_DATA_CLR5      (0x00000020u)
#define GPIO_CLR_DATA_CLR5_SHIFT     (0x00000005u)

#define GPIO_CLR_DATA_CLR4      (0x00000010u)
#define GPIO_CLR_DATA_CLR4_SHIFT     (0x00000004u)

#define GPIO_CLR_DATA_CLR3      (0x00000008u)
#define GPIO_CLR_DATA_CLR3_SHIFT     (0x00000003u)

#define GPIO_CLR_DATA_CLR2      (0x00000004u)
#define GPIO_CLR_DATA_CLR2_SHIFT     (0x00000002u)

#define GPIO_CLR_DATA_CLR1      (0x00000002u)
#define GPIO_CLR_DATA_CLR1_SHIFT     (0x00000001u)

#define GPIO_CLR_DATA_CLR0      (0x00000001u)
#define GPIO_CLR_DATA_CLR0_SHIFT     (0x00000000u)


/* IN_DATA */

#define GPIO_IN_DATA_IN31       (0x80000000u)
#define GPIO_IN_DATA_IN31_SHIFT      (0x0000001Fu)

#define GPIO_IN_DATA_IN30       (0x40000000u)
#define GPIO_IN_DATA_IN30_SHIFT      (0x0000001Eu)

#define GPIO_IN_DATA_IN29       (0x20000000u)
#define GPIO_IN_DATA_IN29_SHIFT      (0x0000001Du)

#define GPIO_IN_DATA_IN28       (0x10000000u)
#define GPIO_IN_DATA_IN28_SHIFT      (0x0000001Cu)

#define GPIO_IN_DATA_IN27       (0x08000000u)
#define GPIO_IN_DATA_IN27_SHIFT      (0x0000001Bu)

#define GPIO_IN_DATA_IN26       (0x04000000u)
#define GPIO_IN_DATA_IN26_SHIFT      (0x0000001Au)

#define GPIO_IN_DATA_IN25       (0x02000000u)
#define GPIO_IN_DATA_IN25_SHIFT      (0x00000019u)

#define GPIO_IN_DATA_IN24       (0x01000000u)
#define GPIO_IN_DATA_IN24_SHIFT      (0x00000018u)

#define GPIO_IN_DATA_IN23       (0x00800000u)
#define GPIO_IN_DATA_IN23_SHIFT      (0x00000017u)

#define GPIO_IN_DATA_IN22       (0x00400000u)
#define GPIO_IN_DATA_IN22_SHIFT      (0x00000016u)

#define GPIO_IN_DATA_IN21       (0x00200000u)
#define GPIO_IN_DATA_IN21_SHIFT      (0x00000015u)

#define GPIO_IN_DATA_IN20       (0x00100000u)
#define GPIO_IN_DATA_IN20_SHIFT      (0x00000014u)

#define GPIO_IN_DATA_IN19       (0x00080000u)
#define GPIO_IN_DATA_IN19_SHIFT      (0x00000013u)

#define GPIO_IN_DATA_IN18       (0x00040000u)
#define GPIO_IN_DATA_IN18_SHIFT      (0x00000012u)

#define GPIO_IN_DATA_IN17       (0x00020000u)
#define GPIO_IN_DATA_IN17_SHIFT      (0x00000011u)

#define GPIO_IN_DATA_IN16       (0x00010000u)
#define GPIO_IN_DATA_IN16_SHIFT      (0x00000010u)

#define GPIO_IN_DATA_IN15       (0x00008000u)
#define GPIO_IN_DATA_IN15_SHIFT      (0x0000000Fu)

#define GPIO_IN_DATA_IN14       (0x00004000u)
#define GPIO_IN_DATA_IN14_SHIFT      (0x0000000Eu)

#define GPIO_IN_DATA_IN13       (0x00002000u)
#define GPIO_IN_DATA_IN13_SHIFT      (0x0000000Du)

#define GPIO_IN_DATA_IN12       (0x00001000u)
#define GPIO_IN_DATA_IN12_SHIFT      (0x0000000Cu)

#define GPIO_IN_DATA_IN11       (0x00000800u)
#define GPIO_IN_DATA_IN11_SHIFT      (0x0000000Bu)

#define GPIO_IN_DATA_IN10       (0x00000400u)
#define GPIO_IN_DATA_IN10_SHIFT      (0x0000000Au)

#define GPIO_IN_DATA_IN9        (0x00000200u)
#define GPIO_IN_DATA_IN9_SHIFT       (0x00000009u)

#define GPIO_IN_DATA_IN8        (0x00000100u)
#define GPIO_IN_DATA_IN8_SHIFT       (0x00000008u)

#define GPIO_IN_DATA_IN7        (0x00000080u)
#define GPIO_IN_DATA_IN7_SHIFT       (0x00000007u)

#define GPIO_IN_DATA_IN6        (0x00000040u)
#define GPIO_IN_DATA_IN6_SHIFT       (0x00000006u)

#define GPIO_IN_DATA_IN5        (0x00000020u)
#define GPIO_IN_DATA_IN5_SHIFT       (0x00000005u)

#define GPIO_IN_DATA_IN4        (0x00000010u)
#define GPIO_IN_DATA_IN4_SHIFT       (0x00000004u)

#define GPIO_IN_DATA_IN3        (0x00000008u)
#define GPIO_IN_DATA_IN3_SHIFT       (0x00000003u)

#define GPIO_IN_DATA_IN2        (0x00000004u)
#define GPIO_IN_DATA_IN2_SHIFT       (0x00000002u)

#define GPIO_IN_DATA_IN1        (0x00000002u)
#define GPIO_IN_DATA_IN1_SHIFT       (0x00000001u)

#define GPIO_IN_DATA_IN0        (0x00000001u)
#define GPIO_IN_DATA_IN0_SHIFT       (0x00000000u)

/* SET_RIS_TRIG */

#define GPIO_SET_RIS_TRIG_SETRIS31 (0x80000000u)
#define GPIO_SET_RIS_TRIG_SETRIS31_SHIFT (0x0000001Fu)

#define GPIO_SET_RIS_TRIG_SETRIS30 (0x40000000u)
#define GPIO_SET_RIS_TRIG_SETRIS30_SHIFT (0x0000001Eu)

#define GPIO_SET_RIS_TRIG_SETRIS29 (0x20000000u)
#define GPIO_SET_RIS_TRIG_SETRIS29_SHIFT (0x0000001Du)

#define GPIO_SET_RIS_TRIG_SETRIS28 (0x10000000u)
#define GPIO_SET_RIS_TRIG_SETRIS28_SHIFT (0x0000001Cu)

#define GPIO_SET_RIS_TRIG_SETRIS27 (0x08000000u)
#define GPIO_SET_RIS_TRIG_SETRIS27_SHIFT (0x0000001Bu)

#define GPIO_SET_RIS_TRIG_SETRIS26 (0x04000000u)
#define GPIO_SET_RIS_TRIG_SETRIS26_SHIFT (0x0000001Au)

#define GPIO_SET_RIS_TRIG_SETRIS25 (0x02000000u)
#define GPIO_SET_RIS_TRIG_SETRIS25_SHIFT (0x00000019u)

#define GPIO_SET_RIS_TRIG_SETRIS24 (0x01000000u)
#define GPIO_SET_RIS_TRIG_SETRIS24_SHIFT (0x00000018u)

#define GPIO_SET_RIS_TRIG_SETRIS23 (0x00800000u)
#define GPIO_SET_RIS_TRIG_SETRIS23_SHIFT (0x00000017u)

#define GPIO_SET_RIS_TRIG_SETRIS22 (0x00400000u)
#define GPIO_SET_RIS_TRIG_SETRIS22_SHIFT (0x00000016u)

#define GPIO_SET_RIS_TRIG_SETRIS21 (0x00200000u)
#define GPIO_SET_RIS_TRIG_SETRIS21_SHIFT (0x00000015u)

#define GPIO_SET_RIS_TRIG_SETRIS20 (0x00100000u)
#define GPIO_SET_RIS_TRIG_SETRIS20_SHIFT (0x00000014u)

#define GPIO_SET_RIS_TRIG_SETRIS19 (0x00080000u)
#define GPIO_SET_RIS_TRIG_SETRIS19_SHIFT (0x00000013u)

#define GPIO_SET_RIS_TRIG_SETRIS18 (0x00040000u)
#define GPIO_SET_RIS_TRIG_SETRIS18_SHIFT (0x00000012u)

#define GPIO_SET_RIS_TRIG_SETRIS17 (0x00020000u)
#define GPIO_SET_RIS_TRIG_SETRIS17_SHIFT (0x00000011u)

#define GPIO_SET_RIS_TRIG_SETRIS16 (0x00010000u)
#define GPIO_SET_RIS_TRIG_SETRIS16_SHIFT (0x00000010u)

#define GPIO_SET_RIS_TRIG_SETRIS15 (0x00008000u)
#define GPIO_SET_RIS_TRIG_SETRIS15_SHIFT (0x0000000Fu)

#define GPIO_SET_RIS_TRIG_SETRIS14 (0x00004000u)
#define GPIO_SET_RIS_TRIG_SETRIS14_SHIFT (0x0000000Eu)

#define GPIO_SET_RIS_TRIG_SETRIS13 (0x00002000u)
#define GPIO_SET_RIS_TRIG_SETRIS13_SHIFT (0x0000000Du)

#define GPIO_SET_RIS_TRIG_SETRIS12 (0x00001000u)
#define GPIO_SET_RIS_TRIG_SETRIS12_SHIFT (0x0000000Cu)

#define GPIO_SET_RIS_TRIG_SETRIS11 (0x00000800u)
#define GPIO_SET_RIS_TRIG_SETRIS11_SHIFT (0x0000000Bu)

#define GPIO_SET_RIS_TRIG_SETRIS10 (0x00000400u)
#define GPIO_SET_RIS_TRIG_SETRIS10_SHIFT (0x0000000Au)

#define GPIO_SET_RIS_TRIG_SETRIS9 (0x00000200u)
#define GPIO_SET_RIS_TRIG_SETRIS9_SHIFT (0x00000009u)

#define GPIO_SET_RIS_TRIG_SETRIS8 (0x00000100u)
#define GPIO_SET_RIS_TRIG_SETRIS8_SHIFT (0x00000008u)

#define GPIO_SET_RIS_TRIG_SETRIS7 (0x00000080u)
#define GPIO_SET_RIS_TRIG_SETRIS7_SHIFT (0x00000007u)

#define GPIO_SET_RIS_TRIG_SETRIS6 (0x00000040u)
#define GPIO_SET_RIS_TRIG_SETRIS6_SHIFT (0x00000006u)

#define GPIO_SET_RIS_TRIG_SETRIS5 (0x00000020u)
#define GPIO_SET_RIS_TRIG_SETRIS5_SHIFT (0x00000005u)

#define GPIO_SET_RIS_TRIG_SETRIS4 (0x00000010u)
#define GPIO_SET_RIS_TRIG_SETRIS4_SHIFT (0x00000004u)

#define GPIO_SET_RIS_TRIG_SETRIS3 (0x00000008u)
#define GPIO_SET_RIS_TRIG_SETRIS3_SHIFT (0x00000003u)

#define GPIO_SET_RIS_TRIG_SETRIS2 (0x00000004u)
#define GPIO_SET_RIS_TRIG_SETRIS2_SHIFT (0x00000002u)

#define GPIO_SET_RIS_TRIG_SETRIS1 (0x00000002u)
#define GPIO_SET_RIS_TRIG_SETRIS1_SHIFT (0x00000001u)

#define GPIO_SET_RIS_TRIG_SETRIS0 (0x00000001u)
#define GPIO_SET_RIS_TRIG_SETRIS0_SHIFT (0x00000000u)

/* CLR_RIS_TRIG */

#define GPIO_CLR_RIS_TRIG_CLRRIS31 (0x80000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS31_SHIFT (0x0000001Fu)

#define GPIO_CLR_RIS_TRIG_CLRRIS30 (0x40000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS30_SHIFT (0x0000001Eu)

#define GPIO_CLR_RIS_TRIG_CLRRIS29 (0x20000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS29_SHIFT (0x0000001Du)

#define GPIO_CLR_RIS_TRIG_CLRRIS28 (0x10000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS28_SHIFT (0x0000001Cu)

#define GPIO_CLR_RIS_TRIG_CLRRIS27 (0x08000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS27_SHIFT (0x0000001Bu)

#define GPIO_CLR_RIS_TRIG_CLRRIS26 (0x04000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS26_SHIFT (0x0000001Au)

#define GPIO_CLR_RIS_TRIG_CLRRIS25 (0x02000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS25_SHIFT (0x00000019u)

#define GPIO_CLR_RIS_TRIG_CLRRIS24 (0x01000000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS24_SHIFT (0x00000018u)

#define GPIO_CLR_RIS_TRIG_CLRRIS23 (0x00800000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS23_SHIFT (0x00000017u)

#define GPIO_CLR_RIS_TRIG_CLRRIS22 (0x00400000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS22_SHIFT (0x00000016u)

#define GPIO_CLR_RIS_TRIG_CLRRIS21 (0x00200000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS21_SHIFT (0x00000015u)

#define GPIO_CLR_RIS_TRIG_CLRRIS20 (0x00100000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS20_SHIFT (0x00000014u)

#define GPIO_CLR_RIS_TRIG_CLRRIS19 (0x00080000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS19_SHIFT (0x00000013u)

#define GPIO_CLR_RIS_TRIG_CLRRIS18 (0x00040000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS18_SHIFT (0x00000012u)

#define GPIO_CLR_RIS_TRIG_CLRRIS17 (0x00020000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS17_SHIFT (0x00000011u)

#define GPIO_CLR_RIS_TRIG_CLRRIS16 (0x00010000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS16_SHIFT (0x00000010u)

#define GPIO_CLR_RIS_TRIG_CLRRIS15 (0x00008000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS15_SHIFT (0x0000000Fu)

#define GPIO_CLR_RIS_TRIG_CLRRIS14 (0x00004000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS14_SHIFT (0x0000000Eu)

#define GPIO_CLR_RIS_TRIG_CLRRIS13 (0x00002000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS13_SHIFT (0x0000000Du)

#define GPIO_CLR_RIS_TRIG_CLRRIS12 (0x00001000u)
#define GPIO_CLR_RIS_TRIG_CLRRIS12_SHIFT (0x0000000Cu)

#define GPIO_CLR_RIS_TRIG_CLRRIS11 (0x00000800u)
#define GPIO_CLR_RIS_TRIG_CLRRIS11_SHIFT (0x0000000Bu)

#define GPIO_CLR_RIS_TRIG_CLRRIS10 (0x00000400u)
#define GPIO_CLR_RIS_TRIG_CLRRIS10_SHIFT (0x0000000Au)

#define GPIO_CLR_RIS_TRIG_CLRRIS9 (0x00000200u)
#define GPIO_CLR_RIS_TRIG_CLRRIS9_SHIFT (0x00000009u)

#define GPIO_CLR_RIS_TRIG_CLRRIS8 (0x00000100u)
#define GPIO_CLR_RIS_TRIG_CLRRIS8_SHIFT (0x00000008u)

#define GPIO_CLR_RIS_TRIG_CLRRIS7 (0x00000080u)
#define GPIO_CLR_RIS_TRIG_CLRRIS7_SHIFT (0x00000007u)

#define GPIO_CLR_RIS_TRIG_CLRRIS6 (0x00000040u)
#define GPIO_CLR_RIS_TRIG_CLRRIS6_SHIFT (0x00000006u)

#define GPIO_CLR_RIS_TRIG_CLRRIS5 (0x00000020u)
#define GPIO_CLR_RIS_TRIG_CLRRIS5_SHIFT (0x00000005u)

#define GPIO_CLR_RIS_TRIG_CLRRIS4 (0x00000010u)
#define GPIO_CLR_RIS_TRIG_CLRRIS4_SHIFT (0x00000004u)

#define GPIO_CLR_RIS_TRIG_CLRRIS3 (0x00000008u)
#define GPIO_CLR_RIS_TRIG_CLRRIS3_SHIFT (0x00000003u)

#define GPIO_CLR_RIS_TRIG_CLRRIS2 (0x00000004u)
#define GPIO_CLR_RIS_TRIG_CLRRIS2_SHIFT (0x00000002u)

#define GPIO_CLR_RIS_TRIG_CLRRIS1 (0x00000002u)
#define GPIO_CLR_RIS_TRIG_CLRRIS1_SHIFT (0x00000001u)

#define GPIO_CLR_RIS_TRIG_CLRRIS0 (0x00000001u)
#define GPIO_CLR_RIS_TRIG_CLRRIS0_SHIFT (0x00000000u)

/* SET_FAL_TRIG */

#define GPIO_SET_FAL_TRIG_SETFAL31 (0x80000000u)
#define GPIO_SET_FAL_TRIG_SETFAL31_SHIFT (0x0000001Fu)

#define GPIO_SET_FAL_TRIG_SETFAL30 (0x40000000u)
#define GPIO_SET_FAL_TRIG_SETFAL30_SHIFT (0x0000001Eu)

#define GPIO_SET_FAL_TRIG_SETFAL29 (0x20000000u)
#define GPIO_SET_FAL_TRIG_SETFAL29_SHIFT (0x0000001Du)

#define GPIO_SET_FAL_TRIG_SETFAL28 (0x10000000u)
#define GPIO_SET_FAL_TRIG_SETFAL28_SHIFT (0x0000001Cu)

#define GPIO_SET_FAL_TRIG_SETFAL27 (0x08000000u)
#define GPIO_SET_FAL_TRIG_SETFAL27_SHIFT (0x0000001Bu)

#define GPIO_SET_FAL_TRIG_SETFAL26 (0x04000000u)
#define GPIO_SET_FAL_TRIG_SETFAL26_SHIFT (0x0000001Au)

#define GPIO_SET_FAL_TRIG_SETFAL25 (0x02000000u)
#define GPIO_SET_FAL_TRIG_SETFAL25_SHIFT (0x00000019u)

#define GPIO_SET_FAL_TRIG_SETFAL24 (0x01000000u)
#define GPIO_SET_FAL_TRIG_SETFAL24_SHIFT (0x00000018u)

#define GPIO_SET_FAL_TRIG_SETFAL23 (0x00800000u)
#define GPIO_SET_FAL_TRIG_SETFAL23_SHIFT (0x00000017u)

#define GPIO_SET_FAL_TRIG_SETFAL22 (0x00400000u)
#define GPIO_SET_FAL_TRIG_SETFAL22_SHIFT (0x00000016u)

#define GPIO_SET_FAL_TRIG_SETFAL21 (0x00200000u)
#define GPIO_SET_FAL_TRIG_SETFAL21_SHIFT (0x00000015u)

#define GPIO_SET_FAL_TRIG_SETFAL20 (0x00100000u)
#define GPIO_SET_FAL_TRIG_SETFAL20_SHIFT (0x00000014u)

#define GPIO_SET_FAL_TRIG_SETFAL19 (0x00080000u)
#define GPIO_SET_FAL_TRIG_SETFAL19_SHIFT (0x00000013u)

#define GPIO_SET_FAL_TRIG_SETFAL18 (0x00040000u)
#define GPIO_SET_FAL_TRIG_SETFAL18_SHIFT (0x00000012u)

#define GPIO_SET_FAL_TRIG_SETFAL17 (0x00020000u)
#define GPIO_SET_FAL_TRIG_SETFAL17_SHIFT (0x00000011u)

#define GPIO_SET_FAL_TRIG_SETFAL16 (0x00010000u)
#define GPIO_SET_FAL_TRIG_SETFAL16_SHIFT (0x00000010u)

#define GPIO_SET_FAL_TRIG_SETFAL15 (0x00008000u)
#define GPIO_SET_FAL_TRIG_SETFAL15_SHIFT (0x0000000Fu)

#define GPIO_SET_FAL_TRIG_SETFAL14 (0x00004000u)
#define GPIO_SET_FAL_TRIG_SETFAL14_SHIFT (0x0000000Eu)

#define GPIO_SET_FAL_TRIG_SETFAL13 (0x00002000u)
#define GPIO_SET_FAL_TRIG_SETFAL13_SHIFT (0x0000000Du)

#define GPIO_SET_FAL_TRIG_SETFAL12 (0x00001000u)
#define GPIO_SET_FAL_TRIG_SETFAL12_SHIFT (0x0000000Cu)

#define GPIO_SET_FAL_TRIG_SETFAL11 (0x00000800u)
#define GPIO_SET_FAL_TRIG_SETFAL11_SHIFT (0x0000000Bu)

#define GPIO_SET_FAL_TRIG_SETFAL10 (0x00000400u)
#define GPIO_SET_FAL_TRIG_SETFAL10_SHIFT (0x0000000Au)

#define GPIO_SET_FAL_TRIG_SETFAL9 (0x00000200u)
#define GPIO_SET_FAL_TRIG_SETFAL9_SHIFT (0x00000009u)

#define GPIO_SET_FAL_TRIG_SETFAL8 (0x00000100u)
#define GPIO_SET_FAL_TRIG_SETFAL8_SHIFT (0x00000008u)

#define GPIO_SET_FAL_TRIG_SETFAL7 (0x00000080u)
#define GPIO_SET_FAL_TRIG_SETFAL7_SHIFT (0x00000007u)

#define GPIO_SET_FAL_TRIG_SETFAL6 (0x00000040u)
#define GPIO_SET_FAL_TRIG_SETFAL6_SHIFT (0x00000006u)

#define GPIO_SET_FAL_TRIG_SETFAL5 (0x00000020u)
#define GPIO_SET_FAL_TRIG_SETFAL5_SHIFT (0x00000005u)

#define GPIO_SET_FAL_TRIG_SETFAL4 (0x00000010u)
#define GPIO_SET_FAL_TRIG_SETFAL4_SHIFT (0x00000004u)

#define GPIO_SET_FAL_TRIG_SETFAL3 (0x00000008u)
#define GPIO_SET_FAL_TRIG_SETFAL3_SHIFT (0x00000003u)

#define GPIO_SET_FAL_TRIG_SETFAL2 (0x00000004u)
#define GPIO_SET_FAL_TRIG_SETFAL2_SHIFT (0x00000002u)

#define GPIO_SET_FAL_TRIG_SETFAL1 (0x00000002u)
#define GPIO_SET_FAL_TRIG_SETFAL1_SHIFT (0x00000001u)

#define GPIO_SET_FAL_TRIG_SETFAL0 (0x00000001u)
#define GPIO_SET_FAL_TRIG_SETFAL0_SHIFT (0x00000000u)

/* CLR_FAL_TRIG */

#define GPIO_CLR_FAL_TRIG_CLRFAL31 (0x80000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL31_SHIFT (0x0000001Fu)

#define GPIO_CLR_FAL_TRIG_CLRFAL30 (0x40000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL30_SHIFT (0x0000001Eu)

#define GPIO_CLR_FAL_TRIG_CLRFAL29 (0x20000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL29_SHIFT (0x0000001Du)

#define GPIO_CLR_FAL_TRIG_CLRFAL28 (0x10000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL28_SHIFT (0x0000001Cu)

#define GPIO_CLR_FAL_TRIG_CLRFAL27 (0x08000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL27_SHIFT (0x0000001Bu)

#define GPIO_CLR_FAL_TRIG_CLRFAL26 (0x04000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL26_SHIFT (0x0000001Au)

#define GPIO_CLR_FAL_TRIG_CLRFAL25 (0x02000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL25_SHIFT (0x00000019u)

#define GPIO_CLR_FAL_TRIG_CLRFAL24 (0x01000000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL24_SHIFT (0x00000018u)

#define GPIO_CLR_FAL_TRIG_CLRFAL23 (0x00800000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL23_SHIFT (0x00000017u)

#define GPIO_CLR_FAL_TRIG_CLRFAL22 (0x00400000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL22_SHIFT (0x00000016u)

#define GPIO_CLR_FAL_TRIG_CLRFAL21 (0x00200000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL21_SHIFT (0x00000015u)

#define GPIO_CLR_FAL_TRIG_CLRFAL20 (0x00100000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL20_SHIFT (0x00000014u)

#define GPIO_CLR_FAL_TRIG_CLRFAL19 (0x00080000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL19_SHIFT (0x00000013u)

#define GPIO_CLR_FAL_TRIG_CLRFAL18 (0x00040000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL18_SHIFT (0x00000012u)

#define GPIO_CLR_FAL_TRIG_CLRFAL17 (0x00020000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL17_SHIFT (0x00000011u)

#define GPIO_CLR_FAL_TRIG_CLRFAL16 (0x00010000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL16_SHIFT (0x00000010u)

#define GPIO_CLR_FAL_TRIG_CLRFAL15 (0x00008000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL15_SHIFT (0x0000000Fu)

#define GPIO_CLR_FAL_TRIG_CLRFAL14 (0x00004000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL14_SHIFT (0x0000000Eu)

#define GPIO_CLR_FAL_TRIG_CLRFAL13 (0x00002000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL13_SHIFT (0x0000000Du)

#define GPIO_CLR_FAL_TRIG_CLRFAL12 (0x00001000u)
#define GPIO_CLR_FAL_TRIG_CLRFAL12_SHIFT (0x0000000Cu)

#define GPIO_CLR_FAL_TRIG_CLRFAL11 (0x00000800u)
#define GPIO_CLR_FAL_TRIG_CLRFAL11_SHIFT (0x0000000Bu)

#define GPIO_CLR_FAL_TRIG_CLRFAL10 (0x00000400u)
#define GPIO_CLR_FAL_TRIG_CLRFAL10_SHIFT (0x0000000Au)

#define GPIO_CLR_FAL_TRIG_CLRFAL9 (0x00000200u)
#define GPIO_CLR_FAL_TRIG_CLRFAL9_SHIFT (0x00000009u)

#define GPIO_CLR_FAL_TRIG_CLRFAL8 (0x00000100u)
#define GPIO_CLR_FAL_TRIG_CLRFAL8_SHIFT (0x00000008u)

#define GPIO_CLR_FAL_TRIG_CLRFAL7 (0x00000080u)
#define GPIO_CLR_FAL_TRIG_CLRFAL7_SHIFT (0x00000007u)

#define GPIO_CLR_FAL_TRIG_CLRFAL6 (0x00000040u)
#define GPIO_CLR_FAL_TRIG_CLRFAL6_SHIFT (0x00000006u)

#define GPIO_CLR_FAL_TRIG_CLRFAL5 (0x00000020u)
#define GPIO_CLR_FAL_TRIG_CLRFAL5_SHIFT (0x00000005u)

#define GPIO_CLR_FAL_TRIG_CLRFAL4 (0x00000010u)
#define GPIO_CLR_FAL_TRIG_CLRFAL4_SHIFT (0x00000004u)

#define GPIO_CLR_FAL_TRIG_CLRFAL3 (0x00000008u)
#define GPIO_CLR_FAL_TRIG_CLRFAL3_SHIFT (0x00000003u)

#define GPIO_CLR_FAL_TRIG_CLRFAL2 (0x00000004u)
#define GPIO_CLR_FAL_TRIG_CLRFAL2_SHIFT (0x00000002u)

#define GPIO_CLR_FAL_TRIG_CLRFAL1 (0x00000002u)
#define GPIO_CLR_FAL_TRIG_CLRFAL1_SHIFT (0x00000001u)

#define GPIO_CLR_FAL_TRIG_CLRFAL0 (0x00000001u)
#define GPIO_CLR_FAL_TRIG_CLRFAL0_SHIFT (0x00000000u)

/* INTSTAT */

#define GPIO_INTSTAT_STAT31     (0x80000000u)
#define GPIO_INTSTAT_STAT31_SHIFT    (0x0000001Fu)

#define GPIO_INTSTAT_STAT30     (0x40000000u)
#define GPIO_INTSTAT_STAT30_SHIFT    (0x0000001Eu)

#define GPIO_INTSTAT_STAT29     (0x20000000u)
#define GPIO_INTSTAT_STAT29_SHIFT    (0x0000001Du)

#define GPIO_INTSTAT_STAT28     (0x10000000u)
#define GPIO_INTSTAT_STAT28_SHIFT    (0x0000001Cu)

#define GPIO_INTSTAT_STAT27     (0x08000000u)
#define GPIO_INTSTAT_STAT27_SHIFT    (0x0000001Bu)

#define GPIO_INTSTAT_STAT26     (0x04000000u)
#define GPIO_INTSTAT_STAT26_SHIFT    (0x0000001Au)

#define GPIO_INTSTAT_STAT25     (0x02000000u)
#define GPIO_INTSTAT_STAT25_SHIFT    (0x00000019u)

#define GPIO_INTSTAT_STAT24     (0x01000000u)
#define GPIO_INTSTAT_STAT24_SHIFT    (0x00000018u)

#define GPIO_INTSTAT_STAT23     (0x00800000u)
#define GPIO_INTSTAT_STAT23_SHIFT    (0x00000017u)

#define GPIO_INTSTAT_STAT22     (0x00400000u)
#define GPIO_INTSTAT_STAT22_SHIFT    (0x00000016u)

#define GPIO_INTSTAT_STAT21     (0x00200000u)
#define GPIO_INTSTAT_STAT21_SHIFT    (0x00000015u)

#define GPIO_INTSTAT_STAT20     (0x00100000u)
#define GPIO_INTSTAT_STAT20_SHIFT    (0x00000014u)

#define GPIO_INTSTAT_STAT19     (0x00080000u)
#define GPIO_INTSTAT_STAT19_SHIFT    (0x00000013u)

#define GPIO_INTSTAT_STAT18     (0x00040000u)
#define GPIO_INTSTAT_STAT18_SHIFT    (0x00000012u)

#define GPIO_INTSTAT_STAT17     (0x00020000u)
#define GPIO_INTSTAT_STAT17_SHIFT    (0x00000011u)

#define GPIO_INTSTAT_STAT16     (0x00010000u)
#define GPIO_INTSTAT_STAT16_SHIFT    (0x00000010u)

#define GPIO_INTSTAT_STAT15     (0x00008000u)
#define GPIO_INTSTAT_STAT15_SHIFT    (0x0000000Fu)

#define GPIO_INTSTAT_STAT14     (0x00004000u)
#define GPIO_INTSTAT_STAT14_SHIFT    (0x0000000Eu)

#define GPIO_INTSTAT_STAT13     (0x00002000u)
#define GPIO_INTSTAT_STAT13_SHIFT    (0x0000000Du)

#define GPIO_INTSTAT_STAT12     (0x00001000u)
#define GPIO_INTSTAT_STAT12_SHIFT    (0x0000000Cu)

#define GPIO_INTSTAT_STAT11     (0x00000800u)
#define GPIO_INTSTAT_STAT11_SHIFT    (0x0000000Bu)

#define GPIO_INTSTAT_STAT10     (0x00000400u)
#define GPIO_INTSTAT_STAT10_SHIFT    (0x0000000Au)

#define GPIO_INTSTAT_STAT9      (0x00000200u)
#define GPIO_INTSTAT_STAT9_SHIFT     (0x00000009u)

#define GPIO_INTSTAT_STAT8      (0x00000100u)
#define GPIO_INTSTAT_STAT8_SHIFT     (0x00000008u)

#define GPIO_INTSTAT_STAT7      (0x00000080u)
#define GPIO_INTSTAT_STAT7_SHIFT     (0x00000007u)

#define GPIO_INTSTAT_STAT6      (0x00000040u)
#define GPIO_INTSTAT_STAT6_SHIFT     (0x00000006u)

#define GPIO_INTSTAT_STAT5      (0x00000020u)
#define GPIO_INTSTAT_STAT5_SHIFT     (0x00000005u)

#define GPIO_INTSTAT_STAT4      (0x00000010u)
#define GPIO_INTSTAT_STAT4_SHIFT     (0x00000004u)

#define GPIO_INTSTAT_STAT3      (0x00000008u)
#define GPIO_INTSTAT_STAT3_SHIFT     (0x00000003u)

#define GPIO_INTSTAT_STAT2      (0x00000004u)
#define GPIO_INTSTAT_STAT2_SHIFT     (0x00000002u)

#define GPIO_INTSTAT_STAT1      (0x00000002u)
#define GPIO_INTSTAT_STAT1_SHIFT     (0x00000001u)

#define GPIO_INTSTAT_STAT0      (0x00000001u)
#define GPIO_INTSTAT_STAT0_SHIFT     (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif
