
/* ============================================================================
 *
 *            TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION
 *
 *  Property of Texas Instruments
 *  For Unrestricted Internal Use Only
 *  Unauthorized reproduction and/or distribution is strictly prohibited.
 *  This product is protected under copyright law and trade secret law
 *  as an unpublished work.
 *  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
 *
 */

/**
 *  @Component:   LCD
 *
 *  @Filename:    ../../CredDataBase/lcd_cred.h
 *
 ============================================================================ */


#ifndef _HW_LCDC_H_
#define _HW_LCDC_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define LCDC_PID   (0x0)
#define LCDC_LCD_CTRL   (0x4)
#define LCDC_LCD_STAT   (0x8)
#define LCDC_LIDD_CTRL   (0xC)
#define LCDC_LIDD_CS_CONF(n)    (0x10 + ((n) * 0xC))
#define LCDC_LIDD_CS_ADDR(n)    (0x14 + ((n) * 0xC))
#define LCDC_LIDD_CS_DATA(n)    (0x18 + ((n) * 0xC))
#define LCDC_LIDD_CS0_CONF   (0x10)
#define LCDC_LIDD_CS0_ADDR   (0x14)
#define LCDC_LIDD_CS0_DATA   (0x18)
#define LCDC_LIDD_CS1_CONF   (0x1C)
#define LCDC_LIDD_CS1_ADDR   (0x20)
#define LCDC_LIDD_CS2_DATA   (0x24)
#define LCDC_RASTER_CTRL   (0x28)
#define LCDC_RASTER_TIMING_0    (0x2C)
#define LCDC_RASTER_TIMING_1    (0x30)
#define LCDC_RASTER_TIMING_2    (0x34)
#define LCDC_RASTER_TIMING(n)   (0x2C + (n * 4))
#define LCDC_RASTER_SUBPANEL   (0x38)
#define LCDC_RASTER_SUBPANEL2   (0x3C)
#define LCDC_LCDDMA_CTRL   (0x40)
#define LCDC_LCDDMA_FB0_BASE   (0x44)
#define LCDC_LCDDMA_FB0_CEILING   (0x48)
#define LCDC_LCDDMA_FB1_BASE   (0x4C)
#define LCDC_LCDDMA_FB1_CEILING   (0x50)
#define LCDC_SYSCONFIG   (0x54)
#define LCDC_IRQSTATUS_RAW   (0x58)
#define LCDC_IRQSTATUS   (0x5C)
#define LCDC_IRQENABLE_SET   (0x60)
#define LCDC_IRQENABLE_CLEAR   (0x64)
#define LCDC_IRQEOI_VECTOR   (0x68)
#define LCDC_CLKC_ENABLE   (0x6C)
#define LCDC_CLKC_RESET   (0x70)

/**************************************************************************\ 
 * Field Definition Macros
\**************************************************************************/

/* PID */
#define LCDC_PID_CUSTOM   (0x000000C0u)
#define LCDC_PID_CUSTOM_SHIFT   (0x00000006u)

#define LCDC_PID_FUNC   (0x0FFF0000u)
#define LCDC_PID_FUNC_SHIFT   (0x00000010u)

#define LCDC_PID_MAJOR   (0x00000700u)
#define LCDC_PID_MAJOR_SHIFT   (0x00000008u)

#define LCDC_PID_MINOR   (0x0000003Fu)
#define LCDC_PID_MINOR_SHIFT   (0x00000000u)

#define LCDC_PID_RTL   (0x0000F800u)
#define LCDC_PID_RTL_SHIFT   (0x0000000Bu)

#define LCDC_PID_SCHEME   (0xC0000000u)
#define LCDC_PID_SCHEME_SHIFT   (0x0000001Eu)


/* CTRL */
#define LCDC_LCD_CTRL_AUTO_UFLOW_RESTART   (0x00000002u)
#define LCDC_LCD_CTRL_AUTO_UFLOW_RESTART_SHIFT   (0x00000001u)
#define LCDC_LCD_CTRL_AUTO_UFLOW_RESTART_AUTO   (0x1u)
#define LCDC_LCD_CTRL_AUTO_UFLOW_RESTART_MANUAL   (0x0u)

#define LCDC_LCD_CTRL_CLKDIV   (0x0000FF00u)
#define LCDC_LCD_CTRL_CLKDIV_SHIFT   (0x00000008u)

#define LCDC_LCD_CTRL_MODESEL   (0x00000001u)
#define LCDC_LCD_CTRL_MODESEL_SHIFT   (0x00000000u)
#define LCDC_LCD_CTRL_MODESEL_LIDD   (0x0u)
#define LCDC_LCD_CTRL_MODESEL_RASTER   (0x1u)


#define LCDC_LIDD_CTRL_DONE_INT_EN (0x00000400u)
#define LCDC_LIDD_CTRL_DONE_INT_EN_SHIFT (0x0000000Au)


#define LCDC_LIDD_CTRL_ALEPOL   (0x00000008u)
#define LCDC_LIDD_CTRL_ALEPOL_SHIFT   (0x00000003u)
#define LCDC_LIDD_CTRL_ALEPOL_INVERT   (0x1u)
#define LCDC_LIDD_CTRL_ALEPOL_NOINVERT   (0x0u)

#define LCDC_LIDD_CTRL_CS0_E0_POL   (0x00000040u)
#define LCDC_LIDD_CTRL_CS0_E0_POL_SHIFT   (0x00000006u)
#define LCDC_LIDD_CTRL_CS0_E0_POL_INVERT   (0x1u)
#define LCDC_LIDD_CTRL_CS0_E0_POL_NOINVERT   (0x0u)

#define LCDC_LIDD_CTRL_CS1_E1_POL   (0x00000080u)
#define LCDC_LIDD_CTRL_CS1_E1_POL_SHIFT   (0x00000007u)
#define LCDC_LIDD_CTRL_CS1_E1_POL_INVERT   (0x1u)
#define LCDC_LIDD_CTRL_CS1_E1_POL_NOINVERT   (0x0u)

#define LCDC_LIDD_CTRL_DMA_CS0_CS1   (0x00000200u)
#define LCDC_LIDD_CTRL_DMA_CS0_CS1_SHIFT   (0x00000009u)
#define LCDC_LIDD_CTRL_DMA_CS0_CS1_DMACS0   (0x0u)
#define LCDC_LIDD_CTRL_DMA_CS0_CS1_DMACS1   (0x1u)

#define LCDC_LIDD_CTRL_LIDD_DMA_EN   (0x00000100u)
#define LCDC_LIDD_CTRL_LIDD_DMA_EN_SHIFT   (0x00000008u)
#define LCDC_LIDD_CTRL_LIDD_DMA_EN_ACTIVATE   (0x1u)
#define LCDC_LIDD_CTRL_LIDD_DMA_EN_DEACTIVATE   (0x0u)

#define LCDC_LIDD_CTRL_LIDD_MODE_SEL   (0x00000007u)
#define LCDC_LIDD_CTRL_LIDD_MODE_SEL_SHIFT   (0x00000000u)
#define LCDC_LIDD_CTRL_LIDD_MODE_SEL_ASYNC_MPU68   (0x1u)
#define LCDC_LIDD_CTRL_LIDD_MODE_SEL_ASYNC_MPU80   (0x3u)
#define LCDC_LIDD_CTRL_LIDD_MODE_SEL_HITACHI   (0x4u)
#define LCDC_LIDD_CTRL_LIDD_MODE_SEL_SYNC_MPU68   (0x0u)
#define LCDC_LIDD_CTRL_LIDD_MODE_SEL_SYNC_MPU80   (0x2u)

#define LCDC_LIDD_CTRL_RS_EN_POL   (0x00000010u)
#define LCDC_LIDD_CTRL_RS_EN_POL_SHIFT   (0x00000004u)
#define LCDC_LIDD_CTRL_RS_EN_POL_INVERT   (0x1u)
#define LCDC_LIDD_CTRL_RS_EN_POL_NOINVERT   (0x0u)

#define LCDC_LIDD_CTRL_WS_DIR_POL   (0x00000020u)
#define LCDC_LIDD_CTRL_WS_DIR_POL_SHIFT   (0x00000005u)
#define LCDC_LIDD_CTRL_WS_DIR_POL_   (0x1u)
#define LCDC_LIDD_CTRL_WS_DIR_POL_NOINVERT   (0x0u)


/* LIDD_CS0_CONF */
#define LCDC_LIDD_CS0_CONF_R_HOLD   (0x0000003Cu)
#define LCDC_LIDD_CS0_CONF_R_HOLD_SHIFT   (0x00000002u)

#define LCDC_LIDD_CS0_CONF_R_STROBE   (0x00000FC0u)
#define LCDC_LIDD_CS0_CONF_R_STROBE_SHIFT   (0x00000006u)

#define LCDC_LIDD_CS0_CONF_R_SU   (0x0001F000u)
#define LCDC_LIDD_CS0_CONF_R_SU_SHIFT   (0x0000000Cu)

#define LCDC_LIDD_CS0_CONF_TA   (0x00000003u)
#define LCDC_LIDD_CS0_CONF_TA_SHIFT   (0x00000000u)

#define LCDC_LIDD_CS0_CONF_W_HOLD   (0x001E0000u)
#define LCDC_LIDD_CS0_CONF_W_HOLD_SHIFT   (0x00000011u)

#define LCDC_LIDD_CS0_CONF_W_STROBE   (0x07E00000u)
#define LCDC_LIDD_CS0_CONF_W_STROBE_SHIFT   (0x00000015u)

#define LCDC_LIDD_CS0_CONF_W_SU   (0xF8000000u)
#define LCDC_LIDD_CS0_CONF_W_SU_SHIFT   (0x0000001Bu)



/* LIDD_CS0_ADDR */
#define LCDC_LIDD_CS0_ADDR_ADR_INDX   (0x0000FFFFu)
#define LCDC_LIDD_CS0_ADDR_ADR_INDX_SHIFT   (0x00000000u)



/* LIDD_CS0_DATA */
#define LCDC_LIDD_CS0_DATA_DATA   (0x0000FFFFu)
#define LCDC_LIDD_CS0_DATA_DATA_SHIFT   (0x00000000u)




/* LIDD_CS1_CONF */
#define LCDC_LIDD_CS1_CONF_R_HOLD   (0x0000003Cu)
#define LCDC_LIDD_CS1_CONF_R_HOLD_SHIFT   (0x00000002u)

#define LCDC_LIDD_CS1_CONF_R_STROBE   (0x00000FC0u)
#define LCDC_LIDD_CS1_CONF_R_STROBE_SHIFT   (0x00000006u)

#define LCDC_LIDD_CS1_CONF_R_SU   (0x0001F000u)
#define LCDC_LIDD_CS1_CONF_R_SU_SHIFT   (0x0000000Cu)

#define LCDC_LIDD_CS1_CONF_TA   (0x00000003u)
#define LCDC_LIDD_CS1_CONF_TA_SHIFT   (0x00000000u)

#define LCDC_LIDD_CS1_CONF_W_HOLD   (0x001E0000u)
#define LCDC_LIDD_CS1_CONF_W_HOLD_SHIFT   (0x00000011u)

#define LCDC_LIDD_CS1_CONF_W_STROBE   (0x07E00000u)
#define LCDC_LIDD_CS1_CONF_W_STROBE_SHIFT   (0x00000015u)

#define LCDC_LIDD_CS1_CONF_W_SU   (0xF8000000u)
#define LCDC_LIDD_CS1_CONF_W_SU_SHIFT   (0x0000001Bu)


/* LIDD_CS1_ADDR */
#define LCDC_LIDD_CS1_ADDR_ADR_INDX   (0x0000FFFFu)
#define LCDC_LIDD_CS1_ADDR_ADR_INDX_SHIFT   (0x00000000u)




/* RASTER_CTRL */
#define LCDC_RASTER_CTRL_ACTVID_EN_VBLANK   (0x08000000u)
#define LCDC_RASTER_CTRL_ACTVID_EN_VBLANK_SHIFT   (0x0000001Bu)
#define LCDC_RASTER_CTRL_ACTVID_EN_VBLANK_NOACTVID   (0x0u)
#define LCDC_RASTER_CTRL_ACTVID_EN_VBLANK_TOGGLEACTVID   (0x1u)

#define LCDC_RASTER_CTRL_FIFO_DMA_DELAY   (0x000FF000u)
#define LCDC_RASTER_CTRL_FIFO_DMA_DELAY_SHIFT   (0x0000000Cu)
#define LCDC_RASTER_CTRL_FIFO_DMA_DELAY_DISABLED   (0x0u)

#define LCDC_RASTER_CTRL_MONO8B   (0x00000200u)
#define LCDC_RASTER_CTRL_MONO8B_SHIFT   (0x00000009u)
#define LCDC_RASTER_CTRL_MONO8B_4PIXEL   (0x0u)
#define LCDC_RASTER_CTRL_MONO8B_8PIXEL   (0x1u)

#define LCDC_RASTER_CTRL_MONO_COLOR   (0x00000002u)
#define LCDC_RASTER_CTRL_MONO_COLOR_SHIFT   (0x00000001u)
#define LCDC_RASTER_CTRL_MONO_COLOR_COLOR   (0x0u)
#define LCDC_RASTER_CTRL_MONO_COLOR_MONO   (0x1u)

#define LCDC_RASTER_CTRL_NIB_MODE   (0x00400000u)
#define LCDC_RASTER_CTRL_NIB_MODE_SHIFT   (0x00000016u)
#define LCDC_RASTER_CTRL_NIB_MODE_DISABLED   (0x0u)
#define LCDC_RASTER_CTRL_NIB_MODE_ENABLED   (0x1u)

#define LCDC_RASTER_CTRL_PLM   (0x00300000u)
#define LCDC_RASTER_CTRL_PLM_SHIFT   (0x00000014u)
#define LCDC_RASTER_CTRL_PLM_DATA   (0x00000002u)
#define LCDC_RASTER_CTRL_PLM_PALETTE   (0x00000001u)
#define LCDC_RASTER_CTRL_PLM_PALETTE_DATA   (0x00000000u)

#define LCDC_RASTER_CTRL_RASTER_EN   (0x00000001u)
#define LCDC_RASTER_CTRL_RASTER_EN_SHIFT   (0x00000000u)
#define LCDC_RASTER_CTRL_RASTER_EN_DISABLED   (0x0u)
#define LCDC_RASTER_CTRL_RASTER_EN_ENABLED   (0x1u)

#define LCDC_RASTER_CTRL_RD_ORDER   (0x00000100u)
#define LCDC_RASTER_CTRL_RD_ORDER_SHIFT   (0x00000008u)
#define LCDC_RASTER_CTRL_RD_ORDER_H2L   (0x1u)
#define LCDC_RASTER_CTRL_RD_ORDER_L2H   (0x0u)

#define LCDC_RASTER_CTRL_STN_565   (0x01000000u)
#define LCDC_RASTER_CTRL_STN_565_SHIFT   (0x00000018u)
#define LCDC_RASTER_CTRL_STN_565_12BPP   (0x0u)
#define LCDC_RASTER_CTRL_STN_565_16BPP   (0x1u)

#define LCDC_RASTER_CTRL_TFT24   (0x02000000u)
#define LCDC_RASTER_CTRL_TFT24_SHIFT   (0x00000019u)
#define LCDC_RASTER_CTRL_TFT24_OFF   (0x0u)
#define LCDC_RASTER_CTRL_TFT24_ON   (0x1u)

#define LCDC_RASTER_CTRL_TFT24UNPACKED   (0x04000000u)
#define LCDC_RASTER_CTRL_TFT24UNPACKED_SHIFT   (0x0000001Au)
#define LCDC_RASTER_CTRL_TFT24UNPACKED_PACKED   (0x0u)
#define LCDC_RASTER_CTRL_TFT24UNPACKED_UNPACKED   (0x1u)

#define LCDC_RASTER_CTRL_TFT_ALT_MAP   (0x00800000u)
#define LCDC_RASTER_CTRL_TFT_ALT_MAP_SHIFT   (0x00000017u)
#define LCDC_RASTER_CTRL_TFT_ALT_MAP_565   (0x1u)
#define LCDC_RASTER_CTRL_TFT_ALT_MAP_ALIGN   (0x0u)

#define LCDC_RASTER_CTRL_TFT_STN   (0x00000080u)
#define LCDC_RASTER_CTRL_TFT_STN_SHIFT   (0x00000007u)
#define LCDC_RASTER_CTRL_TFT_STN_STN   (0x0u)
#define LCDC_RASTER_CTRL_TFT_STN_TFT   (0x1u)


#define LCDC_RASTER_CTRL_FUF_EN (0x00000040u)
#define LCDC_RASTER_CTRL_FUF_EN_SHIFT (0x00000006u)

#define LCDC_RASTER_CTRL_SL_EN (0x00000020u)
#define LCDC_RASTER_CTRL_SL_EN_SHIFT (0x00000005u)

#define LCDC_RASTER_CTRL_PL_EN (0x00000010u)
#define LCDC_RASTER_CTRL_PL_EN_SHIFT (0x00000004u)

#define LCDC_RASTER_CTRL_DONE_EN (0x00000008u)
#define LCDC_RASTER_CTRL_DONE_EN_SHIFT (0x00000003u)

#define LCDC_RASTER_CTRL_AC_EN (0x00000004u)
#define LCDC_RASTER_CTRL_AC_EN_SHIFT (0x00000002u)



/* RASTER_TIMING_0 */
#define LCDC_RASTER_TIMING_0_HBP   (0xFF000000u)
#define LCDC_RASTER_TIMING_0_HBP_SHIFT   (0x00000018u)

#define LCDC_RASTER_TIMING_0_HFP   (0x00FF0000u)
#define LCDC_RASTER_TIMING_0_HFP_SHIFT   (0x00000010u)

#define LCDC_RASTER_TIMING_0_HSW   (0x0000FC00u)
#define LCDC_RASTER_TIMING_0_HSW_SHIFT   (0x0000000Au)

#define LCDC_RASTER_TIMING_0_PPL   (0x000003F0u)
#define LCDC_RASTER_TIMING_0_PPL_SHIFT   (0x00000004u)

#define LCDC_RASTER_TIMING_0_PPLMSB   (0x00000008u)
#define LCDC_RASTER_TIMING_0_PPLMSB_SHIFT   (0x00000003u)



/* RASTER_TIMING_1 */
#define LCDC_RASTER_TIMING_1_LPP   (0x000003FFu)
#define LCDC_RASTER_TIMING_1_LPP_SHIFT   (0x00000000u)

#define LCDC_RASTER_TIMING_1_VBP   (0xFF000000u)
#define LCDC_RASTER_TIMING_1_VBP_SHIFT   (0x00000018u)

#define LCDC_RASTER_TIMING_1_VFP   (0x00FF0000u)
#define LCDC_RASTER_TIMING_1_VFP_SHIFT   (0x00000010u)

#define LCDC_RASTER_TIMING_1_VSW   (0x0000FC00u)
#define LCDC_RASTER_TIMING_1_VSW_SHIFT   (0x0000000Au)



/* RASTER_TIMING_2 */
#define LCDC_RASTER_TIMING_2_ACB   (0x0000FF00u)
#define LCDC_RASTER_TIMING_2_ACB_SHIFT   (0x00000008u)

#define LCDC_RASTER_TIMING_2_ACB_I   (0x000F0000u)
#define LCDC_RASTER_TIMING_2_ACB_I_SHIFT   (0x00000010u)

#define LCDC_RASTER_TIMING_2_BIAS   (0x00800000u)
#define LCDC_RASTER_TIMING_2_BIAS_SHIFT   (0x00000017u)
#define LCDC_RASTER_TIMING_2_BIAS_ACTIVE_HIGH   (0x0u)
#define LCDC_RASTER_TIMING_2_BIAS_ACTIVE_LOW   (0x1u)

#define LCDC_RASTER_TIMING_2_HBP_HIGHBITS   (0x00000030u)
#define LCDC_RASTER_TIMING_2_HBP_HIGHBITS_SHIFT   (0x00000006u)

#define LCDC_RASTER_TIMING_2_HFP_HIGHBITS   (0x00000003u)
#define LCDC_RASTER_TIMING_2_HFP_HIGHBITS_SHIFT   (0x00000000u)

#define LCDC_RASTER_TIMING_2_IEO   (0x00800000u)
#define LCDC_RASTER_TIMING_2_IEO_SHIFT   (0x00000017u)
#define LCDC_RASTER_TIMING_2_IEO_ACTIVE_HIGH   (0x0u)
#define LCDC_RASTER_TIMING_2_IEO_ACTIVE_LOW   (0x1u)

#define LCDC_RASTER_TIMING_2_IHS   (0x00200000u)
#define LCDC_RASTER_TIMING_2_IHS_SHIFT   (0x00000015u)
#define LCDC_RASTER_TIMING_2_IHS_ACTIVE_HIGH   (0x0u)
#define LCDC_RASTER_TIMING_2_IHS_ACTIVE_LOW   (0x1u)

#define LCDC_RASTER_TIMING_2_IPC   (0x00400000u)
#define LCDC_RASTER_TIMING_2_IPC_SHIFT   (0x00000016u)
#define LCDC_RASTER_TIMING_2_IPC_FALLING   (0x1u)
#define LCDC_RASTER_TIMING_2_IPC_RISING   (0x0u)

#define LCDC_RASTER_TIMING_2_IVS   (0x00100000u)
#define LCDC_RASTER_TIMING_2_IVS_SHIFT   (0x00000014u)
#define LCDC_RASTER_TIMING_2_IVS_ACTIVE_HIGH   (0x0u)
#define LCDC_RASTER_TIMING_2_IVS_ACTIVE_LOW   (0x1u)

#define LCDC_RASTER_TIMING_2_LPP_B10   (0x04000000u)
#define LCDC_RASTER_TIMING_2_LPP_B10_SHIFT   (0x0000001Au)

#define LCDC_RASTER_TIMING_2_PHSVS_ON_OFF   (0x02000000u)
#define LCDC_RASTER_TIMING_2_PHSVS_ON_OFF_SHIFT   (0x00000019u)
#define LCDC_RASTER_TIMING_2_PHSVS_ON_OFF_BIT24   (0x1u)
#define LCDC_RASTER_TIMING_2_PHSVS_ON_OFF_OPPOSITE_EDGE   (0x0u)

#define LCDC_RASTER_TIMING_2_PHSVS_RF   (0x01000000u)
#define LCDC_RASTER_TIMING_2_PHSVS_RF_SHIFT   (0x00000018u)
#define LCDC_RASTER_TIMING_2_PHSVS_RF_FALLING   (0x0u)
#define LCDC_RASTER_TIMING_2_PHSVS_RF_RISING   (0x1u)

#define LCDC_RASTER_TIMING_2_SYNC_CTRL   (0x02000000u)
#define LCDC_RASTER_TIMING_2_SYNC_CTRL_SHIFT   (0x00000019u)
#define LCDC_RASTER_TIMING_2_SYNC_CTRL_BIT24   (0x1u)
#define LCDC_RASTER_TIMING_2_SYNC_CTRL_OPPOSITE_EDGE   (0x0u)

#define LCDC_RASTER_TIMING_2_SYNC_EDGE   (0x01000000u)
#define LCDC_RASTER_TIMING_2_SYNC_EDGE_SHIFT   (0x00000018u)
#define LCDC_RASTER_TIMING_2_SYNC_EDGE_FALLING   (0x0u)
#define LCDC_RASTER_TIMING_2_SYNC_EDGE_RISING   (0x1u)



/* RASTER_SUBPANEL */
#define LCDC_RASTER_SUBPANEL_DPD   (0x0000FFFFu)
#define LCDC_RASTER_SUBPANEL_DPD_SHIFT   (0x00000000u)

#define LCDC_RASTER_SUBPANEL_DPDMSB   (0x000000FFu)
#define LCDC_RASTER_SUBPANEL_DPDMSB_SHIFT   (0x00000000u)

#define LCDC_RASTER_SUBPANEL_HOLS   (0x20000000u)
#define LCDC_RASTER_SUBPANEL_HOLS_SHIFT   (0x0000001Du)
#define LCDC_RASTER_SUBPANEL_HOLS_DATA_BOTTOM   (0x1u)
#define LCDC_RASTER_SUBPANEL_HOLS_DATA_TOP   (0x0u)

#define LCDC_RASTER_SUBPANEL_LPPT   (0x03FF0000u)
#define LCDC_RASTER_SUBPANEL_LPPT_SHIFT   (0x00000010u)

#define LCDC_RASTER_SUBPANEL_LPPT_B10   (0x00000100u)
#define LCDC_RASTER_SUBPANEL_LPPT_B10_SHIFT   (0x00000008u)

#define LCDC_RASTER_SUBPANEL_SPEN   (0x80000000u)
#define LCDC_RASTER_SUBPANEL_SPEN_SHIFT   (0x0000001Fu)
#define LCDC_RASTER_SUBPANEL_SPEN_DISABLED   (0x0u)
#define LCDC_RASTER_SUBPANEL_SPEN_ENABLED   (0x1u)



/* LCDDMA_CTRL */
#define LCDC_LCDDMA_CTRL_BIGENDIAN   (0x00000002u)
#define LCDC_LCDDMA_CTRL_BIGENDIAN_SHIFT   (0x00000001u)

#define LCDC_LCDDMA_CTRL_EOF_INTEN     (0x00000004)
#define LCDC_LCDDMA_CTRL_EOF_INTEN_SHIFT (0x00000002u)

#define LCDC_LCDDMA_CTRL_BURST_SIZE   (0x00000070u)
#define LCDC_LCDDMA_CTRL_BURST_SIZE_SHIFT   (0x00000004u)
#define LCDC_LCDDMA_CTRL_BURST_SIZE_EIGHT   (0x00000003u)
#define LCDC_LCDDMA_CTRL_BURST_SIZE_FOUR   (0x00000002u)
#define LCDC_LCDDMA_CTRL_BURST_SIZE_ONE   (0x00000000u)
#define LCDC_LCDDMA_CTRL_BURST_SIZE_SIXTEEN   (0x00000004u)
#define LCDC_LCDDMA_CTRL_BURST_SIZE_TWO   (0x00000001u)

#define LCDC_LCDDMA_CTRL_BYTE_SWAP   (0x00000008u)
#define LCDC_LCDDMA_CTRL_BYTE_SWAP_SHIFT   (0x00000003u)

#define LCDC_LCDDMA_CTRL_DMA_MASTER_PRIO   (0x00070000u)
#define LCDC_LCDDMA_CTRL_DMA_MASTER_PRIO_SHIFT   (0x00000010u)

#define LCDC_LCDDMA_CTRL_FRAME_MODE   (0x00000001u)
#define LCDC_LCDDMA_CTRL_FRAME_MODE_SHIFT   (0x00000000u)
#define LCDC_LCDDMA_CTRL_FRAME_MODE_ONE   (0x0u)
#define LCDC_LCDDMA_CTRL_FRAME_MODE_TWO   (0x1u)

#define LCDC_LCDDMA_CTRL_TH_FIFO_READY   (0x00000700u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_SHIFT   (0x00000008u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_EIGHT   (0x00000000u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_FIVE_TWELVE   (0x00000006u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_ONE_TWENTY_EIGHT   (0x00000004u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_SIXTEEN   (0x00000001u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_SIXTY_FOUR   (0x00000003u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_THIRTY_TWO   (0x00000002u)
#define LCDC_LCDDMA_CTRL_TH_FIFO_READY_TWO_FIFTY_SIX   (0x00000005u)


/* LCDDMA_FB0_BASE */
#define LCDC_LCDDMA_FB0_BASE_FB0_BASE   (0xFFFFFFFCu)
#define LCDC_LCDDMA_FB0_BASE_FB0_BASE_SHIFT   (0x00000002u)


/* LCDDMA_FB0_CEILING */
#define LCDC_LCDDMA_FB0_CEILING_FB0_CEIL   (0xFFFFFFFCu)
#define LCDC_LCDDMA_FB0_CEILING_FB0_CEIL_SHIFT   (0x00000002u)


/* LCDDMA_FB1_BASE */
#define LCDC_LCDDMA_FB1_BASE_FB1_BASE   (0xFFFFFFFCu)
#define LCDC_LCDDMA_FB1_BASE_FB1_BASE_SHIFT   (0x00000002u)


/* LCDDMA_FB1_CEILING */
#define LCDC_LCDDMA_FB1_CEILING_FB1_CEIL   (0xFFFFFFFCu)
#define LCDC_LCDDMA_FB1_CEILING_FB1_CEIL_SHIFT   (0x00000002u)


/* SYSCONFIG */
#define LCDC_SYSCONFIG_IDLEMODE   (0x000000C0u)
#define LCDC_SYSCONFIG_IDLEMODE_SHIFT   (0x00000004u)
#define LCDC_SYSCONFIG_IDLEMODE_FORCE   (0x0u)
#define LCDC_SYSCONFIG_IDLEMODE_NOIDLE   (0x1u)
#define LCDC_SYSCONFIG_IDLEMODE_SMART   (0x2u)
#define LCDC_SYSCONFIG_IDLEMODE_WAKEUP   (0x3u)

#define LCDC_SYSCONFIG_STANDBYMODE   (0x00000030u)
#define LCDC_SYSCONFIG_STANDBYMODE_SHIFT   (0x00000002u)
#define LCDC_SYSCONFIG_STANDBYMODE_FORCE   (0x0u)
#define LCDC_SYSCONFIG_STANDBYMODE_NOSTANDBY   (0x1u)
#define LCDC_SYSCONFIG_STANDBYMODE_SMART   (0x2u)
#define LCDC_SYSCONFIG_STANDBYMODE_WAKEUP   (0x3u)


/* IRQSTATUS_RAW */
#define LCDC_IRQSTATUS_RAW_ACB   (0x00000008u)
#define LCDC_IRQSTATUS_RAW_ACB_SHIFT   (0x00000003u)
#define LCDC_IRQSTATUS_RAW_ACB_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_ACB_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_ACB_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_DONE   (0x00000001u)
#define LCDC_IRQSTATUS_RAW_DONE_SHIFT   (0x00000000u)
#define LCDC_IRQSTATUS_RAW_DONE_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_DONE_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_DONE_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_EOF0   (0x00000100u)
#define LCDC_IRQSTATUS_RAW_EOF0_SHIFT   (0x00000008u)
#define LCDC_IRQSTATUS_RAW_EOF0_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_EOF0_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_EOF0_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_EOF1   (0x00000200u)
#define LCDC_IRQSTATUS_RAW_EOF1_SHIFT   (0x00000009u)
#define LCDC_IRQSTATUS_RAW_EOF1_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_EOF1_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_EOF1_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_FUF   (0x00000020u)
#define LCDC_IRQSTATUS_RAW_FUF_SHIFT   (0x00000005u)
#define LCDC_IRQSTATUS_RAW_FUF_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_FUF_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_FUF_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_PL   (0x00000040u)
#define LCDC_IRQSTATUS_RAW_PL_SHIFT   (0x00000006u)
#define LCDC_IRQSTATUS_RAW_PL_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_PL_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_PL_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_RECURRENT_RASTER   (0x00000002u)
#define LCDC_IRQSTATUS_RAW_RECURRENT_RASTER_SHIFT   (0x00000001u)
#define LCDC_IRQSTATUS_RAW_RECURRENT_RASTER_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_RECURRENT_RASTER_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_RECURRENT_RASTER_SET   (0x1u)

#define LCDC_IRQSTATUS_RAW_SYNC   (0x00000004u)
#define LCDC_IRQSTATUS_RAW_SYNC_SHIFT   (0x00000002u)
#define LCDC_IRQSTATUS_RAW_SYNC_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RAW_SYNC_INACTIVE   (0x0u)
#define LCDC_IRQSTATUS_RAW_SYNC_SET   (0x1u)


/* IRQSTATUS */
#define LCDC_IRQSTATUS_ACB   (0x00000008u)
#define LCDC_IRQSTATUS_ACB_SHIFT   (0x00000003u)
#define LCDC_IRQSTATUS_ACB_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_ACB_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_ACB_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_DONE   (0x00000001u)
#define LCDC_IRQSTATUS_DONE_SHIFT   (0x00000000u)
#define LCDC_IRQSTATUS_DONE_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_DONE_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_DONE_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_EOF0   (0x00000100u)
#define LCDC_IRQSTATUS_EOF0_SHIFT   (0x00000008u)
#define LCDC_IRQSTATUS_EOF0_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_EOF0_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_EOF0_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_EOF1   (0x00000200u)
#define LCDC_IRQSTATUS_EOF1_SHIFT   (0x00000009u)
#define LCDC_IRQSTATUS_EOF1_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_EOF1_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_EOF1_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_FUF   (0x00000020u)
#define LCDC_IRQSTATUS_FUF_SHIFT   (0x00000005u)
#define LCDC_IRQSTATUS_FUF_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_FUF_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_FUF_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_PL   (0x00000040u)
#define LCDC_IRQSTATUS_PL_SHIFT   (0x00000006u)
#define LCDC_IRQSTATUS_PL_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_PL_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_PL_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_RECURRENT_RASTER   (0x00000002u)
#define LCDC_IRQSTATUS_RECURRENT_RASTER_SHIFT   (0x00000001u)
#define LCDC_IRQSTATUS_RECURRENT_RASTER_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_RECURRENT_RASTER_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_RECURRENT_RASTER_INACTIVE   (0x0u)

#define LCDC_IRQSTATUS_SYNC   (0x00000004u)
#define LCDC_IRQSTATUS_SYNC_SHIFT   (0x00000002u)
#define LCDC_IRQSTATUS_SYNC_ACTIVE   (0x1u)
#define LCDC_IRQSTATUS_SYNC_CLEAR   (0x1u)
#define LCDC_IRQSTATUS_SYNC_INACTIVE   (0x0u)

#define LCDC_LCD_STAT_EOF1 (0x00000200u)
#define LCDC_LCD_STAT_EOF1_SHIFT (0x00000009u)

#define LCDC_LCD_STAT_EOF0 (0x00000100u)
#define LCDC_LCD_STAT_EOF0_SHIFT (0x00000008u)

#define LCDC_LCD_STAT_PL (0x00000040u)
#define LCDC_LCD_STAT_PL_SHIFT (0x00000006u)

#define LCDC_LCD_STAT_FUF (0x00000020u)
#define LCDC_LCD_STAT_FUF_SHIFT (0x00000005u)

#define LCDC_LCD_STAT_ABC (0x00000008u)
#define LCDC_LCD_STAT_ABC_SHIFT (0x00000003u)

#define LCDC_LCD_STAT_SYNC (0x00000004u)
#define LCDC_LCD_STAT_SYNC_SHIFT (0x00000002u)

#define LCDC_LCD_STAT_DONE (0x00000001u)
#define LCDC_LCD_STAT_DONE_SHIFT (0x00000000u)



/* IRQENABLE_SET */
#define LCDC_IRQENABLE_SET_ACB   (0x00000008u)
#define LCDC_IRQENABLE_SET_ACB_SHIFT   (0x00000003u)
#define LCDC_IRQENABLE_SET_ACB_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_ACB_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_ACB_SET   (0x1u)

#define LCDC_IRQENABLE_SET_DONE   (0x00000001u)
#define LCDC_IRQENABLE_SET_DONE_SHIFT   (0x00000000u)
#define LCDC_IRQENABLE_SET_DONE_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_DONE_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_DONE_SET   (0x1u)

#define LCDC_IRQENABLE_SET_EOF0   (0x00000100u)
#define LCDC_IRQENABLE_SET_EOF0_SHIFT   (0x00000008u)
#define LCDC_IRQENABLE_SET_EOF0_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_EOF0_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_EOF0_SET   (0x1u)

#define LCDC_IRQENABLE_SET_EOF1   (0x00000200u)
#define LCDC_IRQENABLE_SET_EOF1_SHIFT   (0x00000009u)
#define LCDC_IRQENABLE_SET_EOF1_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_EOF1_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_EOF1_SET   (0x1u)

#define LCDC_IRQENABLE_SET_FUF   (0x00000020u)
#define LCDC_IRQENABLE_SET_FUF_SHIFT   (0x00000005u)
#define LCDC_IRQENABLE_SET_FUF_SET   (0x1u)

#define LCDC_IRQENABLE_SET_PL   (0x00000040u)
#define LCDC_IRQENABLE_SET_PL_SHIFT   (0x00000006u)
#define LCDC_IRQENABLE_SET_PL_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_PL_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_PL_SET   (0x1u)

#define LCDC_IRQENABLE_SET_RECURRENT_RASTER   (0x00000002u)
#define LCDC_IRQENABLE_SET_RECURRENT_RASTER_SHIFT   (0x00000001u)
#define LCDC_IRQENABLE_SET_RECURRENT_RASTER_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_RECURRENT_RASTER_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_RECURRENT_RASTER_SET   (0x1u)

#define LCDC_IRQENABLE_SET_SYNC   (0x00000004u)
#define LCDC_IRQENABLE_SET_SYNC_SHIFT   (0x00000002u)
#define LCDC_IRQENABLE_SET_SYNC_DISABLED   (0x0u)
#define LCDC_IRQENABLE_SET_SYNC_ENABLED   (0x1u)
#define LCDC_IRQENABLE_SET_SYNC_SET   (0x1u)


/* IRQENABLE_CLEAR */
#define LCDC_IRQENABLE_CLEAR_ACB   (0x00000008u)
#define LCDC_IRQENABLE_CLEAR_ACB_SHIFT   (0x00000003u)
#define LCDC_IRQENABLE_CLEAR_ACB_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_ACB_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_ACB_ENABLED   (0x1u)

#define LCDC_IRQENABLE_CLEAR_DONE   (0x00000001u)
#define LCDC_IRQENABLE_CLEAR_DONE_SHIFT   (0x00000000u)
#define LCDC_IRQENABLE_CLEAR_DONE_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_DONE_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_DONE_ENABLED   (0x1u)

#define LCDC_IRQENABLE_CLEAR_EOF0   (0x00000100u)
#define LCDC_IRQENABLE_CLEAR_EOF0_SHIFT   (0x00000008u)
#define LCDC_IRQENABLE_CLEAR_EOF0_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_EOF0_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_EOF0_ENABLED   (0x1u)

#define LCDC_IRQENABLE_CLEAR_EOF1   (0x00000200u)
#define LCDC_IRQENABLE_CLEAR_EOF1_SHIFT   (0x00000009u)
#define LCDC_IRQENABLE_CLEAR_EOF1_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_EOF1_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_EOF1_ENABLED   (0x1u)

#define LCDC_IRQENABLE_CLEAR_FUF   (0x00000020u)
#define LCDC_IRQENABLE_CLEAR_FUF_SHIFT   (0x00000005u)
#define LCDC_IRQENABLE_CLEAR_FUF_CLEAR   (0x1u)

#define LCDC_IRQENABLE_CLEAR_PL   (0x00000040u)
#define LCDC_IRQENABLE_CLEAR_PL_SHIFT   (0x00000006u)
#define LCDC_IRQENABLE_CLEAR_PL_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_PL_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_PL_ENABLED   (0x1u)

#define LCDC_IRQENABLE_CLEAR_RECURRENT_RASTER   (0x00000002u)
#define LCDC_IRQENABLE_CLEAR_RECURRENT_RASTER_SHIFT   (0x00000001u)
#define LCDC_IRQENABLE_CLEAR_RECURRENT_RASTER_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_RECURRENT_RASTER_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_RECURRENT_RASTER_ENABLED   (0x1u)

#define LCDC_IRQENABLE_CLEAR_SYNC   (0x00000004u)
#define LCDC_IRQENABLE_CLEAR_SYNC_SHIFT   (0x00000002u)
#define LCDC_IRQENABLE_CLEAR_SYNC_CLEAR   (0x1u)
#define LCDC_IRQENABLE_CLEAR_SYNC_DISABLED   (0x0u)
#define LCDC_IRQENABLE_CLEAR_SYNC_ENABLED   (0x1u)

/* CLKC_ENABLE */
#define LCDC_CLKC_ENABLE_CORE   (0x00000001u)
#define LCDC_CLKC_ENABLE_CORE_SHIFT   (0x00000000u)
#define LCDC_CLKC_ENABLE_CORE_DISABLE   (0x0u)
#define LCDC_CLKC_ENABLE_CORE_ENABLE   (0x1u)

#define LCDC_CLKC_ENABLE_DMA   (0x00000004u)
#define LCDC_CLKC_ENABLE_DMA_SHIFT   (0x00000002u)
#define LCDC_CLKC_ENABLE_DMA_DISABLE   (0x0u)
#define LCDC_CLKC_ENABLE_DMA_ENABLE   (0x1u)

#define LCDC_CLKC_ENABLE_LIDD   (0x00000002u)
#define LCDC_CLKC_ENABLE_LIDD_SHIFT   (0x00000001u)
#define LCDC_CLKC_ENABLE_LIDD_DISABLE   (0x0u)
#define LCDC_CLKC_ENABLE_LIDD_ENABLE   (0x1u)



/* CLKC_RESET */
#define LCDC_CLKC_RESET_CORE   (0x00000001u)
#define LCDC_CLKC_RESET_CORE_SHIFT   (0x00000000u)
#define LCDC_CLKC_RESET_CORE_DISABLE   (0x0u)
#define LCDC_CLKC_RESET_CORE_ENABLE   (0x1u)

#define LCDC_CLKC_RESET_DMA   (0x00000004u)
#define LCDC_CLKC_RESET_DMA_SHIFT   (0x00000002u)
#define LCDC_CLKC_RESET_DMA_DISABLE   (0x0u)
#define LCDC_CLKC_RESET_DMA_ENABLE   (0x1u)

#define LCDC_CLKC_RESET_LIDD   (0x00000002u)
#define LCDC_CLKC_RESET_LIDD_SHIFT   (0x00000001u)
#define LCDC_CLKC_RESET_LIDD_DISABLE   (0x0u)
#define LCDC_CLKC_RESET_LIDD_ENABLE   (0x1u)

#define LCDC_CLKC_RESET_MAIN   (0x00000008u)
#define LCDC_CLKC_RESET_MAIN_SHIFT   (0x00000003u)
#define LCDC_CLKC_RESET_MAIN_DISABLE   (0x0u)
#define LCDC_CLKC_RESET_MAIN_ENABLE   (0x1u)




#ifdef __cplusplus
}
#endif

#endif
