/************************************************************************************
 * FILE PURPOSE: Linker command file for test small arm code
 ************************************************************************************
 * FILE NAME: hawking_arm.cmd
 *
 * DESCRIPTION: The linker command file for the arm test code
 *
 ************************************************************************************/

/* Source files */
testsmall.arm.oc
testsmall.arm.oa

/* options */
-a
-c

#include "gem_arm.h"

/* Rom function table */
_romtTetrisPsc = 0x00001028;
_romtMonitorFunction = 0x00001000;


/* Since the conversion is through a blob, the end address of the blob must
 * be known for the automated tests. The definitions below mark the block */
#define ARM_CODE_START	0x0c010810
#define ARM_CODE_LENGTH 0x07f0
#define ARM_CODE_END	(ARM_CODE_START + ARM_CODE_LENGTH)

MEMORY
{

	STACK	  :  origin = 0x0c030000, length = 0x1000		/* 0x400 for each core */
	DATA	  :  origin = 0x0c031000, length = 0x1000
	ARM_ENTRY :  origin = T_ENTRY,    length = 0x0010
    ARM_CODE  :  origin = ARM_CODE_START, length = ARM_CODE_LENGTH

	RESULTS   :  origin = T_RESULTS,  length = 0x004

	IPCGR	  :  origin = 0x2620240,  length = 0x30
	IPCAR	  :  origin = 0x2620280,  length = 0x30

}

SECTIONS
{
	.data > DATA			RUN_START(block_0_start)  RUN_END(block_0_end)
	.bss  > DATA			RUN_START(block_1_start)  RUN_END(block_1_end)
	.far  > DATA			RUN_START(block_2_start)  RUN_END(block_2_end)

	.ipcgr > IPCGR
	.ipcar > IPCAR

	/* Since the output is sent as a single blob, not a boot table, these sections make a single block */
	.entry > ARM_ENTRY		RUN_START(block_3_start)  
	.text  > ARM_CODE
	.const > ARM_CODE		
	.cinit > ARM_CODE

	.results > RESULTS


	UNION RUN=STACK   RUN_START(block_4_start)  RUN_END(block_4_end)  {
		.stack
		.stacks
	}

}
block_3_end =  ARM_CODE_END;

nblocks=5;





