/*********************************************************************************************
 * FILE PURPOSE: Linker command file for test small gem code
 *********************************************************************************************
 * FILE NAME: hawking_gem.cmd
 *
 * DESCRIPTION: The linker command file for the gem test code
 *
 *********************************************************************************************/

/* Source files */
testsmall.oc


/* options */
-a
-c
-stack 0x400

#include "gem_arm.h"


MEMORY
{

	STACK		:  origin = 0x840000, length = 0x400
	DATA		:  origin = 0x840400, length = 0x400
	SECREGS		:  origin = 0x840800, length = 0x100

	DDR_CFG		:  origin = 0x8ffd20, length = 0x180
	BOOT_MAGIC  :  origin = 0x8ffffc, length = 0x004

	GEM_CODE	:  origin = 0x0c010000, length = 0x800
	ARM_CODE    :  origin = T_ENTRY,    length = 0x004
	RESULTS     :  origin = T_RESULTS,  length = 0x004

	ARM_MAGIC   :  origin = 0x0c5ad000, length = 0x10

	IPCGR		:  origin = 0x2620240, length = 0x30
	IPCAR		:  origin = 0x2620280, length = 0x30
	DDR_CODE	:  origin = 0x80000000, length = 0x1000


}

SECTIONS
{
	.emif4Cfg > DDR_CFG
	.stack > STACK  				RUN_START(block_0_start)  RUN_END(block_0_end)
	.data  > DATA					RUN_START(block_1_start)  RUN_END(block_1_end)
	.bss   > DATA					RUN_START(block_2_start)  RUN_END(block_2_end)
	.far   > DATA				    RUN_START(block_3_start)  RUN_END(block_3_end)

	.gem_boot_magic > BOOT_MAGIC
	.arm_boot_magic > ARM_MAGIC

	.ipcgr > IPCGR
	.ipcar > IPCAR

	.text  > GEM_CODE				RUN_START(block_4_start)  RUN_END(block_4_end)
	.const > GEM_CODE				RUN_START(block_5_start)  RUN_END(block_5_end)
	.cinit > GEM_CODE				RUN_START(block_6_start)  RUN_END(block_6_end)

	.arm_entry > ARM_CODE

	.results > RESULTS				RUN_START(block_7_start)  RUN_END(block_7_end)
	.ddr_code > DDR_CODE				RUN_START(block_8_start)  RUN_END(block_8_end)

	.secRegs > SECREGS

}

nblocks=8;






