; /**************************************************************************************
;  * FILE PURPOSE: testsmall ARM assembly
;  **************************************************************************************
;  * FILE NAME: testsmall.s
;  *
;  * DESCRIPTION: Provides assembly support functions for the testsmall program
;  *
;  ***************************************************************************************

	.global  _armStart
	.global	 _armNum
	.global  _sendEvent

	.ref     _main
	.ref	 _main_func_sp
	.ref	 __stack
	.ref	 __STACK_SIZE
	.ref	 __TI_auto_init



;;  The entry section is used to place the ARM start at a known location
;;  in the linker command file

	.sect	".entry"

_armStart:

	b		textStart


;;  Each core gets its own supervisor stack
STACK_SIZE	.set	0x400
stacks		.usect	".stacks", 	MAXARMS * STACK_SIZE
	


;;  Use the TI standard library functions for setting up cinit and bss

	.text

val_stacks	.word	stacks
val_mf_sp	.word	_main_func_sp

textStart:

	;;   Set the initial endianness
	.if .TMS470_BIG
		setend 	BE
	.else
		setend	LE
	.endif

	;; Setup the stack
	bl		_armNum				;; Read the ARM core number
	add		r0, r0, #1			;; Make the core number start at 1 

	movw	r1, #STACK_SIZE		;; the size of the stack
	mul		r0, r0, r1			;; Then end offset of the stack for this core
	ldr		r1, val_stacks		;; The base address of the stack
	add		r13, r1, r0			;; The end of the stack
	sub		r13, r13, #4		;; Back up one word

	ldr		r0, val_mf_sp		;; Save the stack value for auto-init
	str		r13, [r0]

	
	adr		lr, gomain
	bl		__TI_auto_init



gomain:
	b	_main


;; *********************************************************************************
;; * FUNCTION PURPOSE: Return the ARM core number
;; *********************************************************************************
;; * DESCRIPTION: Reads the multi-processor ID and returns it
;; *********************************************************************************

_armNum:
	mrc		p15, #0, r0, c0, c0, #5		;;  Read the multi-processor affinity register
	and		r0,  r0, #3					;;   The core number
	bx		lr	











