/*
 *
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/**********************************************************************************************
 * FILE PURPOSE: Convert a binary file to CCS format
 **********************************************************************************************
 * FILE NAME: bin2ccs.c
 *
 * DESCRIPTION: The binary file is converted to an ascii file in CCS data format
 *
 **********************************************************************************************/

#include <stdio.h>
#include <malloc.h>

/**********************************************************************************************
 * FUNCTION PURPOSE: Form a 32 bit value from an unsigned byte array
 **********************************************************************************************
 * DESCRIPTION: The value is formed and padded if required
 **********************************************************************************************/
unsigned int formInt  (unsigned char *c, unsigned int i, unsigned int len)
{
  unsigned int x = 0;

  if (i < len)
    x = x | (c[i] << 24);

  if ((i+1) < len)
    x = x | (c[i+1] << 16);

  if ((i+2) < len)
    x = x | (c[i+2] << 8);

  if ((i+3) < len)
    x = x | c[i+3];

  return (x);

}

int main (int argc, char *argv[])
{
  FILE *fil;
  unsigned char *cdat;
  unsigned int len;
  unsigned int i;


  if (argc != 3)  {
    fprintf (stderr, "usage: %s infile outfile\n", argv[0]);
    return (-1);
  }

  fil = fopen (argv[1], "rb");
  if (fil == NULL)  {
    fprintf (stderr, "%s: Failed to open input file %s\n", argv[0], argv[1]);
    return (-1);
  }

  fseek (fil, 0, SEEK_END);
  len = ftell (fil);
  fclose (fil);

  cdat = malloc (len * sizeof (unsigned char));
  if (cdat == NULL)  {
    fprintf (stderr, "%s: Failed to malloc %d bytes\n", argv[0], len);
    return (-1);
  }

  fil = fopen (argv[1], "rb");
  if (fil == NULL)  {
    fprintf (stderr, "%s: Failed to open input file %s\n", argv[0], argv[1]);
    return (-1);
  }

  fread (cdat, sizeof(unsigned char), len, fil);

  fclose (fil);

  
  fil = fopen (argv[2], "w");
  if (fil == NULL)  {
    fprintf (stderr, "%s: Error opening output file %s\n", argv[0], argv[1]);
    free (cdat);
    return (-1);
  }

  /* The ccs header */
  fprintf (fil, "1651 1 10000 1 %x\n", (len + 3) / 4);


  /* The data */
  for (i = 0; i < len; i += 4)  
    fprintf (fil, "0x%08x\n", formInt(cdat, i, len));


  fclose (fil);
  free (cdat);

  return (0);

}


  







